/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.internal.util;

import com.ibm.team.foundation.common.internal.util.ExceptionDescription;
import com.ibm.team.foundation.common.internal.util.Messages;
import com.ibm.team.foundation.common.internal.util.TeamFoundationException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HostUnknownException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import org.eclipse.core.runtime.IAdapterFactory;

public class ExceptionDescriptionFactory
implements IAdapterFactory {
    private static final Class[] ADAPTERS = new Class[]{ExceptionDescription.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof Throwable && ExceptionDescription.class.equals((Object)adapterType)) {
            return this.findExceptionDescription((Throwable)adaptableObject);
        }
        return null;
    }

    private ExceptionDescription findExceptionDescription(Throwable x) {
        TeamFoundationException y;
        if (x instanceof NotLoggedInException) {
            return ExceptionDescription.createDescription(Messages.getString("ExceptionDescriptionFactory.NOT_LOGGED_INTO_REPOSITORY"), Messages.getString("ExceptionDescriptionFactory.NOT_LOGGED_INTO_REPOSITORY_LONG"));
        }
        if (x instanceof PermissionDeniedException) {
            return ExceptionDescription.createDescription(Messages.getString("ExceptionDescriptionFactory.INSUFFICIENT_PERMISSIONS"), Messages.getString("ExceptionDescriptionFactory.INSUFFICIENT_PERMISSIONS_LONG"));
        }
        if (x instanceof StaleDataException) {
            return ExceptionDescription.createDescription(Messages.getString("ExceptionDescriptionFactory.DATA_CHANGED_REMOTELY"), Messages.getString("ExceptionDescriptionFactory.DATA_CHANGED_REMOTELY_LONG"));
        }
        if (x instanceof TeamFoundationException && (y = (TeamFoundationException)((Object)x)).getSummary() != null && y.getDescription() != null) {
            return ExceptionDescription.createDescription(y.getSummary(), y.getDescription());
        }
        if (x instanceof ConnectionException) {
            if (x.getCause() instanceof ConnectException) {
                return ExceptionDescription.createDescription(Messages.getString("ExceptionDescriptionFactory.REPOSITORY_NO_CONTACT"), Messages.getString("ExceptionDescriptionFactory.REPOSITORY_NO_CONTACT_LONG"));
            }
            if (x.getCause() instanceof NoRouteToHostException) {
                return ExceptionDescription.createDescription(Messages.getString("ExceptionDescriptionFactory.REPOSITORY_NO_CONTACT"), Messages.getString("ExceptionDescriptionFactory.REPOSITORY_NO_CONTACT_CHECK_CONNECTION"));
            }
            return ExceptionDescription.createDescription(Messages.getString("ExceptionDescriptionFactory.REPOSITORY_NO_CONTACT"), Messages.getString("ExceptionDescriptionFactory.REPOSITORY_NO_CONTACT_CHECK_ADDRESS"));
        }
        if (x instanceof HostUnknownException) {
            return ExceptionDescription.createDescription(Messages.getString("ExceptionDescriptionFactory.REPOSITORY_NOT_RESOLVED"), Messages.getString("ExceptionDescriptionFactory.REPOSITORY_NO_CONTACT_CHECK_NETWORK"));
        }
        if (x instanceof SocketTimeoutException) {
            return ExceptionDescription.createDescription(Messages.getString("ExceptionDescriptionFactory.NETWORK_TIMEOUT"), Messages.getString("ExceptionDescriptionFactory.NETWORK_TIMEOUT_LONG"));
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTERS;
    }
}

