/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.internal.util;

import com.ibm.team.foundation.common.internal.util.Messages;
import com.ibm.team.foundation.common.util.Adapters;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExceptionDescription {
    private Throwable fException;
    private String fSummary;
    private String fDescription;
    private String fOperationName;

    public static ExceptionDescription findDescription(String operationName, Throwable x) {
        if (operationName == null || operationName.length() == 0) {
            operationName = Messages.getString("ExceptionDescription.UNNAMED");
        }
        ExceptionDescription description = null;
        if (x != null) {
            description = ExceptionDescription.findAdapter(x, ExceptionDescription.class);
        }
        if (description == null) {
            String detail = x != null && x.getLocalizedMessage() != null && x.getLocalizedMessage().length() > 0 ? x.getLocalizedMessage() : Messages.getString("ExceptionDescription.NO_DESCRIPTION_AVAILABLE");
            description = ExceptionDescription.createDescription(ExceptionDescription.getContextSummary(4, operationName), detail);
        }
        description.fOperationName = operationName;
        description.fException = x != null ? x : new NullPointerException();
        return description;
    }

    public static ExceptionDescription createDescription(String summary, String description) {
        return new ExceptionDescription(summary, description);
    }

    public static <T> T findAdapter(Throwable x, Class<T> clazz) {
        HashSet<Throwable> seen = new HashSet<Throwable>();
        while (x != null && !seen.contains(x)) {
            seen.add(x);
            T adapter = Adapters.getAdapter((Object)x, clazz);
            if (adapter != null) {
                return adapter;
            }
            x = x instanceof CoreException && ((CoreException)x).getStatus() != null && ((CoreException)x).getStatus().getException() != null ? ((CoreException)x).getStatus().getException() : x.getCause();
        }
        return null;
    }

    private ExceptionDescription(String summary, String description) {
        this.fSummary = summary;
        this.fDescription = description;
    }

    public Throwable getException() {
        return this.fException;
    }

    public String getSummary() {
        return this.fSummary;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getOperationName() {
        return this.fOperationName;
    }

    public String getContextSummary() {
        return ExceptionDescription.getContextSummary(4, this.getOperationName());
    }

    public static String getContextSummary(int severity, String operationName) {
        if (operationName == null || operationName.length() == 0) {
            operationName = Messages.getString("ExceptionDescription.UNNAMED");
        }
        switch (severity) {
            case 4: {
                return MessageFormat.format(Messages.getString("ExceptionDescription.ERROR_RUNNING_OPERATION"), operationName);
            }
            case 2: {
                return MessageFormat.format(Messages.getString("ExceptionDescription.WARNING_RUNNING_OPERATION"), operationName);
            }
            case 8: {
                return MessageFormat.format(Messages.getString("ExceptionDescription.CANCELED_OPERATION"), operationName);
            }
        }
        return MessageFormat.format(Messages.getString("ExceptionDescription.INFORMATION_RUNNING_OPERATION"), operationName);
    }
}

