/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common;

import com.ibm.team.foundation.common.Messages;
import java.net.URI;
import org.eclipse.core.runtime.Assert;

public class URIReference {
    private final String fDetails;
    private final String fName;
    private final String fType;
    private final URI fURI;

    public URIReference(String name, String details, String type, URI uri) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)Messages.getString("URIReference.ERROR_NAME_EMPTY"));
        Assert.isNotNull((Object)details);
        Assert.isNotNull((Object)uri);
        Assert.isNotNull((Object)type);
        Assert.isLegal((!"".equals(type) ? 1 : 0) != 0, (String)Messages.getString("URIReference.ERROR_TYPE_EMPTY"));
        this.fName = name;
        this.fDetails = details;
        this.fURI = uri;
        this.fType = type;
    }

    public URIReference(String name, String details, URI uri) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)Messages.getString("URIReference.ERROR_NAME_EMPTY"));
        Assert.isNotNull((Object)details);
        Assert.isNotNull((Object)uri);
        this.fName = name;
        this.fDetails = details;
        this.fURI = uri;
        this.fType = null;
    }

    public boolean equals(Object object) {
        if (object instanceof URIReference) {
            URIReference reference = (URIReference)object;
            return this.fURI.equals(reference.fURI);
        }
        return false;
    }

    public String getDetails() {
        return this.fDetails;
    }

    public String getName() {
        return this.fName;
    }

    public String getType() {
        return this.fType;
    }

    public URI getURI() {
        return this.fURI;
    }

    public int hashCode() {
        return this.fURI.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("URIReference[name=");
        buffer.append(this.fName);
        buffer.append(",details=");
        buffer.append(this.fDetails);
        buffer.append(",type=");
        buffer.append(this.fType);
        buffer.append(",uri=");
        buffer.append(this.fURI.toString());
        buffer.append("]");
        return buffer.toString();
    }
}

