/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.serialize.IPrimitiveHandler;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.utils.DateUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class PrimitiveRegistry
implements IPrimitiveRegistry {
    private final Map primitives = Collections.synchronizedMap(new WeakHashMap());
    private final Map nsPrimitives = Collections.synchronizedMap(new HashMap());

    public PrimitiveRegistry() {
        this.addInstrinsicHandlers();
    }

    private void addInstrinsicHandlers() {
        this.register(Byte.TYPE, PrimitiveHandlerByte.INSTANCE);
        this.register(Byte.class, PrimitiveHandlerByte.INSTANCE);
        this.register(Short.TYPE, PrimitiveHandlerShort.INSTANCE);
        this.register(Short.class, PrimitiveHandlerShort.INSTANCE);
        this.register(Integer.TYPE, PrimitiveHandlerInteger.INSTANCE);
        this.register(Integer.class, PrimitiveHandlerInteger.INSTANCE);
        this.register(Long.TYPE, PrimitiveHandlerLong.INSTANCE);
        this.register(Long.class, PrimitiveHandlerLong.INSTANCE);
        this.register(Float.TYPE, PrimitiveHandlerFloat.INSTANCE);
        this.register(Float.class, PrimitiveHandlerFloat.INSTANCE);
        this.register(Double.TYPE, PrimitiveHandlerDouble.INSTANCE);
        this.register(Double.class, PrimitiveHandlerDouble.INSTANCE);
        this.register(Boolean.TYPE, PrimitiveHandlerBoolean.INSTANCE);
        this.register(Boolean.class, PrimitiveHandlerBoolean.INSTANCE);
        this.register(Character.TYPE, PrimitiveHandlerCharacter.INSTANCE);
        this.register(Character.class, PrimitiveHandlerCharacter.INSTANCE);
        this.register(Void.TYPE, PrimitiveHandlerVoid.INSTANCE);
        this.register(String.class, PrimitiveHandlerString.INSTANCE);
        this.register(Date.class, PrimitiveHandlerDate.INSTANCE);
        this.register(Timestamp.class, PrimitiveHandlerTimestamp.INSTANCE);
        this.register(UUID.class, PrimitiveHandlerRepoUUID.INSTANCE);
    }

    public IPrimitiveHandler getHandler(Class clazz) {
        return (IPrimitiveHandler)this.primitives.get(clazz);
    }

    public IPrimitiveHandler getHandler(String[] xsiType) {
        String nsKey = String.valueOf(xsiType[0]) + ' ' + xsiType[1];
        return (IPrimitiveHandler)this.nsPrimitives.get(nsKey);
    }

    public void register(Class clazz, IPrimitiveHandler handler) {
        this.primitives.put(clazz, handler);
        String[] xsiType = handler.getXsiType();
        String nsKey = String.valueOf(xsiType[0]) + ' ' + xsiType[1];
        this.nsPrimitives.put(nsKey, handler);
    }

    public boolean isPrimitive(Class clazz) {
        return this.primitives.containsKey(clazz);
    }

    static class PrimitiveHandlerBoolean
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerBoolean();

        PrimitiveHandlerBoolean() {
        }

        public String objectToString(Object object) {
            return ((Boolean)object).toString();
        }

        public Object stringToObject(String string) {
            return Boolean.valueOf(string);
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "boolean"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerByte
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerByte();

        PrimitiveHandlerByte() {
        }

        public String objectToString(Object object) {
            return ((Byte)object).toString();
        }

        public Object stringToObject(String string) {
            return Byte.decode(string);
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "unsignedByte"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerCharacter
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerCharacter();

        PrimitiveHandlerCharacter() {
        }

        public String objectToString(Object object) {
            return ((Character)object).toString();
        }

        public Object stringToObject(String string) {
            return new Character(string.charAt(0));
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "string"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerDate
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerDate();

        PrimitiveHandlerDate() {
        }

        public String objectToString(Object object) {
            return DateUtils.formatTimeRFC3339((Date)((Date)object));
        }

        public Object stringToObject(String string) throws SerializeException {
            try {
                Timestamp time = DateUtils.parseTimeRFC3339((String)string);
                return new Date(time.getTime());
            }
            catch (ParseException e) {
                throw SerializeException.from(e);
            }
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "dateTime"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerDouble
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerDouble();

        PrimitiveHandlerDouble() {
        }

        public String objectToString(Object object) {
            return ((Double)object).toString();
        }

        public Object stringToObject(String string) {
            return Double.valueOf(string);
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "double"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerFloat
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerFloat();

        PrimitiveHandlerFloat() {
        }

        public String objectToString(Object object) {
            return ((Float)object).toString();
        }

        public Object stringToObject(String string) {
            return Float.valueOf(string);
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "float"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerInteger
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerInteger();

        PrimitiveHandlerInteger() {
        }

        public String objectToString(Object object) {
            return ((Integer)object).toString();
        }

        public Object stringToObject(String string) {
            return Integer.decode(string);
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "int"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerLong
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerLong();

        PrimitiveHandlerLong() {
        }

        public String objectToString(Object object) {
            return ((Long)object).toString();
        }

        public Object stringToObject(String string) {
            return Long.decode(string);
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "long"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerRepoUUID
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerRepoUUID();

        PrimitiveHandlerRepoUUID() {
        }

        public String objectToString(Object object) {
            return ((UUID)object).getUuidValue();
        }

        public Object stringToObject(String string) {
            return UUID.valueOf((String)string);
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "string"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerShort
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerShort();

        PrimitiveHandlerShort() {
        }

        public String objectToString(Object object) {
            return ((Short)object).toString();
        }

        public Object stringToObject(String string) {
            return Short.decode(string);
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "short"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerString
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerString();

        PrimitiveHandlerString() {
        }

        public String objectToString(Object object) {
            return (String)object;
        }

        public Object stringToObject(String string) {
            return string;
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "string"};
        }

        public boolean isEmptyValid() {
            return true;
        }
    }

    static class PrimitiveHandlerTimestamp
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerTimestamp();

        PrimitiveHandlerTimestamp() {
        }

        public String objectToString(Object object) {
            return DateUtils.formatTimeRFC3339((Date)((Date)object));
        }

        public Object stringToObject(String string) throws SerializeException {
            try {
                return DateUtils.parseTimeRFC3339((String)string);
            }
            catch (ParseException e) {
                throw SerializeException.from(e);
            }
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "dateTime"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerVoid
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INSTANCE = new PrimitiveHandlerVoid();

        PrimitiveHandlerVoid() {
        }

        public String objectToString(Object object) {
            return null;
        }

        public Object stringToObject(String string) {
            return null;
        }

        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "string"};
        }

        public boolean isEmptyValid() {
            return false;
        }
    }
}

