/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IVirtual;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.serialize.internal.APPSerializer;
import com.ibm.team.repository.common.serialize.internal.JSONSerializer;
import com.ibm.team.repository.common.serialize.internal.UriSerializer;
import com.ibm.team.repository.common.serialize.internal.XMLSerializer;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ISerializer2 {
    public static final Factory FACTORY = new Factory(){

        public ISerializer2 newInstance(HttpUtil.MediaType mType, String repoUri, boolean format, IURISerializer uriSerializer) {
            if (uriSerializer == null) {
                uriSerializer = new UriSerializer();
            }
            if (mType == HttpUtil.MediaType.XML) {
                return new XMLSerializer(mType, repoUri, format, uriSerializer);
            }
            if (mType == HttpUtil.MediaType.JSON || mType == HttpUtil.MediaType.TEXT_PLAIN || mType == HttpUtil.MediaType.ANY) {
                return new JSONSerializer(mType, repoUri, format, uriSerializer);
            }
            if (mType == HttpUtil.MediaType.APP) {
                return new APPSerializer(mType, repoUri, format, uriSerializer);
            }
            String msg = NLS.bind((String)Messages.getServerString("ISerializer2.UnknownMediaType"), (Object[])new Object[]{mType});
            throw new UnsupportedOperationException(msg);
        }
    };

    public void serialize(IItem var1, Writer var2) throws TeamRepositoryException, IOException;

    public void serialize(IVirtual var1, Writer var2) throws TeamRepositoryException, IOException;

    public void serialize(List<IItem> var1, Writer var2) throws TeamRepositoryException, IOException;

    public void serializeVirtuals(List<IVirtual> var1, Writer var2) throws TeamRepositoryException, IOException;

    public void serializeList(List var1, Writer var2) throws TeamRepositoryException, IOException;

    public void serializeException(Throwable var1, Integer var2, Writer var3) throws TeamRepositoryException, IOException;

    public String getRepoUri();

    public HttpUtil.MediaType getMediaType();

    public boolean format();

    public void serialize(EObject var1, Writer var2) throws TeamRepositoryException, IOException;

    public static interface Factory {
        public ISerializer2 newInstance(HttpUtil.MediaType var1, String var2, boolean var3, IURISerializer var4);
    }
}

