/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.AbstractEObjectMarshaller;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.internal.marshal.util.WebServicesXMLResourceImpl;
import com.ibm.team.repository.common.internal.marshal.util.XMLConstructionUtil;
import com.ibm.team.repository.common.internal.marshal.util.XMLNamespaceUtil;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.transport.HttpUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLParserPool;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectMarshaller
extends AbstractEObjectMarshaller {
    private static final long serialVersionUID = 1022760887174062824L;
    public static final String UTF8_ENCODING = HttpUtil.CharsetEncoding.UTF8.toString();
    protected static final EClass ECLASS_TYPE = EcorePackage.eINSTANCE.getEClass();
    protected static final EClass EDATA_TYPE = EcorePackage.eINSTANCE.getEDataType();
    protected static final EClass EENUM_TYPE = EcorePackage.eINSTANCE.getEEnum();
    public static final String OPTION_USE_XML_ELEMENT_TO_REPRESENT_ATTRIBUTE = "USE_XML_ELEMENT_TO_REPRESENT_ATTRIBUTE";
    protected boolean useXmlElementToRepresentAttribute = true;
    protected static XMLParserPool xmlParserPool = new XMLParserPoolImpl();

    private static Map getXmlLoadingOptions(Charset charset) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("USE_PARSER_POOL", xmlParserPool);
        if (charset == null) {
            result.put("ENCODING", UTF8_ENCODING);
        } else {
            result.put("ENCODING", charset.name());
        }
        return result;
    }

    public EObjectMarshaller() {
        super(EObject.class, MarshallerType.EOBJECT_LITERAL);
    }

    public EObjectMarshaller(Class clazz, MarshallerType marshallerType) {
        super(clazz, marshallerType);
    }

    public EObjectMarshaller(Map options) {
        super(EObject.class, MarshallerType.EOBJECT_LITERAL, options);
        if (Boolean.FALSE.equals(options.get(OPTION_USE_XML_ELEMENT_TO_REPRESENT_ATTRIBUTE))) {
            this.useXmlElementToRepresentAttribute = false;
        }
    }

    public EObjectMarshaller(Class clazz, MarshallerType marshallerType, Map options) {
        super(clazz, marshallerType, options);
        if (Boolean.FALSE.equals(options.get(OPTION_USE_XML_ELEMENT_TO_REPRESENT_ATTRIBUTE))) {
            this.useXmlElementToRepresentAttribute = false;
        }
    }

    @Override
    @Deprecated
    public void marshalObjectToOutputStream(Object object, OutputStream outputStream) throws MarshallingException {
        this.marshalObjectToOutputStream(object, outputStream, HttpUtil.CharsetEncoding.UTF8.toCharset());
    }

    @Override
    public void marshalObjectToOutputStream(Object object, OutputStream outputStream, Charset charset) throws MarshallingException {
        if (charset == null) {
            charset = HttpUtil.CharsetEncoding.UTF8.toCharset();
        }
        try {
            Writer writer = XMLConstructionUtil.createWriter(outputStream, charset);
            this.marshalObjectToOutputStreamUsingWriter(object, writer, charset);
            writer.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MarshallingException(unsupportedEncodingException);
        }
        catch (IOException e) {
            throw new MarshallingException(e);
        }
    }

    protected void marshalObjectToOutputStreamUsingWriter(Object object, Writer writer, Charset charset) throws MarshallingException {
        int depth = 0;
        EObject eObject = (EObject)object;
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        String qualifiedClassName = this.getQualifiedEClassName(eClass, ePackage.getNsPrefix());
        this.writeXMLHeader(writer, charset);
        this.marshalContainedObjectToOutputStreamUsingWriter(eObject, qualifiedClassName, writer, null, null, depth);
    }

    protected void writeXMLHeader(Writer writer, Charset charset) throws MarshallingException {
        XMLConstructionUtil.writeXMLHeader(writer, charset);
        XMLConstructionUtil.writeNewLineCharacter(writer);
    }

    protected void marshalContainedObjectToOutputStreamUsingWriter(EObject eObject, String elementName, Writer writer, String containingReferenceType, Map nsURIToNsPrefixMap, int depth) throws MarshallingException {
        EClass eClass = eObject.eClass();
        XMLConstructionUtil.writeElementName(writer, elementName);
        if (depth == 0) {
            Map<String, String> nsPrefixToNsURIMap = XMLNamespaceUtil.getReferencedNamespaces(eObject);
            XMLConstructionUtil.writeNamespaceInformation(writer, nsPrefixToNsURIMap);
            nsURIToNsPrefixMap = XMLNamespaceUtil.constructNsURIToNsPrefixMap(nsPrefixToNsURIMap);
        }
        this.addTypeAttribute(eObject, containingReferenceType, writer, nsURIToNsPrefixMap, depth);
        this.serializeEAttributesAsXMLAttributes(eObject, eClass, writer);
        this.marshalEmptyMultiValuedReferencesAsAttributes(eObject, eClass, writer);
        XMLConstructionUtil.writeEndElementTag(writer);
        this.serializeEAttributesAsXMLElements(eObject, eClass, writer, depth + 1);
        this.marshalReferences(eObject, eClass, writer, nsURIToNsPrefixMap, depth + 1);
        XMLConstructionUtil.writeEndElementName(writer, elementName, depth);
    }

    protected void addTypeAttribute(EObject eObject, String containingReferenceType, Writer writer, Map<String, String> nsUriToNsPrefix, int depth) throws MarshallingException {
        if (depth > 0) {
            String eObjectReferenceType = this.getQualifiedEClassName(eObject, nsUriToNsPrefix);
            if (this.saveTypeInformation || !eObjectReferenceType.equals(containingReferenceType)) {
                XMLConstructionUtil.writeAttribute(writer, "xsi:type", eObjectReferenceType);
            }
        }
    }

    protected void serializeEAttributesAsXMLAttributes(EObject eObject, EClass eClass, Writer writer) throws MarshallingException {
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            if (!this.shouldBeMarshalled(eObject, (EStructuralFeature)attribute) || !this.shouldMarshalAsXMLAttribute(attribute)) continue;
            this.serializeEAttributeAsXMLAtribute(eObject, attribute, writer);
        }
    }

    protected void serializeEAttributeAsXMLAtribute(EObject eObject, EAttribute attribute, Writer writer) throws MarshallingException {
        String marshalledValue = this.serializeEAttributeValue(eObject, attribute);
        if (marshalledValue != null) {
            XMLConstructionUtil.writeAttribute(writer, attribute.getName(), marshalledValue);
        }
    }

    @Override
    protected boolean shouldMarshalAsXMLAttribute(EAttribute attribute) {
        if (!this.useXmlElementToRepresentAttribute) {
            return true;
        }
        return super.shouldMarshalAsXMLAttribute(attribute);
    }

    protected void marshalEmptyMultiValuedReferencesAsAttributes(EObject eObject, EClass eClass, Writer writer) throws MarshallingException {
        for (EReference reference : eClass.getEAllReferences()) {
            if (!this.shouldBeMarshalled(eObject, (EStructuralFeature)reference) || !this.isEmptyListReference(eObject, reference)) continue;
            XMLConstructionUtil.writeEmptyAttribute(reference.getName(), writer);
        }
    }

    private boolean isEmptyListReference(EObject eObject, EReference reference) {
        if (!reference.isMany()) {
            return false;
        }
        List objectValues = (List)eObject.eGet((EStructuralFeature)reference);
        return objectValues != null && objectValues.size() == 0;
    }

    protected void serializeEAttributesAsXMLElements(EObject eObject, EClass eClass, Writer writer, int depth) throws MarshallingException {
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            if (!this.shouldBeMarshalled(eObject, (EStructuralFeature)attribute) || this.shouldMarshalAsXMLAttribute(attribute)) continue;
            if (attribute.isMany()) {
                this.serializeManyValuedEAttributesAsXMLElements(eObject, attribute, writer, depth);
                continue;
            }
            String serializedValue = this.serializeEAttributeValue(eObject, attribute);
            this.serializeAsXMLElement(writer, attribute, serializedValue, depth);
        }
    }

    private void serializeAsXMLElement(Writer writer, EAttribute attribute, String serializedValue, int depth) throws MarshallingException {
        if (serializedValue == null) {
            this.marshalNullElement(attribute.getName(), writer, depth);
        } else {
            XMLConstructionUtil.writeElement(writer, attribute.getName(), serializedValue, depth);
        }
    }

    protected void serializeManyValuedEAttributesAsXMLElements(EObject eObject, EAttribute attribute, Writer writer, int depth) throws MarshallingException {
        Object objectValue = eObject.eGet((EStructuralFeature)attribute);
        if (objectValue == null) {
            this.marshalNullElement(attribute.getName(), writer, depth);
            return;
        }
        Class classZ = attribute.getEType().getInstanceClass();
        Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(classZ);
        if (objectValue instanceof List) {
            List objectValueList = (List)objectValue;
            for (Object attributeValue : objectValueList) {
                if (classZ == FeatureMap.Entry.class) continue;
                String attributeValueAsString = attributeValue != null ? marshaller.marshalObjectToString(attributeValue) : null;
                this.serializeAsXMLElement(writer, attribute, attributeValueAsString, depth);
            }
        }
    }

    protected void marshalReferences(EObject eObject, EClass eClass, Writer writer, Map nsUriToNsPrefixMap, int depth) throws MarshallingException {
        for (EReference reference : eClass.getEAllReferences()) {
            if (!this.shouldBeMarshalled(eObject, (EStructuralFeature)reference)) continue;
            if (reference.isMany()) {
                this.marshalMultiValuedReference(eObject, reference, writer, nsUriToNsPrefixMap, depth);
                continue;
            }
            this.marshalSingleValuedReference(eObject, reference, writer, nsUriToNsPrefixMap, depth);
        }
    }

    private void marshalSingleValuedReference(EObject eObject, EReference reference, Writer writer, Map nsUriToNsPrefixMap, int depth) throws MarshallingException {
        if (!this.marshalEClassifiersUsingHREFs(eObject, reference, writer, depth)) {
            Object objectValue = eObject.eGet((EStructuralFeature)reference);
            if (objectValue == null) {
                this.marshalNullElement(reference.getName(), writer, depth);
            } else if (MarshallerUtil.shouldConsiderAsContainment(reference)) {
                this.marshalContainedReference(reference, objectValue, writer, nsUriToNsPrefixMap, depth);
            } else if (objectValue instanceof ItemHandle) {
                this.marshalItemHandleAssociationReference(reference, (ItemHandle)objectValue, writer, nsUriToNsPrefixMap, depth);
            }
        }
    }

    protected boolean marshalEClassifiersUsingHREFs(EObject eObject, EReference reference, Writer writer, int depth) throws MarshallingException {
        if (reference.getEReferenceType().equals(EDATA_TYPE) || reference.getEReferenceType().equals(ECLASS_TYPE) || reference.getEReferenceType().equals(EENUM_TYPE)) {
            String hrefURI = this.createHREFs(eObject, reference);
            XMLConstructionUtil.writeDataType(writer, reference.getName(), hrefURI, depth);
            return true;
        }
        return false;
    }

    protected void marshalItemHandleAssociationReference(EReference reference, ItemHandle itemHandle, Writer writer, Map nsUriToNsPrefixMap, int depth) throws MarshallingException {
        XMLConstructionUtil.writeNewLineWithTabCharacters(writer, depth);
        UUID itemId = itemHandle.getItemId();
        UUID stateId = itemHandle.getStateId();
        String qualifiedNameOfInstance = this.getQualifiedEClassName(ItemUtil.getHandleEClass((ItemType)((ItemType)itemHandle.getItemType())), (Map<String, String>)nsUriToNsPrefixMap);
        String qualifiedNameOfReferenceType = this.getQualifiedEClassName(ItemUtil.getTargetClassIfFacade((EReference)reference), (Map<String, String>)nsUriToNsPrefixMap);
        if (this.saveTypeInformation) {
            XMLConstructionUtil.writeReference(writer, reference.getName(), itemId != null ? itemId.getUuidValue() : null, stateId != null ? stateId.getUuidValue() : null, qualifiedNameOfInstance);
        } else {
            XMLConstructionUtil.writeReference(writer, reference.getName(), itemId != null ? itemId.getUuidValue() : null, stateId != null ? stateId.getUuidValue() : null, qualifiedNameOfInstance.equals(qualifiedNameOfReferenceType) ? null : qualifiedNameOfInstance);
        }
    }

    private void marshalContainedReference(EReference reference, Object objectValue, Writer writer, Map nsUriToNsPrefixMap, int depth) throws MarshallingException {
        String referenceTypeName = this.getQualifiedEClassName(ItemUtil.getTargetClassIfFacade((EReference)reference), (Map<String, String>)nsUriToNsPrefixMap);
        XMLConstructionUtil.writeNewLineWithTabCharacters(writer, depth);
        this.marshalContainedObjectToOutputStreamUsingWriter((EObject)objectValue, this.getReferenceName((EObject)objectValue, (EStructuralFeature)reference), writer, referenceTypeName, nsUriToNsPrefixMap, depth);
    }

    private void marshalMultiValuedReference(EObject eObject, EReference reference, Writer writer, Map nsUriToNsPrefixMap, int depth) throws MarshallingException {
        List objectValues = (List)eObject.eGet((EStructuralFeature)reference);
        if (objectValues != null && objectValues.size() != 0) {
            if (MarshallerUtil.shouldConsiderAsContainment(reference)) {
                String referenceTypeName = this.getQualifiedEClassName(ItemUtil.getTargetClassIfFacade((EReference)reference), (Map<String, String>)nsUriToNsPrefixMap);
                for (EObject objectValue : objectValues) {
                    XMLConstructionUtil.writeNewLineWithTabCharacters(writer, depth);
                    this.marshalContainedObjectToOutputStreamUsingWriter(objectValue, this.getReferenceName(objectValue, (EStructuralFeature)reference), writer, referenceTypeName, nsUriToNsPrefixMap, depth);
                }
            } else {
                XMLConstructionUtil.writeNewLineCharacter(writer);
                for (Object objectValue : objectValues) {
                    if (objectValue == null || !(objectValue instanceof ItemHandle)) continue;
                    this.marshalItemHandleAssociationReference(reference, (ItemHandle)objectValue, writer, nsUriToNsPrefixMap, depth);
                }
                XMLConstructionUtil.writeNewLineCharacter(writer);
            }
        }
    }

    private void marshalNullElement(String elementName, Writer writer, int depth) throws MarshallingException {
        XMLConstructionUtil.writeNewLineWithTabCharacters(writer, depth);
        XMLConstructionUtil.writeNullElement(writer, elementName);
    }

    @Override
    public String marshalObjectToString(Object object) throws MarshallingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.marshalObjectToOutputStream(object, byteArrayOutputStream);
        try {
            return byteArrayOutputStream.toString(UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return byteArrayOutputStream.toString();
        }
    }

    @Override
    public Object demarshalInputStreamToObject(InputStream inputStream) throws MarshallingException {
        WebServicesXMLResourceImpl webServicesXMLResource = new WebServicesXMLResourceImpl();
        try {
            webServicesXMLResource.doLoad(inputStream, EObjectMarshaller.getXmlLoadingOptions(null));
            return webServicesXMLResource.getContents().get(0);
        }
        catch (IOException e) {
            throw new MarshallingException(e);
        }
    }

    @Override
    public Object demarshalInputStreamToObject(InputStream inputStream, Charset charset) throws MarshallingException {
        if (charset == null) {
            return this.demarshalInputStreamToObject(inputStream);
        }
        WebServicesXMLResourceImpl webServicesXMLResource = new WebServicesXMLResourceImpl();
        webServicesXMLResource.setEncoding(charset.name());
        try {
            webServicesXMLResource.doLoad(inputStream, EObjectMarshaller.getXmlLoadingOptions(charset));
            return webServicesXMLResource.getContents().get(0);
        }
        catch (IOException e) {
            throw new MarshallingException(e);
        }
    }
}

