/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.security.GuardedObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.AppPersistence;
import org.eclipse.equinox.internal.app.EclipseScheduledApplication$TriggerGuard;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ScheduledApplication;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public class EclipseScheduledApplication
implements ScheduledApplication,
EventHandler {
    private static final String FILTER_PREFIX;
    private static final String FILTER_POSTFIX = "))";
    private boolean recurring;
    private String topic;
    private String eventFilter;
    private Map args;
    private String appPid;
    private String id;
    private ServiceRegistration sr;
    private ServiceTracker appTracker;
    private boolean removed = false;
    static Class class$0;

    static {
        StringBuffer stringBuffer = new StringBuffer("(&(objectclass=");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.application.ApplicationDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        FILTER_PREFIX = stringBuffer.append(clazz.getName()).append(")(").append("service.pid").append("=").toString();
    }

    EclipseScheduledApplication(BundleContext bundleContext, String string, String string2, Map map, String string3, String string4, boolean bl) throws InvalidSyntaxException {
        this.id = string;
        this.appPid = string2;
        this.args = map;
        this.topic = string3 == null || string3.trim().equals("") || string3.trim().equals("*") ? null : string3;
        this.eventFilter = string4;
        this.recurring = bl;
        this.appTracker = new ServiceTracker(bundleContext, bundleContext.createFilter(String.valueOf(FILTER_PREFIX) + string2 + FILTER_POSTFIX), null);
        Activator.openTracker(this.appTracker, false);
    }

    public String getScheduleId() {
        return this.id;
    }

    String getAppPid() {
        return this.appPid;
    }

    public synchronized String getTopic() {
        if (this.removed) {
            throw (Throwable)new IllegalStateException(Messages.scheduled_app_removed);
        }
        return this.topic;
    }

    public synchronized String getEventFilter() {
        if (this.removed) {
            throw (Throwable)new IllegalStateException(Messages.scheduled_app_removed);
        }
        return this.eventFilter;
    }

    public synchronized boolean isRecurring() {
        if (this.removed) {
            throw (Throwable)new IllegalStateException(Messages.scheduled_app_removed);
        }
        return this.recurring;
    }

    public synchronized ApplicationDescriptor getApplicationDescriptor() {
        if (this.removed) {
            throw (Throwable)new IllegalStateException(Messages.scheduled_app_removed);
        }
        return (ApplicationDescriptor)Activator.getService(this.appTracker);
    }

    public synchronized Map getArguments() {
        if (this.removed) {
            throw (Throwable)new IllegalStateException(Messages.scheduled_app_removed);
        }
        return this.args == null ? null : new HashMap(this.args);
    }

    private Map getArguments(Event event) {
        Map<String, GuardedObject> map = this.args == null ? new HashMap() : this.getArguments();
        map.put("org.osgi.triggeringevent", new GuardedObject(event, new EclipseScheduledApplication$TriggerGuard(this, event.getTopic())));
        return map;
    }

    public synchronized void remove() {
        if (this.removed) {
            return;
        }
        this.removed = true;
        AppPersistence.removeScheduledApp(this);
        if (this.sr != null) {
            this.sr.unregister();
        }
        this.sr = null;
        this.appTracker.close();
    }

    public synchronized void handleEvent(Event event) {
        try {
            if (this.removed) {
                return;
            }
            ApplicationDescriptor applicationDescriptor = this.getApplicationDescriptor();
            if (applicationDescriptor == null) {
                return;
            }
            applicationDescriptor.launch(this.getArguments(event));
        }
        catch (Exception exception) {
            String string = NLS.bind((String)Messages.scheduled_app_launch_error, (Object)this.sr);
            Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 2, 0, string, 0, (Throwable)exception, null));
            return;
        }
        if (!this.isRecurring()) {
            this.remove();
        }
    }

    synchronized void setServiceRegistration(ServiceRegistration serviceRegistration) {
        this.sr = serviceRegistration;
        if (this.removed) {
            serviceRegistration.unregister();
        }
    }
}

