/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.AnyThreadAppLauncher;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.DefaultApplicationListener;
import org.eclipse.equinox.internal.app.EclipseAppContainer$$Cold;
import org.eclipse.equinox.internal.app.EclipseAppContainer$RegisterService;
import org.eclipse.equinox.internal.app.EclipseAppDescriptor;
import org.eclipse.equinox.internal.app.EclipseAppHandle;
import org.eclipse.equinox.internal.app.IBranding;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.equinox.internal.app.ProductExtensionBranding;
import org.eclipse.equinox.internal.app.ProviderExtensionBranding;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.runnable.ApplicationLauncher;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EclipseAppContainer
implements IRegistryChangeListener,
SynchronousBundleListener,
ServiceTrackerCustomizer {
    private static final String PI_RUNTIME = "org.eclipse.core.runtime";
    private static final String PT_APPLICATIONS = "applications";
    private static final String PT_APP_VISIBLE = "visible";
    private static final String PT_APP_THREAD = "thread";
    private static final String PT_APP_THREAD_ANY = "any";
    private static final String PT_APP_CARDINALITY = "cardinality";
    private static final String PT_APP_CARDINALITY_SINGLETON_GLOBAL = "singleton-global";
    private static final String PT_APP_CARDINALITY_SINGLETON_SCOPED = "singleton-scoped";
    private static final String PT_APP_CARDINALITY_UNLIMITED = "*";
    private static final String PT_PRODUCTS = "products";
    private static final String EXT_ERROR_APP = "org.eclipse.equinox.app.error";
    private static final String PROP_PRODUCT = "eclipse.product";
    private static final String PROP_ECLIPSE_APPLICATION = "eclipse.application";
    private static final String PROP_ECLIPSE_APPLICATION_LAUNCH_DEFAULT = "eclipse.application.launchDefault";
    private static final String PROP_ECLIPSE_REGISTER_APP_DESC = "eclipse.application.registerDescriptors";
    static final int NOT_LOCKED = 0;
    static final int LOCKED_SINGLETON_GLOBAL_RUNNING = 1;
    static final int LOCKED_SINGLETON_GLOBAL_APPS_RUNNING = 2;
    static final int LOCKED_SINGLETON_SCOPED_RUNNING = 3;
    static final int LOCKED_SINGLETON_LIMITED_RUNNING = 4;
    static final int LOCKED_MAIN_THREAD_RUNNING = 5;
    final BundleContext context;
    private final HashMap apps = new HashMap();
    private final IExtensionRegistry extensionRegistry;
    private final ServiceTracker launcherTracker;
    private IBranding branding;
    private boolean missingProductReported;
    private final Collection activeHandles = new ArrayList();
    private EclipseAppHandle activeMain;
    private EclipseAppHandle activeGlobalSingleton;
    private EclipseAppHandle activeScopedSingleton;
    private HashMap activeLimited;
    private String defaultAppId;
    private DefaultApplicationListener defaultAppListener;
    private ParameterizedRunnable defaultMainThreadAppHandle;
    static Class class$0;
    static Class class$1;
    static Class class$2;

    public EclipseAppContainer(BundleContext bundleContext, IExtensionRegistry iExtensionRegistry) {
        this.context = bundleContext;
        this.extensionRegistry = iExtensionRegistry;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.runnable.ApplicationLauncher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        this.launcherTracker = new ServiceTracker(bundleContext, clazz.getName(), (ServiceTrackerCustomizer)this);
    }

    void start() {
        this.launcherTracker.open();
        this.extensionRegistry.addRegistryChangeListener((IRegistryChangeListener)this);
        this.context.addBundleListener((BundleListener)this);
        String string = this.context.getProperty(PROP_ECLIPSE_APPLICATION_LAUNCH_DEFAULT);
        if (string == null || "true".equalsIgnoreCase(string)) {
            boolean bl = "true".equalsIgnoreCase(this.context.getProperty(PROP_ECLIPSE_REGISTER_APP_DESC));
            if (bl) {
                this.registerAppDescriptors();
            }
            try {
                this.startDefaultApp();
            }
            catch (ApplicationException applicationException) {
                Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 4, 0, Messages.application_errorStartDefault, 0, (Throwable)applicationException, null));
                if (!bl) {
                    this.registerAppDescriptors();
                }
            }
        } else {
            this.registerAppDescriptors();
        }
    }

    void stop() {
        this.stopAllApps();
        this.context.removeBundleListener((BundleListener)this);
        this.extensionRegistry.removeRegistryChangeListener((IRegistryChangeListener)this);
        this.apps.clear();
        this.branding = null;
        this.missingProductReported = false;
        this.launcherTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EclipseAppDescriptor getAppDescriptor(String string) {
        EclipseAppDescriptor eclipseAppDescriptor = null;
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            eclipseAppDescriptor = (EclipseAppDescriptor)this.apps.get(string);
        }
        if (eclipseAppDescriptor == null) {
            this.registerAppDescriptor(string);
            hashMap = this.apps;
            synchronized (hashMap) {
                eclipseAppDescriptor = (EclipseAppDescriptor)this.apps.get(string);
            }
        }
        return eclipseAppDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EclipseAppDescriptor createAppDescriptor(IExtension iExtension) {
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            String string;
            EclipseAppDescriptor eclipseAppDescriptor = (EclipseAppDescriptor)this.apps.get(iExtension.getUniqueIdentifier());
            if (eclipseAppDescriptor != null) {
                return eclipseAppDescriptor;
            }
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = 35;
            int n2 = 0;
            if (iConfigurationElementArray.length > 0) {
                String string2;
                String string3;
                String string4;
                string = iConfigurationElementArray[0].getAttribute(PT_APP_VISIBLE);
                if (string != null && !Boolean.valueOf(string).booleanValue()) {
                    n &= 0xFFFFFFFE;
                }
                if (PT_APP_THREAD_ANY.equals(string4 = iConfigurationElementArray[0].getAttribute(PT_APP_THREAD))) {
                    n |= 0x40;
                    n &= 0xFFFFFFDF;
                }
                if ((string3 = iConfigurationElementArray[0].getAttribute(PT_APP_CARDINALITY)) != null) {
                    n &= 0xFFFFFFFD;
                    if (PT_APP_CARDINALITY_SINGLETON_SCOPED.equals(string3)) {
                        n |= 4;
                    } else if (PT_APP_CARDINALITY_UNLIMITED.equals(string3)) {
                        n |= 8;
                    } else if (PT_APP_CARDINALITY_SINGLETON_GLOBAL.equals(string3)) {
                        n |= 2;
                    } else {
                        try {
                            n2 = Integer.parseInt(string3);
                            n |= 0x10;
                        }
                        catch (NumberFormatException numberFormatException) {
                            n |= 2;
                        }
                    }
                }
                if ((string2 = this.getDefaultAppId()) != null && string2.equals(iExtension.getUniqueIdentifier())) {
                    n |= 0x80;
                }
            }
            eclipseAppDescriptor = new EclipseAppDescriptor(Activator.getBundle(iExtension.getContributor()), iExtension.getUniqueIdentifier(), iExtension.getLabel(), n, n2, this);
            String[] stringArray = new String[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.osgi.service.application.ApplicationDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            stringArray[0] = clazz.getName();
            string = (ServiceRegistration)AccessController.doPrivileged(new EclipseAppContainer$RegisterService(this, stringArray, eclipseAppDescriptor, eclipseAppDescriptor.getServiceProperties()));
            eclipseAppDescriptor.setServiceRegistration((ServiceRegistration)string);
            this.apps.put(iExtension.getUniqueIdentifier(), eclipseAppDescriptor);
            return eclipseAppDescriptor;
        }
    }

    PrivilegedAction getRegServiceAction(String[] stringArray, Object object, Dictionary dictionary) {
        return new EclipseAppContainer$RegisterService(this, stringArray, object, dictionary);
    }

    private void startDefaultApp() throws ApplicationException {
        String string = this.getDefaultAppId();
        EclipseAppDescriptor eclipseAppDescriptor = null;
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>(2);
        hashMap.put("eclipse.application.default", Boolean.TRUE);
        if (string == null) {
            hashMap.put("error.exception", new RuntimeException(Messages.application_noIdFound));
            eclipseAppDescriptor = this.getAppDescriptor(EXT_ERROR_APP);
        } else {
            eclipseAppDescriptor = this.getAppDescriptor(string);
            if (eclipseAppDescriptor == null) {
                hashMap.put("error.exception", new RuntimeException(NLS.bind((String)Messages.application_notFound, (Object)string, (Object)this.getAvailableAppsMsg())));
                eclipseAppDescriptor = this.getAppDescriptor(EXT_ERROR_APP);
            }
        }
        if (eclipseAppDescriptor == null) {
            throw (Throwable)new ApplicationException(3, Messages.application_noIdFound);
        }
        ((ApplicationDescriptor)eclipseAppDescriptor).launch(hashMap);
    }

    private void registerAppDescriptor(String string) {
        IExtension iExtension = this.getAppExtension(string);
        if (iExtension != null) {
            this.createAppDescriptor(iExtension);
        }
    }

    IExtension getAppExtension(String string) {
        return this.extensionRegistry.getExtension(PI_RUNTIME, PT_APPLICATIONS, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void launch(EclipseAppHandle eclipseAppHandle) throws Exception {
        this.lock(eclipseAppHandle);
        boolean bl = eclipseAppHandle.isDefault();
        if (((EclipseAppDescriptor)((ApplicationHandle)eclipseAppHandle).getApplicationDescriptor()).getThreadType() == 32) {
            DefaultApplicationListener defaultApplicationListener = null;
            ApplicationLauncher applicationLauncher = null;
            EclipseAppContainer eclipseAppContainer = this;
            synchronized (eclipseAppContainer) {
                applicationLauncher = (ApplicationLauncher)this.launcherTracker.getService();
                if (applicationLauncher == null) {
                    if (bl) {
                        this.defaultMainThreadAppHandle = (ParameterizedRunnable)eclipseAppHandle;
                        return;
                    }
                    throw (Throwable)new ApplicationException(3);
                }
                defaultApplicationListener = this.defaultAppListener;
            }
            if (defaultApplicationListener != null) {
                defaultApplicationListener.launch(eclipseAppHandle);
            } else {
                applicationLauncher.launch((ParameterizedRunnable)eclipseAppHandle, eclipseAppHandle.getArguments().get("application.args"));
            }
        } else {
            AnyThreadAppLauncher.launchEclipseApplication(eclipseAppHandle);
            DefaultApplicationListener defaultApplicationListener = null;
            if (bl) {
                ApplicationLauncher applicationLauncher = null;
                EclipseAppContainer eclipseAppContainer = this;
                synchronized (eclipseAppContainer) {
                    applicationLauncher = (ApplicationLauncher)this.launcherTracker.getService();
                    if (this.defaultAppListener == null) {
                        this.defaultAppListener = new DefaultApplicationListener(eclipseAppHandle);
                    }
                    defaultApplicationListener = this.defaultAppListener;
                    if (applicationLauncher == null) {
                        this.defaultMainThreadAppHandle = (ParameterizedRunnable)defaultApplicationListener;
                        return;
                    }
                }
                applicationLauncher.launch((ParameterizedRunnable)defaultApplicationListener, null);
            }
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if ((0x100 & bundleEvent.getType()) == 0 || bundleEvent.getBundle().getBundleId() != 0L) {
            return;
        }
        this.stopAllApps();
    }

    private void stopAllApps() {
        block15: {
            try {
                ServiceReference[] serviceReferenceArray;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.osgi.service.application.ApplicationHandle");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                    }
                }
                if ((serviceReferenceArray = this.context.getServiceReferences(clazz.getName(), "(!(application.state=STOPPING))")) == null) break block15;
                int n = 0;
                while (n < serviceReferenceArray.length) {
                    block17: {
                        ApplicationHandle applicationHandle = (ApplicationHandle)this.context.getService(serviceReferenceArray[n]);
                        try {
                            try {
                                if (applicationHandle != null) {
                                    applicationHandle.destroy();
                                }
                            }
                            catch (Throwable throwable) {
                                String string = NLS.bind((String)Messages.application_error_stopping, (Object)applicationHandle.getInstanceId());
                                Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", 2, 0, string, 0, throwable, null));
                                if (applicationHandle != null) {
                                    this.context.ungetService(serviceReferenceArray[n]);
                                }
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            if (applicationHandle != null) {
                                this.context.ungetService(serviceReferenceArray[n]);
                            }
                            throw throwable;
                        }
                        if (applicationHandle != null) {
                            this.context.ungetService(serviceReferenceArray[n]);
                        }
                    }
                    ++n;
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
    }

    private String getDefaultAppId() {
        if (this.defaultAppId != null) {
            return this.defaultAppId;
        }
        this.defaultAppId = CommandLineArgs.getApplication();
        if (this.defaultAppId != null) {
            return this.defaultAppId;
        }
        this.defaultAppId = this.context.getProperty(PROP_ECLIPSE_APPLICATION);
        if (this.defaultAppId != null) {
            return this.defaultAppId;
        }
        this.defaultAppId = this.getBranding() == null ? null : this.getBranding().getApplication();
        return this.defaultAppId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAppDescriptors() {
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            Iterator iterator = this.apps.values().iterator();
            while (iterator.hasNext()) {
                ((EclipseAppDescriptor)iterator.next()).refreshProperties();
            }
        }
    }

    synchronized void lock(EclipseAppHandle eclipseAppHandle) throws ApplicationException {
        EclipseAppDescriptor eclipseAppDescriptor = (EclipseAppDescriptor)((ApplicationHandle)eclipseAppHandle).getApplicationDescriptor();
        switch (this.isLocked(eclipseAppDescriptor)) {
            case 0: {
                break;
            }
            case 1: {
                throw (Throwable)new ApplicationException(3, NLS.bind((String)Messages.singleton_running, (Object)((ApplicationHandle)this.activeGlobalSingleton).getInstanceId()));
            }
            case 2: {
                throw (Throwable)new ApplicationException(3, Messages.apps_running);
            }
            case 3: {
                throw (Throwable)new ApplicationException(3, NLS.bind((String)Messages.singleton_running, (Object)((ApplicationHandle)this.activeScopedSingleton).getInstanceId()));
            }
            case 4: {
                throw (Throwable)new ApplicationException(3, NLS.bind((String)Messages.max_running, (Object)((ApplicationDescriptor)eclipseAppDescriptor).getApplicationId()));
            }
            case 5: {
                throw (Throwable)new ApplicationException(3, NLS.bind((String)Messages.main_running, (Object)((ApplicationHandle)this.activeMain).getInstanceId()));
            }
        }
        if (eclipseAppDescriptor.getThreadType() == 32 && this.activeMain != null) {
            throw (Throwable)new IllegalStateException(String.valueOf(Messages.main_running) + ((ApplicationHandle)this.activeMain).getInstanceId());
        }
        switch (eclipseAppDescriptor.getCardinalityType()) {
            case 2: {
                this.activeGlobalSingleton = eclipseAppHandle;
                break;
            }
            case 4: {
                this.activeScopedSingleton = eclipseAppHandle;
                break;
            }
            case 16: {
                ArrayList<EclipseAppHandle> arrayList;
                if (this.activeLimited == null) {
                    this.activeLimited = new HashMap(3);
                }
                if ((arrayList = (ArrayList<EclipseAppHandle>)this.activeLimited.get(((ApplicationDescriptor)eclipseAppDescriptor).getApplicationId())) == null) {
                    arrayList = new ArrayList<EclipseAppHandle>(eclipseAppDescriptor.getCardinality());
                    this.activeLimited.put(((ApplicationDescriptor)eclipseAppDescriptor).getApplicationId(), arrayList);
                }
                arrayList.add(eclipseAppHandle);
                break;
            }
            case 8: {
                break;
            }
        }
        if (eclipseAppDescriptor.getThreadType() == 32) {
            this.activeMain = eclipseAppHandle;
        }
        this.activeHandles.add(eclipseAppHandle);
        this.refreshAppDescriptors();
    }

    synchronized void unlock(EclipseAppHandle eclipseAppHandle) {
        ArrayList arrayList;
        if (this.activeGlobalSingleton == eclipseAppHandle) {
            this.activeGlobalSingleton = null;
        } else if (this.activeScopedSingleton == eclipseAppHandle) {
            this.activeScopedSingleton = null;
        } else if (((EclipseAppDescriptor)((ApplicationHandle)eclipseAppHandle).getApplicationDescriptor()).getCardinalityType() == 16 && this.activeLimited != null && (arrayList = (ArrayList)this.activeLimited.get(((ApplicationHandle)eclipseAppHandle).getApplicationDescriptor().getApplicationId())) != null) {
            ((AbstractCollection)arrayList).remove(eclipseAppHandle);
        }
        if (this.activeMain == eclipseAppHandle) {
            this.activeMain = null;
        }
        if (this.activeHandles.remove(eclipseAppHandle)) {
            this.refreshAppDescriptors();
        }
    }

    synchronized int isLocked(EclipseAppDescriptor eclipseAppDescriptor) {
        if (this.activeGlobalSingleton != null) {
            return 1;
        }
        switch (eclipseAppDescriptor.getCardinalityType()) {
            case 2: {
                if (this.activeHandles.size() <= 0) break;
                return 2;
            }
            case 4: {
                if (this.activeScopedSingleton == null) break;
                return 3;
            }
            case 16: {
                ArrayList arrayList;
                if (this.activeLimited == null || (arrayList = (ArrayList)this.activeLimited.get(((ApplicationDescriptor)eclipseAppDescriptor).getApplicationId())) == null || arrayList.size() < eclipseAppDescriptor.getCardinality()) break;
                return 4;
            }
            case 8: {
                break;
            }
        }
        if (eclipseAppDescriptor.getThreadType() == 32 && this.activeMain != null) {
            return 5;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference serviceReference) {
        ParameterizedRunnable parameterizedRunnable;
        ApplicationLauncher applicationLauncher;
        EclipseAppContainer eclipseAppContainer = this;
        synchronized (eclipseAppContainer) {
            applicationLauncher = (ApplicationLauncher)this.context.getService(serviceReference);
            parameterizedRunnable = this.defaultMainThreadAppHandle;
            this.defaultMainThreadAppHandle = null;
        }
        if (parameterizedRunnable != null) {
            applicationLauncher.launch(parameterizedRunnable, parameterizedRunnable instanceof EclipseAppHandle ? ((EclipseAppHandle)parameterizedRunnable).getArguments().get("application.args") : null);
        }
        return applicationLauncher;
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
    }

    public void removedService(ServiceReference serviceReference, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EclipseAppDescriptor removeAppDescriptor(String string) {
        HashMap hashMap = this.apps;
        synchronized (hashMap) {
            EclipseAppDescriptor eclipseAppDescriptor;
            block4: {
                eclipseAppDescriptor = (EclipseAppDescriptor)this.apps.remove(string);
                if (eclipseAppDescriptor != null) break block4;
                return null;
            }
            eclipseAppDescriptor.unregister();
            return eclipseAppDescriptor;
        }
    }

    private void registerAppDescriptors() {
        IExtension[] iExtensionArray = this.getAvailableAppExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            this.createAppDescriptor(iExtensionArray[n]);
            ++n;
        }
    }

    private IExtension[] getAvailableAppExtensions() {
        IExtensionPoint iExtensionPoint = this.extensionRegistry.getExtensionPoint("org.eclipse.core.runtime.applications");
        if (iExtensionPoint == null) {
            return new IExtension[0];
        }
        return iExtensionPoint.getExtensions();
    }

    String getAvailableAppsMsg() {
        IExtension[] iExtensionArray = this.getAvailableAppExtensions();
        String string = "<NONE>";
        if (iExtensionArray.length != 0) {
            string = iExtensionArray[0].getUniqueIdentifier();
            int n = 1;
            while (n < iExtensionArray.length) {
                string = String.valueOf(string) + ", " + iExtensionArray[n].getUniqueIdentifier();
                ++n;
            }
        }
        return string;
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        this.processAppDeltas(iRegistryChangeEvent.getExtensionDeltas(PI_RUNTIME, PT_APPLICATIONS));
        this.processAppDeltas(iRegistryChangeEvent.getExtensionDeltas("org.eclipse.equinox.app", PT_APPLICATIONS));
    }

    private void processAppDeltas(IExtensionDelta[] iExtensionDeltaArray) {
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            switch (iExtensionDeltaArray[n].getKind()) {
                case 1: {
                    this.createAppDescriptor(iExtensionDeltaArray[n].getExtension());
                    break;
                }
                case 2: {
                    this.removeAppDescriptor(iExtensionDeltaArray[n].getExtension().getUniqueIdentifier());
                }
            }
            ++n;
        }
    }

    public IBranding getBranding() {
        IConfigurationElement[] iConfigurationElementArray;
        if (this.branding != null) {
            return this.branding;
        }
        String string = CommandLineArgs.getProduct();
        if (string == null) {
            if (this.context == null) {
                return null;
            }
            string = this.context.getProperty(PROP_PRODUCT);
            if (string == null) {
                return null;
            }
        }
        if ((iConfigurationElementArray = this.extensionRegistry.getConfigurationElementsFor(PI_RUNTIME, PT_PRODUCTS, string)).length > 0) {
            this.branding = new ProductExtensionBranding(string, iConfigurationElementArray[0]);
            return this.branding;
        }
        IConfigurationElement[] iConfigurationElementArray2 = this.extensionRegistry.getConfigurationElementsFor(PI_RUNTIME, PT_PRODUCTS);
        ArrayList<FrameworkLogEntry> arrayList = null;
        int n = 0;
        while (n < iConfigurationElementArray2.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n];
            if (iConfigurationElement.getName().equalsIgnoreCase("provider")) {
                try {
                    Object object = iConfigurationElement.createExecutableExtension("run");
                    Object[] objectArray = (Object[])EclipseAppContainer.callMethod(object, "getProducts", null, null);
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        if (string.equalsIgnoreCase((String)EclipseAppContainer.callMethod(objectArray[n2], "getId", null, null))) {
                            this.branding = new ProviderExtensionBranding(objectArray[n2]);
                            return this.branding;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<FrameworkLogEntry>(3);
                    }
                    arrayList.add(new FrameworkLogEntry("org.eclipse.equinox.app", NLS.bind((String)Messages.provider_invalid, (Object)iConfigurationElement.getParent().toString()), 0, (Throwable)coreException, null));
                }
            }
            ++n;
        }
        if (arrayList != null) {
            Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", Messages.provider_invalid_general, 0, null, arrayList.toArray(new FrameworkLogEntry[arrayList.size()])));
        }
        if (!this.missingProductReported) {
            Activator.log(new FrameworkLogEntry("org.eclipse.equinox.app", NLS.bind((String)Messages.product_notFound, (Object)string), 0, null, null));
            this.missingProductReported = true;
        }
        return null;
    }

    static Object callMethod(Object object, String string, Class[] classArray, Object[] objectArray) throws  {
        return EclipseAppContainer$$Cold.callMethod(object, string, classArray, objectArray);
    }
}

