/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.common.collection;

import com.ibm.team.repository.rcp.common.collection.IFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> boolean contains(Collection<T> toTest, IFilter<T> theFilter) {
        for (T next : toTest) {
            if (!theFilter.select(next)) continue;
            return true;
        }
        return false;
    }

    public static <T> T findFirst(Collection<T> toTest, IFilter<T> theFilter) {
        for (T next : toTest) {
            if (!theFilter.select(next)) continue;
            return next;
        }
        return null;
    }

    public static <T> List<T> filter(Collection<T> toFilter, IFilter<T> theFilter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T next : toFilter) {
            if (!theFilter.select(next)) continue;
            result.add(next);
        }
        return result;
    }

    public static <K, V> void addAllToMapOfLists(Map<K, List<V>> map, K key, Collection<V> value) {
        List<V> currentList = map.get(key);
        if (currentList == null) {
            currentList = new ArrayList<V>();
            map.put(key, currentList);
        }
        currentList.addAll(value);
    }

    public static <K, V> Map<V, List<K>> invertMap(Map<K, V> inputMap) {
        HashMap result = new HashMap();
        for (Map.Entry<K, V> next : inputMap.entrySet()) {
            CollectionUtil.addToMapOfLists(result, next.getValue(), next.getKey());
        }
        return result;
    }

    public static <K, V> void addToMapOfLists(Map<K, List<V>> toBeModified, Map<K, List<V>> toAdd) {
        for (Map.Entry<K, List<V>> next : toAdd.entrySet()) {
            CollectionUtil.addAllToMapOfLists(toBeModified, next.getKey(), (Collection)next.getValue());
        }
    }

    public static <K, V> List<V> reorderValues(Map<K, V> mapToReorder, List<K> order) {
        ArrayList<V> result = new ArrayList<V>();
        for (K next : order) {
            result.add(mapToReorder.get(next));
        }
        return result;
    }

    public static <T> List<T> filterByType(Collection unfiltered, Class<T> type) {
        ArrayList result = new ArrayList();
        for (Object next : unfiltered) {
            if (next == null || !type.isAssignableFrom(next.getClass())) continue;
            result.add(next);
        }
        return result;
    }

    public static <T> List<T> filterDupes(Collection<T> changeSetSet) {
        ArrayList<T> result = new ArrayList<T>();
        HashSet<T> elements = new HashSet<T>();
        for (T next : changeSetSet) {
            if (!elements.add(next)) continue;
            result.add(next);
        }
        return result;
    }

    public static <T> List<T> removeNulls(List<T> toFilter) {
        boolean hasNulls = false;
        Iterator<T> iter = toFilter.iterator();
        while (iter.hasNext() && !hasNulls) {
            T next = iter.next();
            if (next != null) continue;
            hasNulls = true;
        }
        if (!hasNulls) {
            return toFilter;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T next : toFilter) {
            if (next == null) continue;
            result.add(next);
        }
        return result;
    }

    public static <K, V> void addToMapOfLists(Map<K, List<V>> map, K key, V value) {
        List<V> currentList = map.get(key);
        if (currentList == null) {
            currentList = new ArrayList<V>();
            map.put(key, currentList);
        }
        currentList.add(value);
    }

    public static <T> Set<T> asSet(Collection<T> collection) {
        if (collection instanceof Set) {
            Set cfr_ignored_0 = (Set)collection;
            return (Set)collection;
        }
        HashSet<T> result = new HashSet<T>((int)((double)collection.size() * 1.5));
        result.addAll(collection);
        return result;
    }
}

