/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.core.utils;

import com.ibm.team.repository.rcp.core.internal.LoggingHelper;
import com.ibm.team.repository.rcp.core.internal.Messages;
import com.ibm.team.repository.rcp.core.internal.RepositoryRcpCorePlugin;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class StatusUtil {
    public static void log(IStatus status) {
        Bundle bundle = Platform.getBundle((String)status.getPlugin());
        if (bundle == null) {
            RepositoryRcpCorePlugin plugin = RepositoryRcpCorePlugin.getDefault();
            bundle = plugin != null ? plugin.getBundle() : Platform.getBundle((String)"org.eclipse.core.runtime");
        }
        ILog log = Platform.getLog((Bundle)bundle);
        log.log(status);
    }

    public static void log(Object pluginId, Throwable e) {
        StatusUtil.log(StatusUtil.newStatus(pluginId, e));
    }

    public static void log(Object pluginId, String message) {
        StatusUtil.log(StatusUtil.newStatus(pluginId, message));
    }

    public static void log(Object pluginId, String message, Throwable throwable) {
        StatusUtil.log(StatusUtil.newStatus(pluginId, message, throwable));
    }

    public static void log(Object pluginId, int severity, String message, Throwable throwable) {
        StatusUtil.log(StatusUtil.newStatus(pluginId, severity, message, throwable));
    }

    public static void log(Object pluginId, int severity, String message) {
        StatusUtil.log(StatusUtil.newStatus(pluginId, severity, message));
    }

    public static IStatus newStatus(Object pluginId, String message) {
        return StatusUtil.newStatus(pluginId, 4, message, null);
    }

    public static IStatus newStatus(IStatus originalStatus, String newMessage) {
        if (originalStatus.isMultiStatus()) {
            return new MultiStatus(originalStatus.getPlugin(), originalStatus.getCode(), originalStatus.getChildren(), newMessage, originalStatus.getException());
        }
        return new Status(originalStatus.getSeverity(), originalStatus.getPlugin(), originalStatus.getCode(), newMessage, originalStatus.getException());
    }

    public static IStatus newStatus(Object pluginId, String message, Throwable exception) {
        if (exception instanceof CoreException) {
            MultiStatus multi = new MultiStatus(StatusUtil.getPluginId(exception, pluginId), 0, message, exception);
            multi.add(((CoreException)exception).getStatus());
            return multi;
        }
        return new Status(StatusUtil.getSeverity(exception, 4), StatusUtil.getPluginId(exception, pluginId), 0, message, exception);
    }

    public static IStatus newStatus(Object pluginId, Throwable exception) {
        return StatusUtil.newStatus(pluginId, StatusUtil.getSeverity(exception, 4), StatusUtil.getLocalizedMessage(exception), exception);
    }

    public static IStatus newStatus(Object pluginId, int severity, String message) {
        return StatusUtil.newStatus(pluginId, severity, message, null);
    }

    public static IStatus newStatus(Object plugin, int severity, int code, String message) {
        return StatusUtil.newStatus(plugin, severity, code, message, null);
    }

    public static IStatus newStatus(Object pluginId, int severity, String message, Throwable exception) {
        return StatusUtil.newStatus(pluginId, severity, 0, message, exception);
    }

    public static IStatus newStatus(Object pluginId, int severity, int code, String message, Throwable exception) {
        String statusMessage = message;
        if (exception != null && (message == null || message.trim().length() == 0)) {
            statusMessage = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        }
        String pluginIdStr = StatusUtil.getPluginId(exception, pluginId);
        int errorCode = StatusUtil.getErrorCode(exception, code);
        if (exception instanceof CoreException) {
            MultiStatus multi = new MultiStatus(pluginIdStr, errorCode, message, exception, severity){
                {
                    this.setSeverity(n);
                }
            };
            IStatus status = ((CoreException)exception).getStatus();
            multi.add(status);
            return multi;
        }
        return new Status(severity, pluginIdStr, errorCode, statusMessage, exception);
    }

    public static String getPlugin(Object pluginId) {
        if (pluginId instanceof String) {
            return (String)pluginId;
        }
        if (pluginId instanceof Bundle) {
            return ((Bundle)pluginId).getSymbolicName();
        }
        Class<?> pluginClass = pluginId instanceof Class ? (Class<?>)pluginId : pluginId.getClass();
        Bundle b = null;
        try {
            b = RepositoryRcpCorePlugin.getBundle(pluginClass);
        }
        catch (RuntimeException e) {
            LoggingHelper.log("com.ibm.team.repository.rcp.core", (IStatus)new Status(4, "com.ibm.team.repository.rcp.core", 0, StatusUtil.getLocalizedMessage(e), (Throwable)e));
        }
        if (b == null) {
            LoggingHelper.log("com.ibm.team.repository.rcp.core", (IStatus)new Status(4, "com.ibm.team.repository.rcp.core", 0, NLS.bind((String)"The class {0} was not loaded by a plugin bundle and cannot be used as the context for creating an IStatus. This is a bug in the error handling code. The following error will be logged against plugin {1} even though it actually occurred elsewhere.", (Object)pluginClass.getName(), (Object)"com.ibm.team.repository.rcp.core"), (Throwable)new Exception()));
            return "com.ibm.team.repository.rcp.core";
        }
        return b.getSymbolicName();
    }

    public static int getSeverity(Throwable toCheck, int defaultSeverity) {
        if (toCheck instanceof CoreException) {
            CoreException ce = (CoreException)toCheck;
            return ce.getStatus().getSeverity();
        }
        return defaultSeverity;
    }

    private static String getPluginId(Throwable toCheck, Object defaultId) {
        if (toCheck instanceof CoreException) {
            CoreException ce = (CoreException)toCheck;
            return ce.getStatus().getPlugin();
        }
        return StatusUtil.getPlugin(defaultId);
    }

    public static int getErrorCode(Throwable toCheck, int defaultCode) {
        if (toCheck instanceof CoreException) {
            CoreException ce = (CoreException)toCheck;
            return ce.getStatus().getCode();
        }
        return defaultCode;
    }

    public static Throwable getCause(Throwable exception) {
        Throwable cause = null;
        if (exception != null) {
            if (exception instanceof CoreException) {
                CoreException ce = (CoreException)exception;
                cause = ce.getStatus().getException();
            } else {
                if (exception instanceof InvocationTargetException) {
                    InvocationTargetException ite = (InvocationTargetException)exception;
                    return ite.getTargetException();
                }
                try {
                    Method causeMethod = exception.getClass().getMethod("getCause", new Class[0]);
                    Object o = causeMethod.invoke((Object)exception, new Object[0]);
                    if (o instanceof Throwable) {
                        cause = (Throwable)o;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            if (cause == null) {
                cause = exception;
            }
        }
        return cause;
    }

    public static String getLocalizedMessage(Throwable exception) {
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            return ce.getStatus().getMessage();
        }
        String message = exception.getLocalizedMessage();
        if (message != null) {
            return message;
        }
        return Messages.StatusUtil_3;
    }
}

