/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.core.preferences;

import com.ibm.team.internal.repository.rcp.streams.InputStreamUtil;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.preferences.StreamStore;
import com.ibm.team.repository.rcp.core.utils.FileInputStreamProvider;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.core.utils.StreamReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Bundle;

public final class TempFileStore
extends StreamStore {
    private IPath location;
    private Set<String> requestedFiles = new HashSet<String>();

    public TempFileStore(Bundle bundle, String storeName) {
        this.location = Platform.getStateLocation((Bundle)bundle).append(storeName);
    }

    public TempFileStore(IPath path) {
        this.location = path;
    }

    private File getFile(String relativeName) {
        return this.location.append(relativeName).toFile();
    }

    private String getRelativeName(File theFile) {
        return theFile.getName();
    }

    private File createFile() throws IOException {
        String randomFilename;
        File theFile;
        while ((theFile = this.location.append(randomFilename = UUID.generate().getUuidValue()).toFile()).exists()) {
        }
        this.location.toFile().mkdirs();
        theFile.createNewFile();
        return theFile;
    }

    public void clearStore() {
        File[] files = this.location.toFile().listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            file.delete();
            ++i;
        }
        this.location.toFile().delete();
    }

    public IInputStreamProvider loadStream(String handle, IProgressMonitor monitor) throws CoreException {
        File theFile = this.getFile(handle);
        FileInputStreamProvider inputStream = new FileInputStreamProvider(theFile);
        this.requestedFiles.add(handle);
        return inputStream;
    }

    public String saveStream(IInputStreamProvider inputStream, IProgressMonitor monitor) throws CoreException {
        FileInputStreamProvider fisp;
        File theFile;
        Path path;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (inputStream instanceof StreamReference) {
            StreamReference ref = (StreamReference)inputStream;
            inputStream = ref.getOriginal();
        }
        if (inputStream instanceof FileInputStreamProvider && (path = new Path((theFile = (fisp = (FileInputStreamProvider)inputStream).getFile()).getAbsolutePath())).removeLastSegments(1).equals((Object)this.location)) {
            String handle = this.getRelativeName(theFile);
            this.requestedFiles.add(handle);
            return handle;
        }
        try {
            File newFile = this.createFile();
            FileOutputStream fos = new FileOutputStream(newFile);
            try {
                InputStream is = inputStream.getInputStream((IProgressMonitor)progress.newChild(50));
                try {
                    InputStreamUtil.copyStream((OutputStream)fos, (InputStream)is, (IProgressMonitor)progress.newChild(50));
                }
                finally {
                    is.close();
                }
            }
            finally {
                fos.close();
            }
            String result = this.getRelativeName(newFile);
            this.requestedFiles.add(result);
            return result;
        }
        catch (IOException e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, e));
        }
    }

    public void deleteUnreferenced() {
        File[] children = this.location.toFile().listFiles();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            String name;
            File child = children[i];
            if (child.isFile() && !this.requestedFiles.contains(name = this.getRelativeName(child))) {
                child.delete();
            }
            ++i;
        }
    }

    public void clearReferences() {
        this.requestedFiles.clear();
    }
}

