/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.core.preferences;

import com.ibm.team.repository.rcp.core.preferences.StringStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class StringStoreToPreferencesAdapter
implements Preferences,
IEclipsePreferences {
    private static final String SEPARATOR = "/";
    private Preferences parent;
    private StringStore memento;
    private String cachedAbsolutePath;
    private String name;
    private Map cachedChildren = new HashMap();
    private List nodeListeners = new ArrayList();
    private List preferenceListeners = new ArrayList();
    private IEclipsePreferences.IPreferenceChangeListener childPreferenceChangeListener;
    private StringStore.NodeListener storeNodeListener = new StringStore.NodeListener(){

        public void childAdded(StringStore parent, String added) {
            StringStoreToPreferencesAdapter.this.initChild(added);
            IEclipsePreferences node = StringStoreToPreferencesAdapter.this.getChild(added);
            IEclipsePreferences.NodeChangeEvent event = new IEclipsePreferences.NodeChangeEvent((Preferences)StringStoreToPreferencesAdapter.this, (Preferences)node);
            for (IEclipsePreferences.INodeChangeListener listener : StringStoreToPreferencesAdapter.this.nodeListeners) {
                listener.added(event);
            }
        }

        public void childRemoved(StringStore parent, String removed) {
            IEclipsePreferences node = StringStoreToPreferencesAdapter.this.getChild(removed);
            StringStoreToPreferencesAdapter.this.cachedChildren.remove(node.name());
            IEclipsePreferences.NodeChangeEvent event = new IEclipsePreferences.NodeChangeEvent((Preferences)StringStoreToPreferencesAdapter.this, (Preferences)node);
            for (IEclipsePreferences.INodeChangeListener listener : StringStoreToPreferencesAdapter.this.nodeListeners) {
                listener.removed(event);
            }
        }
    };
    private StringStore.ValueListener storeValueListener = new StringStore.ValueListener(){

        public void changed(StringStore.StoreChangeEvent storeEvent) {
            IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)StringStoreToPreferencesAdapter.this, storeEvent.getKey(), (Object)storeEvent.getOldValue(), (Object)storeEvent.getNewValue());
            for (IEclipsePreferences.IPreferenceChangeListener listener : StringStoreToPreferencesAdapter.this.preferenceListeners) {
                listener.preferenceChange(event);
            }
        }
    };

    public StringStoreToPreferencesAdapter(StringStore toWrap) {
        this(toWrap, null, SEPARATOR);
    }

    public StringStoreToPreferencesAdapter(StringStore toWrap, StringStoreToPreferencesAdapter parent, String name) {
        this.parent = parent;
        this.memento = toWrap;
        this.name = name;
    }

    public String absolutePath() {
        if (this.cachedAbsolutePath == null) {
            String parentPath;
            this.cachedAbsolutePath = this.parent == null ? SEPARATOR : ((parentPath = this.parent.absolutePath()).endsWith(SEPARATOR) ? String.valueOf(parentPath) + this.name() : String.valueOf(parentPath) + SEPARATOR + this.name());
        }
        return this.cachedAbsolutePath;
    }

    public String[] childrenNames() {
        return this.memento.childrenNames();
    }

    public String get(String key, String def) {
        String result = this.memento.get(key);
        if (result == null) {
            return def;
        }
        return result;
    }

    public boolean getBoolean(String key, boolean def) {
        String result = this.memento.get(key);
        if (result == null) {
            return def;
        }
        return Boolean.valueOf(result);
    }

    public byte[] getByteArray(String key, byte[] def) {
        throw new RuntimeException("This method has not been implemented yet");
    }

    public double getDouble(String key, double def) {
        String result = this.memento.get(key);
        if (result == null) {
            return def;
        }
        try {
            return Double.parseDouble(result);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public float getFloat(String key, float def) {
        String result = this.memento.get(key);
        if (result == null) {
            return def;
        }
        try {
            return Float.parseFloat(result);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public int getInt(String key, int def) {
        String result = this.memento.get(key);
        if (result == null) {
            return def;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public long getLong(String key, long def) {
        String result = this.memento.get(key);
        if (result == null) {
            return def;
        }
        try {
            return Long.parseLong(result);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public String[] keys() throws BackingStoreException {
        try {
            return this.memento.keys();
        }
        catch (UnsupportedOperationException e) {
            throw new BackingStoreException("Operation not supported", (Throwable)e);
        }
    }

    public String name() {
        return this.name;
    }

    public Preferences node(String pathName) {
        if (pathName.length() == 0) {
            return this;
        }
        int separatorIdx = pathName.indexOf(SEPARATOR);
        if (separatorIdx == 0) {
            return this.getRoot().node(pathName.substring(1));
        }
        String childName = pathName;
        String remain = "";
        if (separatorIdx != -1) {
            childName = pathName.substring(0, separatorIdx);
            remain = pathName.substring(separatorIdx + 1, pathName.length());
        }
        return this.getChild(childName).node(remain);
    }

    private IEclipsePreferences getChild(String childName) {
        StringStore child;
        IEclipsePreferences result = (IEclipsePreferences)this.cachedChildren.get(childName);
        if (result == null && (child = this.memento.createChild(childName)) != null) {
            result = new StringStoreToPreferencesAdapter(child, this, childName);
        }
        return result;
    }

    private Preferences getRoot() {
        StringStoreToPreferencesAdapter current = this;
        while (current.parent() != null) {
            current = current.parent();
        }
        return current;
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        StringStore child;
        if (pathName.length() == 0) {
            return true;
        }
        int separatorIdx = pathName.indexOf(SEPARATOR);
        if (separatorIdx == 0) {
            return this.getRoot().nodeExists(pathName.substring(1));
        }
        String childName = pathName;
        String remain = "";
        if (separatorIdx != -1) {
            childName = pathName.substring(0, separatorIdx);
            remain = pathName.substring(separatorIdx + 1, pathName.length());
        }
        if ((child = this.memento.getChild(childName)) == null) {
            return false;
        }
        return new StringStoreToPreferencesAdapter(child, this, childName).nodeExists(remain);
    }

    public Preferences parent() {
        return this.parent;
    }

    public void put(String key, String value) {
        this.memento.putString(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.memento.putString(key, Boolean.toString(value));
    }

    public void putByteArray(String key, byte[] value) {
        throw new RuntimeException("This method has not been implemented yet");
    }

    public void putDouble(String key, double value) {
        this.memento.putString(key, Double.toString(value));
    }

    public void putFloat(String key, float value) {
        this.memento.putString(key, Float.toString(value));
    }

    public void putInt(String key, int value) {
        this.memento.putString(key, Integer.toString(value));
    }

    public void putLong(String key, long value) {
        this.memento.putString(key, Long.toString(value));
    }

    public void remove(String key) {
        this.memento.removeString(key);
    }

    public void removeNode() throws BackingStoreException {
        if (this.parent instanceof StringStoreToPreferencesAdapter) {
            StringStoreToPreferencesAdapter castParent = (StringStoreToPreferencesAdapter)this.parent;
            castParent.memento.removeChild(this.name);
        }
    }

    public void sync() throws BackingStoreException {
    }

    public void clear() throws BackingStoreException {
    }

    public void flush() throws BackingStoreException {
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        if (!visitor.visit((IEclipsePreferences)this)) {
            return;
        }
        String[] childrenNames = this.childrenNames();
        int i = 0;
        while (i < childrenNames.length) {
            String name = childrenNames[i];
            IEclipsePreferences next = this.getChild(name);
            if (next != null) {
                next.accept(visitor);
            }
            ++i;
        }
    }

    private void attachListeners() {
        this.memento.addNodeListener(this.storeNodeListener);
        this.memento.addValueListener(this.storeValueListener);
        String[] childNames = this.childrenNames();
        int i = 0;
        while (i < childNames.length) {
            String key = childNames[i];
            this.initChild(key);
            ++i;
        }
    }

    private void detachListeners() {
        this.memento.removeNodeListener(this.storeNodeListener);
        this.memento.removeValueListener(this.storeValueListener);
        this.cachedChildren.clear();
    }

    private void initChild(String key) {
        StringStore child = this.memento.getChild(key);
        if (child != null) {
            StringStoreToPreferencesAdapter adapter = new StringStoreToPreferencesAdapter(child, this, key);
            this.cachedChildren.put(key, adapter);
        }
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        if (!this.hasListeners()) {
            this.attachListeners();
        }
        this.nodeListeners.add(listener);
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (!this.hasListeners()) {
            this.attachListeners();
        }
        this.preferenceListeners.add(listener);
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        if (!this.hasListeners()) {
            return;
        }
        this.nodeListeners.remove(listener);
        if (!this.hasListeners()) {
            this.detachListeners();
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (!this.hasListeners()) {
            return;
        }
        this.preferenceListeners.remove(listener);
        if (!this.hasListeners()) {
            this.detachListeners();
        }
    }

    private boolean hasListeners() {
        return !this.preferenceListeners.isEmpty() || !this.nodeListeners.isEmpty();
    }
}

