/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.core.preferences;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

public abstract class StringStore {
    private List valueListeners = new ArrayList();
    private List nodeListeners = new ArrayList();

    public void addValueListener(ValueListener toAdd) {
        this.valueListeners.add(toAdd);
    }

    public void removeValueListener(ValueListener toRemove) {
        this.valueListeners.remove(toRemove);
    }

    public void addNodeListener(NodeListener toAdd) {
        this.nodeListeners.add(toAdd);
    }

    public void removeNodeListener(NodeListener toRemove) {
        this.nodeListeners.remove(toRemove);
    }

    protected final void fireNodeChangeEvent(String key, boolean added) {
        for (NodeListener listener : this.nodeListeners) {
            if (added) {
                listener.childAdded(this, key);
                continue;
            }
            listener.childRemoved(this, key);
        }
    }

    protected final void fireValueChangeEvent(String key, String oldValue, String newValue) {
        StoreChangeEvent event = new StoreChangeEvent(this, key, oldValue, newValue);
        for (ValueListener listener : this.valueListeners) {
            listener.changed(event);
        }
    }

    public abstract String get(String var1);

    public abstract StringStore getChild(String var1);

    public String[] keys() {
        throw new UnsupportedOperationException();
    }

    public String[] childrenNames() {
        throw new UnsupportedOperationException();
    }

    public StringStore createChild(String key) {
        throw new UnsupportedOperationException();
    }

    public void putString(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public void removeString(String key) {
        throw new UnsupportedOperationException();
    }

    public void removeChild(String key) {
        throw new UnsupportedOperationException();
    }

    public static interface NodeListener {
        public void childAdded(StringStore var1, String var2);

        public void childRemoved(StringStore var1, String var2);
    }

    public static final class StoreChangeEvent
    extends EventObject {
        private String key;
        private String oldValue;
        private String newValue;

        public StoreChangeEvent(StringStore source, String key, String oldValue, String newValue) {
            super(source);
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public StringStore getStore() {
            return (StringStore)this.source;
        }
    }

    public static interface ValueListener {
        public void changed(StoreChangeEvent var1);
    }
}

