/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

public class Semaphore {
    protected long notifications;
    protected Runnable runnable;

    public Semaphore(Runnable runnable) {
        this.runnable = runnable;
        this.notifications = 0L;
    }

    public synchronized boolean acquire(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw (Throwable)new InterruptedException();
        }
        long l2 = System.currentTimeMillis();
        long l3 = l;
        while (true) {
            if (this.notifications > 0L) {
                --this.notifications;
                return true;
            }
            if (l3 <= 0L) {
                return false;
            }
            this.wait(l3);
            l3 = l2 + l - System.currentTimeMillis();
        }
    }

    public boolean equals(Object object) {
        return this.runnable == ((Semaphore)object).runnable;
    }

    public int hashCode() {
        return this.runnable == null ? 0 : this.runnable.hashCode();
    }

    public synchronized void release() {
        ++this.notifications;
        this.notifyAll();
    }

    public String toString() {
        return "Semaphore(" + this.runnable + ")";
    }
}

