/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.jobs.Queue;
import org.eclipse.core.internal.jobs.Semaphore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class OrderedLock
implements ILock,
ISchedulingRule {
    private static final boolean DEBUG = false;
    private static int nextLockNumber = 0;
    private volatile Thread currentOperationThread;
    private int depth;
    private final LockManager manager;
    private final int number;
    private final Queue operations = new Queue();

    OrderedLock(LockManager lockManager) {
        this.manager = lockManager;
        this.number = nextLockNumber++;
    }

    public void acquire() {
        while (true) {
            try {
                while (!this.acquire(Long.MAX_VALUE)) {
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public boolean acquire(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw (Throwable)new InterruptedException();
        }
        boolean bl = false;
        if (l <= 0L) {
            return this.attempt();
        }
        Semaphore semaphore = this.createSemaphore();
        if (semaphore == null) {
            return true;
        }
        bl = this.doAcquire(semaphore, l);
        this.manager.resumeSuspendedLocks(Thread.currentThread());
        return bl;
    }

    private synchronized boolean attempt() {
        if (this.currentOperationThread == Thread.currentThread() || this.currentOperationThread == null && this.operations.isEmpty()) {
            ++this.depth;
            this.setCurrentOperationThread(Thread.currentThread());
            return true;
        }
        return false;
    }

    public boolean contains(ISchedulingRule iSchedulingRule) {
        return false;
    }

    private synchronized Semaphore createSemaphore() {
        return this.attempt() ? null : this.enqueue(new Semaphore(Thread.currentThread()));
    }

    private boolean doAcquire(Semaphore semaphore, long l) throws InterruptedException {
        boolean bl = false;
        if (this.manager.aboutToWait(this.currentOperationThread)) {
            this.removeFromQueue(semaphore);
            ++this.depth;
            this.manager.addLockThread(this.currentOperationThread, this);
            return true;
        }
        semaphore = this.createSemaphore();
        if (semaphore == null) {
            return true;
        }
        this.manager.addLockWaitThread(Thread.currentThread(), this);
        try {
            bl = semaphore.acquire(l);
        }
        catch (InterruptedException interruptedException) {
            throw (Throwable)interruptedException;
        }
        if (bl) {
            ++this.depth;
            this.updateCurrentOperation();
        } else {
            this.removeFromQueue(semaphore);
            this.manager.removeLockWaitThread(Thread.currentThread(), this);
        }
        return bl;
    }

    private synchronized void doRelease() {
        this.manager.aboutToRelease();
        this.depth = 0;
        Semaphore semaphore = (Semaphore)this.operations.peek();
        this.setCurrentOperationThread(null);
        if (semaphore != null) {
            semaphore.release();
        }
    }

    private synchronized Semaphore enqueue(Semaphore semaphore) {
        Semaphore semaphore2 = (Semaphore)this.operations.get(semaphore);
        if (semaphore2 == null) {
            this.operations.enqueue(semaphore);
            return semaphore;
        }
        return semaphore2;
    }

    protected int forceRelease() {
        int n = this.depth;
        this.doRelease();
        return n;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isConflicting(ISchedulingRule iSchedulingRule) {
        return iSchedulingRule == this;
    }

    public void release() {
        if (this.depth == 0) {
            return;
        }
        Assert.isTrue((this.depth >= 0 ? 1 : 0) != 0, (String)"Lock released too many times");
        if (--this.depth == 0) {
            this.doRelease();
        } else {
            this.manager.removeLockThread(this.currentOperationThread, this);
        }
    }

    private synchronized void removeFromQueue(Semaphore semaphore) {
        this.operations.remove(semaphore);
    }

    private void setCurrentOperationThread(Thread thread) {
        if (this.currentOperationThread != null && thread == null) {
            this.manager.removeLockThread(this.currentOperationThread, this);
        }
        this.currentOperationThread = thread;
        if (this.currentOperationThread != null) {
            this.manager.addLockThread(this.currentOperationThread, this);
        }
    }

    protected void setDepth(int n) {
        int n2 = this.depth;
        while (n2 < n) {
            this.manager.addLockThread(this.currentOperationThread, this);
            ++n2;
        }
        this.depth = n;
    }

    public String toString() {
        return "OrderedLock (" + this.number + ")";
    }

    private synchronized void updateCurrentOperation() {
        this.operations.dequeue();
        this.setCurrentOperationThread(Thread.currentThread());
    }
}

