/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.jobs.ImplicitJobs$$Cold;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ImplicitJobs {
    private ThreadJob jobCache = null;
    protected JobManager manager;
    private final Set suspendedRules = new HashSet(20);
    private final Map threadJobs = new HashMap(20);

    ImplicitJobs(JobManager jobManager) {
        this.manager = jobManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void begin(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor, boolean bl) {
        Object object;
        ThreadJob threadJob;
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Begin rule: " + iSchedulingRule);
        }
        Thread thread = Thread.currentThread();
        ImplicitJobs implicitJobs = this;
        synchronized (implicitJobs) {
            threadJob = (ThreadJob)this.threadJobs.get(thread);
            if (threadJob != null) {
                threadJob.push(iSchedulingRule);
                return;
            }
            if (iSchedulingRule == null) {
                return;
            }
            object = this.manager.currentJob();
            if (object != null && ((Job)object).getRule() != null) {
                threadJob = this.newThreadJob(((Job)object).getRule());
            } else {
                threadJob = this.newThreadJob(iSchedulingRule);
                threadJob.acquireRule = true;
            }
            if (this.isSuspended(iSchedulingRule)) {
                threadJob.acquireRule = false;
            }
            threadJob.setRealJob((Job)object);
            ((Job)threadJob).setThread(thread);
        }
        try {
            threadJob.push(iSchedulingRule);
            if (threadJob.acquireRule) {
                if (this.manager.runNow(threadJob)) {
                    this.manager.getLockManager().addLockThread(Thread.currentThread(), iSchedulingRule);
                } else {
                    threadJob = threadJob.joinRun(iProgressMonitor);
                }
            }
        }
        catch (Throwable throwable) {
            object = this;
            synchronized (object) {
                this.threadJobs.put(thread, threadJob);
                if (bl) {
                    this.suspendedRules.add(iSchedulingRule);
                }
            }
            if (threadJob.isBlocked) {
                threadJob.isBlocked = false;
                this.manager.reportUnblocked(iProgressMonitor);
            }
            throw throwable;
        }
        object = this;
        synchronized (object) {
            this.threadJobs.put(thread, threadJob);
            if (bl) {
                this.suspendedRules.add(iSchedulingRule);
            }
        }
        if (threadJob.isBlocked) {
            threadJob.isBlocked = false;
            this.manager.reportUnblocked(iProgressMonitor);
        }
    }

    synchronized void end(ISchedulingRule iSchedulingRule, boolean bl) {
        ThreadJob threadJob;
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("End rule: " + iSchedulingRule);
        }
        if ((threadJob = (ThreadJob)this.threadJobs.get(Thread.currentThread())) == null) {
            Assert.isLegal((iSchedulingRule == null ? 1 : 0) != 0, (String)("endRule without matching beginRule: " + iSchedulingRule));
        } else if (threadJob.pop(iSchedulingRule)) {
            this.endThreadJob(threadJob, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endJob(InternalJob internalJob) {
        Status status;
        Thread thread = Thread.currentThread();
        ImplicitJobs implicitJobs = this;
        synchronized (implicitJobs) {
            ThreadJob threadJob = (ThreadJob)this.threadJobs.get(thread);
            if (threadJob == null) {
                if (internalJob.getRule() != null) {
                    this.notifyWaitingThreadJobs();
                }
                return;
            }
            String string = "Worker thread ended job: " + internalJob + ", but still holds rule: " + threadJob;
            status = new Status(4, "org.eclipse.core.jobs", 1, string, null);
            this.endThreadJob(threadJob, false);
        }
        try {
            RuntimeLog.log((IStatus)((IStatus)status));
        }
        catch (RuntimeException runtimeException) {
            System.err.println(status.getMessage());
        }
    }

    private void endThreadJob(ThreadJob threadJob, boolean bl) {
        Thread thread = Thread.currentThread();
        this.threadJobs.remove(thread);
        ISchedulingRule iSchedulingRule = ((Job)threadJob).getRule();
        if (bl && iSchedulingRule != null) {
            this.suspendedRules.remove(iSchedulingRule);
        }
        if (threadJob.acquireRule) {
            this.manager.getLockManager().removeLockThread(thread, iSchedulingRule);
            this.notifyWaitingThreadJobs();
        }
        if (threadJob.isRunning()) {
            this.manager.endJob(threadJob, Status.OK_STATUS, false);
        }
        this.recycle(threadJob);
    }

    private boolean isSuspended(ISchedulingRule iSchedulingRule) {
        if (this.suspendedRules.size() == 0) {
            return false;
        }
        Iterator iterator = this.suspendedRules.iterator();
        while (iterator.hasNext()) {
            if (!((ISchedulingRule)iterator.next()).contains(iSchedulingRule)) continue;
            return true;
        }
        return false;
    }

    private ThreadJob newThreadJob(ISchedulingRule iSchedulingRule) {
        if (this.jobCache != null) {
            ThreadJob threadJob = this.jobCache;
            ((Job)threadJob).setRule(iSchedulingRule);
            threadJob.isRunning = false;
            threadJob.acquireRule = false;
            threadJob.realJob = null;
            this.jobCache = null;
            return threadJob;
        }
        return new ThreadJob(this.manager, iSchedulingRule);
    }

    private void notifyWaitingThreadJobs() throws  {
        ImplicitJobs$$Cold.notifyWaitingThreadJobs(this);
    }

    private void recycle(ThreadJob threadJob) {
        if (this.jobCache == null && threadJob.recycle()) {
            this.jobCache = threadJob;
        }
    }

    void resume(ISchedulingRule iSchedulingRule) throws  {
        ImplicitJobs$$Cold.resume(this, iSchedulingRule);
    }

    void suspend(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws  {
        ImplicitJobs$$Cold.suspend(this, iSchedulingRule, iProgressMonitor);
    }

    synchronized void transfer(ISchedulingRule iSchedulingRule, Thread thread) {
        if (iSchedulingRule == null) {
            return;
        }
        Thread thread2 = Thread.currentThread();
        if (thread2 == thread) {
            return;
        }
        ThreadJob threadJob = (ThreadJob)this.threadJobs.get(thread);
        Assert.isLegal((threadJob == null ? 1 : 0) != 0);
        threadJob = (ThreadJob)this.threadJobs.get(thread2);
        Assert.isNotNull((Object)threadJob);
        Assert.isLegal((((Job)threadJob).getRule() == iSchedulingRule ? 1 : 0) != 0);
        ((Job)threadJob).setThread(thread);
        this.threadJobs.remove(thread2);
        this.threadJobs.put(thread, threadJob);
        if (threadJob.acquireRule) {
            this.manager.getLockManager().removeLockThread(thread2, iSchedulingRule);
            this.manager.getLockManager().addLockThread(thread, iSchedulingRule);
        }
    }
}

