/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.launcher;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.equinox.launcher.JNIBridge;
import org.eclipse.equinox.launcher.Main$$Cold;
import org.eclipse.equinox.launcher.Main$EclipsePolicy;
import org.eclipse.equinox.launcher.Main$Identifier;
import org.eclipse.equinox.launcher.Main$SplashHandler;
import org.eclipse.equinox.launcher.Main$StartupClassLoader;

public class Main {
    protected boolean debug = false;
    protected String bootLocation = null;
    protected URL installLocation = null;
    protected URL configurationLocation = null;
    protected String parentConfigurationLocation = null;
    protected String framework = "org.eclipse.osgi";
    protected String devClassPath = null;
    private Properties devClassPathProps = null;
    protected boolean inDevelopmentMode = false;
    protected String os = null;
    protected String ws = null;
    protected String arch = null;
    private String library = null;
    private String exitData = null;
    private String vm = null;
    private String[] vmargs = null;
    private String[] commands = null;
    String[] extensionPaths = null;
    JNIBridge bridge = null;
    private boolean showSplash = false;
    private String splashLocation = null;
    private String endSplash = null;
    private boolean initialize = false;
    private boolean splashDown = false;
    private final Thread splashHandler = new Main$SplashHandler(this);
    public static final String SPLASH_HANDLE = "org.eclipse.equinox.launcher.splash.handle";
    public static final String SPLASH_LOCATION = "org.eclipse.equinox.launcher.splash.location";
    private static final String FRAMEWORK = "-framework";
    private static final String INSTALL = "-install";
    private static final String INITIALIZE = "-initialize";
    private static final String VM = "-vm";
    private static final String VMARGS = "-vmargs";
    private static final String DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String CONFIGURATION = "-configuration";
    private static final String NOSPLASH = "-nosplash";
    private static final String SHOWSPLASH = "-showsplash";
    private static final String EXITDATA = "-exitdata";
    private static final String NAME = "-name";
    private static final String LAUNCHER = "-launcher";
    private static final String LIBRARY = "--launcher.library";
    private static final String NL = "-nl";
    private static final String ENDSPLASH = "-endsplash";
    private static final String SPLASH_IMAGE = "splash.bmp";
    private static final String CLEAN = "-clean";
    private static final String NOEXIT = "-noExit";
    private static final String OS = "-os";
    private static final String WS = "-ws";
    private static final String ARCH = "-arch";
    private static final String STARTUP = "-startup";
    private static final String OSGI = "org.eclipse.osgi";
    private static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static final String PLATFORM_URL = "platform:/base/";
    private static final String ECLIPSE_PROPERTIES = "eclipse.properties";
    private static final String FILE_SCHEME = "file:";
    protected static final String REFERENCE_SCHEME = "reference:";
    protected static final String JAR_SCHEME = "jar:";
    private static final String CONFIG_DIR = "configuration/";
    private static final String CONFIG_FILE = "config.ini";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String PROP_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    private static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    private static final String PROP_BASE_CONFIG_AREA = "osgi.baseConfiguration.area";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    protected static final String PROP_FRAMEWORK = "osgi.framework";
    private static final String PROP_SPLASHPATH = "osgi.splashPath";
    private static final String PROP_SPLASHLOCATION = "osgi.splashLocation";
    private static final String PROP_CLASSPATH = "osgi.frameworkClassPath";
    private static final String PROP_EXTENSIONS = "osgi.framework.extensions";
    private static final String PROP_FRAMEWORK_SYSPATH = "osgi.syspath";
    private static final String PROP_FRAMEWORK_SHAPE = "osgi.framework.shape";
    private static final String PROP_LOGFILE = "osgi.logfile";
    private static final String PROP_REQUIRED_JAVA_VERSION = "osgi.requiredJavaVersion";
    private static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    private static final String PROP_FRAMEWORK_PARENT_CLASSLOADER = "osgi.frameworkParentClassloader";
    private static final String PROP_NL = "osgi.nl";
    static final String PROP_NOSHUTDOWN = "osgi.noShutdown";
    private static final String PROP_DEBUG = "osgi.debug";
    private static final String PROP_EXITCODE = "eclipse.exitcode";
    private static final String PROP_EXITDATA = "eclipse.exitdata";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_ECLIPSESECURITY = "eclipse.security";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    private static final String PARENT_CLASSLOADER_APP = "app";
    private static final String PARENT_CLASSLOADER_EXT = "ext";
    private static final String PARENT_CLASSLOADER_BOOT = "boot";
    private static final String PARENT_CLASSLOADER_CURRENT = "current";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final int ERROR = 4;
    protected static final String PLUGIN_ID = "org.eclipse.equinox.launcher";
    protected File logFile = null;
    protected BufferedWriter log = null;
    protected boolean newSession = true;
    static Class class$0;
    static Class class$1;
    static Class class$2;
    static Class class$3;
    static Class class$4;

    private void setupJNI(URL[] uRLArray) {
        Object object;
        String string = null;
        if (this.library != null) {
            object = new File(this.library);
            if (((File)object).isDirectory()) {
                string = this.searchFor(ECLIPSE, ((File)object).getAbsolutePath());
            } else if (((File)object).exists()) {
                string = ((File)object).getAbsolutePath();
            }
        }
        if (string == null) {
            String string2;
            File file;
            Object object2;
            Object object3;
            object = this.getOS();
            StringBuffer stringBuffer = new StringBuffer(PLUGIN_ID);
            stringBuffer.append('.');
            stringBuffer.append(this.getWS());
            stringBuffer.append('.');
            stringBuffer.append((String)object);
            if (!((String)object).equals("macosx")) {
                stringBuffer.append('.');
                stringBuffer.append(this.getArch());
            }
            String string3 = stringBuffer.toString();
            String string4 = null;
            if (this.inDevelopmentMode && ((String[])(object3 = this.getArrayFromList((String)(object2 = this.devClassPathProps.getProperty(PLUGIN_ID))))).length > 0 && (file = new File(object3[0])).isAbsolute() && (string4 = this.searchFor(string3, string2 = file.getParent())) != null) {
                string = this.searchFor(ECLIPSE, string4);
            }
            if (string == null && this.bootLocation != null && (object2 = uRLArray) != null && ((Object)object2).length > 0) {
                int n = ((Object)object2).length - 1;
                while (n >= 0 && string == null) {
                    file = new File(((URL)object2[n]).getFile());
                    string2 = file.getParent();
                    if (this.inDevelopmentMode) {
                        String string5 = String.valueOf(string2) + "/" + PLUGIN_ID + "/fragments";
                        string4 = this.searchFor(string3, string5);
                    }
                    if (string4 == null) {
                        string4 = this.searchFor(string3, string2);
                    }
                    if (string4 != null) {
                        string = this.searchFor(ECLIPSE, string4);
                    }
                    --n;
                }
            }
            if (string == null) {
                object2 = this.getInstallLocation();
                object3 = ((URL)object2).getFile();
                string4 = this.searchFor(string3, (String)(object3 = String.valueOf(object3) + "/plugins/"));
                if (string4 != null) {
                    string = this.searchFor(ECLIPSE, string4);
                }
            }
        }
        this.library = string;
        if (this.library != null) {
            this.bridge = new JNIBridge(this.library);
        }
    }

    protected void basicRun(String[] stringArray) throws Exception {
        System.getProperties().put("eclipse.startTime", Long.toString(System.currentTimeMillis()));
        this.commands = stringArray;
        String[] stringArray2 = this.processCommandLine(stringArray);
        if (!this.debug) {
            this.debug = System.getProperty(PROP_DEBUG) != null;
        }
        this.setupVMProperties();
        this.processConfiguration();
        this.getInstallLocation();
        URL[] uRLArray = this.getBootPath(this.bootLocation);
        this.setupJNI(uRLArray);
        if (!this.checkVersion(System.getProperty("java.version"), System.getProperty(PROP_REQUIRED_JAVA_VERSION))) {
            return;
        }
        this.setSecurityPolicy(uRLArray);
        this.handleSplash(uRLArray);
        this.beforeFwkInvocation();
        this.invokeFramework(stringArray2, uRLArray);
    }

    protected void beforeFwkInvocation() {
    }

    protected void setSecurityPolicy(URL[] uRLArray) {
        String string = System.getProperty(PROP_ECLIPSESECURITY);
        if (string != null) {
            Class<?> clazz;
            Object object;
            SecurityManager securityManager = System.getSecurityManager();
            boolean bl = false;
            if (securityManager == null) {
                if (string.length() < 1) {
                    string = "java.lang.SecurityManager";
                }
                try {
                    object = Class.forName(string);
                    securityManager = (SecurityManager)((Class)object).newInstance();
                    bl = true;
                }
                catch (Throwable throwable) {
                    System.getProperties().put("java.security.manager", string);
                }
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.launcher.Main");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            object = clazz.getProtectionDomain();
            CodeSource codeSource = null;
            if (object != null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.equinox.launcher.Main");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                    }
                }
                codeSource = clazz2.getProtectionDomain().getCodeSource();
            }
            if (object == null || codeSource == null) {
                this.log("Can not automatically set the security manager. Please use a policy file.");
                return;
            }
            URL[] uRLArray2 = new URL[uRLArray.length + 1];
            uRLArray2[0] = codeSource.getLocation();
            System.arraycopy(uRLArray, 0, uRLArray2, 1, uRLArray.length);
            Main$EclipsePolicy main$EclipsePolicy = new Main$EclipsePolicy(this, Policy.getPolicy(), uRLArray2);
            Policy.setPolicy(main$EclipsePolicy);
            if (bl) {
                System.setSecurityManager(securityManager);
            }
        }
    }

    private void invokeFramework(String[] stringArray, URL[] uRLArray) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, Error, Exception, InvocationTargetException {
        ClassLoader classLoader;
        String string = System.getProperty(PROP_FRAMEWORK_PARENT_CLASSLOADER, System.getProperty(PROP_PARENT_CLASSLOADER, PARENT_CLASSLOADER_BOOT));
        ClassLoader classLoader2 = null;
        if (PARENT_CLASSLOADER_APP.equalsIgnoreCase(string)) {
            classLoader2 = ClassLoader.getSystemClassLoader();
        } else if (PARENT_CLASSLOADER_EXT.equalsIgnoreCase(string)) {
            classLoader = ClassLoader.getSystemClassLoader();
            if (classLoader != null) {
                classLoader2 = classLoader.getParent();
            }
        } else if (PARENT_CLASSLOADER_CURRENT.equalsIgnoreCase(string)) {
            classLoader2 = this.getClass().getClassLoader();
        }
        classLoader = new Main$StartupClassLoader(this, uRLArray, classLoader2);
        Class<?> clazz = ((URLClassLoader)classLoader).loadClass(STARTER);
        Class[] classArray = new Class[2];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Runnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        classArray[1] = clazz3;
        Method method = clazz.getDeclaredMethod("run", classArray);
        try {
            method.invoke(clazz, stringArray, this.splashHandler);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof Exception) {
                throw invocationTargetException.getTargetException();
            }
            throw (Throwable)invocationTargetException;
        }
    }

    private boolean checkVersion(String string, String string2) {
        if (string2 == null || string == null) {
            return true;
        }
        try {
            Main$Identifier main$Identifier = new Main$Identifier(string2);
            Main$Identifier main$Identifier2 = new Main$Identifier(string);
            boolean bl = main$Identifier2.isGreaterEqualTo(main$Identifier);
            if (!bl) {
                System.getProperties().put(PROP_EXITCODE, "14");
                System.getProperties().put(PROP_EXITDATA, "<title>Incompatible JVM</title>Version " + string + " of the JVM is not suitable for this product. Version: " + string2 + " or greater is required.");
            }
            return bl;
        }
        catch (SecurityException securityException) {
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    protected String decode(String string) {
        char c;
        int n;
        Object object;
        Object object2;
        try {
            Object object3;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("java.net.URLDecoder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Class[] classArray = new Class[2];
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            classArray[0] = clazz3;
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            classArray[1] = clazz4;
            object2 = clazz2.getDeclaredMethod("decode", classArray);
            if (string.indexOf(43) >= 0) {
                int n2 = string.length();
                object = new StringBuffer(n2);
                n = 0;
                while (n < n2) {
                    c = string.charAt(n);
                    if (c == '+') {
                        ((StringBuffer)object).append("%2B");
                    } else {
                        ((StringBuffer)object).append(c);
                    }
                    ++n;
                }
                string = ((StringBuffer)object).toString();
            }
            if ((object3 = ((Method)object2).invoke(null, string, "UTF-8")) != null) {
                return (String)object3;
            }
        }
        catch (Exception exception) {}
        boolean bl = false;
        object2 = string.getBytes();
        char c2 = ((byte[])object2).length;
        object = new byte[c2];
        n = 0;
        c = '\u0000';
        while (c < c2) {
            byte by = object2[c];
            if (by == 37) {
                if (c + 2 >= c2) {
                    throw (Throwable)new IllegalArgumentException("Malformed URL (\"" + string + "\"): % must be followed by 2 digits.");
                }
                byte by2 = object2[++c];
                Object object4 = object2[++c];
                by = (byte)((this.hexToByte(by2) << 4) + this.hexToByte((byte)object4));
                bl = true;
            }
            object[n++] = by;
            ++c;
        }
        if (!bl) {
            return string;
        }
        try {
            return new String((byte[])object, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String((byte[])object, 0, n);
        }
    }

    protected String[] getArrayFromList(String string) {
        if (string == null || string.trim().equals("")) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? new String[]{} : vector.toArray(new String[vector.size()]);
    }

    private URL[] getDevPath(URL uRL) throws IOException {
        ArrayList arrayList = new ArrayList(5);
        if (this.inDevelopmentMode) {
            this.addDevEntries(uRL, arrayList, OSGI);
        }
        this.addBaseJars(uRL, arrayList);
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private void readFrameworkExtensions(URL uRL, ArrayList arrayList) throws IOException {
        String[] stringArray = this.getArrayFromList(System.getProperties().getProperty(PROP_EXTENSIONS));
        String string = new File(uRL.getFile()).getParent().toString();
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = this.searchFor(stringArray[n], string);
            if (string2 == null) {
                this.log("Could not find extension: " + stringArray[n]);
            } else {
                String[] stringArray2;
                Properties properties;
                URL uRL2;
                block14: {
                    if (this.debug) {
                        System.out.println("Loading extension: " + stringArray[n]);
                    }
                    uRL2 = null;
                    if (this.installLocation.getProtocol().equals("file")) {
                        arrayList2.add(string2);
                        uRL2 = new File(string2).toURL();
                    } else {
                        uRL2 = new URL(this.installLocation.getProtocol(), this.installLocation.getHost(), this.installLocation.getPort(), string2);
                    }
                    properties = null;
                    try {
                        properties = this.loadProperties(this.constructURL(uRL2, ECLIPSE_PROPERTIES));
                    }
                    catch (IOException iOException) {
                        if (!this.debug) break block14;
                        System.out.println("\teclipse.properties not found");
                    }
                }
                String string3 = null;
                if (properties != null) {
                    string3 = properties.getProperty(PROP_CLASSPATH);
                } else {
                    properties = new Properties();
                }
                if (string3 == null || string3.length() == 0) {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = "";
                } else {
                    stringArray2 = this.getArrayFromList(string3);
                }
                String[] stringArray4 = stringArray2;
                String string4 = System.getProperty(PROP_CLASSPATH) == null ? "." : "";
                int n2 = 0;
                while (n2 < stringArray4.length) {
                    string4 = String.valueOf(string4) + ", file:" + string2 + stringArray4[n2];
                    ++n2;
                }
                properties.put(PROP_CLASSPATH, string4);
                this.mergeProperties(System.getProperties(), properties);
                if (this.inDevelopmentMode) {
                    this.addDevEntries(uRL2, arrayList, stringArray[n]);
                }
            }
            ++n;
        }
        this.extensionPaths = arrayList2.toArray(new String[arrayList2.size()]);
    }

    private void addBaseJars(URL uRL, ArrayList arrayList) throws IOException {
        Object[] objectArray;
        File file;
        boolean bl;
        String string = System.getProperty(PROP_CLASSPATH);
        if (string == null) {
            this.readFrameworkExtensions(uRL, arrayList);
            string = System.getProperties().getProperty(PROP_CLASSPATH);
        }
        if (bl = (file = new File(uRL.getFile())).isDirectory()) {
            System.getProperties().put(PROP_FRAMEWORK_SHAPE, "folder");
        } else {
            System.getProperties().put(PROP_FRAMEWORK_SHAPE, "jar");
        }
        String string2 = new File(new File(uRL.getFile()).getParent()).getAbsolutePath();
        if (Character.isUpperCase(string2.charAt(0))) {
            objectArray = string2.toCharArray();
            objectArray[0] = Character.toLowerCase(objectArray[0]);
            string2 = new String((char[])objectArray);
        }
        System.getProperties().put(PROP_FRAMEWORK_SYSPATH, string2);
        objectArray = this.getArrayFromList(string);
        if (objectArray.length == 0) {
            if (!this.inDevelopmentMode && new File(uRL.getFile()).isDirectory()) {
                throw (Throwable)new IOException("Unable to initialize osgi.frameworkClassPath");
            }
            this.addEntry(uRL, arrayList);
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            char c = objectArray[n];
            try {
                if (c.equals(".")) {
                    this.addEntry(uRL, arrayList);
                }
                URL uRL2 = null;
                uRL2 = c.startsWith(FILE_SCHEME) ? new File(c.substring(5)).toURL() : new URL((String)c);
                this.addEntry(uRL2, arrayList);
            }
            catch (MalformedURLException malformedURLException) {
                this.addEntry(new URL(uRL, (String)c), arrayList);
            }
            ++n;
        }
    }

    protected void addEntry(URL uRL, List list) {
        if (new File(uRL.getFile()).exists()) {
            list.add(uRL);
        }
    }

    protected URL[] getBootPath(String string) throws IOException {
        URL[] uRLArray;
        URL uRL = null;
        if (string != null) {
            uRL = Main.buildURL(string, true);
        } else {
            uRL = this.getInstallLocation();
            uRLArray = new File(uRL.getFile(), "plugins").toString();
            if ((uRLArray = this.searchFor(this.framework, (String)uRLArray)) == null) {
                throw (Throwable)new RuntimeException("Could not find framework");
            }
            uRL = uRL.getProtocol().equals("file") ? new File((String)uRLArray).toURL() : new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), (String)uRLArray);
        }
        if (System.getProperty(PROP_FRAMEWORK) == null) {
            System.getProperties().put(PROP_FRAMEWORK, uRL.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Framework located:\n    " + uRL.toExternalForm());
        }
        uRLArray = this.getDevPath(uRL);
        if (this.debug) {
            System.out.println("Framework classpath:");
            int n = 0;
            while (n < uRLArray.length) {
                System.out.println("    " + uRLArray[n].toExternalForm());
                ++n;
            }
        }
        return uRLArray;
    }

    protected String searchFor(String string, String string2) {
        return this.searchFor(string, null, string2);
    }

    protected String searchFor(String string, String string2, String string3) {
        String[] stringArray = new File(string3).list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string) || stringArray[n].startsWith(String.valueOf(string) + "_")) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        int n2 = this.findMax(stringArray2);
        if (n2 == -1) {
            return null;
        }
        File file = new File(string3, stringArray2[n2]);
        return String.valueOf(file.getAbsolutePath().replace(File.separatorChar, '/')) + (file.isDirectory() ? "/" : "");
    }

    protected int findMax(String[] stringArray) {
        int n = -1;
        Object[] objectArray = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            String string2 = "";
            int n3 = string.indexOf(95);
            if (n3 != -1) {
                string2 = string.substring(n3 + 1);
            }
            Object[] objectArray2 = this.getVersionElements(string2);
            if (objectArray == null) {
                n = n2;
                objectArray = objectArray2;
            } else if (this.compareVersion(objectArray, objectArray2) < 0) {
                n = n2;
                objectArray = objectArray2;
            }
            ++n2;
        }
        return n;
    }

    private Object[] getVersionElements(String string) {
        if (string.endsWith(".jar")) {
            string = string.substring(0, string.length() - 4);
        }
        Object[] objectArray = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < 4) {
            String string2 = stringTokenizer.nextToken();
            if (n < 3) {
                try {
                    objectArray[n++] = new Integer(string2);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            objectArray[n++] = string2;
        }
        return objectArray;
    }

    private static URL buildURL(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        boolean bl2 = string.startsWith(FILE_SCHEME);
        try {
            if (bl2) {
                File file = new File(string.substring(5));
                if (file.isDirectory()) {
                    return Main.adjustTrailingSlash(file.toURL(), bl);
                }
                return file.toURL();
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (bl2) {
                return null;
            }
            try {
                File file = new File(string);
                if (file.isDirectory()) {
                    return Main.adjustTrailingSlash(file.toURL(), bl);
                }
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL uRL, boolean bl) throws MalformedURLException {
        String string = uRL.getFile();
        if (bl == string.endsWith("/")) {
            return uRL;
        }
        string = bl ? String.valueOf(string) + "/" : string.substring(0, string.length() - 1);
        return new URL(uRL.getProtocol(), uRL.getHost(), string);
    }

    private URL buildLocation(String string, URL uRL, String string2) {
        URL uRL2 = null;
        String string3 = System.getProperty(string);
        System.getProperties().remove(string);
        try {
            if (string3 == null) {
                uRL2 = uRL;
            } else {
                if (string3.equalsIgnoreCase(NONE)) {
                    return null;
                }
                if (string3.equalsIgnoreCase(NO_DEFAULT)) {
                    uRL2 = Main.buildURL(string3, true);
                } else {
                    if (string3.startsWith(USER_HOME)) {
                        String string4 = this.substituteVar(string3, USER_HOME, PROP_USER_HOME);
                        string3 = new File(string4, string2).getAbsolutePath();
                    } else if (string3.startsWith(USER_DIR)) {
                        String string5 = this.substituteVar(string3, USER_DIR, PROP_USER_DIR);
                        string3 = new File(string5, string2).getAbsolutePath();
                    }
                    uRL2 = Main.buildURL(string3, true);
                }
            }
        }
        finally {
            if (uRL2 != null) {
                System.getProperties().put(string, uRL2.toExternalForm());
            }
        }
        return uRL2;
    }

    private String computeDefaultConfigurationLocation() {
        File file;
        URL uRL = this.getInstallLocation();
        if (uRL.getProtocol().equals("file") && Main.canWrite(file = new File(uRL.getFile()))) {
            return String.valueOf(file.getAbsolutePath()) + File.separator + CONFIG_DIR;
        }
        return this.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    private static boolean canWrite(File file) {
        if (!file.canWrite()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File file2 = null;
        try {
            try {
                file2 = File.createTempFile("writtableArea", ".dll", file);
            }
            catch (IOException iOException) {
                if (file2 != null) {
                    file2.delete();
                }
                return false;
            }
        }
        finally {
            if (file2 != null) {
                file2.delete();
            }
        }
        return true;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        try {
            try {
                n = new Main().run(stringArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (!Boolean.getBoolean(PROP_NOSHUTDOWN)) {
                    System.exit(n);
                }
            }
        }
        finally {
            if (!Boolean.getBoolean(PROP_NOSHUTDOWN)) {
                System.exit(n);
            }
        }
    }

    public int run(String[] stringArray) {
        int n;
        block11: {
            n = 0;
            try {
                try {
                    this.basicRun(stringArray);
                    String string = System.getProperty(PROP_EXITCODE);
                    try {
                        n = string == null ? 0 : Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 17;
                    }
                }
                catch (Throwable throwable) {
                    if (!"13".equals(System.getProperty(PROP_EXITCODE))) {
                        this.log("Exception launching the Eclipse Platform:");
                        this.log(throwable);
                        String string = "An error has occurred";
                        string = this.logFile == null ? String.valueOf(string) + " and could not be logged: \n" + throwable.getMessage() : String.valueOf(string) + ".  See the log file\n" + this.logFile.getAbsolutePath();
                        System.getProperties().put(PROP_EXITDATA, string);
                    }
                    n = 13;
                    this.takeDownSplash();
                    if (this.bridge != null) {
                        this.bridge.uninitialize();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.takeDownSplash();
                if (this.bridge != null) {
                    this.bridge.uninitialize();
                }
                throw throwable;
            }
            this.takeDownSplash();
            if (this.bridge != null) {
                this.bridge.uninitialize();
            }
        }
        System.getProperties().put(PROP_EXITCODE, Integer.toString(n));
        this.setExitData();
        return n;
    }

    private void setExitData() {
        String string = System.getProperty(PROP_EXITDATA);
        if (string == null || this.bridge == null) {
            return;
        }
        this.bridge.setExitData(this.exitData, string);
    }

    protected String[] processCommandLine(String[] stringArray) {
        int n;
        if (stringArray.length == 0) {
            return stringArray;
        }
        int[] nArray = new int[stringArray.length];
        nArray[0] = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            n = 0;
            if (stringArray[n3].equalsIgnoreCase(DEBUG)) {
                this.debug = true;
            } else {
                if (stringArray[n3].equalsIgnoreCase(NOSPLASH)) {
                    this.splashDown = true;
                    n = 1;
                }
                if (stringArray[n3].equalsIgnoreCase(NOEXIT)) {
                    System.getProperties().put(PROP_NOSHUTDOWN, "true");
                    n = 1;
                }
                if (stringArray[n3].equalsIgnoreCase(INITIALIZE)) {
                    this.initialize = true;
                } else if (stringArray[n3].equalsIgnoreCase(DEV) && (n3 + 1 == stringArray.length || n3 + 1 < stringArray.length && stringArray[n3 + 1].startsWith("-"))) {
                    this.inDevelopmentMode = true;
                } else {
                    if (stringArray[n3].equalsIgnoreCase(SHOWSPLASH)) {
                        this.showSplash = true;
                        n = 1;
                        if (n3 + 1 < stringArray.length && !stringArray[n3 + 1].startsWith("-")) {
                            nArray[n2++] = n3++;
                            this.splashLocation = stringArray[n3];
                        }
                    }
                    if (n != 0) {
                        nArray[n2++] = n3;
                    } else if (stringArray[n3].equalsIgnoreCase(VMARGS)) {
                        stringArray[n3] = null;
                        this.vmargs = new String[stringArray.length - ++n3];
                        int n4 = 0;
                        while (n3 < stringArray.length) {
                            this.vmargs[n4++] = stringArray[n3];
                            stringArray[n3] = null;
                            ++n3;
                        }
                    } else if (n3 != stringArray.length - 1 && !stringArray[n3 + 1].startsWith("-")) {
                        String string = stringArray[++n3];
                        if (stringArray[n3 - 1].equalsIgnoreCase(DEV)) {
                            this.inDevelopmentMode = true;
                            this.devClassPathProps = this.processDevArg(string);
                            if (this.devClassPathProps != null) {
                                this.devClassPath = this.devClassPathProps.getProperty(OSGI);
                                if (this.devClassPath == null) {
                                    this.devClassPath = this.devClassPathProps.getProperty("*");
                                }
                            }
                        } else {
                            if (stringArray[n3 - 1].equalsIgnoreCase(FRAMEWORK)) {
                                this.framework = string;
                                n = 1;
                            }
                            if (stringArray[n3 - 1].equalsIgnoreCase(OS)) {
                                this.os = string;
                            } else if (stringArray[n3 - 1].equalsIgnoreCase(WS)) {
                                this.ws = string;
                            } else if (stringArray[n3 - 1].equalsIgnoreCase(ARCH)) {
                                this.arch = string;
                            } else {
                                if (stringArray[n3 - 1].equalsIgnoreCase(INSTALL)) {
                                    System.getProperties().put(PROP_INSTALL_AREA, string);
                                    n = 1;
                                }
                                if (stringArray[n3 - 1].equalsIgnoreCase(CONFIGURATION)) {
                                    System.getProperties().put(PROP_CONFIG_AREA, string);
                                    n = 1;
                                }
                                if (stringArray[n3 - 1].equalsIgnoreCase(EXITDATA)) {
                                    this.exitData = string;
                                    n = 1;
                                }
                                if (stringArray[n3 - 1].equalsIgnoreCase(NAME)) {
                                    n = 1;
                                }
                                if (stringArray[n3 - 1].equalsIgnoreCase(STARTUP)) {
                                    n = 1;
                                }
                                if (stringArray[n3 - 1].equalsIgnoreCase(LAUNCHER)) {
                                    n = 1;
                                }
                                if (stringArray[n3 - 1].equalsIgnoreCase(LIBRARY)) {
                                    this.library = string;
                                    n = 1;
                                }
                                if (stringArray[n3 - 1].equalsIgnoreCase(ENDSPLASH)) {
                                    this.endSplash = string;
                                    n = 1;
                                }
                                if (stringArray[n3 - 1].equalsIgnoreCase(VM)) {
                                    this.vm = string;
                                    n = 1;
                                }
                                if (stringArray[n3 - 1].equalsIgnoreCase(NL)) {
                                    System.getProperties().put(PROP_NL, string);
                                    n = 1;
                                }
                                if (n != 0) {
                                    nArray[n2++] = n3 - 1;
                                    nArray[n2++] = n3;
                                }
                            }
                        }
                    }
                }
            }
            ++n3;
        }
        String[] stringArray2 = new String[stringArray.length - n2 - (this.vmargs == null ? 0 : this.vmargs.length + 1)];
        n2 = 0;
        n = 0;
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (n5 == nArray[n2]) {
                ++n2;
            } else if (stringArray[n5] != null) {
                stringArray2[n++] = stringArray[n5];
            }
            ++n5;
        }
        return stringArray2;
    }

    private URL getConfigurationLocation() {
        if (this.configurationLocation != null) {
            return this.configurationLocation;
        }
        this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA, null, "");
        if (this.configurationLocation == null) {
            this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA_DEFAULT, null, "");
            if (this.configurationLocation == null) {
                this.configurationLocation = Main.buildURL(this.computeDefaultConfigurationLocation(), true);
            }
        }
        if (this.configurationLocation != null) {
            System.getProperties().put(PROP_CONFIG_AREA, this.configurationLocation.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Configuration location:\n    " + this.configurationLocation);
        }
        return this.configurationLocation;
    }

    private void processConfiguration() {
        Object object;
        Object object2;
        URL uRL = null;
        Object object3 = null;
        if (System.getProperty(PROP_CONFIG_AREA) == null) {
            object2 = System.getProperty(PROP_BASE_CONFIG_AREA);
            if (object2 != null) {
                uRL = Main.buildURL((String)object2, true);
            }
            if (uRL == null) {
                try {
                    uRL = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if ((object3 = this.loadConfiguration(uRL)) != null) {
                object = ((Properties)object3).getProperty(PROP_CONFIG_AREA);
                if (object != null) {
                    System.getProperties().put(PROP_CONFIG_AREA, object);
                }
                if ((object = ((Properties)object3).getProperty(PROP_INSTALL_AREA)) != null && System.getProperty(PROP_INSTALL_AREA) == null) {
                    System.getProperties().put(PROP_INSTALL_AREA, object);
                }
            }
        }
        if ((object2 = object3) == null || !this.getConfigurationLocation().equals(uRL)) {
            object2 = this.loadConfiguration(this.getConfigurationLocation());
        }
        this.mergeProperties(System.getProperties(), (Properties)object2);
        if ("false".equalsIgnoreCase(System.getProperty(PROP_CONFIG_CASCADED))) {
            System.getProperties().remove(PROP_SHARED_CONFIG_AREA);
        } else {
            this.ensureAbsolute(PROP_SHARED_CONFIG_AREA);
            object = this.buildLocation(PROP_SHARED_CONFIG_AREA, null, "");
            if (object == null) {
                try {
                    object = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (object != null) {
                if (((URL)object).equals(this.getConfigurationLocation())) {
                    System.getProperties().remove(PROP_SHARED_CONFIG_AREA);
                } else {
                    object2 = object3;
                    if (!((URL)object).equals(uRL)) {
                        object2 = this.loadConfiguration((URL)object);
                    }
                    this.mergeProperties(System.getProperties(), (Properties)object2);
                    System.getProperties().put(PROP_SHARED_CONFIG_AREA, ((URL)object).toExternalForm());
                    if (this.debug) {
                        System.out.println("Shared configuration location:\n    " + ((URL)object).toExternalForm());
                    }
                }
            }
        }
        object = System.getProperty(PROP_FRAMEWORK, null);
        if (object != null) {
            URL uRL2 = Main.buildURL((String)object, true);
            System.getProperties().put(PROP_FRAMEWORK, uRL2.toExternalForm());
            this.bootLocation = this.resolve((String)object);
        }
    }

    private void ensureAbsolute(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        String string3 = uRL.getPath();
        if (string3.startsWith("/")) {
            return;
        }
        URL uRL2 = this.getInstallLocation();
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return;
        }
        try {
            URL uRL3 = new URL(uRL2, string3);
            System.getProperties().put(string, uRL3.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private URL getInstallLocation() {
        if (this.installLocation != null) {
            return this.installLocation;
        }
        String string = System.getProperty(PROP_INSTALL_AREA);
        if (string != null) {
            this.installLocation = Main.buildURL(string, true);
            if (this.installLocation == null) {
                throw (Throwable)new IllegalStateException("Install location is invalid: " + string);
            }
            System.getProperties().put(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
            if (this.debug) {
                System.out.println("Install location:\n    " + this.installLocation);
            }
            return this.installLocation;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.launcher.Main");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = null;
        URL uRL = null;
        if (protectionDomain != null) {
            codeSource = protectionDomain.getCodeSource();
        }
        if (codeSource == null || protectionDomain == null) {
            if (this.debug) {
                System.out.println("CodeSource location is null. Defaulting the install location to file:startup.jar");
            }
            try {
                uRL = new URL("file:startup.jar");
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (codeSource != null) {
            uRL = codeSource.getLocation();
        }
        String string2 = this.decode(uRL.getFile());
        File file = new File(string2);
        string2 = file.toString().replace('\\', '/');
        if (File.separatorChar == '\\' && Character.isUpperCase(string2.charAt(0))) {
            char[] cArray = string2.toCharArray();
            cArray[0] = Character.toLowerCase(cArray[0]);
            string2 = new String(cArray);
        }
        if (string2.toLowerCase().endsWith(".jar")) {
            string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
        }
        if (string2.toLowerCase().endsWith("/plugins/")) {
            string2 = string2.substring(0, string2.length() - "/plugins/".length());
        }
        try {
            try {
                string2 = new File(string2).toURL().getFile();
            }
            catch (MalformedURLException malformedURLException) {}
            this.installLocation = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string2);
            System.getProperties().put(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {}
        if (this.debug) {
            System.out.println("Install location:\n    " + this.installLocation);
        }
        return this.installLocation;
    }

    private Properties loadConfiguration(URL uRL) {
        Properties properties;
        block6: {
            properties = null;
            try {
                uRL = new URL(uRL, CONFIG_FILE);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            try {
                if (this.debug) {
                    System.out.print("Configuration file:\n    " + uRL.toString());
                }
                properties = this.loadProperties(uRL);
                if (this.debug) {
                    System.out.println(" loaded");
                }
            }
            catch (IOException iOException) {
                if (!this.debug) break block6;
                System.out.println(" not found or not read");
            }
        }
        return properties;
    }

    private Properties loadProperties(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        Properties properties = null;
        IOException iOException = null;
        try {
            properties = this.load(uRL, null);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            try {
                properties = this.load(uRL, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException iOException3) {
                try {
                    properties = this.load(uRL, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException iOException4) {
                    throw (Throwable)iOException;
                }
            }
        }
        return properties;
    }

    private Properties load(URL uRL, String string) throws IOException {
        if (string != null && !string.equals("")) {
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(uRL.getFile()) + string);
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            properties.load(inputStream);
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    private void handleSplash(URL[] uRLArray) {
        if (this.initialize || this.splashDown || this.bridge == null) {
            this.showSplash = false;
            this.endSplash = null;
            return;
        }
        if (this.showSplash || this.endSplash != null) {
            try {
                Runtime.getRuntime().addShutdownHook(this.splashHandler);
            }
            catch (Throwable throwable) {}
        }
        if (this.endSplash != null) {
            this.showSplash = false;
            return;
        }
        if (!this.showSplash) {
            return;
        }
        this.splashLocation = this.getSplashLocation(uRLArray);
        if (this.debug) {
            System.out.println("Splash location:\n    " + this.splashLocation);
        }
        if (this.splashLocation == null) {
            return;
        }
        this.bridge.showSplash(this.splashLocation);
        long l = this.bridge.getSplashHandle();
        if (l != 0L && l != -1L) {
            System.getProperties().put(SPLASH_HANDLE, String.valueOf(l));
            System.getProperties().put(SPLASH_LOCATION, this.splashLocation);
            this.bridge.updateSplash();
        }
    }

    protected void takeDownSplash() {
        if (this.splashDown || this.bridge == null) {
            return;
        }
        this.splashDown = this.bridge.takeDownSplash();
        System.getProperties().remove(SPLASH_HANDLE);
        try {
            Runtime.getRuntime().removeShutdownHook(this.splashHandler);
        }
        catch (Throwable throwable) {}
    }

    private String getSplashLocation(URL[] uRLArray) {
        int n;
        Object object;
        if (this.splashLocation != null && !Character.isDigit(this.splashLocation.charAt(0)) && new File(this.splashLocation).exists()) {
            System.getProperties().put(PROP_SPLASHLOCATION, this.splashLocation);
            return this.splashLocation;
        }
        String string = System.getProperty(PROP_SPLASHLOCATION);
        if (string != null) {
            return string;
        }
        String string2 = System.getProperty(PROP_SPLASHPATH);
        if (string2 != null) {
            object = this.getArrayFromList(string2);
            ArrayList<String> arrayList = new ArrayList<String>(((String[])object).length);
            n = 0;
            while (n < ((Object)object).length) {
                String string3 = this.resolve((String)object[n]);
                if (string3 == null || string3.startsWith(FILE_SCHEME)) {
                    File file = new File(string3.substring(5).replace('/', File.separatorChar));
                    if ((string3 = this.searchFor(file.getName(), file.getParent())) != null) {
                        arrayList.add(string3);
                    }
                } else {
                    this.log("Invalid splash path entry: " + (String)object[n]);
                }
                ++n;
            }
            string = this.searchForSplash(arrayList.toArray(new String[arrayList.size()]));
            if (string != null) {
                System.getProperties().put(PROP_SPLASHLOCATION, string);
                return string;
            }
        }
        object = uRLArray[0].getFile();
        int n2 = ((String)(object = ((String)object).replace('/', File.separatorChar))).lastIndexOf("plugins" + File.separator);
        if (n2 != -1 && (n = ((String)object).indexOf(File.separator, n2 + 8)) != -1 && (string = this.searchForSplash(new String[]{object = ((String)object).substring(0, n)})) != null) {
            System.getProperties().put(PROP_SPLASHLOCATION, string);
        }
        return string;
    }

    private String searchForSplash(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String string = (String)System.getProperties().get(PROP_NL);
        if (string == null) {
            string = Locale.getDefault().toString();
        }
        String[] stringArray2 = Main.buildNLVariants(string);
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2;
                if (this.isJAR(stringArray[n2])) {
                    string2 = this.extractSplashFromJAR(stringArray[n2], stringArray2[n]);
                    if (string2 != null) {
                        return string2;
                    }
                } else {
                    File file;
                    string2 = stringArray[n2];
                    if (!string2.endsWith(File.separator)) {
                        string2 = String.valueOf(string2) + File.separator;
                    }
                    if ((file = new File(string2 = String.valueOf(string2) + stringArray2[n])).exists()) {
                        return file.getAbsolutePath();
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private String extractSplashFromJAR(String string, String string2) {
        BufferedOutputStream bufferedOutputStream;
        ZipFile zipFile;
        String string3 = System.getProperty(PROP_CONFIG_AREA);
        if (string3 == null) {
            this.log("Configuration area not set yet. Unable to extract splash from JAR'd plug-in: " + string);
            return null;
        }
        URL uRL = Main.buildURL(string3, false);
        if (uRL == null) {
            return null;
        }
        File file = new File(uRL.getPath(), PLUGIN_ID);
        File file2 = new File(string);
        String string4 = file2.getName();
        if (string4.endsWith(".jar")) {
            string4 = string4.substring(0, string4.length() - 4);
        }
        file = new File(file, string4);
        if ((file = new File(file, string2)).exists()) {
            boolean bl = false;
            int n = 0;
            while (n < this.commands.length) {
                if (CLEAN.equalsIgnoreCase(this.commands[n])) {
                    bl = true;
                    file.delete();
                    break;
                }
                ++n;
            }
            if (!bl) {
                return file.getAbsolutePath();
            }
        }
        try {
            zipFile = new ZipFile(string);
        }
        catch (IOException iOException) {
            this.log("Exception looking for splash  in JAR file: " + string);
            this.log(iOException);
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(string2.replace(File.separatorChar, '/'));
        if (zipEntry == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            this.log("Exception opening splash: " + zipEntry.getName() + " in JAR file: " + string);
            this.log(iOException);
            return null;
        }
        new File(file.getParent()).mkdirs();
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return null;
        }
        Main.transferStreams(inputStream, bufferedOutputStream);
        return file.exists() ? file.getAbsolutePath() : null;
    }

    private boolean isJAR(String string) {
        if (string.endsWith(File.separator)) {
            return false;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        if (++n >= string.length()) {
            return false;
        }
        return "JAR".equalsIgnoreCase(string.substring(n));
    }

    private static String[] buildNLVariants(String string) {
        String string2 = string;
        ArrayList<String> arrayList = new ArrayList<String>(4);
        while (true) {
            arrayList.add("nl" + File.separatorChar + string2.replace('_', File.separatorChar) + File.separatorChar + SPLASH_IMAGE);
            int n = string2.lastIndexOf(95);
            if (n == -1) break;
            string2 = string2.substring(0, n);
        }
        arrayList.add(SPLASH_IMAGE);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String resolve(String string) {
        if (string.startsWith(REFERENCE_SCHEME)) {
            string = string.substring(10);
            System.getProperties().put(PROP_FRAMEWORK, string);
        }
        if (string.startsWith(PLATFORM_URL)) {
            String string2 = string.substring(PLATFORM_URL.length());
            return this.getInstallLocation() + string2;
        }
        return string;
    }

    private void mergeProperties(Properties properties, Properties properties2) {
        if (properties == null || properties2 == null) {
            return;
        }
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.equals(PROP_CLASSPATH)) {
                string = properties.getProperty(PROP_CLASSPATH);
                String string3 = properties2.getProperty(PROP_CLASSPATH);
                string = string == null ? string3 : String.valueOf(string) + string3;
                properties.put(PROP_CLASSPATH, string);
                continue;
            }
            string = properties2.getProperty(string2);
            if (properties.getProperty(string2) != null) continue;
            properties.put(string2, string);
        }
    }

    private void setupVMProperties() {
        if (this.vm != null) {
            System.getProperties().put(PROP_VM, this.vm);
        }
        this.setMultiValueProperty(PROP_VMARGS, this.vmargs);
        this.setMultiValueProperty(PROP_COMMANDS, this.commands);
    }

    private void setMultiValueProperty(String string, String[] stringArray) {
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer(300);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append('\n');
                }
                ++n;
            }
            System.getProperties().put(string, stringBuffer.toString());
        }
    }

    private String getWS() {
        if (this.ws != null) {
            return this.ws;
        }
        String string = this.getOS();
        if (string.equals("win32")) {
            return "win32";
        }
        if (string.equals("linux")) {
            return "gtk";
        }
        if (string.equals("macosx")) {
            return "carbon";
        }
        if (string.equals("hpux")) {
            return "motif";
        }
        if (string.equals("aix")) {
            return "motif";
        }
        if (string.equals("solaris")) {
            return "motif";
        }
        if (string.equals("qnx")) {
            return "photon";
        }
        return "unknown";
    }

    private String getOS() throws  {
        return Main$$Cold.getOS(this);
    }

    private String getArch() throws  {
        return Main$$Cold.getArch(this);
    }

    URL constructURL(URL uRL, String string) throws  {
        return Main$$Cold.constructURL(this, uRL, string);
    }

    private void addDevEntries(URL uRL, List list, String string) throws MalformedURLException {
        if (this.devClassPathProps == null) {
            return;
        }
        String string2 = this.devClassPathProps.getProperty(string);
        if (string2 == null) {
            string2 = this.devClassPathProps.getProperty("*");
        }
        String[] stringArray = this.getArrayFromList(string2);
        int n = 0;
        while (n < stringArray.length) {
            URL uRL2;
            String string3 = stringArray[n];
            File file = new File(string3);
            if (file.isAbsolute()) {
                uRL2 = file.toURL();
            } else {
                char c = string3.charAt(string3.length() - 1);
                uRL2 = string3.endsWith(".jar") || c == '/' || c == '\\' ? new URL(uRL, string3) : new URL(uRL, String.valueOf(string3) + "/");
            }
            this.addEntry(uRL2, list);
            ++n;
        }
    }

    private int compareVersion(Object[] objectArray, Object[] objectArray2) throws  {
        return Main$$Cold.compareVersion(this, objectArray, objectArray2);
    }

    private String substituteVar(String string, String string2, String string3) throws  {
        return Main$$Cold.substituteVar(this, string, string2, string3);
    }

    private String computeDefaultUserAreaLocation(String string) {
        Object object;
        int n;
        URL uRL = this.getInstallLocation();
        if (uRL == null) {
            return null;
        }
        File file = new File(uRL.getFile());
        try {
            n = file.getCanonicalPath().hashCode();
        }
        catch (IOException iOException) {
            n = file.getAbsolutePath().hashCode();
        }
        if (n < 0) {
            n = -n;
        }
        String string2 = String.valueOf(n);
        String string3 = ".eclipse";
        File file2 = new File(file, PRODUCT_SITE_MARKER);
        if (file2.exists()) {
            object = new Properties();
            try {
                String string4;
                ((Properties)object).load(new FileInputStream(file2));
                String string5 = ((Properties)object).getProperty(PRODUCT_SITE_ID);
                if (string5 == null || string5.trim().length() == 0) {
                    string5 = ECLIPSE;
                }
                if ((string4 = ((Properties)object).getProperty(PRODUCT_SITE_VERSION)) == null || string4.trim().length() == 0) {
                    string4 = "";
                }
                string3 = String.valueOf(string3) + File.separator + string5 + "_" + string4 + "_" + string2;
            }
            catch (IOException iOException) {
                string3 = String.valueOf(string3) + File.separator + string2;
            }
        } else {
            string3 = String.valueOf(string3) + File.separator + string2;
        }
        object = System.getProperty(PROP_USER_HOME);
        return new File((String)object, String.valueOf(string3) + "/" + string).getAbsolutePath();
    }

    public static void main(String string) throws  {
        Main$$Cold.main(string);
    }

    private Properties processDevArg(String string) {
        if (string == null) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            return this.load(uRL, null);
        }
        catch (MalformedURLException malformedURLException) {
            Properties properties = new Properties();
            properties.put("*", string);
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void transferStreams(InputStream inputStream, OutputStream outputStream) throws  {
        Main$$Cold.transferStreams(inputStream, outputStream);
    }

    protected synchronized void log(Object object) {
        if (object == null) {
            return;
        }
        try {
            try {
                this.openLogFile();
                try {
                    if (this.newSession) {
                        this.log.write(SESSION);
                        this.log.write(32);
                        String string = new Date().toString();
                        this.log.write(string);
                        this.log.write(32);
                        int n = SESSION.length() + string.length();
                        while (n < 78) {
                            this.log.write(45);
                            ++n;
                        }
                        this.log.newLine();
                        this.newSession = false;
                    }
                    this.write(object);
                }
                finally {
                    if (this.logFile == null) {
                        if (this.log != null) {
                            this.log.flush();
                        }
                    } else {
                        this.closeLogFile();
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("An exception occurred while writing to the platform log:");
                exception.printStackTrace(System.err);
                System.err.println("Logging to the console instead.");
                try {
                    this.log = this.logForStream(System.err);
                    this.write(object);
                    this.log.flush();
                }
                catch (Exception exception2) {
                    System.err.println("An exception occurred while logging to the console:");
                    exception2.printStackTrace(System.err);
                }
                this.log = null;
            }
        }
        finally {
            this.log = null;
        }
    }

    private void write(Object object) throws IOException {
        Main$$Cold.write(this, object);
    }

    protected String getDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPaddedInt(calendar.get(1), 4, stringBuffer).append('-');
        this.appendPaddedInt(calendar.get(2) + 1, 2, stringBuffer).append('-');
        this.appendPaddedInt(calendar.get(5), 2, stringBuffer).append(' ');
        this.appendPaddedInt(calendar.get(11), 2, stringBuffer).append(':');
        this.appendPaddedInt(calendar.get(12), 2, stringBuffer).append(':');
        this.appendPaddedInt(calendar.get(13), 2, stringBuffer).append('.');
        this.appendPaddedInt(calendar.get(14), 3, stringBuffer);
        return stringBuffer.toString();
    }

    private StringBuffer appendPaddedInt(int n, int n2, StringBuffer stringBuffer) throws  {
        return Main$$Cold.appendPaddedInt(this, n, n2, stringBuffer);
    }

    private void computeLogFileLocation() {
        String string = System.getProperty(PROP_LOGFILE);
        if (string != null) {
            if (this.logFile == null || !string.equals(this.logFile.getAbsolutePath())) {
                this.logFile = new File(string);
                new File(this.logFile.getParent()).mkdirs();
            }
            return;
        }
        URL uRL = Main.buildURL(System.getProperty(PROP_CONFIG_AREA), false);
        if (uRL == null) {
            return;
        }
        this.logFile = new File(uRL.getPath(), String.valueOf(Long.toString(System.currentTimeMillis())) + ".log");
        new File(this.logFile.getParent()).mkdirs();
        System.getProperties().put(PROP_LOGFILE, this.logFile.getAbsolutePath());
    }

    private int hexToByte(byte by) throws  {
        return Main$$Cold.hexToByte(this, by);
    }

    private void openLogFile() throws IOException {
        this.computeLogFileLocation();
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), "UTF-8"));
        }
        catch (IOException iOException) {
            this.logFile = null;
            throw (Throwable)iOException;
        }
    }

    private BufferedWriter logForStream(OutputStream outputStream) throws  {
        return Main$$Cold.logForStream(this, outputStream);
    }

    private void closeLogFile() throws IOException {
        Main$$Cold.closeLogFile(this);
    }
}

