/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class InternalPlatform$$Cold {
    public static URL getInstallURL(InternalPlatform internalPlatform) {
        Location location = internalPlatform.getInstallLocation();
        if (location == null) {
            throw (Throwable)new IllegalStateException("The installation location must not be null");
        }
        return location.getURL();
    }

    public static long getStateTimeStamp(InternalPlatform internalPlatform) {
        PlatformAdmin platformAdmin = internalPlatform.getPlatformAdmin();
        return platformAdmin == null ? -1L : platformAdmin.getState(false).getTimeStamp();
    }

    public static void message(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new Date(System.currentTimeMillis()));
        stringBuffer.append(" - [");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append("] ");
        stringBuffer.append(string);
        System.out.println(stringBuffer.toString());
    }

    public static URL[] readPluginPath(InternalPlatform internalPlatform, InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        Vector<URL> vector = new Vector<URL>(5);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty(string), ";");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (string2.equals("")) continue;
                try {
                    vector.addElement(new URL(string2));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Ignoring plugin: " + string2);
                }
            }
        }
        return vector.toArray(new URL[vector.size()]);
    }

    public static void start(Bundle bundle) {
        int n = bundle.getState();
        if ((n & 0x20) != 0) {
            return;
        }
        try {
            bundle.start(1);
        }
        catch (BundleException bundleException) {
            if ((n & 8) != 0 && (bundle.getState() & 8) != 0) {
                return;
            }
            throw (Throwable)bundleException;
        }
    }
}

