/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

class AdapterFactoryProxy
implements IAdapterFactory,
IAdapterFactoryExt {
    private IConfigurationElement element;
    private IAdapterFactory factory;
    private boolean factoryLoaded = false;
    private String ownerId;

    AdapterFactoryProxy() {
    }

    public static AdapterFactoryProxy createProxy(IConfigurationElement iConfigurationElement) {
        AdapterFactoryProxy adapterFactoryProxy = new AdapterFactoryProxy();
        adapterFactoryProxy.element = iConfigurationElement;
        adapterFactoryProxy.ownerId = iConfigurationElement.getDeclaringExtension().getUniqueIdentifier();
        if ("factory".equals(iConfigurationElement.getName())) {
            return adapterFactoryProxy;
        }
        adapterFactoryProxy.logError();
        return null;
    }

    String getAdaptableType() {
        String string = this.element.getAttribute("adaptableType");
        if (string != null) {
            return string;
        }
        this.logError();
        return "";
    }

    public Object getAdapter(Object object, Class clazz) {
        if (!this.factoryLoaded) {
            this.loadFactory(false);
        }
        return this.factory == null ? null : this.factory.getAdapter(object, clazz);
    }

    public Class[] getAdapterList() {
        if (!this.factoryLoaded) {
            this.loadFactory(false);
        }
        return this.factory == null ? null : this.factory.getAdapterList();
    }

    public String[] getAdapterNames() {
        IConfigurationElement[] iConfigurationElementArray = this.element.getChildren();
        ArrayList<String> arrayList = new ArrayList<String>(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string;
            if ("adapter".equals(iConfigurationElementArray[n].getName()) && (string = iConfigurationElementArray[n].getAttribute("type")) != null) {
                arrayList.add(string);
            }
            ++n;
        }
        if (arrayList.isEmpty()) {
            this.logError();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    IExtension getExtension() {
        return this.element.getDeclaringExtension();
    }

    String getOwnerId() {
        return this.ownerId;
    }

    public synchronized IAdapterFactory loadFactory(boolean bl) {
        if (this.factory != null || this.factoryLoaded) {
            return this.factory;
        }
        String string = this.element.getContributor().getName();
        if (!bl && Platform.getBundle(string).getState() != 32) {
            return null;
        }
        this.factoryLoaded = true;
        try {
            this.factory = (IAdapterFactory)this.element.createExecutableExtension("class");
        }
        catch (CoreException coreException) {
            InternalPlatform.getDefault().log(coreException.getStatus());
        }
        return this.factory;
    }

    private void logError() {
        String string = NLS.bind((String)Messages.adapters_badAdapterFactory, (Object)this.element.getContributor().getName());
        InternalPlatform.getDefault().log((IStatus)new Status(4, "org.eclipse.core.runtime", 1, string, null));
    }
}

