/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model;

import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.model.AbstractElementBuilder;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.BuildContext;
import com.ibm.team.process.internal.common.model.Messages;
import com.ibm.team.process.internal.common.model.ModelParsingException;
import com.ibm.team.process.internal.common.model.StartBuilder;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ModelHandler
extends DefaultHandler {
    private final AbstractModel fModel;
    private BuildContext fContext;
    private AbstractElementBuilder fCurrentBuilder;
    private Stack fBuilder = new Stack();

    public ModelHandler(AbstractModel model) {
        this.fModel = model;
        this.fContext = new BuildContext(this.fModel);
        this.fCurrentBuilder = new StartBuilder(model.getRootBuilder());
        this.fBuilder.push(this.fCurrentBuilder);
    }

    public void setDirectives(Map directives) {
        this.fContext.setDirectives(directives);
    }

    public void error(SAXParseException e) {
        this.fModel.error(new ModelParsingException(e, this.fContext.getCurrentModelElement()));
    }

    public void fatalError(SAXParseException e) {
        this.fModel.fatalError(new ModelParsingException(e, this.fContext.getCurrentModelElement()));
    }

    public void warning(SAXParseException e) {
        this.fModel.warning(new ModelParsingException(e, this.fContext.getCurrentModelElement()));
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        AbstractElementBuilder next = this.fCurrentBuilder.childStart(uri, localName, qName, attributes, this.fContext);
        if (next == null) {
            throw new ModelParsingException(NLS.bind(Messages.getCommonString("ModelHandler.0"), qName), this.fContext);
        }
        this.fBuilder.push(this.fCurrentBuilder);
        this.fCurrentBuilder = next;
        this.fCurrentBuilder.start(uri, localName, qName, attributes, this.fContext);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        this.fCurrentBuilder.end(uri, localName, this.fContext);
        this.fCurrentBuilder = (AbstractElementBuilder)this.fBuilder.pop();
        if (this.fCurrentBuilder != null) {
            this.fCurrentBuilder.childEnd(uri, localName, qName, this.fContext);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fCurrentBuilder != null) {
            this.fCurrentBuilder.characters(ch, start, length, this.fContext);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.fContext.setLocator(locator);
    }
}

