/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model;

import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.AbstractElementBuilder;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.Messages;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public abstract class AbstractModel
extends AbstractElement {
    private Exception fException = null;
    protected ModelGenerator fModelGenerator = null;
    private IDocument fCurrentDocument;

    public AbstractModel() {
        super(null, null, "", null);
    }

    public Exception initialize(String xmlData) {
        if (this.fModelGenerator == null) {
            if (xmlData != null && xmlData.trim().length() > 0) {
                try {
                    this.fModelGenerator = this.createModelGenerator();
                    if (this.fModelGenerator.getDirective(ElementBuilderDirectives.COMPUTE_ELEMENT_OFFSETS) != null) {
                        this.fCurrentDocument = new Document(xmlData);
                    }
                    this.fModelGenerator.generate(xmlData);
                }
                catch (RuntimeException e) {
                    this.fException = e;
                }
            }
            return this.fException;
        }
        this.fException = new Exception(Messages.getCommonString("AbstractModel.1"));
        return this.fException;
    }

    public Exception initialize(IDocument xmlDocument) {
        if (this.fModelGenerator == null) {
            this.fCurrentDocument = xmlDocument;
            String xmlData = xmlDocument.get();
            if (xmlData != null && xmlData.trim().length() > 0) {
                try {
                    this.fModelGenerator = this.createModelGenerator();
                    this.fModelGenerator.generate(xmlData);
                }
                catch (RuntimeException e) {
                    this.fException = e;
                }
            }
            return this.fException;
        }
        this.fException = new Exception(Messages.getCommonString("AbstractModel.2"));
        return this.fException;
    }

    protected ModelGenerator createModelGenerator() {
        return new ModelGenerator(this);
    }

    public abstract AbstractElementBuilder getRootBuilder();

    public void dispose() {
        this.fCurrentDocument = null;
        this.clearChildElements();
    }

    public void warning(Exception x) {
    }

    public void error(Exception x) {
        this.fException = x;
    }

    public void fatalError(Exception x) {
        this.fException = x;
    }

    public static String serializeDocument(org.w3c.dom.Document doc) throws TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("indent-number", new Integer(4));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        StreamResult outputTarget = new StreamResult(new OutputStreamWriter((OutputStream)s, "UTF-8"));
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public IDocument getCurrentDocument() {
        return this.fCurrentDocument;
    }
}

