/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.advice.runtime;

import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.ISafeRunnableInfoCollector;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.common.advice.runtime.IOperationAdviceListener;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.advice.AdvicePackage;
import com.ibm.team.process.internal.common.advice.ReportInfo;
import com.ibm.team.process.internal.common.advice.RunnableReport;
import com.ibm.team.process.internal.common.advice.runtime.IOperationAdviceNotifier;
import com.ibm.team.process.internal.common.advice.runtime.Messages;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;

public class RunnableInfoCollector
implements ISafeRunnableInfoCollector {
    private final OperationAdviceManager fOperationAdviceManager;
    private final RunnableReport fReport;

    public RunnableInfoCollector(OperationAdviceManager operationAdviceManager, RunnableReport report) {
        this.fOperationAdviceManager = operationAdviceManager;
        this.fReport = report;
    }

    public void createExceptionInfo(final IReportInfo[] infos) {
        this.fReport.addInfos(infos);
        this.fOperationAdviceManager.runAdviceNotifier(new IOperationAdviceNotifier(){

            public void notifyListener(IOperationAdviceListener listener) {
                listener.handleInfosAdded(infos);
            }
        });
    }

    public void appendExceptionInfo(String summary, Throwable exception) {
        if (!this.alreadyReported(exception, this.fReport)) {
            String description = NLS.bind(Messages.getCommonString("RunnableInfoCollector.0"), exception.getMessage());
            ReportInfo info = (ReportInfo)this.createInfo(summary, description, exception);
            info.setIdentifier("com.ibm.team.process.exceptionProblem");
            info.setSeverity(4);
            final IReportInfo[] infos = new IReportInfo[]{info};
            this.fReport.addInfos(infos);
            this.fOperationAdviceManager.runAdviceNotifier(new IOperationAdviceNotifier(){

                public void notifyListener(IOperationAdviceListener listener) {
                    listener.handleInfosAdded(infos);
                }
            });
        }
    }

    private IReportInfo createInfo(String summary, String description, Object problemObject) {
        ReportInfo problem = AdvicePackage.eINSTANCE.getAdviceFactory().createReportInfo();
        problem.setDescription(description);
        problem.setIdentifier("com.ibm.team.process.participantInfo");
        problem.setSeverity(0);
        problem.setSummary(summary);
        if (problemObject != null) {
            problem.setProblemObject(problemObject);
        }
        return problem;
    }

    private boolean alreadyReported(Throwable exception, IProcessReport report) {
        if (exception instanceof TeamOperationCanceledException) {
            return true;
        }
        IReportInfo[] infos = report.getInfos();
        int i = 0;
        while (i < infos.length) {
            ReportInfo info = (ReportInfo)infos[i];
            if (info.getProblemObject() == exception) {
                return true;
            }
            ++i;
        }
        IProcessReport[] children = report.getNestedReports();
        int i2 = 0;
        while (i2 < children.length) {
            IProcessReport child = children[i2];
            if (this.alreadyReported(exception, child)) {
                return true;
            }
            ++i2;
        }
        return false;
    }
}

