/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.advice.runtime;

import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdviceListener;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.advice.AdvicePackage;
import com.ibm.team.process.internal.common.advice.AdvisorInfo;
import com.ibm.team.process.internal.common.advice.ParticipantReport;
import com.ibm.team.process.internal.common.advice.runtime.IOperationAdviceNotifier;
import com.ibm.team.process.internal.common.advice.runtime.Messages;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;

public class AdvisorInfoCollector
implements IAdvisorInfoCollector {
    private final OperationAdviceManager fOperationAdviceManager;
    private final ParticipantReport fReport;

    public AdvisorInfoCollector(OperationAdviceManager operationAdviceManager, ParticipantReport report) {
        this.fOperationAdviceManager = operationAdviceManager;
        this.fReport = report;
    }

    public void addInfo(IReportInfo info) {
        this.addInfos(new IReportInfo[]{info});
    }

    public void addInfos(final IReportInfo[] infos) {
        this.fReport.addInfos(infos);
        this.fOperationAdviceManager.runAdviceNotifier(new IOperationAdviceNotifier(){

            public void notifyListener(IOperationAdviceListener listener) {
                listener.handleInfosAdded(infos);
            }
        });
    }

    public IAdvisorInfo createExceptionInfo(String summary, Throwable exception) {
        String description = NLS.bind(Messages.getCommonString("AdvisorInfoCollector.0"), exception.getMessage());
        AdvisorInfo info = (AdvisorInfo)this.createProblemInfo(summary, description, "exceptionProblem");
        info.setSeverity(4);
        return info;
    }

    public IAdvisorInfo createProblemInfo(String summary, String description, String type) {
        AdvisorInfo problem = AdvicePackage.eINSTANCE.getAdviceFactory().createAdvisorInfo();
        problem.setDescription(description);
        problem.setIdentifier(type);
        problem.setSeverity(4);
        problem.setSummary(summary);
        return problem;
    }
}

