/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.advice.runtime;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;

public class AdvisorDeclaration
implements IAdvisorDeclaration {
    private IProcessConfigurationElement fConfigElement;
    private String fAdvisorId;
    private String fName;
    private boolean fOverrulable;
    private String fDescription;

    public static AdvisorDeclaration newAdvisorDeclaration(IProcessConfigurationElement configElement) {
        String advisorId = configElement.getAttribute("id");
        String name = configElement.getAttribute("name");
        if (advisorId != null && name != null) {
            String description = configElement.getAttribute("description");
            boolean overrulable = false;
            String overrulableString = configElement.getAttribute("overrulable");
            if (overrulableString != null) {
                overrulable = Boolean.parseBoolean(overrulableString);
            }
            return new AdvisorDeclaration(configElement, advisorId, name, overrulable, description);
        }
        return null;
    }

    private AdvisorDeclaration(IProcessConfigurationElement configElement, String advisorId, String name, boolean overrulable, String description) {
        this.fConfigElement = configElement;
        this.fAdvisorId = advisorId;
        this.fName = name;
        this.fOverrulable = overrulable;
        this.fDescription = description;
    }

    public IProcessConfigurationElement getConfigurationElement() {
        return this.fConfigElement;
    }

    public boolean isOverrulable() {
        return this.fOverrulable;
    }

    public String getIdentifier() {
        return this.fAdvisorId;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }
}

