/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common;

import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamData;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class RolePersistence {
    private static final String ROLES_KEY = "roles";
    private HashMap fRolesMap;

    public static String getPersistentRoleData(ITeamData teamData, IContributorHandle contributor) {
        return teamData.getContributorData(contributor, ROLES_KEY);
    }

    public static void setPersistedRoleData(ITeamData teamData, IContributorHandle contributor, String roleData) {
        teamData.setContributorData(contributor, ROLES_KEY, roleData);
    }

    public RolePersistence(IRole[] availableRoles) {
        this.fRolesMap = new HashMap(availableRoles.length);
        int i = 0;
        while (i < availableRoles.length) {
            this.fRolesMap.put(availableRoles[i].getId(), availableRoles[i]);
            ++i;
        }
    }

    public static String serialize(IRole[] roles) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < roles.length) {
            String roleId;
            if (i > 0) {
                buffer.append('|');
            }
            if (!(roleId = roles[i].getId()).equals("default")) {
                buffer.append(roleId);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    public IRole[] deserialize(String roleData) {
        ArrayList<IRole> roles = new ArrayList<IRole>();
        StringTokenizer tokenizer = new StringTokenizer(roleData, "|");
        while (tokenizer.hasMoreTokens()) {
            String roleId = tokenizer.nextToken();
            IRole role = (IRole)this.fRolesMap.get(roleId);
            if (role == null) continue;
            roles.add(role);
        }
        if (!roles.isEmpty()) {
            return roles.toArray(new IRole[roles.size()]);
        }
        return null;
    }
}

