/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.common.advice;

import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ISafeRunnableInfoCollector;
import com.ibm.team.process.common.advice.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ProcessRunnable {
    private String fOperationId;
    private ISafeRunnableInfoCollector fCollector;
    private Object fOrigin;

    public ProcessRunnable() {
    }

    public ProcessRunnable(String operationIdentifier) {
        this.fOperationId = operationIdentifier;
    }

    public abstract IOperationReport run(IProgressMonitor var1) throws TeamRepositoryException;

    public String getOperationIdentifier() {
        return this.fOperationId;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final IOperationReport internalRun(ISafeRunnableInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fCollector = collector;
        return this.run(monitor);
    }

    public final void safeRun(SafeProcessRunnable subRunnable, IProgressMonitor monitor) {
        try {
            subRunnable.run(monitor);
        }
        catch (Exception e) {
            subRunnable.handleException(e, this.fCollector);
        }
    }

    public void setOrigin(Object origin) {
        this.fOrigin = origin;
    }

    public Object getOrigin() {
        return this.fOrigin;
    }

    public abstract class SafeProcessRunnable {
        public abstract void run(IProgressMonitor var1) throws Exception;

        public void handleException(Exception e, ISafeRunnableInfoCollector collector) {
            collector.appendExceptionInfo(Messages.getCommonString("ProcessRunnable.0"), e);
        }
    }
}

