/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.contentmergeviewer;

import com.ibm.icu.text.MessageFormat;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.IEditableContentExtension;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.internal.BufferedCanvas;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.internal.DocumentManager;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.internal.IMergeViewerTestAdapter;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.internal.NavigationEndDialog;
import org.eclipse.compare.internal.OutlineViewerCreator;
import org.eclipse.compare.internal.ShowWhitespaceAction;
import org.eclipse.compare.internal.TextEditorPropertyAction;
import org.eclipse.compare.internal.TokenComparator;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IElementStateListener;

public class TextMergeViewer
extends ContentMergeViewer
implements IAdaptable {
    private static final String COPY_LEFT_TO_RIGHT_INDICATOR = ">";
    private static final String COPY_RIGHT_TO_LEFT_INDICATOR = "<";
    private static final char ANCESTOR_CONTRIBUTOR = 'A';
    private static final char RIGHT_CONTRIBUTOR = 'R';
    private static final char LEFT_CONTRIBUTOR = 'L';
    private static final String DIFF_RANGE_CATEGORY = "org.eclipse.compare.DIFF_RANGE_CATEGORY";
    static final boolean DEBUG = false;
    private static final boolean FIX_47640 = true;
    private static final String[] GLOBAL_ACTIONS = new String[]{ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.CUT.getId(), ActionFactory.COPY.getId(), ActionFactory.PASTE.getId(), ActionFactory.DELETE.getId(), ActionFactory.SELECT_ALL.getId(), ActionFactory.SAVE.getId(), ActionFactory.FIND.getId()};
    private static final String[] TEXT_ACTIONS = new String[]{"undo", "redo", "cut", "copy", "paste", "delete", "selectAll", "save", "find"};
    private static final String BUNDLE_NAME = "org.eclipse.compare.contentmergeviewer.TextMergeViewerResources";
    private static final String INCOMING_COLOR = "INCOMING_COLOR";
    private static final String OUTGOING_COLOR = "OUTGOING_COLOR";
    private static final String CONFLICTING_COLOR = "CONFLICTING_COLOR";
    private static final String RESOLVED_COLOR = "RESOLVED_COLOR";
    private static final int MARGIN_WIDTH = 6;
    private static final int CENTER_WIDTH = 34;
    private static final int BIRDS_EYE_VIEW_WIDTH = 12;
    private static final int BIRDS_EYE_VIEW_INSET = 2;
    private static final int RESOLVE_SIZE = 5;
    private static final boolean APPEND_CONFLICT = true;
    private static final int LW = 1;
    private static final boolean USE_MERGING_TOKEN_DIFF = false;
    private boolean fLeftIsLocal;
    private boolean fShowCurrentOnly = false;
    private boolean fShowCurrentOnly2 = false;
    private int fMarginWidth = 6;
    private int fTopInset;
    private RGB fBackground;
    private RGB fForeground;
    private boolean fPollSystemForeground = true;
    private boolean fPollSystemBackground = true;
    private RGB SELECTED_INCOMING;
    private RGB INCOMING;
    private RGB INCOMING_FILL;
    private RGB INCOMING_TEXT_FILL;
    private RGB SELECTED_CONFLICT;
    private RGB CONFLICT;
    private RGB CONFLICT_FILL;
    private RGB CONFLICT_TEXT_FILL;
    private RGB SELECTED_OUTGOING;
    private RGB OUTGOING;
    private RGB OUTGOING_FILL;
    private RGB OUTGOING_TEXT_FILL;
    private RGB RESOLVED;
    private IPreferenceStore fPreferenceStore;
    private IPropertyChangeListener fPreferenceChangeListener;
    private ArrayList fAllDiffs;
    private ArrayList fChangeDiffs;
    private Diff fCurrentDiff;
    private HashMap fNewAncestorRanges = new HashMap();
    private HashMap fNewLeftRanges = new HashMap();
    private HashMap fNewRightRanges = new HashMap();
    private MergeSourceViewer fAncestor;
    private MergeSourceViewer fLeft;
    private MergeSourceViewer fRight;
    private int fLeftLineCount;
    private int fRightLineCount;
    private boolean fInScrolling;
    private int[] fPts = new int[8];
    private int fInheritedDirection;
    private int fTextDirection;
    private ActionContributionItem fIgnoreAncestorItem;
    private boolean fHighlightRanges;
    private boolean fShowPseudoConflicts = false;
    private boolean fUseSplines = true;
    private boolean fUseSingleLine = true;
    private boolean fUseResolveUI = true;
    private boolean fHighlightTokenChanges = false;
    private String fSymbolicFontName;
    private ActionContributionItem fNextDiff;
    private ActionContributionItem fPreviousDiff;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;
    private CompareHandlerService fHandlerService;
    private boolean fSynchronizedScrolling = true;
    private boolean fShowMoreInfo = false;
    private MergeSourceViewer fFocusPart;
    private boolean fSubDoc = true;
    private IPositionUpdater fPositionUpdater;
    private boolean fIsMotif;
    private boolean fIsCarbon;
    private boolean fHasErrors;
    private BufferedCanvas fAncestorCanvas;
    private BufferedCanvas fLeftCanvas;
    private BufferedCanvas fRightCanvas;
    private Canvas fScrollCanvas;
    private ScrollBar fVScrollBar;
    private Canvas fBirdsEyeCanvas;
    private Canvas fSummaryHeader;
    private HeaderPainter fHeaderPainter;
    private Map fColors;
    private Cursor fBirdsEyeCursor;
    private double[] fBasicCenterCurve;
    private Button fCenterButton;
    private Diff fButtonDiff;
    private ContributorInfo fLeftContributor;
    private ContributorInfo fRightContributor;
    private ContributorInfo fAncestorContributor;
    private boolean isRefreshing;
    private int fSynchronziedScrollPosition;
    private ActionContributionItem fNextChange;
    private ActionContributionItem fPreviousChange;
    private ShowWhitespaceAction showWhitespaceAction;
    private InternalOutlineViewerCreator fOutlineViewerCreator;
    private TextEditorPropertyAction toggleLineNumbersAction;
    private IFindReplaceTarget fFindReplaceTarget;
    private ChangePropertyAction fIgnoreWhitespace;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public TextMergeViewer(Composite parent, CompareConfiguration configuration) {
        this(parent, 0, configuration);
    }

    public TextMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(style, ResourceBundle.getBundle(BUNDLE_NAME), configuration);
        int inheritedStyle = parent.getStyle();
        this.fInheritedDirection = (inheritedStyle & 0x2000000) != 0 ? 0x2000000 : ((inheritedStyle & 0x4000000) != 0 ? 0x4000000 : 0);
        this.fTextDirection = (style & 0x2000000) != 0 ? 0x2000000 : ((style & 0x4000000) != 0 ? 0x4000000 : 0);
        this.fSymbolicFontName = this.getClass().getName();
        String platform = SWT.getPlatform();
        this.fIsMotif = "motif".equals(platform);
        this.fIsCarbon = "carbon".equals(platform);
        if (this.fIsMotif) {
            this.fMarginWidth = 0;
        }
        Display display = parent.getDisplay();
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TextMergeViewer.this.handlePropertyChangeEvent(event);
            }
        };
        this.fPreferenceStore = this.getCompareConfiguration().getPreferenceStore();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
            this.checkForColorUpdate(display);
            this.fLeftIsLocal = Utilities.getBoolean(this.getCompareConfiguration(), "LEFT_IS_LOCAL", false);
            this.fSynchronizedScrolling = this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling");
            this.fShowMoreInfo = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowMoreInfo");
            this.fShowPseudoConflicts = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowPseudoConflicts");
            this.fUseSingleLine = this.fPreferenceStore.getBoolean("org.eclipse.compare.UseSingleLine");
            this.fHighlightTokenChanges = this.fPreferenceStore.getBoolean("org.eclipse.compare.HighlightTokenChanges");
        }
        this.buildControl(parent);
        INavigatable nav = new INavigatable(){

            public boolean selectChange(int flag) {
                if (flag == 3 || flag == 4) {
                    TextMergeViewer.this.selectFirstDiff(flag == 3);
                    return false;
                }
                return TextMergeViewer.this.navigate(flag == 1, false, false);
            }

            public Object getInput() {
                return TextMergeViewer.this.getInput();
            }

            public boolean openSelectedChange() {
                return false;
            }

            public boolean hasChange(int flag) {
                return TextMergeViewer.this.getNextVisibleDiff(flag == 1, false) != null;
            }
        };
        this.fComposite.setData("org.eclipse.compare.internal.Navigator", (Object)nav);
        this.fBirdsEyeCursor = new Cursor((Device)parent.getDisplay(), 21);
        JFaceResources.getFontRegistry().addListener(this.fPreferenceChangeListener);
        JFaceResources.getColorRegistry().addListener(this.fPreferenceChangeListener);
        this.updateFont();
    }

    private void updateFont() {
        Font f = JFaceResources.getFont((String)this.fSymbolicFontName);
        if (f != null) {
            if (this.fAncestor != null) {
                this.fAncestor.setFont(f);
            }
            if (this.fLeft != null) {
                this.fLeft.setFont(f);
            }
            if (this.fRight != null) {
                this.fRight.setFont(f);
            }
        }
    }

    private void checkForColorUpdate(Display display) {
        if (this.fPollSystemForeground) {
            RGB fg = display.getSystemColor(24).getRGB();
            if (this.fForeground == null || !fg.equals((Object)this.fForeground)) {
                this.fForeground = fg;
                this.updateColors(display);
            }
        }
        if (this.fPollSystemBackground) {
            RGB bg = display.getSystemColor(25).getRGB();
            if (this.fBackground == null || !bg.equals((Object)this.fBackground)) {
                this.fBackground = bg;
                this.updateColors(display);
            }
        }
    }

    public void setBackgroundColor(RGB background) {
        this.fPollSystemBackground = background == null;
        this.fBackground = background;
        this.updateColors(null);
    }

    private RGB getBackground(Display display) {
        if (this.fBackground != null) {
            return this.fBackground;
        }
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        return display.getSystemColor(25).getRGB();
    }

    public void setForegroundColor(RGB foreground) {
        this.fPollSystemForeground = foreground == null;
        this.fForeground = foreground;
        this.updateColors(null);
    }

    private void updateColors(Display display) {
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        Color color = null;
        if (this.fBackground != null) {
            color = this.getColor(display, this.fBackground);
        }
        if (this.fAncestor != null) {
            this.fAncestor.setBackgroundColor(color);
        }
        if (this.fLeft != null) {
            this.fLeft.setBackgroundColor(color);
        }
        if (this.fRight != null) {
            this.fRight.setBackgroundColor(color);
        }
        ColorRegistry registry = JFaceResources.getColorRegistry();
        RGB bg = this.getBackground(display);
        this.SELECTED_INCOMING = registry.getRGB(INCOMING_COLOR);
        if (this.SELECTED_INCOMING == null) {
            this.SELECTED_INCOMING = new RGB(0, 0, 255);
        }
        this.INCOMING = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.6);
        this.INCOMING_FILL = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.97);
        this.INCOMING_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.85);
        this.SELECTED_OUTGOING = registry.getRGB(OUTGOING_COLOR);
        if (this.SELECTED_OUTGOING == null) {
            this.SELECTED_OUTGOING = new RGB(0, 0, 0);
        }
        this.OUTGOING = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.6);
        this.OUTGOING_FILL = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.97);
        this.OUTGOING_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.85);
        this.SELECTED_CONFLICT = registry.getRGB(CONFLICTING_COLOR);
        if (this.SELECTED_CONFLICT == null) {
            this.SELECTED_CONFLICT = new RGB(255, 0, 0);
        }
        this.CONFLICT = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.6);
        this.CONFLICT_FILL = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.97);
        this.CONFLICT_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.85);
        this.RESOLVED = registry.getRGB(RESOLVED_COLOR);
        if (this.RESOLVED == null) {
            this.RESOLVED = new RGB(0, 255, 0);
        }
        this.updatePresentation(display);
    }

    private void updatePresentation(Display display) {
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        this.refreshBirdsEyeView();
        this.invalidateLines();
        this.updateAllDiffBackgrounds(display);
        this.invalidateTextPresentation();
    }

    public void invalidateTextPresentation() {
        if (this.fAncestor != null) {
            this.fAncestor.invalidateTextPresentation();
        }
        if (this.fLeft != null) {
            this.fLeft.invalidateTextPresentation();
        }
        if (this.fRight != null) {
            this.fRight.invalidateTextPresentation();
        }
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof MergeSourceViewer) {
            SourceViewerConfiguration configuration = new SourceViewerConfiguration();
            ((MergeSourceViewer)textViewer).configure(configuration);
        }
    }

    protected ITokenComparator createTokenComparator(String line) {
        return new TokenComparator(line);
    }

    protected void setupDocument(IDocument document) {
        String partitioning = this.getDocumentPartitioning();
        if (partitioning == null || !(document instanceof IDocumentExtension3)) {
            IDocumentPartitioner partitioner;
            if (document.getDocumentPartitioner() == null && (partitioner = this.getDocumentPartitioner()) != null) {
                document.setDocumentPartitioner(partitioner);
                partitioner.connect(document);
            }
        } else {
            IDocumentPartitioner partitioner;
            IDocumentExtension3 ex3 = (IDocumentExtension3)document;
            if (ex3.getDocumentPartitioner(partitioning) == null && (partitioner = this.getDocumentPartitioner()) != null) {
                ex3.setDocumentPartitioner(partitioning, partitioner);
                partitioner.connect(document);
            }
        }
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return null;
    }

    protected String getDocumentPartitioning() {
        return null;
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fHandlerService != null) {
            this.fHandlerService.dispose();
        }
        Object input = this.getInput();
        this.removeFromDocumentManager('A', input);
        this.removeFromDocumentManager('L', input);
        this.removeFromDocumentManager('R', input);
        if (this.fPreferenceChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fPreferenceChangeListener);
            JFaceResources.getColorRegistry().removeListener(this.fPreferenceChangeListener);
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            }
            this.fPreferenceChangeListener = null;
        }
        this.fLeftCanvas = null;
        this.fRightCanvas = null;
        this.fVScrollBar = null;
        this.fBirdsEyeCanvas = null;
        this.fSummaryHeader = null;
        this.fAncestorContributor.unsetDocument(this.fAncestor);
        this.fLeftContributor.unsetDocument(this.fLeft);
        this.fRightContributor.unsetDocument(this.fRight);
        this.disconnect(this.fLeftContributor);
        this.disconnect(this.fRightContributor);
        this.disconnect(this.fAncestorContributor);
        if (this.fColors != null) {
            Iterator i = this.fColors.values().iterator();
            while (i.hasNext()) {
                Color color = (Color)i.next();
                if (color.isDisposed()) continue;
                color.dispose();
            }
            this.fColors = null;
        }
        if (this.fBirdsEyeCursor != null) {
            this.fBirdsEyeCursor.dispose();
            this.fBirdsEyeCursor = null;
        }
        if (this.showWhitespaceAction != null) {
            this.showWhitespaceAction.dispose();
        }
        if (this.toggleLineNumbersAction != null) {
            this.toggleLineNumbersAction.dispose();
        }
        if (this.fIgnoreWhitespace != null) {
            this.fIgnoreWhitespace.dispose();
        }
        super.handleDispose(event);
    }

    private void disconnect(ContributorInfo legInfo) {
        if (legInfo != null) {
            legInfo.disconnect();
        }
    }

    protected void createControls(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.compare.text_merge_view_context");
        if (this.fMarginWidth > 0) {
            this.fAncestorCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fAncestor, TextMergeViewer.this.fAncestorCanvas, false);
                }
            };
            this.fAncestorCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides(TextMergeViewer.this.fAncestorCanvas, TextMergeViewer.this.fAncestor, e.y), false);
                }
            });
        }
        this.fAncestor = this.createPart(composite);
        this.fAncestor.setEditable(false);
        this.fAncestor.getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_ancestor, (Object)TextMergeViewer.this.getCompareConfiguration().getAncestorLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fAncestor.addTextPresentationListener(new ChangeHighlighter(this.fAncestor));
        this.fSummaryHeader = new Canvas(composite, 0);
        this.fHeaderPainter = new HeaderPainter();
        this.fSummaryHeader.addPaintListener((PaintListener)this.fHeaderPainter);
        this.updateResolveStatus();
        if (this.fMarginWidth > 0) {
            this.fLeftCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fLeft, TextMergeViewer.this.fLeftCanvas, false);
                }
            };
            this.fLeftCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides(TextMergeViewer.this.fLeftCanvas, TextMergeViewer.this.fLeft, e.y), false);
                }
            });
        }
        this.fLeft = this.createPart(composite);
        this.fLeft.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fLeft.addAction("save", this.fLeftSaveAction);
        this.fLeft.getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_left, (Object)TextMergeViewer.this.getCompareConfiguration().getLeftLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fLeft.addTextPresentationListener(new ChangeHighlighter(this.fLeft));
        this.fRight = this.createPart(composite);
        this.fRight.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fRight.addAction("save", this.fRightSaveAction);
        this.fRight.getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_right, (Object)TextMergeViewer.this.getCompareConfiguration().getRightLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fRight.addTextPresentationListener(new ChangeHighlighter(this.fRight));
        this.hsynchViewport((TextViewer)this.fAncestor, (TextViewer)this.fLeft, (TextViewer)this.fRight);
        this.hsynchViewport((TextViewer)this.fLeft, (TextViewer)this.fAncestor, (TextViewer)this.fRight);
        this.hsynchViewport((TextViewer)this.fRight, (TextViewer)this.fAncestor, (TextViewer)this.fLeft);
        if (this.fMarginWidth > 0) {
            this.fRightCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fRight, TextMergeViewer.this.fRightCanvas, TextMergeViewer.this.fSynchronizedScrolling);
                }
            };
            this.fRightCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides(TextMergeViewer.this.fRightCanvas, TextMergeViewer.this.fRight, e.y), false);
                }
            });
        }
        this.fScrollCanvas = new Canvas(composite, 512);
        Rectangle trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        this.fTopInset = trim.y;
        this.fVScrollBar = this.fScrollCanvas.getVerticalBar();
        this.fVScrollBar.setIncrement(1);
        this.fVScrollBar.setVisible(true);
        this.fVScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int vpos = ((ScrollBar)e.widget).getSelection();
                TextMergeViewer.this.synchronizedScrollVertical(vpos);
            }
        });
        this.fBirdsEyeCanvas = new BufferedCanvas(composite, 0){

            public void doPaint(GC gc) {
                TextMergeViewer.this.paintBirdsEyeView(this, gc);
            }
        };
        this.fBirdsEyeCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handlemouseInBirdsEyeView(TextMergeViewer.this.fBirdsEyeCanvas, e.y), true);
            }
        });
        this.fBirdsEyeCanvas.addMouseMoveListener(new MouseMoveListener(){
            private Cursor fLastCursor;

            public void mouseMove(MouseEvent e) {
                Cursor cursor = null;
                Diff diff = TextMergeViewer.this.handlemouseInBirdsEyeView(TextMergeViewer.this.fBirdsEyeCanvas, e.y);
                if (diff != null && diff.fDirection != 0) {
                    cursor = TextMergeViewer.this.fBirdsEyeCursor;
                }
                if (this.fLastCursor != cursor) {
                    TextMergeViewer.this.fBirdsEyeCanvas.setCursor(cursor);
                    this.fLastCursor = cursor;
                }
            }
        });
    }

    private void hsynchViewport(TextViewer tv1, TextViewer tv2, TextViewer tv3) {
        StyledText st1 = tv1.getTextWidget();
        final StyledText st2 = tv2.getTextWidget();
        final StyledText st3 = tv3.getTextWidget();
        final ScrollBar sb1 = st1.getHorizontalBar();
        sb1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextMergeViewer.this.fSynchronizedScrolling) {
                    int max = sb1.getMaximum() - sb1.getThumb();
                    double v = 0.0;
                    if (max > 0) {
                        v = (float)sb1.getSelection() / (float)max;
                    }
                    if (st2.isVisible()) {
                        ScrollBar sb2 = st2.getHorizontalBar();
                        st2.setHorizontalPixel((int)((double)(sb2.getMaximum() - sb2.getThumb()) * v));
                    }
                    if (st3.isVisible()) {
                        ScrollBar sb3 = st3.getHorizontalBar();
                        st3.setHorizontalPixel((int)((double)(sb3.getMaximum() - sb3.getThumb()) * v));
                    }
                    TextMergeViewer.this.workaround65205();
                }
            }
        });
    }

    private void workaround65205() {
        if (this.fIsCarbon && this.fComposite != null && !this.fComposite.isDisposed()) {
            this.fComposite.getDisplay().update();
        }
    }

    private void setCurrentDiff2(Diff diff, boolean reveal) {
        if (diff != null && diff.fDirection != 0) {
            this.setCurrentDiff(diff, reveal);
        }
    }

    private Diff handleMouseInSides(Canvas canvas, MergeSourceViewer tp, int my) {
        int lineHeight = tp.getTextWidget().getLineHeight();
        int visibleHeight = tp.getViewportHeight();
        if (!this.fHighlightRanges) {
            return null;
        }
        if (this.fChangeDiffs != null) {
            int shift = tp.getVerticalScrollOffset() + 1;
            Point region = new Point(0, 0);
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                tp.getLineRange(diff.getPosition(tp), region);
                int y = region.x * lineHeight + shift;
                int h = region.y * lineHeight;
                if (y + h < 0) continue;
                if (y >= visibleHeight) break;
                if (my < y || my >= y + h) continue;
                return diff;
            }
        }
        return null;
    }

    private Diff getDiffUnderMouse(Canvas canvas, int mx, int my, Rectangle r) {
        if (!this.fSynchronizedScrolling) {
            return null;
        }
        int lineHeight = this.fLeft.getTextWidget().getLineHeight();
        int visibleHeight = this.fRight.getViewportHeight();
        Point size = canvas.getSize();
        int w = size.x;
        if (!this.fHighlightRanges) {
            return null;
        }
        if (this.fChangeDiffs != null) {
            int lshift = this.fLeft.getVerticalScrollOffset();
            int rshift = this.fRight.getVerticalScrollOffset();
            Point region = new Point(0, 0);
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                this.fLeft.getLineRange(diff.fLeftPos, region);
                int ly = region.x * lineHeight + lshift;
                int lh = region.y * lineHeight;
                this.fRight.getLineRange(diff.fRightPos, region);
                int ry = region.x * lineHeight + rshift;
                int rh = region.y * lineHeight;
                if (Math.max(ly + lh, ry + rh) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                int cx = (w - 5) / 2;
                int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
                if (my < cy || my >= cy + 5 || mx < cx || mx >= cx + 5) continue;
                if (r != null) {
                    int SIZE = this.fIsCarbon ? 30 : 20;
                    r.x = cx + (5 - SIZE) / 2;
                    r.y = cy + (5 - SIZE) / 2;
                    r.width = SIZE;
                    r.height = SIZE;
                }
                return diff;
            }
        }
        return null;
    }

    private Diff handlemouseInBirdsEyeView(Canvas canvas, int my) {
        int virtualHeight;
        Point size = canvas.getSize();
        int n = virtualHeight = this.fSynchronizedScrolling ? this.getVirtualHeight() : this.getRightHeight();
        if (virtualHeight < this.getViewportHeight()) {
            return null;
        }
        int y = 0;
        if (this.fAllDiffs != null) {
            Iterator e = this.fAllDiffs.iterator();
            int i = 0;
            while (e.hasNext()) {
                int h;
                Diff diff = (Diff)e.next();
                int n2 = h = this.fSynchronizedScrolling ? diff.getMaxDiffHeight() : diff.getRightHeight();
                if (this.useChange(diff.fDirection) && !diff.fIsWhitespace) {
                    int yy = y * size.y / virtualHeight;
                    int hh = h * size.y / virtualHeight;
                    if (hh < 3) {
                        hh = 3;
                    }
                    if (my >= yy && my < yy + hh) {
                        return diff;
                    }
                }
                y += h;
                ++i;
            }
        }
        return null;
    }

    private void paintBirdsEyeView(Canvas canvas, GC gc) {
        int virtualHeight;
        Rectangle r = new Rectangle(0, 0, 0, 0);
        Point size = canvas.getSize();
        int n = virtualHeight = this.fSynchronizedScrolling ? this.getVirtualHeight() : this.getRightHeight();
        if (virtualHeight < this.getViewportHeight()) {
            return;
        }
        Display display = canvas.getDisplay();
        int y = 0;
        if (this.fAllDiffs != null) {
            Iterator e = this.fAllDiffs.iterator();
            int i = 0;
            while (e.hasNext()) {
                int h;
                Diff diff = (Diff)e.next();
                int n2 = h = this.fSynchronizedScrolling ? diff.getMaxDiffHeight() : diff.getRightHeight();
                if (this.useChange(diff.fDirection) && !diff.fIsWhitespace) {
                    Color c;
                    int yy = y * size.y / virtualHeight;
                    int hh = h * size.y / virtualHeight;
                    if (hh < 3) {
                        hh = 3;
                    }
                    if ((c = this.getColor(display, this.getFillColor(diff))) != null) {
                        gc.setBackground(c);
                        gc.fillRectangle(2, yy, size.x - 4, hh);
                    }
                    if ((c = this.getColor(display, this.getStrokeColor(diff))) != null) {
                        gc.setForeground(c);
                        r.x = 2;
                        r.y = yy;
                        r.width = size.x - 4 - 1;
                        r.height = hh;
                        if (diff == this.fCurrentDiff || this.fCurrentDiff != null && diff == this.fCurrentDiff.fParent) {
                            gc.setLineWidth(2);
                            ++r.x;
                            ++r.y;
                            --r.width;
                            --r.height;
                        } else {
                            gc.setLineWidth(0);
                        }
                        gc.drawRectangle(r);
                    }
                }
                y += h;
                ++i;
            }
        }
    }

    private void refreshBirdsEyeView() {
        if (this.fBirdsEyeCanvas != null) {
            this.fBirdsEyeCanvas.redraw();
        }
    }

    protected boolean handleSetFocus() {
        StyledText st;
        if (this.fFocusPart == null) {
            if (this.fLeft != null && this.fLeft.getEnabled()) {
                this.fFocusPart = this.fLeft;
            } else if (this.fRight != null && this.fRight.getEnabled()) {
                this.fFocusPart = this.fRight;
            } else if (this.fAncestor != null && this.fAncestor.getEnabled()) {
                this.fFocusPart = this.fAncestor;
            }
        }
        if (this.fFocusPart != null && (st = this.fFocusPart.getTextWidget()) != null) {
            return st.setFocus();
        }
        return false;
    }

    protected final Control createCenterControl(Composite parent) {
        if (this.fSynchronizedScrolling) {
            BufferedCanvas canvas = new BufferedCanvas(parent, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintCenter(this, gc);
                }
            };
            if (this.fUseResolveUI) {
                new HoverResizer(canvas, 1);
                this.fCenterButton = new Button((Composite)canvas, this.fIsCarbon ? 0x800000 : 8);
                if (this.fNormalCursor == null) {
                    this.fNormalCursor = new Cursor((Device)canvas.getDisplay(), 0);
                }
                this.fCenterButton.setCursor(this.fNormalCursor);
                this.fCenterButton.setText(COPY_RIGHT_TO_LEFT_INDICATOR);
                this.fCenterButton.pack();
                this.fCenterButton.setVisible(false);
                this.fCenterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextMergeViewer.this.fCenterButton.setVisible(false);
                        if (TextMergeViewer.this.fButtonDiff != null) {
                            TextMergeViewer.this.setCurrentDiff(TextMergeViewer.this.fButtonDiff, false);
                            TextMergeViewer.this.copy(TextMergeViewer.this.fCurrentDiff, TextMergeViewer.this.fCenterButton.getText().equals(TextMergeViewer.COPY_LEFT_TO_RIGHT_INDICATOR), ((TextMergeViewer)TextMergeViewer.this).fCurrentDiff.fDirection != 1);
                        }
                    }
                });
            } else {
                new ContentMergeViewer.Resizer(this, (Control)canvas, 1);
            }
            return canvas;
        }
        return super.createCenterControl(parent);
    }

    private boolean handleMouseMoveOverCenter(Canvas canvas, int x, int y) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        Diff diff = this.getDiffUnderMouse(canvas, x, y, r);
        if (diff != null && !diff.isUnresolvedIncomingOrConflicting()) {
            diff = null;
        }
        if (diff != this.fButtonDiff) {
            if (diff != null) {
                if (this.fLeft.isEditable()) {
                    this.fButtonDiff = diff;
                    this.fCenterButton.setText(COPY_RIGHT_TO_LEFT_INDICATOR);
                    String tt = this.fCopyDiffRightToLeftItem.getAction().getToolTipText();
                    this.fCenterButton.setToolTipText(tt);
                    this.fCenterButton.setBounds(r);
                    this.fCenterButton.setVisible(true);
                } else if (this.fRight.isEditable()) {
                    this.fButtonDiff = diff;
                    this.fCenterButton.setText(COPY_LEFT_TO_RIGHT_INDICATOR);
                    String tt = this.fCopyDiffLeftToRightItem.getAction().getToolTipText();
                    this.fCenterButton.setToolTipText(tt);
                    this.fCenterButton.setBounds(r);
                    this.fCenterButton.setVisible(true);
                } else {
                    this.fButtonDiff = null;
                }
            } else {
                this.fCenterButton.setVisible(false);
                this.fButtonDiff = null;
            }
        }
        return this.fButtonDiff != null;
    }

    protected final int getCenterWidth() {
        if (this.fSynchronizedScrolling) {
            return 34;
        }
        return super.getCenterWidth();
    }

    private int getDirection() {
        switch (this.fTextDirection) {
            case 0x2000000: 
            case 0x4000000: {
                if (this.fInheritedDirection == this.fTextDirection) {
                    return 0;
                }
                return this.fTextDirection;
            }
        }
        return this.fInheritedDirection;
    }

    private MergeSourceViewer createPart(Composite parent) {
        final MergeSourceViewer part = new MergeSourceViewer(parent, this.getDirection(), this.getResourceBundle(), this.getCompareConfiguration().getContainer());
        StyledText te = part.getTextWidget();
        if (!this.fConfirmSave) {
            part.hideSaveAction();
        }
        te.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TextMergeViewer.this.paint(e, part);
            }
        });
        te.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TextMergeViewer.this.handleSelectionChanged(part);
            }
        });
        te.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TextMergeViewer.this.handleSelectionChanged(part);
            }
        });
        te.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent fe) {
                TextMergeViewer.this.fFocusPart = part;
                TextMergeViewer.this.connectGlobalActions(TextMergeViewer.this.fFocusPart);
            }

            public void focusLost(FocusEvent fe) {
                TextMergeViewer.this.connectGlobalActions(null);
            }
        });
        part.addViewportListener(new IViewportListener(){

            public void viewportChanged(int verticalPosition) {
                TextMergeViewer.this.syncViewport(part);
            }
        });
        Font font = JFaceResources.getFont((String)this.fSymbolicFontName);
        if (font != null) {
            te.setFont(font);
        }
        if (this.fBackground != null) {
            te.setBackground(this.getColor(parent.getDisplay(), this.fBackground));
        }
        this.contributeFindAction(part);
        this.configureTextViewer((TextViewer)part);
        return part;
    }

    private void contributeFindAction(MergeSourceViewer viewer) {
        IWorkbenchPart wp = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        FindReplaceAction action = wp != null ? new FindReplaceAction(this.getResourceBundle(), "Editor.FindReplace.", wp) : new FindReplaceAction(this.getResourceBundle(), "Editor.FindReplace.", viewer.getControl().getShell(), this.getFindReplaceTarget());
        action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        viewer.addAction("find", (IAction)action);
    }

    private void connectGlobalActions(final MergeSourceViewer part) {
        if (this.fHandlerService != null) {
            if (part != null) {
                part.updateActions();
            }
            this.fHandlerService.updatePaneActionHandlers(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < GLOBAL_ACTIONS.length) {
                        Object action = null;
                        if (part != null && (action = part.getAction(TEXT_ACTIONS[i])) == null && TEXT_ACTIONS[i].equals("save")) {
                            action = part == TextMergeViewer.this.fLeft ? TextMergeViewer.this.fLeftSaveAction : TextMergeViewer.this.fRightSaveAction;
                        }
                        TextMergeViewer.this.fHandlerService.setGlobalActionHandler(GLOBAL_ACTIONS[i], (IAction)action);
                        ++i;
                    }
                }
            });
        }
    }

    private IDocument getElementDocument(char type, Object element) {
        if (element instanceof IDocument) {
            return (IDocument)element;
        }
        ITypedElement te = Utilities.getLeg(type, element);
        IDocument document = null;
        switch (type) {
            case 'A': {
                document = this.getDocument(te, this.fAncestorContributor);
                break;
            }
            case 'L': {
                document = this.getDocument(te, this.fLeftContributor);
                break;
            }
            case 'R': {
                document = this.getDocument(te, this.fRightContributor);
            }
        }
        if (document != null) {
            return document;
        }
        return Utilities.getDocument(type, element, this.isUsingDefaultContentProvider(), this.canHaveSharedDocument());
    }

    private boolean isUsingDefaultContentProvider() {
        return this.getContentProvider() instanceof MergeViewerContentProvider;
    }

    private boolean canHaveSharedDocument() {
        return this.getDocumentPartitioning() != null || this.getDocumentPartitioner() == null;
    }

    private IDocument getDocument(ITypedElement te, ContributorInfo info) {
        if (info != null && info.getElement() == te) {
            return info.getDocument();
        }
        return null;
    }

    IDocument getDocument(char type, Object input) {
        IDocument doc = this.getElementDocument(type, input);
        if (doc != null) {
            return doc;
        }
        if (input instanceof IDiffElement) {
            IDiffContainer parent = ((IDiffElement)input).getParent();
            return this.getElementDocument(type, parent);
        }
        return null;
    }

    boolean sameDoc(char type, Object newInput, Object oldInput) {
        IDocument oldDoc;
        IDocument newDoc = this.getDocument(type, newInput);
        return newDoc == (oldDoc = this.getDocument(type, oldInput));
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        if (oldInput != null && newInput != null && this.sameDoc('A', newInput, oldInput) && this.sameDoc('L', newInput, oldInput) && this.sameDoc('R', newInput, oldInput)) {
            return false;
        }
        this.removeFromDocumentManager('A', oldInput);
        this.removeFromDocumentManager('L', oldInput);
        this.removeFromDocumentManager('R', oldInput);
        return super.doSave(newInput, oldInput);
    }

    private void removeFromDocumentManager(char leg, Object oldInput) {
        IDocument document = this.getDocument(leg, oldInput);
        if (document != null) {
            DocumentManager.remove(document);
        }
    }

    private ITypedElement getParent(char type) {
        Object input = this.getInput();
        if (input instanceof IDiffElement) {
            IDiffContainer parent = ((IDiffElement)input).getParent();
            return Utilities.getLeg(type, parent);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateContent(Object ancestor, Object left, Object right) {
        ICompareInput ci;
        IDiffContainer parent;
        boolean emptyInput = ancestor == null && left == null && right == null;
        Object input = this.getInput();
        Position leftRange = null;
        Position rightRange = null;
        if (!emptyInput && (left == null || right == null) && input instanceof IDiffElement && (parent = ((IDiffElement)input).getParent()) instanceof ICompareInput && ((ci = (ICompareInput)((Object)parent)).getAncestor() instanceof IDocumentRange || ci.getLeft() instanceof IDocumentRange || ci.getRight() instanceof IDocumentRange)) {
            if (left instanceof IDocumentRange) {
                leftRange = ((IDocumentRange)left).getRange();
            }
            if (right instanceof IDocumentRange) {
                rightRange = ((IDocumentRange)right).getRange();
            }
            ancestor = ci.getAncestor();
            left = ci.getLeft();
            right = ci.getRight();
        }
        int n = 0;
        if (left != null) {
            ++n;
        }
        if (right != null) {
            ++n;
        }
        this.fHighlightRanges = n > 1;
        this.resetDiffs();
        this.fHasErrors = false;
        CompareConfiguration cc = this.getCompareConfiguration();
        IMergeViewerContentProvider cp = this.getMergeContentProvider();
        if (cp instanceof MergeViewerContentProvider) {
            MergeViewerContentProvider mcp = (MergeViewerContentProvider)cp;
            mcp.setAncestorError(null);
            mcp.setLeftError(null);
            mcp.setRightError(null);
        }
        ContributorInfo oldLeftContributor = this.fLeftContributor;
        ContributorInfo oldRightContributor = this.fRightContributor;
        ContributorInfo oldAncestorContributor = this.fAncestorContributor;
        this.fLeftContributor = this.createLegInfoFor(left, 'L');
        this.fRightContributor = this.createLegInfoFor(right, 'R');
        this.fAncestorContributor = this.createLegInfoFor(ancestor, 'A');
        this.fLeftContributor.transferContributorStateFrom(oldLeftContributor);
        this.fRightContributor.transferContributorStateFrom(oldRightContributor);
        this.fAncestorContributor.transferContributorStateFrom(oldAncestorContributor);
        this.disconnect(oldLeftContributor);
        this.disconnect(oldRightContributor);
        this.disconnect(oldAncestorContributor);
        this.fLeftContributor.setEncodingIfAbsent(this.fRightContributor);
        this.fRightContributor.setEncodingIfAbsent(this.fLeftContributor);
        this.fAncestorContributor.setEncodingIfAbsent(this.fLeftContributor);
        this.fLeftContributor.setDocument(this.fLeft, cc.isLeftEditable() && cp.isLeftEditable(input));
        this.fLeftLineCount = this.fLeft.getLineCount();
        this.fRightContributor.setDocument(this.fRight, cc.isRightEditable() && cp.isRightEditable(input));
        this.fRightLineCount = this.fRight.getLineCount();
        this.fAncestorContributor.setDocument(this.fAncestor, false);
        if (this.isPatchHunk()) {
            this.setSyncScrolling(false);
        } else {
            this.setSyncScrolling(this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling"));
        }
        this.update(false);
        if (this.fHasErrors) return;
        if (emptyInput) return;
        if (this.fComposite.isDisposed()) return;
        if (this.isRefreshing()) {
            this.fLeftContributor.updateSelection(this.fLeft, !this.fSynchronizedScrolling);
            this.fRightContributor.updateSelection(this.fRight, !this.fSynchronizedScrolling);
            this.fAncestorContributor.updateSelection(this.fAncestor, !this.fSynchronizedScrolling);
            if (!this.fSynchronizedScrolling) return;
            if (this.fSynchronziedScrollPosition == -1) return;
            this.synchronizedScrollVertical(this.fSynchronziedScrollPosition);
            return;
        }
        if (this.isPatchHunk()) {
            if (right != null) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.compare.patch.IHunk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$2 = clazz2;
                }
                if (Utilities.getAdapter(right, clazz) != null) {
                    this.fLeft.setTopIndex(this.getHunkStart());
                    return;
                }
            }
            this.fRight.setTopIndex(this.getHunkStart());
            return;
        }
        Diff selectDiff = null;
        if (leftRange != null) {
            selectDiff = this.findDiff('L', leftRange);
        } else if (rightRange != null) {
            selectDiff = this.findDiff('R', rightRange);
        }
        if (selectDiff != null) {
            this.setCurrentDiff(selectDiff, true);
            return;
        }
        this.selectFirstDiff(true);
    }

    private boolean isRefreshing() {
        return this.isRefreshing;
    }

    private ContributorInfo createLegInfoFor(Object element, char leg) {
        return new ContributorInfo(this, element, leg);
    }

    private Diff findDiff(char c, Position range) {
        MergeSourceViewer v;
        int start = range.getOffset();
        int end = start + range.getLength();
        if (c == 'L') {
            v = this.fLeft;
        } else if (c == 'R') {
            v = this.fRight;
        } else {
            return null;
        }
        if (this.fChangeDiffs != null) {
            Iterator iter = this.fChangeDiffs.iterator();
            while (iter.hasNext()) {
                Diff diff = (Diff)iter.next();
                if (diff.isDeleted() || diff.fDirection == 0 || !diff.overlaps(v, start, end)) continue;
                return diff;
            }
        }
        return null;
    }

    private void updateDiffBackground(Diff diff) {
        if (!this.fHighlightRanges) {
            return;
        }
        if (diff == null || diff.fIsToken) {
            return;
        }
        if (this.fShowCurrentOnly && !this.isCurrentDiff(diff)) {
            return;
        }
        Color c = this.getColor(null, this.getFillColor(diff));
        if (c == null) {
            return;
        }
        if (this.isThreeWay()) {
            this.fAncestor.setLineBackground(diff.fAncestorPos, c);
        }
        this.fLeft.setLineBackground(diff.fLeftPos, c);
        this.fRight.setLineBackground(diff.fRightPos, c);
    }

    private void updateAllDiffBackgrounds(Display display) {
        if (this.fChangeDiffs != null) {
            boolean threeWay = this.isThreeWay();
            Iterator iter = this.fChangeDiffs.iterator();
            while (iter.hasNext()) {
                Diff diff = (Diff)iter.next();
                Color c = this.getColor(display, this.getFillColor(diff));
                if (threeWay) {
                    this.fAncestor.setLineBackground(diff.fAncestorPos, c);
                }
                this.fLeft.setLineBackground(diff.fLeftPos, c);
                this.fRight.setLineBackground(diff.fRightPos, c);
            }
        }
    }

    boolean isCurrentDiff(Diff diff) {
        if (diff == null) {
            return false;
        }
        if (diff == this.fCurrentDiff) {
            return true;
        }
        return this.fCurrentDiff != null && this.fCurrentDiff.fParent == diff;
    }

    private void documentChanged(DocumentEvent e, boolean dirty) {
        IDocument doc = e.getDocument();
        if (doc == this.fLeft.getDocument()) {
            this.setLeftDirty(dirty);
        } else if (doc == this.fRight.getDocument()) {
            this.setRightDirty(dirty);
        }
        this.updateLines(doc);
    }

    protected int findInsertionPosition(char type, ICompareInput input) {
        ITypedElement other = null;
        char otherType = '\u0000';
        switch (type) {
            case 'A': {
                other = input.getLeft();
                otherType = 'L';
                if (other != null) break;
                other = input.getRight();
                otherType = 'R';
                break;
            }
            case 'L': {
                other = input.getRight();
                otherType = 'R';
                if (other != null) break;
                other = input.getAncestor();
                otherType = 'A';
                break;
            }
            case 'R': {
                other = input.getLeft();
                otherType = 'L';
                if (other != null) break;
                other = input.getAncestor();
                otherType = 'A';
            }
        }
        if (other instanceof IDocumentRange) {
            IDocumentRange dr = (IDocumentRange)((Object)other);
            Position p = dr.getRange();
            Diff diff = this.findDiff(otherType, p.offset);
            if (diff != null) {
                switch (type) {
                    case 'A': {
                        if (diff.fAncestorPos == null) break;
                        return diff.fAncestorPos.offset;
                    }
                    case 'L': {
                        if (diff.fLeftPos == null) break;
                        return diff.fLeftPos.offset;
                    }
                    case 'R': {
                        if (diff.fRightPos == null) break;
                        return diff.fRightPos.offset;
                    }
                }
            }
        }
        return 0;
    }

    private void setError(char type, String message) {
        IMergeViewerContentProvider cp = this.getMergeContentProvider();
        if (cp instanceof MergeViewerContentProvider) {
            MergeViewerContentProvider mcp = (MergeViewerContentProvider)cp;
            switch (type) {
                case 'A': {
                    mcp.setAncestorError(message);
                    break;
                }
                case 'L': {
                    mcp.setLeftError(message);
                    break;
                }
                case 'R': {
                    mcp.setRightError(message);
                }
            }
        }
        this.fHasErrors = true;
    }

    private void updateDirtyState(IEditorInput key, IDocumentProvider documentProvider, char type) {
        boolean dirty = documentProvider.canSaveDocument((Object)key);
        if (type == 'L') {
            this.setLeftDirty(dirty);
        } else if (type == 'R') {
            this.setRightDirty(dirty);
        }
    }

    private Position getNewRange(char type, Object input) {
        switch (type) {
            case 'A': {
                return (Position)this.fNewAncestorRanges.get(input);
            }
            case 'L': {
                return (Position)this.fNewLeftRanges.get(input);
            }
            case 'R': {
                return (Position)this.fNewRightRanges.get(input);
            }
        }
        return null;
    }

    private void addNewRange(char type, Object input, Position range) {
        switch (type) {
            case 'A': {
                this.fNewAncestorRanges.put(input, range);
                break;
            }
            case 'L': {
                this.fNewLeftRanges.put(input, range);
                break;
            }
            case 'R': {
                this.fNewRightRanges.put(input, range);
            }
        }
    }

    protected byte[] getContents(boolean left) {
        String contents;
        IDocument d;
        MergeSourceViewer v;
        MergeSourceViewer mergeSourceViewer = v = left ? this.fLeft : this.fRight;
        if (v != null && (d = v.getDocument()) != null && (contents = d.get()) != null) {
            byte[] bytes;
            try {
                bytes = contents.getBytes(left ? this.fLeftContributor.getEncoding() : this.fRightContributor.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = contents.getBytes();
            }
            return bytes;
        }
        return null;
    }

    private IRegion normalizeDocumentRegion(IDocument doc, IRegion region) {
        if (region == null || doc == null) {
            return region;
        }
        int maxLength = doc.getLength();
        int start = region.getOffset();
        if (start < 0) {
            start = 0;
        } else if (start > maxLength) {
            start = maxLength;
        }
        int length = region.getLength();
        if (length < 0) {
            length = 0;
        } else if (start + length > maxLength) {
            length = maxLength - start;
        }
        return new Region(start, length);
    }

    protected final void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            Rectangle trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
            int scrollbarHeight = trim.height;
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.setVisible(true);
            }
            if (this.fAncestor.isControlOkToUse()) {
                this.fAncestor.getTextWidget().setVisible(true);
            }
            if (this.fAncestorCanvas != null) {
                this.fAncestorCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
                x += this.fMarginWidth;
                width -= this.fMarginWidth;
            }
            this.fAncestor.setBounds(x, y, width, height);
        } else {
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.setVisible(false);
            }
            if (this.fAncestor.isControlOkToUse()) {
                StyledText t = this.fAncestor.getTextWidget();
                t.setVisible(false);
                this.fAncestor.setBounds(0, 0, 0, 0);
                if (this.fFocusPart == this.fAncestor) {
                    this.fFocusPart = this.fLeft;
                    this.fFocusPart.getTextWidget().setFocus();
                }
            }
        }
    }

    protected final void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        if (this.fBirdsEyeCanvas != null) {
            width2 -= 12;
        }
        Rectangle trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        int scrollbarHeight = trim.height + trim.x;
        Composite composite = (Composite)this.getControl();
        int leftTextWidth = width1;
        if (this.fLeftCanvas != null) {
            this.fLeftCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
            x += this.fMarginWidth;
            leftTextWidth -= this.fMarginWidth;
        }
        this.fLeft.setBounds(x, y, leftTextWidth, height);
        x += leftTextWidth;
        if (this.fCenter == null || this.fCenter.isDisposed()) {
            this.fCenter = this.createCenterControl(composite);
        }
        this.fCenter.setBounds(x, y, centerWidth, height - scrollbarHeight);
        x += centerWidth;
        if (!this.fSynchronizedScrolling && this.fRightCanvas != null) {
            this.fRightCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
            this.fRightCanvas.redraw();
            x += this.fMarginWidth;
        }
        int scrollbarWidth = 0;
        if (this.fSynchronizedScrolling && this.fScrollCanvas != null) {
            trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
            scrollbarWidth = trim.width + 2 * trim.x + 1;
        }
        int rightTextWidth = width2 - scrollbarWidth;
        if (this.fRightCanvas != null) {
            rightTextWidth -= this.fMarginWidth;
        }
        this.fRight.setBounds(x, y, rightTextWidth, height);
        x += rightTextWidth;
        if (this.fSynchronizedScrolling) {
            if (this.fRightCanvas != null) {
                this.fRightCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
                x += this.fMarginWidth;
            }
            if (this.fScrollCanvas != null) {
                this.fScrollCanvas.setBounds(x, y, scrollbarWidth, height - scrollbarHeight);
            }
        }
        if (this.fBirdsEyeCanvas != null) {
            int verticalScrollbarButtonHeight = scrollbarWidth;
            int horizontalScrollbarButtonHeight = scrollbarHeight;
            if (this.fIsCarbon) {
                verticalScrollbarButtonHeight += 2;
                horizontalScrollbarButtonHeight = 18;
            }
            if (this.fSummaryHeader != null) {
                this.fSummaryHeader.setBounds(x + scrollbarWidth, y, 12, verticalScrollbarButtonHeight);
            }
            this.fBirdsEyeCanvas.setBounds(x + scrollbarWidth, y += verticalScrollbarButtonHeight, 12, height - (2 * verticalScrollbarButtonHeight + horizontalScrollbarButtonHeight));
        }
        this.updateVScrollBar();
        this.refreshBirdsEyeView();
    }

    private void handleSelectionChanged(MergeSourceViewer tw) {
        Point p = tw.getSelectedRange();
        Diff d = this.findDiff(tw, p.x, p.x + p.y);
        this.updateStatus(d);
        this.setCurrentDiff(d, false);
    }

    private static IRegion toRegion(Position position) {
        if (position != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    private static int maxWork(IRangeComparator a, IRangeComparator l, IRangeComparator r) {
        int ln = l.getRangeCount();
        int rn = r.getRangeCount();
        if (a != null) {
            int an = a.getRangeCount();
            return 2 * Math.max(an, ln) + 2 * Math.max(an, rn);
        }
        return 2 * Math.max(ln, rn);
    }

    /*
     * Unable to fully structure code
     */
    private void doDiff() {
        block35: {
            block34: {
                block33: {
                    newAllDiffs = new ArrayList<Diff>();
                    this.fChangeDiffs = new ArrayList<E>();
                    this.fCurrentDiff = null;
                    aDoc = null;
                    lDoc = this.fLeft.getDocument();
                    rDoc = this.fRight.getDocument();
                    if (lDoc == null || rDoc == null) {
                        return;
                    }
                    aRegion = null;
                    lRegion = this.fLeft.getRegion();
                    rRegion = this.fRight.getRegion();
                    threeWay = this.isThreeWay();
                    if (threeWay && !this.isIgnoreAncestor()) {
                        aDoc = this.fAncestor.getDocument();
                        aRegion = this.fAncestor.getRegion();
                    }
                    this.resetPositions(lDoc);
                    this.resetPositions(rDoc);
                    this.resetPositions(aDoc);
                    this.fAncestor.resetLineBackground();
                    this.fLeft.resetLineBackground();
                    this.fRight.resetLineBackground();
                    ignoreWhiteSpace = Utilities.getBoolean(this.getCompareConfiguration(), "IGNORE_WHITESPACE", false);
                    sright = new DocLineComparator(rDoc, TextMergeViewer.toRegion(rRegion), ignoreWhiteSpace);
                    sleft = new DocLineComparator(lDoc, TextMergeViewer.toRegion(lRegion), ignoreWhiteSpace);
                    sancestor = null;
                    isRight = true;
                    if (aDoc == null) break block33;
                    sancestor = new DocLineComparator(aDoc, TextMergeViewer.toRegion(aRegion), ignoreWhiteSpace);
                    if (!this.isPatchHunk()) break block33;
                    right = ((ICompareInput)this.getInput()).getRight();
                    if (right == null) ** GOTO lbl-1000
                    v0 = TextMergeViewer.class$2;
                    if (v0 == null) {
                        try {
                            v0 = TextMergeViewer.class$2 = Class.forName("org.eclipse.compare.patch.IHunk");
                        }
                        catch (ClassNotFoundException v1) {
                            throw new NoClassDefFoundError(v1.getMessage());
                        }
                    }
                    if (Utilities.getAdapter(right, v0) != null) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = isRight = false;
                    }
                    if (isRight) {
                        sleft = new DocLineComparator(aDoc, TextMergeViewer.toRegion(aRegion), ignoreWhiteSpace);
                    } else {
                        sright = new DocLineComparator(aDoc, TextMergeViewer.toRegion(aRegion), ignoreWhiteSpace);
                    }
                }
                if (!this.fSubDoc && rRegion != null && lRegion != null) {
                    astart = 0;
                    as = 0;
                    if (aRegion != null) {
                        astart = aRegion.getOffset();
                        as = Math.max(0, astart - 1);
                    }
                    ys = Math.max(0, lRegion.getOffset() - 1);
                    ms = Math.max(0, rRegion.getOffset() - 1);
                    if (as > 0 || ys > 0 || ms > 0) {
                        diff = new Diff(null, 0, aDoc, aRegion, 0, astart, lDoc, lRegion, 0, lRegion.getOffset(), rDoc, rRegion, 0, rRegion.getOffset());
                        newAllDiffs.add(diff);
                    }
                }
                bundle = this.getResourceBundle();
                result = new Object[1];
                sa = sancestor;
                sl = sleft;
                sr = sright;
                runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                        String progressTitle = Utilities.getString(bundle, "compareProgressTask.title");
                        monitor.beginTask(progressTitle, TextMergeViewer.maxWork(sa, sl, sr));
                        try {
                            result[0] = RangeDifferencer.findRanges(monitor, sa, sl, sr);
                        }
                        catch (OutOfMemoryError ex) {
                            System.gc();
                            throw new InvocationTargetException(ex);
                        }
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        monitor.done();
                    }
                };
                e = null;
                try {
                    this.getCompareConfiguration().getContainer().run(true, true, runnable);
                    e = (RangeDifference[])result[0];
                }
                catch (InvocationTargetException v3) {
                    title = Utilities.getString(bundle, "tooComplexError.title");
                    format = Utilities.getString(bundle, "tooComplexError.format");
                    msg = MessageFormat.format((String)format, (Object[])new Object[]{Integer.toString(PlatformUI.getWorkbench().getProgressService().getLongOperationTime() / 1000)});
                    MessageDialog.openError((Shell)this.fComposite.getShell(), (String)title, (String)msg);
                    e = null;
                }
                catch (InterruptedException v4) {}
                if (e != null) break block34;
                diff = new Diff(null, 0, aDoc, aRegion, 0, aDoc != null ? aDoc.getLength() : 0, lDoc, lRegion, 0, lDoc.getLength(), rDoc, rRegion, 0, rDoc.getLength());
                newAllDiffs.add(diff);
                break block35;
            }
            i = 0;
            while (i < e.length) {
                a = null;
                s = null;
                d = null;
                es = e[i];
                kind = es.kind();
                ancestorStart = 0;
                ancestorEnd = 0;
                if (sancestor != null) {
                    ancestorStart = sancestor.getTokenStart(es.ancestorStart());
                    ancestorEnd = TextMergeViewer.getTokenEnd2(sancestor, es.ancestorStart(), es.ancestorLength());
                }
                leftStart = sleft.getTokenStart(es.leftStart());
                leftEnd = TextMergeViewer.getTokenEnd2(sleft, es.leftStart(), es.leftLength());
                rightStart = sright.getTokenStart(es.rightStart());
                rightEnd = TextMergeViewer.getTokenEnd2(sright, es.rightStart(), es.rightLength());
                if (this.isPatchHunk()) {
                    if (isRight) {
                        leftStart = leftEnd = this.getHunkStart();
                    } else {
                        rightStart = rightEnd = this.getHunkStart();
                    }
                }
                diff = new Diff(null, kind, aDoc, aRegion, ancestorStart, ancestorEnd, lDoc, lRegion, leftStart, leftEnd, rDoc, rRegion, rightStart, rightEnd);
                newAllDiffs.add(diff);
                if (!ignoreWhiteSpace || this.isPatchHunk()) ** GOTO lbl-1000
                if (sancestor != null) {
                    a = this.extract2(aDoc, sancestor, es.ancestorStart(), es.ancestorLength());
                }
                s = this.extract2(lDoc, sleft, es.leftStart(), es.leftLength());
                d = this.extract2(rDoc, sright, es.rightStart(), es.rightLength());
                if ((a == null || a.trim().length() == 0) && s.trim().length() == 0 && d.trim().length() == 0) {
                    diff.fIsWhitespace = true;
                } else if (this.useChange(kind)) {
                    this.fChangeDiffs.add(diff);
                    this.updateDiffBackground(diff);
                    if (!this.isPatchHunk()) {
                        if (s == null) {
                            s = this.extract2(lDoc, sleft, es.leftStart(), es.leftLength());
                        }
                        if (d == null) {
                            d = this.extract2(rDoc, sright, es.rightStart(), es.rightLength());
                        }
                        if (s.length() > 0 && d.length() > 0) {
                            if (a == null && sancestor != null) {
                                a = this.extract2(aDoc, sancestor, es.ancestorStart(), es.ancestorLength());
                            }
                            this.simpleTokenDiff(diff, aDoc, a, rDoc, d, lDoc, s);
                        }
                    }
                }
                ++i;
            }
        }
        if (!this.fSubDoc && rRegion != null && lRegion != null) {
            aEnd = 0;
            aLen = 0;
            if (aRegion != null && aDoc != null) {
                aEnd = aRegion.getOffset() + aRegion.getLength();
                aLen = aDoc.getLength();
            }
            diff = new Diff(null, 0, aDoc, aRegion, aEnd, aLen, lDoc, lRegion, lRegion.getOffset() + lRegion.getLength(), lDoc.getLength(), rDoc, rRegion, rRegion.getOffset() + rRegion.getLength(), rDoc.getLength());
            newAllDiffs.add(diff);
        }
        this.fAllDiffs = newAllDiffs;
        this.invalidateTextPresentation();
    }

    private void resetPositions(IDocument doc) {
        if (doc == null) {
            return;
        }
        try {
            doc.removePositionCategory(DIFF_RANGE_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        doc.addPositionCategory(DIFF_RANGE_CATEGORY);
    }

    private Diff findDiff(char type, int pos) {
        IDocument aDoc = null;
        IDocument lDoc = this.fLeft.getDocument();
        IDocument rDoc = this.fRight.getDocument();
        if (lDoc == null || rDoc == null) {
            return null;
        }
        Position aRegion = null;
        Position lRegion = null;
        Position rRegion = null;
        boolean threeWay = this.isThreeWay();
        if (threeWay && !this.isIgnoreAncestor()) {
            aDoc = this.fAncestor.getDocument();
        }
        boolean ignoreWhiteSpace = Utilities.getBoolean(this.getCompareConfiguration(), "IGNORE_WHITESPACE", false);
        DocLineComparator sright = new DocLineComparator(rDoc, TextMergeViewer.toRegion(rRegion), ignoreWhiteSpace);
        DocLineComparator sleft = new DocLineComparator(lDoc, TextMergeViewer.toRegion(lRegion), ignoreWhiteSpace);
        DocLineComparator sancestor = null;
        if (aDoc != null) {
            sancestor = new DocLineComparator(aDoc, TextMergeViewer.toRegion(aRegion), ignoreWhiteSpace);
        }
        final ResourceBundle bundle = this.getResourceBundle();
        final Object[] result = new Object[1];
        final DocLineComparator sa = sancestor;
        final DocLineComparator sl = sleft;
        final DocLineComparator sr = sright;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                String progressTitle = Utilities.getString(bundle, "compareProgressTask.title");
                monitor.beginTask(progressTitle, TextMergeViewer.maxWork(sa, sl, sr));
                try {
                    result[0] = RangeDifferencer.findRanges(monitor, sa, sl, sr);
                }
                catch (OutOfMemoryError ex) {
                    System.gc();
                    throw new InvocationTargetException(ex);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                monitor.done();
            }
        };
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        RangeDifference[] e = null;
        try {
            progressService.run(true, true, runnable);
            e = (RangeDifference[])result[0];
        }
        catch (InvocationTargetException invocationTargetException) {
            String title = Utilities.getString(bundle, "tooComplexError.title");
            String format = Utilities.getString(bundle, "tooComplexError.format");
            String msg = MessageFormat.format((String)format, (Object[])new Object[]{Integer.toString(progressService.getLongOperationTime() / 1000)});
            MessageDialog.openError((Shell)this.fComposite.getShell(), (String)title, (String)msg);
            e = null;
        }
        catch (InterruptedException interruptedException) {}
        if (e != null) {
            int i = 0;
            while (i < e.length) {
                int rightEnd;
                int rightStart;
                int leftEnd;
                int leftStart;
                Diff diff;
                RangeDifference es = e[i];
                int kind = es.kind();
                int ancestorStart = 0;
                int ancestorEnd = 0;
                if (sancestor != null) {
                    ancestorStart = sancestor.getTokenStart(es.ancestorStart());
                    ancestorEnd = TextMergeViewer.getTokenEnd2(sancestor, es.ancestorStart(), es.ancestorLength());
                }
                if ((diff = new Diff(null, kind, aDoc, aRegion, ancestorStart, ancestorEnd, lDoc, lRegion, leftStart = sleft.getTokenStart(es.leftStart()), leftEnd = TextMergeViewer.getTokenEnd2(sleft, es.leftStart(), es.leftLength()), rDoc, rRegion, rightStart = sright.getTokenStart(es.rightStart()), rightEnd = TextMergeViewer.getTokenEnd2(sright, es.rightStart(), es.rightLength()))).isInRange(type, pos)) {
                    return diff;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean useChange(int kind) {
        if (kind == 0) {
            return false;
        }
        if (kind == 4) {
            return this.fShowPseudoConflicts;
        }
        return true;
    }

    private int getTokenEnd(ITokenComparator tc, int start, int count) {
        if (count <= 0) {
            return tc.getTokenStart(start);
        }
        int index = start + count - 1;
        return tc.getTokenStart(index) + tc.getTokenLength(index);
    }

    private static int getTokenEnd2(ITokenComparator tc, int start, int length) {
        return tc.getTokenStart(start + length);
    }

    private String extract2(IDocument doc, ITokenComparator tc, int start, int length) {
        int count = tc.getRangeCount();
        if (length > 0 && count > 0) {
            int startPos = tc.getTokenStart(start);
            int endPos = length == 1 ? startPos + tc.getTokenLength(start) : tc.getTokenStart(start + length);
            try {
                return doc.get(startPos, endPos - startPos);
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    private void simpleTokenDiff(Diff baseDiff, IDocument ancestorDoc, String a, IDocument rightDoc, String d, IDocument leftDoc, String s) {
        int ancestorStart = 0;
        ITokenComparator sa = null;
        if (ancestorDoc != null) {
            ancestorStart = baseDiff.fAncestorPos.getOffset();
            sa = this.createTokenComparator(a);
        }
        int rightStart = baseDiff.fRightPos.getOffset();
        ITokenComparator sm = this.createTokenComparator(d);
        int leftStart = baseDiff.fLeftPos.getOffset();
        ITokenComparator sy = this.createTokenComparator(s);
        RangeDifference[] e = RangeDifferencer.findRanges(sa, (IRangeComparator)sy, (IRangeComparator)sm);
        int i = 0;
        while (i < e.length) {
            RangeDifference es = e[i];
            int kind = es.kind();
            if (kind != 0) {
                int ancestorStart2 = ancestorStart;
                int ancestorEnd2 = ancestorStart;
                if (ancestorDoc != null) {
                    ancestorStart2 += sa.getTokenStart(es.ancestorStart());
                    ancestorEnd2 += this.getTokenEnd(sa, es.ancestorStart(), es.ancestorLength());
                }
                int leftStart2 = leftStart + sy.getTokenStart(es.leftStart());
                int leftEnd2 = leftStart + this.getTokenEnd(sy, es.leftStart(), es.leftLength());
                int rightStart2 = rightStart + sm.getTokenStart(es.rightStart());
                int rightEnd2 = rightStart + this.getTokenEnd(sm, es.rightStart(), es.rightLength());
                Diff diff = new Diff(baseDiff, kind, ancestorDoc, null, ancestorStart2, ancestorEnd2, leftDoc, null, leftStart2, leftEnd2, rightDoc, null, rightStart2, rightEnd2);
                int leftS = baseDiff.fLeftPos.offset;
                int leftE = baseDiff.fLeftPos.offset + baseDiff.fLeftPos.length;
                int rightS = baseDiff.fRightPos.offset;
                int rightE = baseDiff.fRightPos.offset + baseDiff.fRightPos.length;
                if (leftS != leftStart2 || leftE != leftEnd2 || rightS != rightStart2 || rightE != rightEnd2) {
                    diff.fIsToken = true;
                    baseDiff.add(diff);
                }
            }
            ++i;
        }
    }

    private void mergingTokenDiff(Diff baseDiff, IDocument ancestorDoc, String a, IDocument rightDoc, String d, IDocument leftDoc, String s) {
        ITokenComparator sa = null;
        int ancestorStart = 0;
        if (ancestorDoc != null) {
            sa = this.createTokenComparator(a);
            ancestorStart = baseDiff.fAncestorPos.getOffset();
        }
        int rightStart = baseDiff.fRightPos.getOffset();
        ITokenComparator sm = this.createTokenComparator(d);
        int leftStart = baseDiff.fLeftPos.getOffset();
        ITokenComparator sy = this.createTokenComparator(s);
        RangeDifference[] r = RangeDifferencer.findRanges(sa, (IRangeComparator)sy, (IRangeComparator)sm);
        int i = 0;
        while (i < r.length) {
            RangeDifference es = r[i];
            int start = i;
            int leftLine = -1;
            int rightLine = -1;
            try {
                leftLine = leftDoc.getLineOfOffset(leftStart + sy.getTokenStart(es.leftStart()));
                rightLine = rightDoc.getLineOfOffset(rightStart + sm.getTokenStart(es.rightStart()));
            }
            catch (BadLocationException badLocationException) {}
            ++i;
            while (i < r.length) {
                es = r[i];
                try {
                    if (leftLine != leftDoc.getLineOfOffset(leftStart + sy.getTokenStart(es.leftStart())) || rightLine != rightDoc.getLineOfOffset(rightStart + sm.getTokenStart(es.rightStart()))) {
                        break;
                    }
                }
                catch (BadLocationException badLocationException) {}
                ++i;
            }
            int end = i;
            RangeDifference first = null;
            int ii = start;
            while (ii < end) {
                es = r[ii];
                if (this.useChange(es.kind())) {
                    first = es;
                    break;
                }
                ++ii;
            }
            RangeDifference last = null;
            int ii2 = end - 1;
            while (ii2 >= start) {
                es = r[ii2];
                if (this.useChange(es.kind())) {
                    last = es;
                    break;
                }
                --ii2;
            }
            if (first != null && last != null) {
                int ancestorStart2 = 0;
                int ancestorEnd2 = 0;
                if (ancestorDoc != null) {
                    ancestorStart2 = ancestorStart + sa.getTokenStart(first.ancestorStart());
                    ancestorEnd2 = ancestorStart + this.getTokenEnd(sa, last.ancestorStart(), last.ancestorLength());
                }
                int leftStart2 = leftStart + sy.getTokenStart(first.leftStart());
                int leftEnd2 = leftStart + this.getTokenEnd(sy, last.leftStart(), last.leftLength());
                int rightStart2 = rightStart + sm.getTokenStart(first.rightStart());
                int rightEnd2 = rightStart + this.getTokenEnd(sm, last.rightStart(), last.rightLength());
                Diff diff = new Diff(baseDiff, first.kind(), ancestorDoc, null, ancestorStart2, ancestorEnd2, leftDoc, null, leftStart2, leftEnd2, rightDoc, null, rightStart2, rightEnd2);
                diff.fIsToken = true;
                baseDiff.add(diff);
            }
            ++i;
        }
    }

    private void updateControls() {
        IAction a;
        IMergeViewerContentProvider cp;
        boolean leftToRight = false;
        boolean rightToLeft = false;
        this.updateStatus(this.fCurrentDiff);
        this.updateResolveStatus();
        if (this.fCurrentDiff != null && (cp = this.getMergeContentProvider()) != null && !this.isPatchHunk()) {
            rightToLeft = cp.isLeftEditable(this.getInput());
            leftToRight = cp.isRightEditable(this.getInput());
        }
        if (this.fDirectionLabel != null) {
            if (this.fHighlightRanges && this.fCurrentDiff != null && this.isThreeWay() && !this.isIgnoreAncestor()) {
                this.fDirectionLabel.setImage(this.fCurrentDiff.getImage());
            } else {
                this.fDirectionLabel.setImage(null);
            }
        }
        if (this.fCopyDiffLeftToRightItem != null) {
            ((Action)this.fCopyDiffLeftToRightItem.getAction()).setEnabled(leftToRight);
        }
        if (this.fCopyDiffRightToLeftItem != null) {
            ((Action)this.fCopyDiffRightToLeftItem.getAction()).setEnabled(rightToLeft);
        }
        boolean enableNavigation = false;
        if (this.fCurrentDiff == null && this.fChangeDiffs != null && this.fChangeDiffs.size() > 0) {
            enableNavigation = true;
        } else if (this.fChangeDiffs != null && this.fChangeDiffs.size() > 1) {
            enableNavigation = true;
        } else if (this.fCurrentDiff != null && this.fCurrentDiff.fDiffs != null) {
            enableNavigation = true;
        } else if (this.fCurrentDiff != null && this.fCurrentDiff.fIsToken) {
            enableNavigation = true;
        }
        if (this.fNextDiff != null) {
            a = this.fNextDiff.getAction();
            a.setEnabled(enableNavigation || this.hasNextElement(true));
        }
        if (this.fPreviousDiff != null) {
            a = this.fPreviousDiff.getAction();
            a.setEnabled(enableNavigation || this.hasNextElement(false));
        }
        if (this.fNextChange != null) {
            a = this.fNextChange.getAction();
            a.setEnabled(enableNavigation);
        }
        if (this.fPreviousChange != null) {
            a = this.fPreviousChange.getAction();
            a.setEnabled(enableNavigation);
        }
    }

    private void updateResolveStatus() {
        RGB rgb = null;
        if (this.showResolveUI()) {
            int incomingOrConflicting = 0;
            int unresolvedIncoming = 0;
            int unresolvedConflicting = 0;
            if (this.fChangeDiffs != null) {
                Iterator e = this.fChangeDiffs.iterator();
                while (e.hasNext()) {
                    Diff d = (Diff)e.next();
                    if (!d.isIncomingOrConflicting()) continue;
                    ++incomingOrConflicting;
                    if (d.fResolved) continue;
                    if (d.fDirection == 1) {
                        ++unresolvedConflicting;
                        break;
                    }
                    ++unresolvedIncoming;
                }
            }
            if (incomingOrConflicting > 0) {
                rgb = unresolvedConflicting > 0 ? this.SELECTED_CONFLICT : (unresolvedIncoming > 0 ? this.SELECTED_INCOMING : this.RESOLVED);
            }
        }
        if (this.fHeaderPainter.setColor(rgb)) {
            this.fSummaryHeader.redraw();
        }
    }

    private void updateStatus(Diff diff) {
        String format;
        String diffDescription;
        if (!this.fShowMoreInfo) {
            return;
        }
        if (diff == null) {
            diffDescription = CompareMessages.TextMergeViewer_diffDescription_noDiff_format;
        } else {
            if (diff.fIsToken) {
                diff = diff.fParent;
            }
            format = CompareMessages.TextMergeViewer_diffDescription_diff_format;
            diffDescription = MessageFormat.format((String)format, (Object[])new String[]{this.getDiffType(diff), this.getDiffNumber(diff), this.getDiffRange(this.fLeft, diff.fLeftPos), this.getDiffRange(this.fRight, diff.fRightPos)});
        }
        format = CompareMessages.TextMergeViewer_statusLine_format;
        String s = MessageFormat.format((String)format, (Object[])new String[]{this.getCursorPosition(this.fLeft), this.getCursorPosition(this.fRight), diffDescription});
        this.getCompareConfiguration().getContainer().setStatusMessage(s);
    }

    private void clearStatus() {
        this.getCompareConfiguration().getContainer().setStatusMessage(null);
    }

    private String getDiffType(Diff diff) {
        String s = "";
        switch (diff.fDirection) {
            case 3: {
                s = CompareMessages.TextMergeViewer_direction_outgoing;
                break;
            }
            case 2: {
                s = CompareMessages.TextMergeViewer_direction_incoming;
                break;
            }
            case 1: {
                s = CompareMessages.TextMergeViewer_direction_conflicting;
            }
        }
        String format = CompareMessages.TextMergeViewer_diffType_format;
        return MessageFormat.format((String)format, (Object[])new String[]{s, diff.changeType()});
    }

    private String getDiffNumber(Diff diff) {
        int diffNumber = 0;
        if (this.fChangeDiffs != null) {
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                Diff d = (Diff)e.next();
                ++diffNumber;
                if (d == diff) break;
            }
        }
        return Integer.toString(diffNumber);
    }

    private String getDiffRange(MergeSourceViewer v, Position pos) {
        Point p = v.getLineRange(pos, new Point(0, 0));
        int endLine = p.x + p.y;
        int startLine = p.x + 1;
        String format = endLine < startLine ? CompareMessages.TextMergeViewer_beforeLine_format : CompareMessages.TextMergeViewer_range_format;
        return MessageFormat.format((String)format, (Object[])new String[]{Integer.toString(startLine), Integer.toString(endLine)});
    }

    private String getCursorPosition(MergeSourceViewer v) {
        if (v != null) {
            StyledText styledText = v.getTextWidget();
            IDocument document = v.getDocument();
            if (document != null) {
                int offset = v.getVisibleRegion().getOffset();
                int caret = offset + styledText.getCaretOffset();
                try {
                    int line = document.getLineOfOffset(caret);
                    int lineOffset = document.getLineOffset(line);
                    int occurrences = 0;
                    int i = lineOffset;
                    while (i < caret) {
                        if ('\t' == document.getChar(i)) {
                            ++occurrences;
                        }
                        ++i;
                    }
                    int tabWidth = styledText.getTabs();
                    int column = caret - lineOffset + (tabWidth - 1) * occurrences;
                    String format = CompareMessages.TextMergeViewer_cursorPosition_format;
                    return MessageFormat.format((String)format, (Object[])new String[]{Integer.toString(line + 1), Integer.toString(column + 1)});
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return "";
    }

    protected void updateHeader() {
        super.updateHeader();
        this.updateControls();
    }

    protected void createToolItems(ToolBarManager tbm) {
        this.fHandlerService = CompareHandlerService.createFor(this.getCompareConfiguration().getContainer(), this.fLeft.getControl().getShell());
        Action ignoreAncestorAction = new Action(){

            public void run() {
                if (!TextMergeViewer.this.isIgnoreAncestor()) {
                    TextMergeViewer.this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, Boolean.FALSE);
                }
                TextMergeViewer.this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_IGNORE_ANCESTOR, !TextMergeViewer.this.isIgnoreAncestor());
                Utilities.initToggleAction((IAction)this, TextMergeViewer.this.getResourceBundle(), "action.IgnoreAncestor.", TextMergeViewer.this.isIgnoreAncestor());
            }
        };
        ignoreAncestorAction.setChecked(this.isIgnoreAncestor());
        Utilities.initAction((IAction)ignoreAncestorAction, this.getResourceBundle(), "action.IgnoreAncestor.");
        Utilities.initToggleAction((IAction)ignoreAncestorAction, this.getResourceBundle(), "action.IgnoreAncestor.", this.isIgnoreAncestor());
        this.fIgnoreAncestorItem = new ActionContributionItem((IAction)ignoreAncestorAction);
        this.fIgnoreAncestorItem.setVisible(false);
        tbm.appendToGroup("modes", (IContributionItem)this.fIgnoreAncestorItem);
        tbm.add((IContributionItem)new Separator());
        Action a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(true, false, false)) {
                    TextMergeViewer.this.endOfDocumentReached(true);
                }
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.NextDiff.");
        this.fNextDiff = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fNextDiff);
        a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(false, false, false)) {
                    TextMergeViewer.this.endOfDocumentReached(false);
                }
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.PrevDiff.");
        this.fPreviousDiff = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fPreviousDiff);
        a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(true, false, true)) {
                    TextMergeViewer.this.endOfDocumentReached(true);
                }
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.NextChange.");
        this.fNextChange = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fNextChange);
        this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.selectNextChange");
        a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(false, false, true)) {
                    TextMergeViewer.this.endOfDocumentReached(false);
                }
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.PrevChange.");
        this.fPreviousChange = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fPreviousChange);
        this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.selectPreviousChange");
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc.isRightEditable()) {
            a = new Action(){

                public void run() {
                    TextMergeViewer.this.copyDiffLeftToRight();
                }
            };
            Utilities.initAction((IAction)a, this.getResourceBundle(), "action.CopyDiffLeftToRight.");
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)a);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            tbm.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.copyLeftToRight");
        }
        if (cc.isLeftEditable()) {
            a = new Action(){

                public void run() {
                    TextMergeViewer.this.copyDiffRightToLeft();
                }
            };
            Utilities.initAction((IAction)a, this.getResourceBundle(), "action.CopyDiffRightToLeft.");
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)a);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            tbm.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.copyRightToLeft");
        }
        this.fIgnoreWhitespace = ChangePropertyAction.createIgnoreWhiteSpaceAction(this.getResourceBundle(), this.getCompareConfiguration());
        this.fIgnoreWhitespace.setActionDefinitionId(ICompareUIConstants.COMMAND_IGNORE_WHITESPACE);
        this.fLeft.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fRight.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fAncestor.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fHandlerService.registerAction((IAction)this.fIgnoreWhitespace, this.fIgnoreWhitespace.getActionDefinitionId());
        this.showWhitespaceAction = new ShowWhitespaceAction(new MergeSourceViewer[]{this.fLeft, this.fRight, this.fAncestor});
        this.fHandlerService.registerAction((IAction)this.showWhitespaceAction, "org.eclipse.ui.edit.text.toggleShowWhitespaceCharacters");
        this.toggleLineNumbersAction = new TextEditorPropertyAction(CompareMessages.TextMergeViewer_16, new MergeSourceViewer[]{this.fLeft, this.fRight, this.fAncestor}, "lineNumberRuler");
        this.fHandlerService.registerAction((IAction)this.toggleLineNumbersAction, "org.eclipse.ui.editors.lineNumberToggle");
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("IGNORE_WHITESPACE") || key.equals("org.eclipse.compare.ShowPseudoConflicts")) {
            this.fShowPseudoConflicts = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowPseudoConflicts");
            this.update(true);
            this.selectFirstDiff(true);
        } else if (key.equals("org.eclipse.compare.UseSingleLine")) {
            this.fUseSingleLine = this.fPreferenceStore.getBoolean("org.eclipse.compare.UseSingleLine");
            this.fBasicCenterCurve = null;
            this.updateResolveStatus();
            this.invalidateLines();
        } else if (key.equals("org.eclipse.compare.HighlightTokenChanges")) {
            this.fHighlightTokenChanges = this.fPreferenceStore.getBoolean("org.eclipse.compare.HighlightTokenChanges");
            this.updateResolveStatus();
            this.updatePresentation(null);
        } else if (key.equals(this.fSymbolicFontName)) {
            this.updateFont();
            this.invalidateLines();
        } else if (key.equals(INCOMING_COLOR) || key.equals(OUTGOING_COLOR) || key.equals(CONFLICTING_COLOR) || key.equals(RESOLVED_COLOR)) {
            this.updateColors(null);
            this.invalidateLines();
            this.invalidateTextPresentation();
        } else if (key.equals("org.eclipse.compare.SynchronizeScrolling")) {
            boolean b = this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling");
            this.setSyncScrolling(b);
        } else if (key.equals("org.eclipse.compare.ShowMoreInfo")) {
            boolean b = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowMoreInfo");
            if (b != this.fShowMoreInfo) {
                this.fShowMoreInfo = b;
                if (this.fShowMoreInfo) {
                    this.updateStatus(this.fCurrentDiff);
                } else {
                    this.clearStatus();
                }
            }
        } else {
            super.handlePropertyChangeEvent(event);
            if (key.equals(ICompareUIConstants.PROP_IGNORE_ANCESTOR)) {
                this.update(false);
                this.selectFirstDiff(true);
            }
        }
    }

    private void selectFirstDiff(boolean first) {
        if (this.fLeft == null || this.fRight == null) {
            return;
        }
        if (this.fLeft.getDocument() == null || this.fRight.getDocument() == null) {
            return;
        }
        Diff firstDiff = null;
        firstDiff = first ? TextMergeViewer.findNext(this.fRight, this.fChangeDiffs, -1, -1, false) : TextMergeViewer.findPrev(this.fRight, this.fChangeDiffs, 9999999, 9999999, false);
        this.setCurrentDiff(firstDiff, true);
    }

    private void setSyncScrolling(boolean newMode) {
        if (this.fSynchronizedScrolling != newMode) {
            this.fSynchronizedScrolling = newMode;
            this.scrollVertical(0, 0, 0, null);
            Control center = this.getCenterControl();
            if (center != null && !center.isDisposed()) {
                center.dispose();
            }
            this.fLeft.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
            this.fRight.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
            this.fComposite.layout(true);
        }
    }

    protected void updateToolItems() {
        if (!this.isPatchHunk()) {
            IAction a;
            if (this.fIgnoreAncestorItem != null) {
                this.fIgnoreAncestorItem.setVisible(this.isThreeWay());
            }
            if (this.fCopyDiffLeftToRightItem != null && (a = this.fCopyDiffLeftToRightItem.getAction()) != null) {
                a.setEnabled(a.isEnabled() && !this.fHasErrors);
            }
            if (this.fCopyDiffRightToLeftItem != null && (a = this.fCopyDiffRightToLeftItem.getAction()) != null) {
                a.setEnabled(a.isEnabled() && !this.fHasErrors);
            }
            super.updateToolItems();
        }
    }

    private void updateLines(IDocument d) {
        int l;
        boolean left = false;
        boolean right = false;
        if (d == this.fLeft.getDocument()) {
            l = this.fLeft.getLineCount();
            left = this.fLeftLineCount != l;
            this.fLeftLineCount = l;
        } else if (d == this.fRight.getDocument()) {
            l = this.fRight.getLineCount();
            right = this.fRightLineCount != l;
            this.fRightLineCount = l;
        }
        if (left || right) {
            Control center;
            if (left) {
                if (this.fLeftCanvas != null) {
                    this.fLeftCanvas.redraw();
                }
            } else if (this.fRightCanvas != null) {
                this.fRightCanvas.redraw();
            }
            if ((center = this.getCenterControl()) != null) {
                center.redraw();
            }
            this.updateVScrollBar();
            this.refreshBirdsEyeView();
        }
    }

    private void invalidateLines() {
        if (this.isThreeWay()) {
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.redraw();
            }
            if (this.fAncestor != null && this.fAncestor.isControlOkToUse()) {
                this.fAncestor.getTextWidget().redraw();
            }
        }
        if (Utilities.okToUse((Widget)this.fLeftCanvas)) {
            this.fLeftCanvas.redraw();
        }
        if (this.fLeft != null && this.fLeft.isControlOkToUse()) {
            this.fLeft.getTextWidget().redraw();
        }
        if (Utilities.okToUse((Widget)this.getCenterControl())) {
            this.getCenterControl().redraw();
        }
        if (this.fRight != null && this.fRight.isControlOkToUse()) {
            this.fRight.getTextWidget().redraw();
        }
        if (Utilities.okToUse((Widget)this.fRightCanvas)) {
            this.fRightCanvas.redraw();
        }
    }

    private boolean showResolveUI() {
        if (!this.fUseResolveUI || !this.isThreeWay() || this.isIgnoreAncestor()) {
            return false;
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        boolean l = cc.isLeftEditable();
        boolean r = cc.isRightEditable();
        return l || r;
    }

    private void paintCenter(Canvas canvas, GC g) {
        Display display = canvas.getDisplay();
        this.checkForColorUpdate(display);
        if (!this.fSynchronizedScrolling) {
            return;
        }
        int lineHeight = this.fLeft.getTextWidget().getLineHeight();
        int visibleHeight = this.fRight.getViewportHeight();
        Point size = canvas.getSize();
        int x = 0;
        int w = size.x;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x + 1, 0, w - 2, size.y);
        if (!this.fIsMotif) {
            g.setBackground(display.getSystemColor(18));
            g.fillRectangle(0, 0, 1, size.y);
            g.fillRectangle(w - 1, 0, 1, size.y);
        }
        if (!this.fHighlightRanges) {
            return;
        }
        boolean showResolveUI = this.showResolveUI();
        if (this.fChangeDiffs != null) {
            int lshift = this.fLeft.getVerticalScrollOffset();
            int rshift = this.fRight.getVerticalScrollOffset();
            Point region = new Point(0, 0);
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                int i;
                Diff diff = (Diff)e.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                this.fLeft.getLineRange(diff.fLeftPos, region);
                int ly = region.x * lineHeight + lshift;
                int lh = region.y * lineHeight;
                this.fRight.getLineRange(diff.fRightPos, region);
                int ry = region.x * lineHeight + rshift;
                int rh = region.y * lineHeight;
                if (Math.max(ly + lh, ry + rh) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                this.fPts[0] = x;
                this.fPts[1] = ly;
                this.fPts[2] = w;
                this.fPts[3] = ry;
                this.fPts[6] = x;
                this.fPts[7] = ly + lh;
                this.fPts[4] = w;
                this.fPts[5] = ry + rh;
                Color fillColor = this.getColor(display, this.getFillColor(diff));
                Color strokeColor = this.getColor(display, this.getStrokeColor(diff));
                if (this.fUseSingleLine) {
                    int w2 = 3;
                    g.setBackground(fillColor);
                    g.fillRectangle(0, ly, w2, lh);
                    g.fillRectangle(w - w2, ry, w2, rh);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    g.drawRectangle(-1, ly, w2, lh);
                    g.drawRectangle(w - w2, ry, w2, rh);
                    if (this.fUseSplines) {
                        int[] points = this.getCenterCurvePoints(w2, ly + lh / 2, w - w2, ry + rh / 2);
                        i = 1;
                        while (i < points.length) {
                            g.drawLine(w2 + i - 1, points[i - 1], w2 + i, points[i]);
                            ++i;
                        }
                    } else {
                        g.drawLine(w2, ly + lh / 2, w - w2, ry + rh / 2);
                    }
                } else if (this.fUseSplines) {
                    g.setBackground(fillColor);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    int[] topPoints = this.getCenterCurvePoints(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    int[] bottomPoints = this.getCenterCurvePoints(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                    g.setForeground(fillColor);
                    g.drawLine(0, bottomPoints[0], 0, topPoints[0]);
                    i = 1;
                    while (i < bottomPoints.length) {
                        g.setForeground(fillColor);
                        g.drawLine(i, bottomPoints[i], i, topPoints[i]);
                        g.setForeground(strokeColor);
                        g.drawLine(i - 1, topPoints[i - 1], i, topPoints[i]);
                        g.drawLine(i - 1, bottomPoints[i - 1], i, bottomPoints[i]);
                        ++i;
                    }
                } else {
                    g.setBackground(fillColor);
                    g.fillPolygon(this.fPts);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    g.drawLine(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    g.drawLine(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                }
                if (!this.fUseSingleLine || !showResolveUI || !diff.isUnresolvedIncomingOrConflicting()) continue;
                int cx = (w - 5) / 2;
                int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
                g.setBackground(fillColor);
                g.fillRectangle(cx, cy, 5, 5);
                g.setForeground(strokeColor);
                g.drawRectangle(cx, cy, 5, 5);
            }
        }
    }

    private int[] getCenterCurvePoints(int startx, int starty, int endx, int endy) {
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }

    private void paintSides(GC g, MergeSourceViewer tp, Canvas canvas, boolean right) {
        Display display = canvas.getDisplay();
        int lineHeight = tp.getTextWidget().getLineHeight();
        int visibleHeight = tp.getViewportHeight();
        Point size = canvas.getSize();
        int x = 0;
        int w = this.fMarginWidth;
        int w2 = w / 2;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x, 0, w, size.y);
        if (!this.fIsMotif) {
            g.setBackground(display.getSystemColor(18));
            if (right) {
                g.fillRectangle(0, 0, 1, size.y);
            } else {
                g.fillRectangle(size.x - 1, 0, 1, size.y);
            }
        }
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.fChangeDiffs != null) {
            int shift = tp.getVerticalScrollOffset() + 1;
            Point region = new Point(0, 0);
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                tp.getLineRange(diff.getPosition(tp), region);
                int y = region.x * lineHeight + shift;
                int h = region.y * lineHeight;
                if (y + h < 0) continue;
                if (y >= visibleHeight) break;
                g.setBackground(this.getColor(display, this.getFillColor(diff)));
                if (right) {
                    g.fillRectangle(x, y, w2, h);
                } else {
                    g.fillRectangle(x + w2, y, w2, h);
                }
                g.setLineWidth(0);
                g.setForeground(this.getColor(display, this.getStrokeColor(diff)));
                if (right) {
                    g.drawRectangle(x - 1, y - 1, w2, h);
                    continue;
                }
                g.drawRectangle(x + w2, y - 1, w2, h);
            }
        }
    }

    private void paint(PaintEvent event, MergeSourceViewer tp) {
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.fChangeDiffs == null) {
            return;
        }
        Control canvas = (Control)event.widget;
        GC g = event.gc;
        Display display = canvas.getDisplay();
        int lineHeight = tp.getTextWidget().getLineHeight();
        int w = canvas.getSize().x;
        int shift = tp.getVerticalScrollOffset() + 1;
        int maxh = event.y + event.height;
        shift += this.fTopInset;
        Point range = new Point(0, 0);
        Iterator e = this.fChangeDiffs.iterator();
        while (e.hasNext()) {
            Diff diff = (Diff)e.next();
            if (diff.isDeleted() || this.fShowCurrentOnly && !this.isCurrentDiff(diff)) continue;
            tp.getLineRange(diff.getPosition(tp), range);
            int y = range.x * lineHeight + shift;
            int h = range.y * lineHeight;
            if (y + h < event.y) continue;
            if (y > maxh) break;
            g.setBackground(this.getColor(display, this.getStrokeColor(diff)));
            g.fillRectangle(0, y - 1, w, 1);
            g.fillRectangle(0, y + h - 1, w, 1);
        }
    }

    private RGB getFillColor(Diff diff) {
        boolean selected = this.fCurrentDiff != null && this.fCurrentDiff.fParent == diff;
        RGB selected_fill = this.getBackground(null);
        if (this.isThreeWay() && !this.isIgnoreAncestor()) {
            switch (diff.fDirection) {
                case 2: {
                    if (this.fLeftIsLocal) {
                        return selected ? selected_fill : this.INCOMING_FILL;
                    }
                    return selected ? selected_fill : this.OUTGOING_FILL;
                }
                case 4: {
                    return selected ? selected_fill : this.CONFLICT_FILL;
                }
                case 3: {
                    if (this.fLeftIsLocal) {
                        return selected ? selected_fill : this.OUTGOING_FILL;
                    }
                    return selected ? selected_fill : this.INCOMING_FILL;
                }
                case 1: {
                    return selected ? selected_fill : this.CONFLICT_FILL;
                }
            }
            return null;
        }
        return selected ? selected_fill : this.OUTGOING_FILL;
    }

    private RGB getStrokeColor(Diff diff) {
        boolean selected;
        boolean bl = selected = this.fCurrentDiff != null && this.fCurrentDiff.fParent == diff;
        if (this.isThreeWay() && !this.isIgnoreAncestor()) {
            switch (diff.fDirection) {
                case 2: {
                    if (this.fLeftIsLocal) {
                        return selected ? this.SELECTED_INCOMING : this.INCOMING;
                    }
                    return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
                }
                case 4: {
                    return selected ? this.SELECTED_CONFLICT : this.CONFLICT;
                }
                case 3: {
                    if (this.fLeftIsLocal) {
                        return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
                    }
                    return selected ? this.SELECTED_INCOMING : this.INCOMING;
                }
                case 1: {
                    return selected ? this.SELECTED_CONFLICT : this.CONFLICT;
                }
            }
            return null;
        }
        return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
    }

    private Color getColor(Display display, RGB rgb) {
        Color c;
        if (rgb == null) {
            return null;
        }
        if (this.fColors == null) {
            this.fColors = new HashMap(20);
        }
        if ((c = (Color)this.fColors.get(rgb)) == null) {
            c = new Color((Device)display, rgb);
            this.fColors.put(rgb, c);
        }
        return c;
    }

    static RGB interpolate(RGB fg, RGB bg, double scale) {
        if (fg != null && bg != null) {
            return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
        }
        if (fg != null) {
            return fg;
        }
        if (bg != null) {
            return bg;
        }
        return new RGB(128, 128, 128);
    }

    private Diff getNextVisibleDiff(boolean down, boolean deep) {
        Diff diff = null;
        MergeSourceViewer part = this.getNavigationPart();
        if (part == null) {
            return null;
        }
        Point s = part.getSelectedRange();
        while (true) {
            diff = null;
            diff = this.internalGetNextDiff(down, deep, part, s);
            if (diff == null || diff.fDirection != 4 || this.isAncestorVisible()) break;
            Position position = diff.getPosition(part);
            s = new Point(position.getOffset(), position.getLength());
            diff = null;
        }
        return diff;
    }

    private Diff internalGetNextDiff(boolean down, boolean deep, MergeSourceViewer part, Point s) {
        if (this.fChangeDiffs != null) {
            if (down) {
                return TextMergeViewer.findNext(part, this.fChangeDiffs, s.x, s.x + s.y, deep);
            }
            return TextMergeViewer.findPrev(part, this.fChangeDiffs, s.x, s.x + s.y, deep);
        }
        return null;
    }

    private MergeSourceViewer getNavigationPart() {
        MergeSourceViewer part = this.fFocusPart;
        if (part == null) {
            part = this.fRight;
        }
        return part;
    }

    private Diff getWrappedDiff(Diff diff, boolean down) {
        if (this.fChangeDiffs != null && this.fChangeDiffs.size() > 0) {
            if (down) {
                return (Diff)this.fChangeDiffs.get(0);
            }
            return (Diff)this.fChangeDiffs.get(this.fChangeDiffs.size() - 1);
        }
        return null;
    }

    private boolean navigate(boolean down, boolean wrap, boolean deep) {
        Diff diff = null;
        boolean wrapped = false;
        do {
            if ((diff = this.getNextVisibleDiff(down, deep)) == null && wrap) {
                if (wrapped) break;
                wrapped = true;
                diff = this.getWrappedDiff(diff, down);
            }
            if (diff == null) continue;
            this.setCurrentDiff(diff, true, deep);
        } while (diff != null && diff.fDirection == 4 && !this.isAncestorVisible());
        return diff == null;
    }

    private void endOfDocumentReached(boolean down) {
        Control c = this.getControl();
        if (Utilities.okToUse((Widget)c)) {
            this.handleEndOfDocumentReached(c.getShell(), down);
        }
    }

    private void handleEndOfDocumentReached(Shell shell, boolean next) {
        boolean hasNextElement = this.hasNextElement(next);
        IPreferenceStore store = CompareUIPlugin.getDefault().getPreferenceStore();
        String value = store.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION);
        if (!value.equals("prompt") && (hasNextElement || store.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION).equals("loop"))) {
            this.performEndOfDocumentAction(shell, store, ICompareUIConstants.PREF_NAVIGATION_END_ACTION, next);
            return;
        }
        shell.getDisplay().beep();
        if (hasNextElement) {
            String nextMessage;
            String loopMessage;
            String message;
            String title;
            if (next) {
                title = CompareMessages.TextMergeViewer_0;
                message = CompareMessages.TextMergeViewer_1;
                loopMessage = CompareMessages.TextMergeViewer_2;
                nextMessage = CompareMessages.TextMergeViewer_3;
            } else {
                title = CompareMessages.TextMergeViewer_4;
                message = CompareMessages.TextMergeViewer_5;
                loopMessage = CompareMessages.TextMergeViewer_6;
                nextMessage = CompareMessages.TextMergeViewer_7;
            }
            String[] localLoopOption = new String[]{loopMessage, "loop"};
            String[] nextElementOption = new String[]{nextMessage, "next"};
            NavigationEndDialog dialog = new NavigationEndDialog(shell, title, null, message, new String[][]{localLoopOption, nextElementOption});
            int result = dialog.open();
            if (result == 0) {
                this.performEndOfDocumentAction(shell, store, ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL, next);
                if (dialog.getToggleState()) {
                    store.putValue(ICompareUIConstants.PREF_NAVIGATION_END_ACTION, store.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL));
                }
            }
        } else {
            String message;
            String title;
            if (next) {
                title = CompareMessages.TextMergeViewer_8;
                message = CompareMessages.TextMergeViewer_9;
            } else {
                title = CompareMessages.TextMergeViewer_10;
                message = CompareMessages.TextMergeViewer_11;
            }
            if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)message)) {
                this.selectFirstDiff(next);
            }
        }
    }

    private void performEndOfDocumentAction(Shell shell, IPreferenceStore store, String key, boolean next) {
        String value = store.getString(key);
        if (value.equals("next")) {
            ICompareNavigator navigator = this.getCompareConfiguration().getContainer().getNavigator();
            if (this.hasNextElement(next)) {
                navigator.selectChange(next);
            } else {
                shell.getDisplay().beep();
            }
        } else {
            this.selectFirstDiff(next);
        }
    }

    private boolean hasNextElement(boolean down) {
        ICompareNavigator navigator = this.getCompareConfiguration().getContainer().getNavigator();
        if (navigator instanceof CompareNavigator) {
            CompareNavigator n = (CompareNavigator)navigator;
            return n.hasChange(down);
        }
        return false;
    }

    private Diff findDiff(MergeSourceViewer tp, int rangeStart, int rangeEnd) {
        if (this.fChangeDiffs != null) {
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                if (!diff.overlaps(tp, rangeStart, rangeEnd)) continue;
                return diff;
            }
        }
        return null;
    }

    private static Diff findNext(MergeSourceViewer tp, List v, int start, int end, boolean deep) {
        int i = 0;
        while (i < v.size()) {
            Diff diff = (Diff)v.get(i);
            Position p = diff.getPosition(tp);
            if (p != null) {
                int startOffset = p.getOffset();
                if (end < startOffset) {
                    return diff;
                }
                if (deep && diff.fDiffs != null) {
                    Diff d = null;
                    int endOffset = startOffset + p.getLength();
                    if (start == startOffset && (end == endOffset || end == endOffset - 1)) {
                        d = TextMergeViewer.findNext(tp, diff.fDiffs, start - 1, start - 1, deep);
                    } else if (end < endOffset) {
                        d = TextMergeViewer.findNext(tp, diff.fDiffs, start, end, deep);
                    }
                    if (d != null) {
                        return d;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private static Diff findPrev(MergeSourceViewer tp, List v, int start, int end, boolean deep) {
        int i = v.size() - 1;
        while (i >= 0) {
            Diff diff = (Diff)v.get(i);
            Position p = diff.getPosition(tp);
            if (p != null) {
                int startOffset = p.getOffset();
                int endOffset = startOffset + p.getLength();
                if (start > endOffset) {
                    if (deep && diff.fDiffs != null) {
                        return TextMergeViewer.findPrev(tp, diff.fDiffs, end, end, deep);
                    }
                    return diff;
                }
                if (deep && diff.fDiffs != null) {
                    Diff d = null;
                    if ((start != startOffset || end != endOffset) && start >= startOffset) {
                        if (TextMergeViewer.isFirstDiff(tp, startOffset, diff.fDiffs)) {
                            return diff;
                        }
                        d = TextMergeViewer.findPrev(tp, diff.fDiffs, start, end, deep);
                    }
                    if (d != null) {
                        return d;
                    }
                }
            }
            --i;
        }
        return null;
    }

    private static boolean isFirstDiff(MergeSourceViewer tp, int startOffset, ArrayList diffs) {
        if (diffs.isEmpty()) {
            return false;
        }
        Diff diff = (Diff)diffs.get(0);
        Position p = diff.getPosition(tp);
        return p.getOffset() >= startOffset;
    }

    private void setCurrentDiff(Diff d, boolean revealAndSelect) {
        this.setCurrentDiff(d, revealAndSelect, false);
    }

    private void setCurrentDiff(Diff d, boolean revealAndSelect, boolean deep) {
        Diff d2;
        if (this.fCenterButton != null && !this.fCenterButton.isDisposed()) {
            this.fCenterButton.setVisible(false);
        }
        Diff oldDiff = this.fCurrentDiff;
        if (d != null && revealAndSelect) {
            if (d.fIsToken || !this.fHighlightTokenChanges || deep || !d.hasChildren()) {
                if (this.isThreeWay() && !this.isIgnoreAncestor()) {
                    this.fAncestor.setSelection(d.fAncestorPos);
                }
                this.fLeft.setSelection(d.fLeftPos);
                this.fRight.setSelection(d.fRightPos);
            } else {
                if (this.isThreeWay() && !this.isIgnoreAncestor()) {
                    this.fAncestor.setSelection(new Position(d.fAncestorPos.offset, 0));
                }
                this.fLeft.setSelection(new Position(d.fLeftPos.offset, 0));
                this.fRight.setSelection(new Position(d.fRightPos.offset, 0));
            }
            this.fCurrentDiff = d;
            this.revealDiff(d, d.fIsToken);
        } else {
            this.fCurrentDiff = d;
        }
        Diff d1 = oldDiff != null ? oldDiff.fParent : null;
        Diff diff = d2 = this.fCurrentDiff != null ? this.fCurrentDiff.fParent : null;
        if (d1 != d2) {
            this.updateDiffBackground(d1);
            this.updateDiffBackground(d2);
        }
        this.updateControls();
        this.invalidateLines();
        this.refreshBirdsEyeView();
    }

    private void revealDiff(Diff d, boolean smart) {
        boolean ancestorIsVisible = false;
        boolean leftIsVisible = false;
        boolean rightIsVisible = false;
        if (smart) {
            int as;
            Point region = new Point(0, 0);
            int ls = this.fLeft.getLineRange((Position)d.fLeftPos, (Point)region).x;
            int rs = this.fRight.getLineRange((Position)d.fRightPos, (Point)region).x;
            if (this.isThreeWay() && !this.isIgnoreAncestor() && (as = this.fAncestor.getLineRange((Position)d.fAncestorPos, (Point)region).x) >= this.fAncestor.getTopIndex() && as <= this.fAncestor.getBottomIndex()) {
                ancestorIsVisible = true;
            }
            if (ls >= this.fLeft.getTopIndex() && ls <= this.fLeft.getBottomIndex()) {
                leftIsVisible = true;
            }
            if (rs >= this.fRight.getTopIndex() && rs <= this.fRight.getBottomIndex()) {
                rightIsVisible = true;
            }
        }
        if (!leftIsVisible || !rightIsVisible) {
            int avpos = 0;
            int lvpos = 0;
            int rvpos = 0;
            MergeSourceViewer allButThis = null;
            if (leftIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition(this.fLeft, this.fLeft.getTopIndex());
                avpos = rvpos;
                allButThis = this.fLeft;
            } else if (rightIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition(this.fRight, this.fRight.getTopIndex());
                avpos = rvpos;
                allButThis = this.fRight;
            } else if (ancestorIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition(this.fAncestor, this.fAncestor.getTopIndex());
                avpos = rvpos;
                allButThis = this.fAncestor;
            } else {
                int delta;
                if (this.fAllDiffs != null) {
                    int vpos = 0;
                    Iterator e = this.fAllDiffs.iterator();
                    int i = 0;
                    while (e.hasNext()) {
                        Diff diff = (Diff)e.next();
                        if (diff == d) break;
                        if (this.fSynchronizedScrolling) {
                            vpos += diff.getMaxDiffHeight();
                        } else {
                            avpos += diff.getAncestorHeight();
                            lvpos += diff.getLeftHeight();
                            rvpos += diff.getRightHeight();
                        }
                        ++i;
                    }
                    if (this.fSynchronizedScrolling) {
                        lvpos = rvpos = vpos;
                        avpos = rvpos;
                    }
                }
                if ((avpos -= (delta = this.fRight.getViewportLines() / 4)) < 0) {
                    avpos = 0;
                }
                if ((lvpos -= delta) < 0) {
                    lvpos = 0;
                }
                if ((rvpos -= delta) < 0) {
                    rvpos = 0;
                }
            }
            this.scrollVertical(avpos, lvpos, rvpos, allButThis);
            if (this.fVScrollBar != null) {
                this.fVScrollBar.setSelection(avpos);
            }
        }
        if (d.fIsToken) {
            TextMergeViewer.reveal(this.fAncestor, d.fAncestorPos);
            TextMergeViewer.reveal(this.fLeft, d.fLeftPos);
            TextMergeViewer.reveal(this.fRight, d.fRightPos);
        } else {
            TextMergeViewer.hscroll(this.fAncestor);
            TextMergeViewer.hscroll(this.fLeft);
            TextMergeViewer.hscroll(this.fRight);
        }
    }

    private static void reveal(MergeSourceViewer v, Position p) {
        Rectangle r;
        StyledText st;
        if (v != null && p != null && (st = v.getTextWidget()) != null && !(r = st.getClientArea()).isEmpty()) {
            v.revealRange(p.offset, p.length);
        }
    }

    private static void hscroll(MergeSourceViewer v) {
        StyledText st;
        if (v != null && (st = v.getTextWidget()) != null) {
            st.setHorizontalIndex(0);
        }
    }

    void copyAllUnresolved(boolean leftToRight) {
        if (this.fChangeDiffs != null && this.isThreeWay() && !this.isIgnoreAncestor()) {
            IRewriteTarget target = leftToRight ? this.fRight.getRewriteTarget() : this.fLeft.getRewriteTarget();
            boolean compoundChangeStarted = false;
            Iterator e = this.fChangeDiffs.iterator();
            try {
                while (e.hasNext()) {
                    Diff diff = (Diff)e.next();
                    switch (diff.fDirection) {
                        case 3: {
                            if (!leftToRight) break;
                            if (!compoundChangeStarted) {
                                target.beginCompoundChange();
                                compoundChangeStarted = true;
                            }
                            this.copy(diff, leftToRight);
                            break;
                        }
                        case 2: {
                            if (leftToRight) break;
                            if (!compoundChangeStarted) {
                                target.beginCompoundChange();
                                compoundChangeStarted = true;
                            }
                            this.copy(diff, leftToRight);
                            break;
                        }
                    }
                }
            }
            finally {
                if (compoundChangeStarted) {
                    target.endCompoundChange();
                }
            }
        }
    }

    protected void copy(boolean leftToRight) {
        if (!this.validateChange(!leftToRight)) {
            return;
        }
        if (this.showResolveUI()) {
            this.copyAllUnresolved(leftToRight);
            this.invalidateLines();
            return;
        }
        if (leftToRight) {
            if (this.fLeft.getEnabled()) {
                String text = this.fLeft.getTextWidget().getText();
                this.fRight.getTextWidget().setText(text);
                this.fRight.setEnabled(true);
            } else {
                this.fRight.getTextWidget().setText("");
                this.fRight.setEnabled(false);
            }
            this.fRightLineCount = this.fRight.getLineCount();
            this.setRightDirty(true);
        } else {
            if (this.fRight.getEnabled()) {
                String text = this.fRight.getTextWidget().getText();
                this.fLeft.getTextWidget().setText(text);
                this.fLeft.setEnabled(true);
            } else {
                this.fLeft.getTextWidget().setText("");
                this.fLeft.setEnabled(false);
            }
            this.fLeftLineCount = this.fLeft.getLineCount();
            this.setLeftDirty(true);
        }
        this.update(false);
        this.selectFirstDiff(true);
    }

    private void copyDiffLeftToRight() {
        this.copy(this.fCurrentDiff, true, false);
    }

    private void copyDiffRightToLeft() {
        this.copy(this.fCurrentDiff, false, false);
    }

    private void copy(Diff diff, boolean leftToRight, boolean gotoNext) {
        if (this.copy(diff, leftToRight)) {
            if (gotoNext) {
                this.navigate(true, true, false);
            } else {
                this.revealDiff(diff, true);
                this.updateControls();
            }
        }
    }

    private boolean copy(Diff diff, boolean leftToRight) {
        if (diff != null && !diff.isResolved()) {
            if (!this.validateChange(!leftToRight)) {
                return false;
            }
            Position fromPos = null;
            Position toPos = null;
            IDocument fromDoc = null;
            IDocument toDoc = null;
            if (leftToRight) {
                this.fRight.setEnabled(true);
                fromPos = diff.fLeftPos;
                toPos = diff.fRightPos;
                fromDoc = this.fLeft.getDocument();
                toDoc = this.fRight.getDocument();
            } else {
                this.fLeft.setEnabled(true);
                fromPos = diff.fRightPos;
                toPos = diff.fLeftPos;
                fromDoc = this.fRight.getDocument();
                toDoc = this.fLeft.getDocument();
            }
            if (fromDoc != null) {
                int fromStart = fromPos.getOffset();
                int fromLen = fromPos.getLength();
                int toStart = toPos.getOffset();
                int toLen = toPos.getLength();
                try {
                    String s = null;
                    switch (diff.fDirection) {
                        case 2: 
                        case 3: {
                            s = fromDoc.get(fromStart, fromLen);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 1: {
                            s = toDoc.get(toStart, toLen);
                            s = String.valueOf(s) + fromDoc.get(fromStart, fromLen);
                        }
                    }
                    if (s != null) {
                        toDoc.replace(toStart, toLen, s);
                        toPos.setOffset(toStart);
                        toPos.setLength(s.length());
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            diff.setResolved(true);
            this.updateResolveStatus();
            return true;
        }
        return false;
    }

    private boolean validateChange(boolean left) {
        ContributorInfo info = left ? this.fLeftContributor : this.fRightContributor;
        return info.validateChange();
    }

    private int getVirtualHeight() {
        int h = 1;
        if (this.fAllDiffs != null) {
            Iterator e = this.fAllDiffs.iterator();
            int i = 0;
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                h += diff.getMaxDiffHeight();
                ++i;
            }
        }
        return h;
    }

    private int getRightHeight() {
        int h = 1;
        if (this.fAllDiffs != null) {
            Iterator e = this.fAllDiffs.iterator();
            int i = 0;
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                h += diff.getRightHeight();
                ++i;
            }
        }
        return h;
    }

    private int getViewportHeight() {
        StyledText te = this.fLeft.getTextWidget();
        int vh = te.getClientArea().height;
        if (vh == 0) {
            Rectangle trim = te.computeTrim(0, 0, 0, 0);
            int scrollbarHeight = trim.height;
            int headerHeight = this.getHeaderHeight();
            Composite composite = (Composite)this.getControl();
            Rectangle r = composite.getClientArea();
            vh = r.height - headerHeight - scrollbarHeight;
        }
        return vh / te.getLineHeight();
    }

    private int realToVirtualPosition(MergeSourceViewer w, int vpos) {
        if (!this.fSynchronizedScrolling || this.fAllDiffs == null) {
            return vpos;
        }
        int viewPos = 0;
        int virtualPos = 0;
        Point region = new Point(0, 0);
        Iterator e = this.fAllDiffs.iterator();
        while (e.hasNext()) {
            Diff diff = (Diff)e.next();
            Position pos = diff.getPosition(w);
            w.getLineRange(pos, region);
            int realHeight = region.y;
            int virtualHeight = diff.getMaxDiffHeight();
            if (vpos <= viewPos + realHeight) {
                vpos -= viewPos;
                vpos = realHeight <= 0 ? 0 : vpos * virtualHeight / realHeight;
                return virtualPos + vpos;
            }
            viewPos += realHeight;
            virtualPos += virtualHeight;
        }
        return virtualPos;
    }

    private void scrollVertical(int avpos, int lvpos, int rvpos, MergeSourceViewer allBut) {
        Control center;
        int y;
        int s = 0;
        if (this.fSynchronizedScrolling) {
            s = this.getVirtualHeight() - rvpos;
            int height = this.fRight.getViewportLines() / 4;
            if (s < 0) {
                s = 0;
            }
            if (s > height) {
                s = height;
            }
        }
        this.fInScrolling = true;
        if (this.isThreeWay() && allBut != this.fAncestor && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition(this.fAncestor, avpos + s) - s;
            this.fAncestor.vscroll(y);
        }
        if (allBut != this.fLeft && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition(this.fLeft, lvpos + s) - s;
            this.fLeft.vscroll(y);
        }
        if (allBut != this.fRight && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition(this.fRight, rvpos + s) - s;
            this.fRight.vscroll(y);
        }
        this.fInScrolling = false;
        if (this.isThreeWay() && this.fAncestorCanvas != null) {
            this.fAncestorCanvas.repaint();
        }
        if (this.fLeftCanvas != null) {
            this.fLeftCanvas.repaint();
        }
        if ((center = this.getCenterControl()) instanceof BufferedCanvas) {
            ((BufferedCanvas)center).repaint();
        }
        if (this.fRightCanvas != null) {
            this.fRightCanvas.repaint();
        }
    }

    private void syncViewport(MergeSourceViewer w) {
        if (this.fInScrolling) {
            return;
        }
        int ix = w.getTopIndex();
        int ix2 = w.getDocumentRegionOffset();
        int viewPosition = this.realToVirtualPosition(w, ix - ix2);
        this.scrollVertical(viewPosition, viewPosition, viewPosition, w);
        if (this.fVScrollBar != null) {
            int value = Math.max(0, Math.min(viewPosition, this.getVirtualHeight() - this.getViewportHeight()));
            this.fVScrollBar.setSelection(value);
        }
    }

    private void updateVScrollBar() {
        if (Utilities.okToUse((Widget)this.fVScrollBar) && this.fSynchronizedScrolling) {
            int virtualHeight = this.getVirtualHeight();
            int viewPortHeight = this.getViewportHeight();
            int pageIncrement = viewPortHeight - 1;
            int thumb = viewPortHeight > virtualHeight ? virtualHeight : viewPortHeight;
            this.fVScrollBar.setPageIncrement(pageIncrement);
            this.fVScrollBar.setMaximum(virtualHeight);
            this.fVScrollBar.setThumb(thumb);
        }
    }

    private int virtualToRealPosition(MergeSourceViewer part, int v) {
        if (!this.fSynchronizedScrolling || this.fAllDiffs == null) {
            return v;
        }
        int virtualPos = 0;
        int viewPos = 0;
        Point region = new Point(0, 0);
        Iterator e = this.fAllDiffs.iterator();
        while (e.hasNext()) {
            Diff diff = (Diff)e.next();
            Position pos = diff.getPosition(part);
            int viewHeight = part.getLineRange((Position)pos, (Point)region).y;
            int virtualHeight = diff.getMaxDiffHeight();
            if (v < virtualPos + virtualHeight) {
                v -= virtualPos;
                v = viewHeight <= 0 ? 0 : (int)((double)v * ((double)viewHeight / (double)virtualHeight));
                return viewPos + v;
            }
            virtualPos += virtualHeight;
            viewPos += viewHeight;
        }
        return viewPos;
    }

    protected void flushContent(Object oldInput, IProgressMonitor monitor) {
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        Object leftContent = content.getLeftContent(oldInput);
        Object rightContent = content.getRightContent(oldInput);
        if (leftContent != null && this.getCompareConfiguration().isLeftEditable() && this.isLeftDirty() && this.fLeftContributor.hasSharedDocument(leftContent) && this.flush(this.fLeftContributor)) {
            this.setLeftDirty(false);
        }
        if (rightContent != null && this.getCompareConfiguration().isRightEditable() && this.isRightDirty() && this.fRightContributor.hasSharedDocument(rightContent) && this.flush(this.fRightContributor)) {
            this.setRightDirty(false);
        }
        if (!(content instanceof MergeViewerContentProvider) || this.isLeftDirty() || this.isRightDirty()) {
            super.flushContent(oldInput, monitor);
        }
    }

    private boolean flush(ContributorInfo info) {
        try {
            return info.flush();
        }
        catch (CoreException e) {
            this.handleException(e);
            return false;
        }
    }

    private void handleException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)throwable;
            this.handleException(ite.getTargetException());
            return;
        }
        CompareUIPlugin.log(throwable);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.compare.internal.IMergeViewerTestAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new IMergeViewerTestAdapter(){

                public IDocument getDocument(char leg) {
                    switch (leg) {
                        case 'L': {
                            return TextMergeViewer.this.fLeft.getDocument();
                        }
                        case 'R': {
                            return TextMergeViewer.this.fRight.getDocument();
                        }
                        case 'A': {
                            return TextMergeViewer.this.fAncestor.getDocument();
                        }
                    }
                    return null;
                }
            };
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("org.eclipse.compare.internal.OutlineViewerCreator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            if (this.fOutlineViewerCreator == null) {
                this.fOutlineViewerCreator = new InternalOutlineViewerCreator();
            }
            return this.fOutlineViewerCreator;
        }
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz3) {
            return this.getFindReplaceTarget();
        }
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("org.eclipse.compare.internal.CompareHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz4) {
            return this.fHandlerService;
        }
        return null;
    }

    protected void handleCompareInputChange() {
        try {
            this.beginRefresh();
            super.handleCompareInputChange();
        }
        finally {
            this.endRefresh();
        }
    }

    private void beginRefresh() {
        this.isRefreshing = true;
        this.fLeftContributor.cacheSelection(this.fLeft);
        this.fRightContributor.cacheSelection(this.fRight);
        this.fAncestorContributor.cacheSelection(this.fAncestor);
        if (this.fSynchronizedScrolling) {
            this.fSynchronziedScrollPosition = this.fVScrollBar.getSelection();
        }
    }

    private void endRefresh() {
        this.isRefreshing = false;
        this.fLeftContributor.cacheSelection(null);
        this.fRightContributor.cacheSelection(null);
        this.fAncestorContributor.cacheSelection(null);
        this.fSynchronziedScrollPosition = -1;
    }

    private void synchronizedScrollVertical(int vpos) {
        this.scrollVertical(vpos, vpos, vpos, null);
        this.workaround65205();
    }

    private boolean isIgnoreAncestor() {
        return Utilities.getBoolean(this.getCompareConfiguration(), ICompareUIConstants.PROP_IGNORE_ANCESTOR, false);
    }

    void update(boolean includeControls) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.fHasErrors) {
            this.resetDiffs();
        } else {
            this.doDiff();
        }
        if (includeControls) {
            this.updateControls();
        }
        this.updateVScrollBar();
        this.updatePresentation(null);
    }

    private void resetDiffs() {
        this.fCurrentDiff = null;
        this.fChangeDiffs = null;
        this.fAllDiffs = null;
        this.resetPositions(this.fLeft.getDocument());
        this.resetPositions(this.fRight.getDocument());
        this.resetPositions(this.fAncestor.getDocument());
    }

    private boolean isPatchHunk() {
        return Utilities.isHunk(this.getInput());
    }

    private int getHunkStart() {
        Object input = this.getInput();
        if (input != null && input instanceof DiffNode) {
            ITypedElement left;
            ITypedElement right = ((DiffNode)input).getRight();
            if (right != null) {
                Object element;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.compare.patch.IHunk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = Utilities.getAdapter(right, clazz)) instanceof IHunk) {
                    return ((IHunk)element).getStartPosition();
                }
            }
            if ((left = ((DiffNode)input).getLeft()) != null) {
                Object element;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.compare.patch.IHunk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((element = Utilities.getAdapter(left, clazz)) instanceof IHunk) {
                    return ((IHunk)element).getStartPosition();
                }
            }
        }
        return 0;
    }

    private IFindReplaceTarget getFindReplaceTarget() {
        if (this.fFindReplaceTarget == null) {
            this.fFindReplaceTarget = new FindReplaceTarget();
        }
        return this.fFindReplaceTarget;
    }

    private class ChangeHighlighter
    implements ITextPresentationListener {
        private final MergeSourceViewer viewer;

        public ChangeHighlighter(MergeSourceViewer viewer) {
            this.viewer = viewer;
        }

        public void applyTextPresentation(TextPresentation textPresentation) {
            if (!TextMergeViewer.this.fHighlightTokenChanges) {
                return;
            }
            IRegion region = textPresentation.getExtent();
            Diff[] changeDiffs = this.getChangeDiffs(region);
            int i = 0;
            while (i < changeDiffs.length) {
                Diff diff = changeDiffs[i];
                StyleRange range = this.getStyleRange(diff, region);
                if (range != null) {
                    textPresentation.mergeStyleRange(range);
                }
                ++i;
            }
        }

        private StyleRange getStyleRange(Diff diff, IRegion region) {
            return diff.getStyleRange(this.viewer, region);
        }

        private Diff[] getChangeDiffs(IRegion region) {
            if (TextMergeViewer.this.fChangeDiffs == null) {
                return new Diff[0];
            }
            ArrayList<Diff> intersectingDiffs = new ArrayList<Diff>();
            Iterator iterator = TextMergeViewer.this.fChangeDiffs.iterator();
            while (iterator.hasNext()) {
                Diff diff = (Diff)iterator.next();
                Diff[] changeDiffs = diff.getChangeDiffs(this.viewer, region);
                int i = 0;
                while (i < changeDiffs.length) {
                    Diff changeDiff = changeDiffs[i];
                    intersectingDiffs.add(changeDiff);
                    ++i;
                }
            }
            return intersectingDiffs.toArray(new Diff[intersectingDiffs.size()]);
        }
    }

    class ChildPositionUpdater
    extends DefaultPositionUpdater {
        protected ChildPositionUpdater(String category) {
            super(category);
        }

        protected boolean notDeleted() {
            return true;
        }

        protected void adaptToInsert() {
            if (this.fPosition == TextMergeViewer.this.fLeft.getRegion() || this.fPosition == TextMergeViewer.this.fRight.getRegion()) {
                int myStart = this.fPosition.offset;
                int myEnd = this.fPosition.offset + this.fPosition.length;
                myEnd = Math.max(myStart, myEnd);
                int yoursStart = this.fOffset;
                int yoursEnd = this.fOffset + this.fReplaceLength - 1;
                yoursEnd = Math.max(yoursStart, yoursEnd);
                if (myEnd < yoursStart) {
                    return;
                }
                if (myStart <= yoursStart) {
                    this.fPosition.length += this.fReplaceLength;
                } else {
                    this.fPosition.offset += this.fReplaceLength;
                }
            } else {
                super.adaptToInsert();
            }
        }
    }

    class ContributorInfo
    implements IElementStateListener,
    VerifyListener,
    IDocumentListener {
        private final TextMergeViewer fViewer;
        private final Object fElement;
        private char fLeg;
        private String fEncoding;
        private IDocumentProvider fDocumentProvider;
        private IEditorInput fDocumentKey;
        private ISelection fSelection;
        private int fTopIndex = -1;
        private boolean fNeedsValidation = false;
        private MergeSourceViewer fSourceViewer;

        public ContributorInfo(TextMergeViewer viewer, Object element, char leg) {
            this.fViewer = viewer;
            this.fElement = element;
            this.fLeg = leg;
            if (this.fElement instanceof IEncodedStreamContentAccessor) {
                try {
                    this.fEncoding = ((IEncodedStreamContentAccessor)this.fElement).getCharset();
                }
                catch (CoreException coreException) {}
            }
        }

        public String getEncoding() {
            if (this.fEncoding == null) {
                return ResourcesPlugin.getEncoding();
            }
            return this.fEncoding;
        }

        public void setEncodingIfAbsent(ContributorInfo otherContributor) {
            if (this.fEncoding == null) {
                this.fEncoding = otherContributor.fEncoding;
            }
        }

        public IDocument getDocument() {
            IDocument document;
            if (this.fDocumentProvider != null && (document = this.fDocumentProvider.getDocument((Object)this.getDocumentKey())) != null) {
                return document;
            }
            if (this.fElement instanceof IDocument) {
                return (IDocument)this.fElement;
            }
            if (this.fElement instanceof IDocumentRange) {
                return ((IDocumentRange)this.fElement).getDocument();
            }
            if (this.fElement instanceof IStreamContentAccessor) {
                return DocumentManager.get(this.fElement);
            }
            return null;
        }

        public void setDocument(MergeSourceViewer viewer, boolean isEditable) {
            Assert.isTrue((this.fSourceViewer == null ? 1 : 0) != 0);
            this.fSourceViewer = viewer;
            try {
                this.internalSetDocument(viewer);
            }
            catch (RuntimeException e) {
                this.clearCachedDocument();
                throw e;
            }
            viewer.setEditable(isEditable);
            if (isEditable) {
                this.fNeedsValidation = true;
                viewer.getTextWidget().addVerifyListener((VerifyListener)this);
            }
        }

        private boolean internalSetDocument(MergeSourceViewer tp) {
            IDocument oldDoc;
            if (tp == null) {
                return false;
            }
            IDocument newDocument = null;
            Position range = null;
            if (this.fElement instanceof IDocumentRange) {
                newDocument = ((IDocumentRange)this.fElement).getDocument();
                range = ((IDocumentRange)this.fElement).getRange();
                this.connectToSharedDocument();
            } else if (this.fElement instanceof IDocument) {
                newDocument = (IDocument)this.fElement;
            } else if (this.fElement instanceof IStreamContentAccessor) {
                newDocument = DocumentManager.get(this.fElement);
                if (newDocument == null) {
                    newDocument = this.createDocument();
                    DocumentManager.put(this.fElement, newDocument);
                    TextMergeViewer.this.setupDocument(newDocument);
                } else if (this.fDocumentProvider == null) {
                    this.connectToSharedDocument();
                }
            } else if (this.fElement == null) {
                ITypedElement parent = this.fViewer.getParent(this.fLeg);
                if (parent instanceof IDocumentRange) {
                    newDocument = ((IDocumentRange)((Object)parent)).getDocument();
                    newDocument.addPositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
                    Object input = this.fViewer.getInput();
                    range = this.fViewer.getNewRange(this.fLeg, input);
                    if (range == null) {
                        int pos = 0;
                        if (input instanceof ICompareInput) {
                            pos = this.fViewer.findInsertionPosition(this.fLeg, (ICompareInput)input);
                        }
                        range = new Position(pos, 0);
                        try {
                            newDocument.addPosition(TextMergeViewer.DIFF_RANGE_CATEGORY, range);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {
                        }
                        catch (BadLocationException badLocationException) {}
                        this.fViewer.addNewRange(this.fLeg, input, range);
                    }
                } else if (parent instanceof IDocument) {
                    newDocument = ((IDocumentRange)this.fElement).getDocument();
                }
            }
            boolean enabled = true;
            if (newDocument == null) {
                newDocument = new Document("");
                enabled = false;
            }
            if (newDocument != (oldDoc = tp.getDocument())) {
                this.updateViewerDocument(tp, newDocument, range);
            } else {
                this.updateViewerDocumentRange(tp, range);
            }
            newDocument.addDocumentListener((IDocumentListener)this);
            tp.setEnabled(enabled);
            return enabled;
        }

        private void updateViewerDocumentRange(MergeSourceViewer tp, Position range) {
            tp.setRegion(range);
            if (this.fViewer.fSubDoc) {
                if (range != null) {
                    IRegion r = this.fViewer.normalizeDocumentRegion(tp.getDocument(), TextMergeViewer.toRegion(range));
                    tp.setVisibleRegion(r.getOffset(), r.getLength());
                } else {
                    tp.resetVisibleRegion();
                }
            } else {
                tp.resetVisibleRegion();
            }
        }

        private void updateViewerDocument(MergeSourceViewer tp, IDocument document, Position range) {
            this.unsetDocument(tp);
            if (document == null) {
                return;
            }
            document.addPositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
            if (this.fViewer.fPositionUpdater == null) {
                TextMergeViewer textMergeViewer = this.fViewer;
                textMergeViewer.getClass();
                this.fViewer.fPositionUpdater = (IPositionUpdater)textMergeViewer.new ChildPositionUpdater(TextMergeViewer.DIFF_RANGE_CATEGORY);
            } else {
                document.removePositionUpdater(this.fViewer.fPositionUpdater);
            }
            document.addPositionUpdater(this.fViewer.fPositionUpdater);
            tp.setRegion(range);
            if (this.fViewer.fSubDoc) {
                if (range != null) {
                    IRegion r = this.fViewer.normalizeDocumentRegion(document, TextMergeViewer.toRegion(range));
                    tp.setDocument(document, r.getOffset(), r.getLength());
                } else {
                    tp.setDocument(document);
                }
            } else {
                tp.setDocument(document);
            }
            tp.rememberDocument(document);
        }

        private void unsetDocument(MergeSourceViewer tp) {
            IDocument oldDoc = this.internalGetDocument(tp);
            if (oldDoc != null) {
                tp.rememberDocument(null);
                try {
                    oldDoc.removePositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                if (TextMergeViewer.this.fPositionUpdater != null) {
                    oldDoc.removePositionUpdater(TextMergeViewer.this.fPositionUpdater);
                }
                oldDoc.removeDocumentListener((IDocumentListener)this);
            }
        }

        private IDocument createDocument() {
            IDocument newDoc = this.connectToSharedDocument();
            if (newDoc == null) {
                IStreamContentAccessor sca = (IStreamContentAccessor)this.fElement;
                String s = null;
                try {
                    String encoding = this.getEncoding();
                    s = Utilities.readString(sca, encoding);
                }
                catch (CoreException ex) {
                    this.fViewer.setError(this.fLeg, ex.getMessage());
                }
                newDoc = new Document(s != null ? s : "");
            }
            return newDoc;
        }

        private IDocument connectToSharedDocument() {
            IEditorInput key = this.getDocumentKey();
            if (key != null) {
                if (this.fDocumentProvider != null) {
                    return this.fDocumentProvider.getDocument((Object)key);
                }
                IDocumentProvider documentProvider = this.getDocumentProvider();
                if (documentProvider != null) {
                    try {
                        this.connect(documentProvider, key);
                        this.setCachedDocumentProvider(key, documentProvider);
                        IDocument newDoc = documentProvider.getDocument((Object)key);
                        this.fViewer.updateDirtyState(key, documentProvider, this.fLeg);
                        return newDoc;
                    }
                    catch (CoreException e) {
                        CompareUIPlugin.log(e);
                    }
                }
            }
            return null;
        }

        private void connect(IDocumentProvider documentProvider, IEditorInput input) throws CoreException {
            ISharedDocumentAdapter sda;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.compare.ISharedDocumentAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((sda = (ISharedDocumentAdapter)Utilities.getAdapter(this.fElement, clazz)) != null) {
                sda.connect(documentProvider, input);
            } else {
                documentProvider.connect((Object)input);
            }
        }

        private void disconnect(IDocumentProvider provider, IEditorInput input) {
            ISharedDocumentAdapter sda;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.compare.ISharedDocumentAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((sda = (ISharedDocumentAdapter)Utilities.getAdapter(this.fElement, clazz)) != null) {
                sda.disconnect(provider, input);
            } else {
                provider.disconnect((Object)input);
            }
        }

        private void setCachedDocumentProvider(IEditorInput key, IDocumentProvider documentProvider) {
            this.fDocumentKey = key;
            this.fDocumentProvider = documentProvider;
            documentProvider.addElementStateListener((IElementStateListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            IDocumentProvider provider = null;
            IEditorInput input = this.getDocumentKey();
            ContributorInfo contributorInfo = this;
            synchronized (contributorInfo) {
                if (this.fDocumentProvider != null) {
                    provider = this.fDocumentProvider;
                    this.fDocumentProvider = null;
                    this.fDocumentKey = null;
                }
            }
            if (provider != null) {
                this.disconnect(provider, input);
                provider.removeElementStateListener((IElementStateListener)this);
            }
            if (this.fSourceViewer != null && !this.fSourceViewer.getTextWidget().isDisposed()) {
                IDocument oldDoc;
                if (this.fNeedsValidation) {
                    this.fSourceViewer.getTextWidget().removeVerifyListener((VerifyListener)this);
                    this.fNeedsValidation = false;
                }
                if ((oldDoc = this.internalGetDocument(this.fSourceViewer)) != null) {
                    oldDoc.removeDocumentListener((IDocumentListener)this);
                }
            }
            this.clearCachedDocument();
        }

        private void clearCachedDocument() {
            IDocument doc = DocumentManager.get(this.fElement);
            if (doc != null) {
                DocumentManager.remove(doc);
            }
        }

        private IDocument internalGetDocument(MergeSourceViewer tp) {
            IDocument oldDoc = tp.getDocument();
            if (oldDoc == null) {
                oldDoc = tp.getRememberedDocument();
            }
            return oldDoc;
        }

        private IEditorInput getDocumentKey() {
            if (this.fDocumentKey != null) {
                return this.fDocumentKey;
            }
            if (this.isUsingDefaultContentProvider() && this.fElement != null && this.canHaveSharedDocument()) {
                ISharedDocumentAdapter sda;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.compare.ISharedDocumentAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((sda = (ISharedDocumentAdapter)Utilities.getAdapter(this.fElement, clazz, true)) != null) {
                    return sda.getDocumentKey(this.fElement);
                }
            }
            return null;
        }

        private IDocumentProvider getDocumentProvider() {
            IEditorInput input;
            if (this.fDocumentProvider != null) {
                return this.fDocumentProvider;
            }
            if (this.isUsingDefaultContentProvider() && (input = this.getDocumentKey()) != null) {
                return SharedDocumentAdapter.getDocumentProvider(input);
            }
            return null;
        }

        private boolean isUsingDefaultContentProvider() {
            return this.fViewer.isUsingDefaultContentProvider();
        }

        private boolean canHaveSharedDocument() {
            return this.fViewer.canHaveSharedDocument();
        }

        boolean hasSharedDocument(Object object) {
            return this.fElement == object && this.fDocumentProvider != null && this.fDocumentProvider.getDocument((Object)this.getDocumentKey()) != null;
        }

        public boolean flush() throws CoreException {
            IEditorInput input;
            IDocument document;
            if (this.fDocumentProvider != null && (document = this.fDocumentProvider.getDocument((Object)(input = this.getDocumentKey()))) != null) {
                ISharedDocumentAdapter sda;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.compare.ISharedDocumentAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((sda = (ISharedDocumentAdapter)Utilities.getAdapter(this.fElement, clazz)) != null) {
                    sda.flushDocument(this.fDocumentProvider, input, document, false);
                    return true;
                }
                try {
                    this.fDocumentProvider.aboutToChange((Object)input);
                    this.fDocumentProvider.saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)input, document, false);
                    return true;
                }
                finally {
                    this.fDocumentProvider.changed((Object)input);
                }
            }
            return false;
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(originalElement)) {
                this.resetDocument();
            }
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (!this.checkState()) {
                return;
            }
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(element)) {
                this.fViewer.updateDirtyState(input, this.getDocumentProvider(), this.fLeg);
            }
        }

        public void elementDeleted(Object element) {
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(element)) {
                this.resetDocument();
            }
        }

        private void resetDocument() {
            this.clearCachedDocument();
            if (this.checkState()) {
                this.fViewer.refresh();
            }
        }

        private boolean checkState() {
            if (this.fViewer == null) {
                return false;
            }
            Control control = this.fViewer.getControl();
            if (control == null) {
                return false;
            }
            return !control.isDisposed();
        }

        public void elementContentReplaced(Object element) {
            if (!this.checkState()) {
                return;
            }
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(element)) {
                this.fViewer.updateDirtyState(input, this.getDocumentProvider(), this.fLeg);
            }
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public Object getElement() {
            return this.fElement;
        }

        public void cacheSelection(MergeSourceViewer viewer) {
            if (viewer == null) {
                this.fSelection = null;
                this.fTopIndex = -1;
            } else {
                this.fSelection = viewer.getSelection();
                this.fTopIndex = viewer.getTopIndex();
            }
        }

        public void updateSelection(MergeSourceViewer viewer, boolean includeScroll) {
            if (this.fSelection != null) {
                viewer.setSelection(this.fSelection);
            }
            if (includeScroll && this.fTopIndex != -1) {
                viewer.setTopIndex(this.fTopIndex);
            }
        }

        public void transferContributorStateFrom(ContributorInfo oldContributor) {
            if (oldContributor != null) {
                this.fSelection = oldContributor.fSelection;
                this.fTopIndex = oldContributor.fTopIndex;
            }
        }

        public boolean validateChange() {
            IStatus status;
            IEditableContentExtension ext;
            if (this.fElement == null) {
                return true;
            }
            if (this.fDocumentProvider instanceof IDocumentProviderExtension) {
                IDocumentProviderExtension ext2 = (IDocumentProviderExtension)this.fDocumentProvider;
                if (ext2.isReadOnly((Object)this.fDocumentKey)) {
                    try {
                        ext2.validateState((Object)this.fDocumentKey, (Object)TextMergeViewer.this.getControl().getShell());
                        ext2.updateStateCache((Object)this.fDocumentKey);
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)TextMergeViewer.this.getControl().getShell(), (String)CompareMessages.TextMergeViewer_12, (String)CompareMessages.TextMergeViewer_13, (IStatus)e.getStatus());
                        return false;
                    }
                }
                return !ext2.isReadOnly((Object)this.fDocumentKey);
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.compare.IEditableContentExtension");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((ext = (IEditableContentExtension)Utilities.getAdapter(this.fElement, clazz)) != null && ext.isReadOnly() && !(status = ext.validateEdit(TextMergeViewer.this.getControl().getShell())).isOK()) {
                if (status.getSeverity() == 4) {
                    ErrorDialog.openError((Shell)TextMergeViewer.this.getControl().getShell(), (String)CompareMessages.TextMergeViewer_14, (String)CompareMessages.TextMergeViewer_15, (IStatus)status);
                    return false;
                }
                if (status.getSeverity() == 8) {
                    return false;
                }
            }
            return true;
        }

        public void verifyText(VerifyEvent e) {
            if (!this.validateChange()) {
                e.doit = false;
            }
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            boolean dirty = true;
            if (this.fDocumentProvider != null && this.fDocumentKey != null) {
                dirty = this.fDocumentProvider.canSaveDocument((Object)this.fDocumentKey);
            }
            TextMergeViewer.this.documentChanged(e, dirty);
            if (this.fNeedsValidation && this.fSourceViewer != null && !this.fSourceViewer.getTextWidget().isDisposed()) {
                this.fSourceViewer.getTextWidget().removeVerifyListener((VerifyListener)this);
                this.fNeedsValidation = false;
            }
        }
    }

    class Diff {
        Position fAncestorPos;
        Position fLeftPos;
        Position fRightPos;
        Diff fParent;
        boolean fResolved;
        int fDirection;
        boolean fIsToken = false;
        ArrayList fDiffs;
        boolean fIsWhitespace = false;

        Diff(Diff parent, int dir, IDocument ancestorDoc, Position aRange, int ancestorStart, int ancestorEnd, IDocument leftDoc, Position lRange, int leftStart, int leftEnd, IDocument rightDoc, Position rRange, int rightStart, int rightEnd) {
            this.fParent = parent != null ? parent : this;
            this.fDirection = dir;
            this.fLeftPos = this.createPosition(leftDoc, lRange, leftStart, leftEnd);
            this.fRightPos = this.createPosition(rightDoc, rRange, rightStart, rightEnd);
            if (ancestorDoc != null) {
                this.fAncestorPos = this.createPosition(ancestorDoc, aRange, ancestorStart, ancestorEnd);
            }
        }

        Position getPosition(char type) {
            switch (type) {
                case 'A': {
                    return this.fAncestorPos;
                }
                case 'L': {
                    return this.fLeftPos;
                }
                case 'R': {
                    return this.fRightPos;
                }
            }
            return null;
        }

        boolean isInRange(char type, int pos) {
            Position p = this.getPosition(type);
            return pos >= p.offset && pos < p.offset + p.length;
        }

        String changeType() {
            boolean rightEmpty;
            boolean leftEmpty = this.fLeftPos.length == 0;
            boolean bl = rightEmpty = this.fRightPos.length == 0;
            if (this.fDirection == 3) {
                if (!leftEmpty && rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_addition;
                }
                if (leftEmpty && !rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_deletion;
                }
            } else {
                if (leftEmpty && !rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_addition;
                }
                if (!leftEmpty && rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_deletion;
                }
            }
            return CompareMessages.TextMergeViewer_changeType_change;
        }

        Image getImage() {
            int code = 3;
            switch (this.fDirection) {
                case 2: {
                    code += 4;
                    break;
                }
                case 3: {
                    code += 8;
                    break;
                }
                case 1: 
                case 4: {
                    code += 12;
                }
            }
            if (code != 0) {
                return TextMergeViewer.this.getCompareConfiguration().getImage(code);
            }
            return null;
        }

        Position createPosition(IDocument doc, Position range, int start, int end) {
            try {
                int dl;
                int l = end - start;
                if (range != null) {
                    dl = range.length;
                    if (l > dl) {
                        l = dl;
                    }
                } else {
                    dl = doc.getLength();
                    if (start + l > dl) {
                        l = dl - start;
                    }
                }
                Position p = null;
                try {
                    p = new Position(start, l);
                }
                catch (RuntimeException runtimeException) {
                    p = new Position(0, 0);
                }
                try {
                    doc.addPosition(TextMergeViewer.DIFF_RANGE_CATEGORY, p);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                return p;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        void add(Diff d) {
            if (this.fDiffs == null) {
                this.fDiffs = new ArrayList();
            }
            this.fDiffs.add(d);
        }

        boolean isDeleted() {
            if (this.fAncestorPos != null && this.fAncestorPos.isDeleted()) {
                return true;
            }
            return this.fLeftPos.isDeleted() || this.fRightPos.isDeleted();
        }

        void setResolved(boolean r) {
            this.fResolved = r;
            if (r) {
                this.fDiffs = null;
            }
        }

        boolean isResolved() {
            if (!this.fResolved && this.fDiffs != null) {
                Iterator e = this.fDiffs.iterator();
                while (e.hasNext()) {
                    Diff d = (Diff)e.next();
                    if (d.isResolved()) continue;
                    return false;
                }
                return true;
            }
            return this.fResolved;
        }

        private boolean isIncomingOrConflicting() {
            switch (this.fDirection) {
                case 2: {
                    if (!TextMergeViewer.this.fLeftIsLocal) break;
                    return true;
                }
                case 3: {
                    if (TextMergeViewer.this.fLeftIsLocal) break;
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        private boolean isUnresolvedIncomingOrConflicting() {
            if (this.fResolved) {
                return false;
            }
            return this.isIncomingOrConflicting();
        }

        Position getPosition(MergeSourceViewer w) {
            if (w == TextMergeViewer.this.fLeft) {
                return this.fLeftPos;
            }
            if (w == TextMergeViewer.this.fRight) {
                return this.fRightPos;
            }
            if (w == TextMergeViewer.this.fAncestor) {
                return this.fAncestorPos;
            }
            return null;
        }

        boolean overlaps(MergeSourceViewer w, int start, int end) {
            int ds;
            int de;
            Position h = this.getPosition(w);
            return h != null && start < (de = (ds = h.getOffset()) + h.getLength()) && end >= ds;
        }

        int getMaxDiffHeight() {
            Point region = new Point(0, 0);
            int h = ((TextMergeViewer)TextMergeViewer.this).fLeft.getLineRange((Position)this.fLeftPos, (Point)region).y;
            if (TextMergeViewer.this.isThreeWay()) {
                h = Math.max(h, ((TextMergeViewer)TextMergeViewer.this).fAncestor.getLineRange((Position)this.fAncestorPos, (Point)region).y);
            }
            return Math.max(h, ((TextMergeViewer)TextMergeViewer.this).fRight.getLineRange((Position)this.fRightPos, (Point)region).y);
        }

        int getAncestorHeight() {
            Point region = new Point(0, 0);
            return ((TextMergeViewer)TextMergeViewer.this).fAncestor.getLineRange((Position)this.fAncestorPos, (Point)region).y;
        }

        int getLeftHeight() {
            Point region = new Point(0, 0);
            return ((TextMergeViewer)TextMergeViewer.this).fLeft.getLineRange((Position)this.fLeftPos, (Point)region).y;
        }

        int getRightHeight() {
            Point region = new Point(0, 0);
            return ((TextMergeViewer)TextMergeViewer.this).fRight.getLineRange((Position)this.fRightPos, (Point)region).y;
        }

        public Diff[] getChangeDiffs(MergeSourceViewer viewer, IRegion region) {
            if (this.fDiffs != null && this.intersectsRegion(viewer, region)) {
                ArrayList<Diff> result = new ArrayList<Diff>();
                Iterator iterator = this.fDiffs.iterator();
                while (iterator.hasNext()) {
                    Diff diff = (Diff)iterator.next();
                    if (!diff.intersectsRegion(viewer, region)) continue;
                    result.add(diff);
                }
                return result.toArray(new Diff[result.size()]);
            }
            return new Diff[0];
        }

        private boolean intersectsRegion(MergeSourceViewer viewer, IRegion region) {
            Position p = this.getPosition(viewer);
            if (p != null) {
                return p.overlapsWith(region.getOffset(), region.getLength());
            }
            return false;
        }

        public StyleRange getStyleRange(MergeSourceViewer viewer, IRegion region) {
            int regionEnd;
            Color cTextFill = TextMergeViewer.this.getColor(null, this.getTextFillColor());
            if (cTextFill == null) {
                return null;
            }
            Position p = this.getPosition(viewer);
            int start = p.getOffset();
            int length = p.getLength();
            if (start < region.getOffset()) {
                length -= region.getOffset() - start;
                start = region.getOffset();
            }
            if (start + length > (regionEnd = region.getOffset() + region.getLength())) {
                length = regionEnd - start;
            }
            if (length < 0) {
                return null;
            }
            return new StyleRange(start, length, null, cTextFill);
        }

        private RGB getTextFillColor() {
            if (TextMergeViewer.this.isThreeWay() && !TextMergeViewer.this.isIgnoreAncestor()) {
                switch (this.fDirection) {
                    case 2: {
                        if (TextMergeViewer.this.fLeftIsLocal) {
                            return TextMergeViewer.this.INCOMING_TEXT_FILL;
                        }
                        return TextMergeViewer.this.OUTGOING_TEXT_FILL;
                    }
                    case 4: {
                        return TextMergeViewer.this.CONFLICT_TEXT_FILL;
                    }
                    case 3: {
                        if (TextMergeViewer.this.fLeftIsLocal) {
                            return TextMergeViewer.this.OUTGOING_TEXT_FILL;
                        }
                        return TextMergeViewer.this.INCOMING_TEXT_FILL;
                    }
                    case 1: {
                        return TextMergeViewer.this.CONFLICT_TEXT_FILL;
                    }
                }
                return null;
            }
            return TextMergeViewer.this.OUTGOING_TEXT_FILL;
        }

        public boolean hasChildren() {
            return this.fDiffs != null && !this.fDiffs.isEmpty();
        }
    }

    private class FindReplaceTarget
    implements IFindReplaceTarget {
        private FindReplaceTarget() {
        }

        public boolean canPerformFind() {
            return TextMergeViewer.this.fFocusPart != null;
        }

        public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
        }

        public Point getSelection() {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().getSelection();
        }

        public String getSelectionText() {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().getSelectionText();
        }

        public boolean isEditable() {
            return TextMergeViewer.this.fFocusPart.getFindReplaceTarget().isEditable();
        }

        public void replaceSelection(String text) {
            TextMergeViewer.this.fFocusPart.getFindReplaceTarget().replaceSelection(text);
        }
    }

    class HeaderPainter
    implements PaintListener {
        private static final int INSET = 2;
        private RGB fIndicatorColor;
        private Color fSeparatorColor;

        public HeaderPainter() {
            this.fSeparatorColor = TextMergeViewer.this.fSummaryHeader.getDisplay().getSystemColor(18);
        }

        public boolean setColor(RGB color) {
            RGB oldColor = this.fIndicatorColor;
            this.fIndicatorColor = color;
            if (color == null) {
                return oldColor != null;
            }
            if (oldColor != null) {
                return !color.equals((Object)oldColor);
            }
            return true;
        }

        private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topLeft, Color bottomRight) {
            gc.setForeground(topLeft);
            gc.drawLine(x, y, x + w - 1, y);
            gc.drawLine(x, y, x, y + h - 1);
            gc.setForeground(bottomRight);
            gc.drawLine(x + w, y, x + w, y + h);
            gc.drawLine(x, y + h, x + w, y + h);
        }

        public void paintControl(PaintEvent e) {
            Point s = TextMergeViewer.this.fSummaryHeader.getSize();
            if (this.fIndicatorColor != null) {
                Display d = TextMergeViewer.this.fSummaryHeader.getDisplay();
                e.gc.setBackground(TextMergeViewer.this.getColor(d, this.fIndicatorColor));
                int min = Math.min(s.x, s.y) - 4;
                Rectangle r = new Rectangle((s.x - min) / 2, (s.y - min) / 2, min, min);
                e.gc.fillRectangle(r);
                if (d != null) {
                    this.drawBevelRect(e.gc, r.x, r.y, r.width - 1, r.height - 1, d.getSystemColor(18), d.getSystemColor(20));
                }
                e.gc.setForeground(this.fSeparatorColor);
                e.gc.setLineWidth(0);
                e.gc.drawLine(1, s.y - 1, s.x - 1 - 1, s.y - 1);
            }
        }
    }

    class HoverResizer
    extends ContentMergeViewer.Resizer {
        Canvas fCanvas;

        public HoverResizer(Canvas c, int dir) {
            super(TextMergeViewer.this, (Control)c, dir);
            this.fCanvas = c;
        }

        public void mouseMove(MouseEvent e) {
            if (!this.fIsDown && TextMergeViewer.this.fUseSingleLine && TextMergeViewer.this.showResolveUI() && TextMergeViewer.this.handleMouseMoveOverCenter(this.fCanvas, e.x, e.y)) {
                return;
            }
            super.mouseMove(e);
        }
    }

    private final class InternalOutlineViewerCreator
    extends OutlineViewerCreator
    implements ISelectionChangedListener {
        private InternalOutlineViewerCreator() {
        }

        public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent, CompareConfiguration configuration) {
            if (input != this.getInput()) {
                return null;
            }
            Viewer v = CompareUI.findStructureViewer(oldViewer, input, parent, configuration);
            if (v != null) {
                v.getControl().addDisposeListener(new DisposeListener(this, v){
                    final /* synthetic */ InternalOutlineViewerCreator this$1;
                    private final /* synthetic */ Viewer val$v;
                    {
                        this.this$1 = internalOutlineViewerCreator;
                        this.val$v = viewer;
                    }

                    public void widgetDisposed(DisposeEvent e) {
                        this.val$v.removeSelectionChangedListener((ISelectionChangedListener)this.this$1);
                    }
                });
                v.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            return v;
        }

        public boolean hasViewerFor(Object input) {
            return true;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection ss;
            Object element;
            Diff diff;
            ISelection s = event.getSelection();
            if (s instanceof IStructuredSelection && (diff = this.findDiff(element = (ss = (IStructuredSelection)s).getFirstElement())) != null) {
                TextMergeViewer.this.setCurrentDiff(diff, true);
            }
        }

        private Diff findDiff(Object element) {
            if (element instanceof ICompareInput) {
                ICompareInput ci = (ICompareInput)element;
                Position p = this.getPosition(ci.getLeft());
                if (p != null) {
                    return this.findDiff(p, true);
                }
                p = this.getPosition(ci.getRight());
                if (p != null) {
                    return this.findDiff(p, false);
                }
            }
            return null;
        }

        private Diff findDiff(Position p, boolean left) {
            Iterator iterator = TextMergeViewer.this.fAllDiffs.iterator();
            while (iterator.hasNext()) {
                Diff diff = (Diff)iterator.next();
                Position diffPos = left ? diff.fLeftPos : diff.fRightPos;
                if (diffPos.offset + diffPos.length >= p.offset && diff.fDirection != 0) {
                    return diff;
                }
                if (diffPos.offset < p.offset) continue;
                return diff;
            }
            return null;
        }

        private Position getPosition(ITypedElement left) {
            if (left instanceof DocumentRangeNode) {
                DocumentRangeNode drn = (DocumentRangeNode)((Object)left);
                return drn.getRange();
            }
            return null;
        }

        public Object getInput() {
            return TextMergeViewer.this.getInput();
        }
    }
}

