/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.text;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.text.Messages;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class WorkItemTextUtilities {
    private static DateFormat fgShortTimeFormat = new SimpleDateFormat("hh:mm:ss");

    public static String getWorkItemId(IWorkItem workitem) {
        return WorkItemTextUtilities.formatWorkItemId(workitem);
    }

    public static String getAttachmentId(IAttachment attachment) {
        return WorkItemTextUtilities.formatAttachmentId(attachment);
    }

    public static String getWorkItemText(IWorkItem workitem) {
        String summary = workitem.getHTMLSummary().getPlainText();
        if (summary != null && summary.length() > 0) {
            return NLS.bind((String)Messages.getString("WorkItemTextUtilities.ID_SUMMARY"), (Object[])new Object[]{WorkItemTextUtilities.formatWorkItemId(workitem), summary});
        }
        return NLS.bind((String)Messages.getString("WorkItemTextUtilities.ID_UNTITLED"), (Object[])new Object[]{WorkItemTextUtilities.formatWorkItemId(workitem)});
    }

    public static String getWorkItemText(IWorkItem workitem, int maxLength) {
        String text = WorkItemTextUtilities.getWorkItemText(workitem);
        return Utils.shorten(text, maxLength);
    }

    public static String getAttachmentText(IAttachment attachment) {
        return NLS.bind((String)Messages.getString("WorkItemTextUtilities.ID_SUMMARY"), (Object[])new Object[]{attachment.getId(), attachment.getName()});
    }

    public static String getAttachmentText(IAttachment attachment, int maxLength) {
        String text = WorkItemTextUtilities.getAttachmentText(attachment);
        return Utils.shorten(text, maxLength);
    }

    private static String formatWorkItemId(IWorkItem workitem) {
        long id = workitem.getId();
        if (id == -1L) {
            Date creationDate;
            Timestamp timestamp = creationDate = workitem.isPropertySet(IWorkItem.CREATION_DATE_PROPERTY) ? workitem.getCreationDate() : null;
            if (creationDate == null) {
                creationDate = workitem.modified();
            }
            if (creationDate == null) {
                return NLS.bind((String)Messages.getString("WorkItemTextUtilities.NEW_ID"));
            }
            return NLS.bind((String)Messages.getString("WorkItemTextUtilities.DATE_ID"), (Object[])new Object[]{WorkItemTextUtilities.format(creationDate, null)});
        }
        return Long.toString(id);
    }

    private static String formatAttachmentId(IAttachment attachment) {
        long id = attachment.getId();
        if (id == -1L) {
            Date creationDate;
            Timestamp timestamp = creationDate = attachment.isPropertySet(IAttachment.CREATION_DATE_PROPERTY) ? attachment.getCreationDate() : null;
            if (creationDate == null) {
                creationDate = attachment.modified();
            }
            if (creationDate == null) {
                return NLS.bind((String)Messages.getString("WorkItemTextUtilities.NEW_ID"));
            }
            return NLS.bind((String)Messages.getString("WorkItemTextUtilities.DATE_ID"), (Object[])new Object[]{WorkItemTextUtilities.format(creationDate, null)});
        }
        return Long.toString(id);
    }

    public static String formatWorkItemId(IWorkItem workitem, TimeZone userTimeZone) {
        if (workitem.isNewItem()) {
            Date creationDate = workitem.modified();
            if (creationDate == null) {
                return NLS.bind((String)Messages.getString("WorkItemTextUtilities.NEW_ID"));
            }
            return NLS.bind((String)Messages.getString("WorkItemTextUtilities.DATE_ID"), (Object[])new Object[]{WorkItemTextUtilities.format(creationDate, userTimeZone)});
        }
        return Long.toString(workitem.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(Date creationDate, TimeZone userTimeZone) {
        DateFormat dateFormat = fgShortTimeFormat;
        synchronized (dateFormat) {
            fgShortTimeFormat.setTimeZone(userTimeZone != null ? userTimeZone : TimeZone.getDefault());
            return fgShortTimeFormat.format(creationDate);
        }
    }
}

