/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.query;

import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.query.QueryType;
import com.ibm.team.workitem.common.query.IQueryType;
import com.ibm.team.workitem.common.query.Messages;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;

public class QueryTypeRegistry {
    private static final String EXTENSION_POINT_ID = "com.ibm.team.workitem.common.queryTypes";
    private static final String EXTENSION_NAME = "queryType";
    private static Map<String, QueryType> fgRegistry;
    private static FoundationLog fgLog;
    private static final String ID_ATTRIBUTE = "id";
    private static final String DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String ITEM_TYPE_ELEMENT = "queryItemType";
    private static final String ITEM_TYPE_NAME_ATTRIBUTE = "name";
    private static final String ITEM_TYPE_URI_ATTRIBUTE = "nsUri";

    public static IQueryType getQueryType(String id) {
        QueryTypeRegistry.initialize();
        return fgRegistry.get(id);
    }

    private static synchronized void initialize() {
        if (fgRegistry != null) {
            return;
        }
        fgRegistry = new HashMap<String, QueryType>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(EXTENSION_NAME)) {
                        try {
                            QueryType queryType = QueryTypeRegistry.readQueryType(element);
                            fgRegistry.put(queryType.getIdentifier(), queryType);
                        }
                        catch (IllegalArgumentException e) {
                            String warning = NLS.bind((String)Messages.getString("QueryTypeRegistry.PATTERN_REGISTRY_ERROR"), (Object[])new Object[]{e.getLocalizedMessage()});
                            QueryTypeRegistry.getLogger().warn(warning, null);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static QueryType readQueryType(IConfigurationElement element) {
        IConfigurationElement[] itemTypeElement;
        String id = element.getAttribute(ID_ATTRIBUTE);
        QueryTypeRegistry.check(id, Messages.getString("QueryTypeRegistry.ID_EMPTY"));
        String displayName = element.getAttribute(DISPLAY_NAME_ATTRIBUTE);
        QueryTypeRegistry.check(displayName, Messages.getString("QueryTypeRegistry.DISPLAY_NAME_EMPTY"));
        URL iconURL = null;
        String icon = element.getAttribute(ICON_ATTRIBUTE);
        if (icon != null && icon.trim().length() > 0) {
            iconURL = FileLocator.find((String)element.getNamespaceIdentifier(), (IPath)new Path(icon), null);
        }
        if ((itemTypeElement = element.getChildren(ITEM_TYPE_ELEMENT)).length != 1) {
            throw new IllegalArgumentException(Messages.getString("QueryTypeRegistry.EXACTLY_ONE_ITEM_TYPE"));
        }
        IItemType itemType = QueryTypeRegistry.readItemType(itemTypeElement[0]);
        if (itemType == null) {
            throw new IllegalArgumentException(Messages.getString("QueryTypeRegistry.UNKNOWN_ITEM_TYPE"));
        }
        return new QueryType(id, displayName, iconURL, itemType);
    }

    private static IItemType readItemType(IConfigurationElement element) {
        String itemTypeName = element.getAttribute(ITEM_TYPE_NAME_ATTRIBUTE);
        QueryTypeRegistry.check(itemTypeName, Messages.getString("QueryTypeRegistry.ITEM_TYPE_NAME_MISSING"));
        String itemTypeURI = element.getAttribute(ITEM_TYPE_URI_ATTRIBUTE);
        QueryTypeRegistry.check(itemTypeURI, Messages.getString("QueryTypeRegistry.ITEM_TYPE_NSURI_MISSING"));
        return IItemType.IRegistry.INSTANCE.getItemType(itemTypeName, itemTypeURI);
    }

    private static void check(String string, String message) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    private static FoundationLog getLogger() {
        if (fgLog == null) {
            fgLog = FoundationLog.getLog((String)"com.ibm.team.workitem.common");
        }
        return fgLog;
    }
}

