/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessDefinitionHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.util.CategoriesManager;
import com.ibm.team.workitem.common.internal.util.CategoryTreeNode;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemProcessUtils {
    public static final String SAMPLE_PROCESS_DEFINITION_ID = "com.ibm.team.workitem.process.sample";
    public static final String DEFAULT_DEV_LINE = "default";
    private static final String SAMPLE_PROCESS_SPECIFICATION_XML = "resources/configuration/process_specification.xml";
    private static final String SAMPLE_PROCESS_STATE_XML = "resources/configuration/process_state.xml";
    private static final String DEFAULT_ENCODING = "UTF8";

    public static void deploySampleProcessDefinition(IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemProcessUtils.deploySampleProcessDefinition(auditableCommon, false, monitor);
    }

    public static void deploySampleProcessDefinition(IAuditableCommon auditableCommon, boolean update, IProgressMonitor monitor) throws TeamRepositoryException {
        URL specificationURL = FileLocator.find((String)"com.ibm.team.workitem.common", (IPath)new Path(SAMPLE_PROCESS_SPECIFICATION_XML));
        URL stateURL = FileLocator.find((String)"com.ibm.team.workitem.common", (IPath)new Path(SAMPLE_PROCESS_STATE_XML));
        WorkItemProcessUtils.deployProcessDefinition(auditableCommon, SAMPLE_PROCESS_DEFINITION_ID, specificationURL, stateURL, update, monitor);
    }

    public static IProcessDefinition deployProcessDefinition(IAuditableCommon auditableCommon, String processDefinitionId, URL specificationURL, URL stateURL, IProgressMonitor monitor) throws TeamRepositoryException {
        return WorkItemProcessUtils.deployProcessDefinition(auditableCommon, processDefinitionId, specificationURL, stateURL, false, monitor);
    }

    public static IProcessDefinition deployProcessDefinition(IAuditableCommon auditableCommon, String processDefinitionId, URL specificationURL, URL stateURL, boolean update, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessDefinition processDefinition = auditableCommon.findProcessDefinition(processDefinitionId, ItemProfile.createFullProfile(IProcessDefinition.ITEM_TYPE), monitor);
        if (processDefinition != null) {
            if (!update) {
                return processDefinition;
            }
            processDefinition = (IProcessDefinition)processDefinition.getWorkingCopy();
        } else {
            processDefinition = (IProcessDefinition)auditableCommon.createAuditable(IProcessDefinition.ITEM_TYPE);
            processDefinition.setProcessId(processDefinitionId);
        }
        processDefinition.setName("Sample Work Item Process");
        processDefinition.getDescription().setSummary("This sample process contains exemplary process definitions for the Work Item component.");
        Map definitionData = processDefinition.getProcessData();
        IContent specification = WorkItemProcessUtils.createXMLContentFromFile(auditableCommon, specificationURL, monitor);
        definitionData.put("com.ibm.team.internal.process.compiled.xml", specification);
        IContent state = WorkItemProcessUtils.createXMLContentFromFile(auditableCommon, stateURL, monitor);
        definitionData.put("com.ibm.team.internal.process.state.xml", state);
        processDefinition = auditableCommon.saveProcessItem(processDefinition, monitor);
        return processDefinition;
    }

    public static IProjectArea setupProcessAreas(IAuditableCommon auditableCommon, String processDefinitionId, String projectAreaName, String teamAreaName, String defaultDevelopmentLineId, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = WorkItemProcessUtils.createProjectArea(auditableCommon, processDefinitionId, projectAreaName, monitor);
        if (teamAreaName != null) {
            List<IDevelopmentLine> developmentLines = auditableCommon.resolveAuditables(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
            for (IDevelopmentLine developmentLine : developmentLines) {
                String developmentLineId = developmentLine.getId();
                if (!developmentLineId.equals(defaultDevelopmentLineId) && developmentLineId.length() > 0) {
                    teamAreaName = String.valueOf(teamAreaName) + " " + developmentLineId.substring(0, 1).toUpperCase() + developmentLineId.substring(1);
                }
                WorkItemProcessUtils.setupTeamAreas(auditableCommon, (IProjectAreaHandle)projectArea, teamAreaName, developmentLineId, developmentLineId.equals(defaultDevelopmentLineId), monitor);
            }
        }
        return (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)((IProjectAreaHandle)projectArea.getItemHandle()), ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
    }

    private static ITeamAreaHandle setupTeamAreas(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String teamAreaName, String developmentLineId, boolean isDefaultDevelopmentLineId, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemCommon workItemCommon = (WorkItemCommon)auditableCommon.getPeer(IWorkItemCommon.class);
        ICategory rootCategory = workItemCommon.findRootCategory(projectArea, ICategory.FULL_PROFILE, monitor);
        ITeamArea rootTeamArea = WorkItemProcessUtils.createRootTeamArea(auditableCommon, teamAreaName, projectArea, developmentLineId, monitor);
        WorkItemProcessUtils.setTeamArea(auditableCommon, rootCategory, (ITeamAreaHandle)rootTeamArea, isDefaultDevelopmentLineId, monitor);
        List<ICategory> categories = workItemCommon.findCategories(projectArea, ICategory.FULL_PROFILE, monitor);
        for (ICategory category : categories) {
            if (category.getDepth() != 0) continue;
            ITeamArea childArea = WorkItemProcessUtils.createChildTeamArea(auditableCommon, (ITeamAreaHandle)rootTeamArea, category.getName(), monitor);
            WorkItemProcessUtils.setTeamArea(auditableCommon, category, (ITeamAreaHandle)childArea, isDefaultDevelopmentLineId, monitor);
        }
        return rootTeamArea;
    }

    private static void setTeamArea(IAuditableCommon auditableCommon, ICategory category, ITeamAreaHandle handle, boolean isDefaultDevelopmentLineId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (isDefaultDevelopmentLineId && WorkItemProcessUtils.equals((IItemHandle)category.getDefaultTeamArea(), (IItemHandle)handle)) {
            return;
        }
        if (!isDefaultDevelopmentLineId && WorkItemProcessUtils.contains(category.getAssociatedTeamAreas(), handle)) {
            return;
        }
        ITeamArea teamArea = auditableCommon.resolveAuditable((IAuditableHandle)handle, ItemProfile.TEAM_AREA_DEFAULT, monitor);
        CategoriesManager manager = CategoriesManager.createInstance(auditableCommon, teamArea.getProjectArea(), monitor);
        CategoryTreeNode node = manager.findNode(category);
        if (isDefaultDevelopmentLineId) {
            node.setDefaultTeamArea((ITeamAreaHandle)teamArea);
        } else {
            node.setDevelopmentLineTeamArea((ITeamAreaHandle)teamArea);
        }
        manager.save(monitor);
    }

    private static boolean equals(IItemHandle left, IItemHandle right) {
        return left == right || left != null && left.sameItemId(right);
    }

    public static ITeamArea createRootTeamArea(IAuditableCommon auditableCommon, String teamAreaName, IProjectAreaHandle projectAreaHandle, String developmentLineId, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamArea teamArea = WorkItemProcessUtils.findProcessArea(auditableCommon, projectAreaHandle, teamAreaName, monitor);
        if (teamArea != null) {
            return teamArea;
        }
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        projectArea = (IProjectArea)projectArea.getWorkingCopy();
        teamArea = (ITeamArea)auditableCommon.createAuditable(ITeamArea.ITEM_TYPE);
        teamArea.setName(teamAreaName);
        teamArea.setProjectArea((IProjectAreaHandle)projectArea);
        IDevelopmentLineHandle line = WorkItemProcessUtils.findDevelopmentLine(auditableCommon, (IProjectAreaHandle)projectArea, developmentLineId, monitor);
        projectArea.getTeamAreaHierarchy().addRoot((ITeamAreaHandle)teamArea, line);
        ArrayList<IProcessItem> toBeSaved = new ArrayList<IProcessItem>();
        toBeSaved.add((IProcessItem)projectArea);
        toBeSaved.add((IProcessItem)teamArea);
        List<IProcessItem> saveProcessItems = auditableCommon.saveProcessItems(toBeSaved, monitor);
        return (ITeamArea)saveProcessItems.get(1);
    }

    private static IDevelopmentLineHandle findDevelopmentLine(IAuditableCommon auditableCommon, IProjectAreaHandle projectAreaHandle, String developmentLineId, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        List<IDevelopmentLine> lines = auditableCommon.resolveAuditables(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        for (IDevelopmentLine current : lines) {
            if (!current.getId().equals(developmentLineId)) continue;
            return current;
        }
        return null;
    }

    private static boolean contains(List<ITeamAreaHandle> teamAreas, ITeamAreaHandle teamArea) {
        boolean found = false;
        for (ITeamAreaHandle handle : teamAreas) {
            if (!handle.sameItemId((IItemHandle)teamArea)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static IProjectArea createProjectArea(IAuditableCommon auditableCommon, String processDefinitionId, String projectAreaName, IProgressMonitor monitor) throws TeamRepositoryException, TeamOperationCanceledException {
        IProjectArea projectArea2;
        List<IProjectArea> projecAreas = auditableCommon.findAuditables(ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        for (IProjectArea projectArea2 : projecAreas) {
            if (!projectArea2.getName().equals(projectAreaName)) continue;
            return projectArea2;
        }
        projectArea2 = (IProjectArea)auditableCommon.createAuditable(IProjectArea.ITEM_TYPE);
        projectArea2.setName(projectAreaName);
        IProcessDefinition definition = auditableCommon.findProcessDefinition(processDefinitionId, ItemProfile.createFullProfile(IProcessDefinition.ITEM_TYPE), monitor);
        projectArea2.setProcessDefinition((IProcessDefinitionHandle)definition);
        projectArea2 = auditableCommon.saveProcessItem(projectArea2, monitor);
        auditableCommon.initializeProjectArea((IProjectAreaHandle)projectArea2, monitor);
        return projectArea2;
    }

    public static ITeamArea createChildTeamArea(IAuditableCommon auditableCommon, ITeamAreaHandle parent, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamArea teamArea = WorkItemProcessUtils.findProcessArea(auditableCommon, parent, name, monitor);
        if (teamArea != null) {
            return teamArea;
        }
        ITeamArea area = auditableCommon.resolveAuditable((IAuditableHandle)parent, ItemProfile.TEAM_AREA_DEFAULT, monitor);
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)area.getProjectArea(), ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        projectArea = (IProjectArea)projectArea.getWorkingCopy();
        teamArea = (ITeamArea)auditableCommon.createAuditable(ITeamArea.ITEM_TYPE);
        teamArea.setName(name);
        teamArea.setProjectArea((IProjectAreaHandle)projectArea);
        projectArea.getTeamAreaHierarchy().addChild(parent, (ITeamAreaHandle)teamArea);
        ArrayList<IProcessItem> toBeSaved = new ArrayList<IProcessItem>();
        toBeSaved.add((IProcessItem)projectArea);
        toBeSaved.add((IProcessItem)teamArea);
        List<IProcessItem> saveProcessItems = auditableCommon.saveProcessItems(toBeSaved, monitor);
        return (ITeamArea)saveProcessItems.get(1);
    }

    private static IContent createXMLContentFromFile(IAuditableCommon auditableCommon, URL url, IProgressMonitor monitor) throws TeamRepositoryException {
        byte[] byteArray;
        InputStream input = null;
        try {
            try {
                URLConnection connection = url.openConnection();
                input = connection.getInputStream();
                String contentEncoding = connection.getContentEncoding();
                if (contentEncoding == null) {
                    contentEncoding = DEFAULT_ENCODING;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(input, contentEncoding));
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, DEFAULT_ENCODING);
                int ch = reader.read();
                while (ch != -1) {
                    writer.write(ch);
                    ch = reader.read();
                }
                writer.flush();
                writer.close();
                byteArray = output.toByteArray();
            }
            catch (IOException x) {
                throw new TeamRepositoryException((Throwable)x);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException x) {
                throw new TeamRepositoryException((Throwable)x);
            }
        }
        return auditableCommon.storeContent("text/xml", DEFAULT_ENCODING, new ByteArrayInputStream(byteArray), byteArray.length, monitor);
    }

    private static ITeamArea findProcessArea(IAuditableCommon auditableCommon, IProjectAreaHandle parent, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)parent, ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        List roots = auditableCommon.resolveAuditables(new ArrayList(projectArea.getTeamAreaHierarchy().getRoots()), ItemProfile.createFullProfile(ITeamArea.ITEM_TYPE), monitor);
        for (ITeamArea root : roots) {
            if (!root.getName().equals(name)) continue;
            return root;
        }
        return null;
    }

    private static ITeamArea findProcessArea(IAuditableCommon auditableCommon, ITeamAreaHandle parent, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamArea teamArea = (ITeamArea)auditableCommon.resolveAuditable((IAuditableHandle)parent, ItemProfile.createFullProfile(ITeamArea.ITEM_TYPE), monitor);
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)teamArea.getProjectArea(), ItemProfile.createFullProfile(IProjectArea.ITEM_TYPE), monitor);
        List children = auditableCommon.resolveAuditables(new ArrayList(projectArea.getTeamAreaHierarchy().getChildren((ITeamAreaHandle)teamArea)), ItemProfile.createFullProfile(ITeamArea.ITEM_TYPE), monitor);
        for (ITeamArea child : children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public static IReportInfo getFirstErrorInfo(IProcessReport report) {
        if (report == null) {
            return null;
        }
        IReportInfo info = WorkItemProcessUtils.getFirstAdvisorErrorInfo(report);
        if (info != null) {
            return info;
        }
        IProcessReport[] nestedReports = report.getNestedReports();
        int i = 0;
        while (i < nestedReports.length) {
            IProcessReport nestedReport = nestedReports[i];
            info = WorkItemProcessUtils.getFirstErrorInfo(nestedReport);
            if (info != null) {
                return info;
            }
            ++i;
        }
        return null;
    }

    private static IReportInfo getFirstAdvisorErrorInfo(IProcessReport participantReport) {
        IReportInfo[] advisorProblems = participantReport.getInfos();
        int j = 0;
        while (j < advisorProblems.length) {
            IReportInfo advisorProblem = advisorProblems[j];
            if (advisorProblem.getSeverity() == 4) {
                return advisorProblem;
            }
            ++j;
        }
        return null;
    }

    public static List<IReportInfo> getAllReportInfos(IProcessReport report) {
        if (report == null) {
            return Collections.emptyList();
        }
        ArrayList<IReportInfo> infos = new ArrayList<IReportInfo>();
        WorkItemProcessUtils.addAllReportInfos(infos, report);
        return infos;
    }

    private static void addAllReportInfos(List<IReportInfo> infos, IProcessReport report) {
        infos.addAll((Collection<IReportInfo>)Arrays.asList(report.getInfos()));
        IProcessReport[] iProcessReportArray = report.getNestedReports();
        int n = iProcessReportArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessReport nestedReport = iProcessReportArray[n2];
            WorkItemProcessUtils.addAllReportInfos(infos, nestedReport);
            ++n2;
        }
    }
}

