/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.AdapterManagerFactory;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IExtensibleItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.Type;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ModelUtils;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.common.validation.IStringSizeConstraintErrorStatus;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemReferences;
import com.ibm.team.workitem.common.internal.rcp.dto.ExceptionDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.MultiSaveParameterDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.MultiSaveResultDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.RcpFactory;
import com.ibm.team.workitem.common.internal.rcp.dto.SaveParameterDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.SaveResultDTO;
import com.ibm.team.workitem.common.internal.util.Messages;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String MENTIONED_LINK_TYPE = "com.ibm.team.workitem.linktype.textualReference";
    public static final IEndPointDescriptor MENTIONED_TARGET_END_POINT = ILinkTypeRegistry.INSTANCE.getLinkType("com.ibm.team.workitem.linktype.textualReference").getTargetEndPointDescriptor();
    public static final IEndPointDescriptor MENTIONED_SOURCE_END_POINT = ILinkTypeRegistry.INSTANCE.getLinkType("com.ibm.team.workitem.linktype.textualReference").getSourceEndPointDescriptor();
    public static final int LONG_STRING_LENGTH = 32768;
    public static final int MISSING_DUPLICATE_STATUS_CODE = 70000;
    public static final int MISSING_TEAM_AREA_STATUS_CODE = 70001;
    public static final int STALE_STATE_STATUS_CODE = 70002;
    public static final int COMMENT_ADDED_STATUS_CODE = 70003;
    private static final String TEAM_REPOSITORY_URI_PROPERTY = "com.ibm.team.repository.uri";
    private static final String TEAM_REPOSITORY_HOST_PROPERTY = "com.ibm.team.repository.host";
    private static final String HTTP_SCHEME = "http://";
    private static final String LOCAL_SCHEME = "local://";
    private static final String WEB_SERVICE_PATH = "/jazz";
    private static final String RELATIVE_WORKITEM_WEBUI_PATH = "web#perspective=Work%20Items&action=viewWorkItem&id=";
    public static final String SECURE_LOCALHOST_URL = "https://localhost:9443/jazz";
    public static final String LOCALHOST_URL = "http://localhost:9080/jazz";
    public static final String LOCAL_URL = "local://host/jazz";
    public static final URI TEST_REPOSITORY_URI;
    public static final String TEST_USER_ID = "ADMIN";
    public static final String TEST_PASSWORD = "ADMIN";
    private static final List<String> TEST_APPLICATIONS;
    public static final boolean PLUGIN_TEST;
    private static final String VALUE_SUFFIX = ".value";
    public static final String LARGE_STRING_EXTENSION_VALUE_PROPERTY;
    public static final String MEDIUM_STRING_EXTENSION_VALUE_PROPERTY;
    public static final String SMALL_STRING_EXTENSION_VALUE_PROPERTY;
    private static ThreadLocal<Boolean> fgImport;
    private static final String TEAM_AREA_ID = "com.ibm.team.workitem.teamArea_id";
    private static final String SYNTHETIC_START_TAG = "<synthetic>";
    private static final String SYNTHETIC_END_TAG = "</synthetic>";

    static {
        TEST_APPLICATIONS = Arrays.asList("org.eclipse.test.uitestapplication", "org.eclipse.test.coretestapplication", "org.eclipse.pde.junit.runtime.uitestapplication", "org.eclipse.pde.junit.runtime.coretestapplication", "org.eclipse.pde.junit.runtime.legacyUItestapplication", "org.eclipse.pde.junit.runtime.legacyCoretestapplication");
        PLUGIN_TEST = Utils.isPluginTest();
        URI repositoryURI = null;
        try {
            repositoryURI = new URI(LOCAL_URL);
            String uri = Utils.findTeamRepositoryURI();
            if (uri != null) {
                repositoryURI = new URI(uri);
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        TEST_REPOSITORY_URI = repositoryURI;
        LARGE_STRING_EXTENSION_VALUE_PROPERTY = String.valueOf(IExtensibleItem.LARGE_STRING_EXTENSIONS_QUERY_PROPERTY) + VALUE_SUFFIX;
        MEDIUM_STRING_EXTENSION_VALUE_PROPERTY = String.valueOf(IExtensibleItem.MEDIUM_STRING_EXTENSIONS_QUERY_PROPERTY) + VALUE_SUFFIX;
        SMALL_STRING_EXTENSION_VALUE_PROPERTY = String.valueOf(IExtensibleItem.STRING_EXTENSIONS_QUERY_PROPERTY) + VALUE_SUFFIX;
        fgImport = new ThreadLocal();
    }

    private static String findTeamRepositoryURI() {
        String property = System.getProperty(TEAM_REPOSITORY_URI_PROPERTY);
        if (property != null && property.length() > 0) {
            return property;
        }
        property = System.getProperty(TEAM_REPOSITORY_HOST_PROPERTY);
        if (property != null && property.length() > 0) {
            return HTTP_SCHEME + property + WEB_SERVICE_PATH;
        }
        return null;
    }

    public static String getBaseURI(URI uri) {
        String protocol = uri.getScheme();
        String authority = uri.getAuthority();
        String path = uri.getPath();
        if (protocol == null || authority == null || path == null) {
            return null;
        }
        String[] segments = path.split("/");
        int i = 0;
        while (i < segments.length && segments[i].equals("")) {
            ++i;
        }
        path = "/";
        if (i < segments.length) {
            path = String.valueOf(path) + segments[i] + "/";
        }
        StringBuffer url = new StringBuffer();
        url.append(protocol);
        url.append("://");
        url.append(authority);
        url.append(path);
        return url.toString();
    }

    public static String getHttpRepositoryUrl(String repositoryUrl) {
        if (repositoryUrl.startsWith(LOCAL_SCHEME)) {
            return LOCALHOST_URL;
        }
        return repositoryUrl;
    }

    public static String getWebUIUrl(String repository, IWorkItem wi) {
        StringBuffer url = new StringBuffer(repository);
        if (!repository.endsWith("/")) {
            url.append('/');
        }
        url.append(RELATIVE_WORKITEM_WEBUI_PATH);
        url.append(wi.getId());
        return url.toString();
    }

    public static String getDebugOption(String option) {
        String property = option.replace('/', '.');
        String value = System.getProperty(property);
        if (value != null) {
            return value;
        }
        return Platform.getDebugOption((String)option);
    }

    public static IItemHandle createItemHandle(IItemHandle itemHandle) {
        Object origin = itemHandle.getOrigin();
        if (origin == null) {
            return itemHandle.getItemType().createItemHandle(itemHandle.getItemId(), itemHandle.getStateId());
        }
        return itemHandle.getItemType().createItemHandle(origin, itemHandle.getItemId(), itemHandle.getStateId());
    }

    private static boolean isPluginTest() {
        String property = System.getProperty("eclipse.commands");
        if (property == null) {
            return false;
        }
        List<String> commands = Arrays.asList(property.split("\n"));
        int index = commands.indexOf("-application");
        if (index < 0 || index + 1 >= commands.size()) {
            return false;
        }
        return TEST_APPLICATIONS.contains(commands.get(index + 1));
    }

    public static void log(String pluginId, String message, Exception x) {
        FoundationLog log = FoundationLog.getLog((String)pluginId);
        log.error(message, (Throwable)x);
    }

    public static <T> T getCommonLibrary(Object origin, Class<T> commonInterface) {
        return (T)AdapterManagerFactory.getAdapterManager().loadAdapter(origin, commonInterface.getName());
    }

    public static void detachItems(EObject eObject) {
        for (EReference containment : eObject.eClass().getEAllContainments()) {
            if (!eObject.eIsSet((EStructuralFeature)containment)) continue;
            EClass containmentType = ModelUtils.getTargetClassIfFacade((EClass)containment.getEReferenceType());
            if (RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(containmentType) || RepositoryPackage.eINSTANCE.getReconcileReport().isSuperTypeOf(containmentType)) {
                eObject.eUnset((EStructuralFeature)containment);
                continue;
            }
            if (containment.isMany()) {
                EList children = (EList)eObject.eGet((EStructuralFeature)containment);
                for (EObject child : children) {
                    if (child == null) continue;
                    Utils.detachItems(child);
                }
                continue;
            }
            EObject child = (EObject)eObject.eGet((EStructuralFeature)containment);
            if (child == null) continue;
            Utils.detachItems(child);
        }
    }

    public static SaveParameterDTO createSaveParameter(IAuditable auditable, IWorkItemReferences references, String workflowAction) {
        SaveParameterDTO saveParameter = RcpFactory.eINSTANCE.createSaveParameterDTO();
        saveParameter.setAuditable(auditable);
        if (references != null) {
            saveParameter.getCreatedLinks().addAll(((WorkItemReferences)references).getCreatedLinks());
            saveParameter.getDeletedLinks().addAll(((WorkItemReferences)references).getDeletedLinks());
        }
        saveParameter.setWorkflowAction(workflowAction);
        return saveParameter;
    }

    public static void checkSaveResult(Object origin, MultiSaveResultDTO multiSaveResult) throws MultiStaleDataException, TeamRepositoryException {
        if (multiSaveResult.isConflictingUpdate()) {
            throw new MultiStaleDataException(origin, multiSaveResult.getReconcileReports());
        }
        if (!multiSaveResult.isSuccessful()) {
            IStatus status = multiSaveResult.getStatus();
            if (!status.isOK()) {
                throw new TeamRepositoryException(origin, status.getMessage(), (Throwable)new CoreException(status));
            }
            throw new TeamRepositoryException(origin, multiSaveResult.getFailureMessage());
        }
    }

    public static void updateWorkingCopies(MultiSaveParameterDTO multiSaveParameter, MultiSaveResultDTO multiSaveResult) {
        List saveResults = multiSaveResult.getSaveResults();
        List saveParameters = multiSaveParameter.getSaveParameters();
        Assert.isTrue((saveParameters.size() <= saveResults.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < saveParameters.size()) {
            IAuditable auditable = ((SaveParameterDTO)saveParameters.get(i)).getAuditable();
            IAuditable updatedState = ((SaveResultDTO)saveResults.get(i)).getUpdatedState();
            Assert.isTrue((boolean)auditable.sameItemId((IItemHandle)updatedState));
            ((Auditable)auditable).setWorkingCopyPredecessor(updatedState.getStateId());
            ++i;
        }
    }

    public static void initNew(Helper helper) {
        EObject eObject = (EObject)helper;
        for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
            if (!ItemUtil.isPersistent((EClass)eObject.eClass(), (EStructuralFeature)feature)) continue;
            if (feature.isMany()) {
                eObject.eSet(feature, (Object)Collections.EMPTY_LIST);
                continue;
            }
            eObject.eSet(feature, feature.getDefaultValue());
        }
    }

    public static String shorten(IType type, String property, String text) {
        if (!Utils.isTooLong(type, property, text)) {
            return text;
        }
        int i = -1;
        int j = text.length();
        while (j - i > 1) {
            int k = i + j >> 1;
            if (Utils.isTooLong(type, property, text.substring(0, k))) {
                j = k;
                continue;
            }
            i = k;
        }
        return text.substring(0, i);
    }

    public static boolean isTooLong(IType type, String property, String text) {
        String[] segments;
        if (!property.contains(".")) {
            return IItemValidator.INSTANCE.validateAttribute(type, property, (Object)text) instanceof IStringSizeConstraintErrorStatus;
        }
        EClass eClass = ItemUtil.getTypeEClass((Type)((Type)type));
        EStructuralFeature feature = null;
        String[] stringArray = segments = property.split("\\.");
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            Assert.isNotNull((Object)eClass);
            feature = eClass.getEStructuralFeature(segment);
            Assert.isNotNull((Object)feature);
            eClass = feature.getEType() instanceof EClass ? (EClass)feature.getEType() : null;
            ++n2;
        }
        return ItemUtil.validateStringPropertySize(feature, (String)text) != null;
    }

    public static String shorten(String string, int maxLength) {
        if (string.length() <= maxLength) {
            return string;
        }
        String probe = NLS.bind((String)Messages.getString("Utils.SHORTENED"), (Object[])new Object[]{""});
        return NLS.bind((String)Messages.getString("Utils.SHORTENED"), (Object[])new Object[]{string.substring(0, maxLength - probe.length())});
    }

    public static Object getValue(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItem.getProjectArea().sameItemId((IItemHandle)attribute.getProjectArea())) {
            return workItem.getValue(attribute);
        }
        IAttribute other = Utils.getAttribute(auditableCommon, workItem, attribute, monitor);
        return workItem.getValue(other);
    }

    public static Object getDefaultValue(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItem.getProjectArea().sameItemId((IItemHandle)attribute.getProjectArea())) {
            return attribute.getDefaultValue(auditableCommon, workItem, monitor);
        }
        IAttribute other = Utils.getAttribute(auditableCommon, workItem, attribute, monitor);
        return other.getDefaultValue(auditableCommon, workItem, monitor);
    }

    public static IAttribute getAttribute(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        IAttribute other = workItemCommon.findAttribute(workItem.getProjectArea(), attribute.getIdentifier(), monitor);
        Assert.isNotNull((Object)other);
        Assert.isTrue((boolean)other.getAttributeType().equals(attribute.getAttributeType()));
        return other;
    }

    public static boolean hasAttribute(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItem.getProjectArea().sameItemId((IItemHandle)attribute.getProjectArea())) {
            return workItem.hasAttribute(attribute);
        }
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        IAttribute other = workItemCommon.findAttribute(workItem.getProjectArea(), attribute.getIdentifier(), monitor);
        if (other == null) {
            return false;
        }
        if (!other.getAttributeType().equals(attribute.getAttributeType())) {
            return false;
        }
        return workItem.hasAttribute(other);
    }

    public static TimeZone getUserTimeZone(MultiSaveParameterDTO multiSaveParameterDTO) {
        ExceptionDTO dto = (ExceptionDTO)multiSaveParameterDTO.getDeferredTransactionData().get("com.ibm.team.workitem.user_time_zone_id");
        if (dto == null) {
            return TimeZone.getDefault();
        }
        String userTimeZoneId = dto.getMessage();
        if (userTimeZoneId == null || userTimeZoneId.length() == 0) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(userTimeZoneId);
    }

    public static void setUserTimeZone(MultiSaveParameterDTO multiSaveParameter, TimeZone timeZone) {
        ExceptionDTO dto = RcpFactory.eINSTANCE.createExceptionDTO();
        dto.setMessage(timeZone.getID());
        multiSaveParameter.getDeferredTransactionData().put("com.ibm.team.workitem.user_time_zone_id", dto);
    }

    public static void runImport(Runnable runnable) {
        try {
            fgImport.set(true);
            runnable.run();
        }
        finally {
            fgImport.remove();
        }
    }

    public static boolean isImport(MultiSaveParameterDTO multiSaveParameterDTO) {
        ExceptionDTO dto = (ExceptionDTO)multiSaveParameterDTO.getDeferredTransactionData().get("com.ibm.team.workitem.import_id");
        if (dto == null) {
            return false;
        }
        return Boolean.valueOf(dto.getMessage());
    }

    public static void setImport(MultiSaveParameterDTO multiSaveParameter) {
        if (fgImport.get() == null || !fgImport.get().booleanValue()) {
            return;
        }
        ExceptionDTO dto = RcpFactory.eINSTANCE.createExceptionDTO();
        dto.setMessage(Boolean.TRUE.toString());
        multiSaveParameter.getDeferredTransactionData().put("com.ibm.team.workitem.import_id", dto);
    }

    public static ITeamAreaHandle getTeamArea(MultiSaveParameterDTO multiSaveParameter) {
        ExceptionDTO dto = (ExceptionDTO)multiSaveParameter.getDeferredTransactionData().get(TEAM_AREA_ID);
        if (dto == null) {
            return null;
        }
        try {
            return (ITeamAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)dto.getMessage()), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static void setTeamArea(MultiSaveParameterDTO multiSaveParameter, ITeamAreaHandle teamArea) {
        if (teamArea == null) {
            return;
        }
        ExceptionDTO dto = RcpFactory.eINSTANCE.createExceptionDTO();
        dto.setMessage(teamArea.getItemId().getUuidValue());
        multiSaveParameter.getDeferredTransactionData().put(TEAM_AREA_ID, dto);
    }

    public static List<IEndPointDescriptor> getSortedWriteableDescriptors() {
        ArrayList<IEndPointDescriptor> descriptors = new ArrayList<IEndPointDescriptor>(WorkItemLinkTypes.getUserWritableDescriptors());
        Collections.sort(descriptors, new Comparator<IEndPointDescriptor>(){

            @Override
            public int compare(IEndPointDescriptor descriptor1, IEndPointDescriptor descriptor2) {
                int weight2;
                int weight1;
                String typeId2;
                String typeId1 = descriptor1.getLinkType().getLinkTypeId();
                if (!typeId1.equals(typeId2 = descriptor2.getLinkType().getLinkTypeId())) {
                    if ("com.ibm.team.workitem.linktype.relatedworkitem".equals(typeId1)) {
                        return -1;
                    }
                    if ("com.ibm.team.workitem.linktype.relatedworkitem".equals(typeId2)) {
                        return 1;
                    }
                    if ("com.ibm.team.workitem.linktype.duplicateworkitem".equals(typeId1)) {
                        return -1;
                    }
                    if ("com.ibm.team.workitem.linktype.duplicateworkitem".equals(typeId2)) {
                        return 1;
                    }
                }
                if ((weight1 = this.getTypeWeight(descriptor1)) != (weight2 = this.getTypeWeight(descriptor2))) {
                    return weight1 - weight2;
                }
                IEndPointDescriptor mainDescriptor1 = this.getMainDescriptor(descriptor1);
                String label1 = mainDescriptor1.getDisplayName();
                IEndPointDescriptor mainDescriptor2 = this.getMainDescriptor(descriptor2);
                String label2 = mainDescriptor2.getDisplayName();
                int compare = Collator.getInstance().compare(label1, label2);
                if (compare != 0) {
                    return compare;
                }
                compare = Collator.getInstance().compare(typeId1, typeId2);
                if (compare != 0) {
                    return compare;
                }
                if (descriptor1 == mainDescriptor1) {
                    return -1;
                }
                if (descriptor2 == mainDescriptor2) {
                    return 1;
                }
                return 0;
            }

            private IEndPointDescriptor getMainDescriptor(IEndPointDescriptor o) {
                IEndPointDescriptor source = o.getLinkType().getSourceEndPointDescriptor();
                IEndPointDescriptor target = o.getLinkType().getTargetEndPointDescriptor();
                if (target.isSingleValued()) {
                    return target;
                }
                if (source.isSingleValued()) {
                    return source;
                }
                if (Collator.getInstance().compare(target.getDisplayName(), source.getDisplayName()) > 0) {
                    return source;
                }
                return target;
            }

            private int getTypeWeight(IEndPointDescriptor o1) {
                int weight = 0;
                if (o1.getLinkType().getSourceEndPointDescriptor().getReferencedItemType() == IWorkItem.ITEM_TYPE) {
                    ++weight;
                }
                if (o1.getLinkType().getTargetEndPointDescriptor().getReferencedItemType() == IWorkItem.ITEM_TYPE) {
                    ++weight;
                }
                return weight;
            }
        });
        return descriptors;
    }

    public static XMLString removeSyntheticContent(XMLString string) {
        StringBuilder s = new StringBuilder(string.getXMLText());
        int i = s.indexOf(SYNTHETIC_START_TAG);
        while (i != -1) {
            int j = s.indexOf(SYNTHETIC_END_TAG, i + SYNTHETIC_START_TAG.length());
            if (j != -1) {
                s.delete(i, j + SYNTHETIC_END_TAG.length());
            } else {
                s.delete(i, s.length());
            }
            i = s.indexOf(SYNTHETIC_START_TAG, i);
        }
        return XMLString.createFromXMLText((String)s.toString());
    }

    public static XMLString createSynthetic(XMLString string) {
        return XMLString.createFromXMLText((String)(SYNTHETIC_START_TAG + string.getXMLText() + SYNTHETIC_END_TAG));
    }
}

