/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.ISubscriptions;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeWayDiffReport {
    private static final Set<Set<EStructuralFeature>> WORK_ITEM_ATTRIBUTE_GROUPS = new HashSet<Set<EStructuralFeature>>();
    private IAuditable fBase;
    private IAuditable fOutgoing;
    private IAuditable fIncoming;
    private List<AttributeDiff> fAttributeDiffs = new ArrayList<AttributeDiff>();

    static {
        ModelPackage model = ModelPackage.eINSTANCE;
        ThreeWayDiffReport.addGroup(new EStructuralFeature[]{model.getWorkItem_InternalState(), model.getWorkItem_InternalResolution(), model.getWorkItem_WorkflowSurrogate(), model.getWorkItem_Resolver(), model.getWorkItem_ResolutionDate()});
        ThreeWayDiffReport.addGroup(new EStructuralFeature[]{model.getWorkItem_InternalApprovalDescriptors(), model.getWorkItem_InternalApprovals()});
        HashSet<EStructuralFeature> customFeatures = new HashSet<EStructuralFeature>();
        for (String property : IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES) {
            customFeatures.add(model.getWorkItem().getEStructuralFeature(property));
        }
        WORK_ITEM_ATTRIBUTE_GROUPS.add(customFeatures);
    }

    private static void addGroup(EStructuralFeature ... features) {
        WORK_ITEM_ATTRIBUTE_GROUPS.add(new HashSet(Arrays.asList(features)));
    }

    public ThreeWayDiffReport(IAuditable base, IAuditable outgoing, IAuditable incoming) {
        Assert.isTrue((base.getClass() == outgoing.getClass() && base.getClass() == incoming.getClass() ? 1 : 0) != 0);
        this.fBase = base;
        this.fOutgoing = outgoing;
        this.fIncoming = incoming;
        Collection<String> baseProperties = ItemProfile.computeProfile(base).getProperties();
        Collection<String> outgoingProperties = ItemProfile.computeProfile(outgoing).getProperties();
        Collection<String> incomingProperties = ItemProfile.computeProfile(incoming).getProperties();
        HashSet<String> diff = new HashSet<String>(outgoingProperties);
        diff.removeAll(baseProperties);
        Assert.isTrue((diff.size() == 0 ? 1 : 0) != 0);
        diff.addAll(outgoingProperties);
        diff.removeAll(incomingProperties);
        Assert.isTrue((diff.size() == 0 ? 1 : 0) != 0);
        this.computeAttributeDiffs((EObject)base, (EObject)outgoing, (EObject)incoming);
    }

    public IAuditable getBase() {
        return this.fBase;
    }

    public IAuditable getOutgoing() {
        return this.fOutgoing;
    }

    public IAuditable getIncoming() {
        return this.fIncoming;
    }

    private void computeAttributeDiffs(EObject base, EObject outgoing, EObject incoming) {
        HashSet<EStructuralFeature> features = new HashSet<EStructuralFeature>((Collection<EStructuralFeature>)outgoing.eClass().getEAllStructuralFeatures());
        if (base instanceof IWorkItem) {
            for (Set<EStructuralFeature> set : WORK_ITEM_ATTRIBUTE_GROUPS) {
                List<SingleAttributeDiff> diffs = this.computeAttributeDiffs(base, outgoing, incoming, set);
                if (!diffs.isEmpty()) {
                    this.fAttributeDiffs.add(new AttributeGroupDiff(this, diffs));
                }
                features.removeAll(set);
            }
        }
        this.fAttributeDiffs.addAll(this.computeAttributeDiffs(base, outgoing, incoming, features));
    }

    private List<SingleAttributeDiff> computeAttributeDiffs(EObject base, EObject outgoing, EObject incoming, Set<EStructuralFeature> features) {
        ArrayList<SingleAttributeDiff> diffs = new ArrayList<SingleAttributeDiff>();
        for (EStructuralFeature feature : features) {
            SingleAttributeDiff diff;
            if (!outgoing.eIsSet(feature) || (diff = this.computeAttributeDiff(base, outgoing, incoming, feature)) == null) continue;
            diffs.add(diff);
        }
        return diffs;
    }

    private SingleAttributeDiff computeAttributeDiff(EObject base, EObject outgoing, EObject incoming, EStructuralFeature feature) {
        Object baseValue = base.eGet(feature);
        Object outgoingValue = outgoing.eGet(feature);
        Object incomingValue = incoming.eGet(feature);
        boolean baseEqualsOutgoing = ThreeWayDiffReport.equals(baseValue, outgoingValue, feature.isOrdered());
        boolean baseEqualsIncoming = ThreeWayDiffReport.equals(baseValue, incomingValue, feature.isOrdered());
        if (baseEqualsOutgoing && baseEqualsIncoming) {
            return null;
        }
        int kind = baseEqualsOutgoing && !baseEqualsIncoming ? 1 : (!baseEqualsOutgoing && baseEqualsIncoming ? 2 : 3);
        if (feature == ModelPackage.eINSTANCE.getWorkItem_InternalComments()) {
            return new CommentsAttributeDiff(this, kind);
        }
        if (feature == ModelPackage.eINSTANCE.getWorkItem_InternalSubscriptions()) {
            return new SubscriptionsAttributeDiff(this, kind);
        }
        return new SingleAttributeDiff(this, kind, feature);
    }

    private static boolean equals(Object left, Object right, boolean ordered) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        if (left instanceof Helper && right instanceof Helper) {
            return ThreeWayDiffReport.equals((Helper)left, (Helper)right);
        }
        if (left instanceof List && right instanceof List) {
            return ThreeWayDiffReport.equals((List)left, (List)right, ordered);
        }
        if (left instanceof EObject && right instanceof EObject) {
            return ThreeWayDiffReport.equals((EObject)left, (EObject)right);
        }
        return left.equals(right);
    }

    private static boolean equals(Helper left, Helper right) {
        UUID leftId = left.getInternalId();
        UUID rightId = right.getInternalId();
        if (leftId != null && rightId != null && !leftId.equals((Object)rightId)) {
            return false;
        }
        return ThreeWayDiffReport.equals((EObject)left, (EObject)right);
    }

    private static boolean equals(EObject left, EObject right) {
        if (left.eClass() != right.eClass()) {
            return false;
        }
        for (EStructuralFeature feature : left.eClass().getEAllStructuralFeatures()) {
            if (ThreeWayDiffReport.equals(left.eGet(feature), right.eGet(feature), feature.isOrdered())) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(List<?> left, List<?> right, boolean ordered) {
        UUID uuid;
        if (left.size() != right.size()) {
            return false;
        }
        if (ordered) {
            int i = 0;
            while (i < left.size()) {
                if (!ThreeWayDiffReport.equals(left.get(i), right.get(i), false)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        HashMap leftItems = new HashMap();
        ArrayList<Object> leftObjects = new ArrayList<Object>();
        for (Object element : left) {
            Assert.isTrue((!(element instanceof List) ? 1 : 0) != 0);
            uuid = ThreeWayDiffReport.getUUID(element);
            if (uuid != null) {
                leftItems.put(uuid, element);
                continue;
            }
            leftObjects.add(element);
        }
        for (Object rightElement : right) {
            uuid = ThreeWayDiffReport.getUUID(rightElement);
            if (uuid != null) {
                Object leftItem = leftItems.get(uuid);
                if (leftItem == null) {
                    return false;
                }
                if (ThreeWayDiffReport.equals(leftItem, rightElement, false)) continue;
                return false;
            }
            ThreeWayDiffReport.remove(leftObjects, rightElement);
        }
        return leftObjects.isEmpty();
    }

    private static UUID getUUID(Object element) {
        if (element instanceof UUID) {
            return (UUID)element;
        }
        if (element instanceof IItemHandle) {
            return ((IItemHandle)element).getItemId();
        }
        if (element instanceof Helper) {
            return ((Helper)element).getInternalId();
        }
        return null;
    }

    private static void remove(List<Object> list, Object element) {
        Iterator<Object> iter = list.iterator();
        while (iter.hasNext()) {
            Object listElement = iter.next();
            if (!ThreeWayDiffReport.equals(listElement, element, false)) continue;
            iter.remove();
            return;
        }
    }

    public void merge() {
        for (AttributeDiff diff : this.fAttributeDiffs) {
            diff.merge();
        }
    }

    public boolean isIncomingOrConflicting(EStructuralFeature feature) {
        for (AttributeDiff diff : this.fAttributeDiffs) {
            if (!diff.affects(feature) || !diff.isIncoming() && !diff.isConflicting()) continue;
            return true;
        }
        return false;
    }

    public boolean canMergeAutomatically() {
        if (!(this.fOutgoing instanceof IWorkItem)) {
            return false;
        }
        for (AttributeDiff diff : this.fAttributeDiffs) {
            if (diff.canMergeAutomatically()) continue;
            return false;
        }
        return true;
    }

    public boolean mergePreservesOutgoing() {
        if (!(this.fOutgoing instanceof IWorkItem)) {
            return false;
        }
        for (AttributeDiff diff : this.fAttributeDiffs) {
            if (diff.mergePreservesOutgoing()) continue;
            return false;
        }
        return true;
    }

    public static boolean mergeAutomatically(IAuditable base, IAuditable outgoing, IAuditable incoming) {
        ThreeWayDiffReport report = new ThreeWayDiffReport(base, outgoing, incoming);
        if (!report.canMergeAutomatically()) {
            return false;
        }
        report.merge();
        return true;
    }

    private static abstract class AttributeDiff {
        public static final int INCOMING = 1;
        public static final int OUTGOING = 2;
        public static final int CONFLICTING = 3;
        private ThreeWayDiffReport fReport;

        private AttributeDiff(ThreeWayDiffReport report) {
            this.fReport = report;
        }

        public ThreeWayDiffReport getReport() {
            return this.fReport;
        }

        public boolean isIncoming() {
            return this.getKind() == 1;
        }

        public boolean isOutgoing() {
            return this.getKind() == 2;
        }

        public boolean isConflicting() {
            return this.getKind() == 3;
        }

        public abstract int getKind();

        public abstract void merge();

        public abstract boolean canMergeAutomatically();

        public abstract boolean mergePreservesOutgoing();

        public abstract boolean affects(EStructuralFeature var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeGroupDiff
    extends AttributeDiff {
        private List<SingleAttributeDiff> fDiffs;

        public AttributeGroupDiff(ThreeWayDiffReport report, List<SingleAttributeDiff> diffs) {
            super(report);
            Assert.isTrue((!diffs.isEmpty() ? 1 : 0) != 0);
            this.fDiffs = diffs;
        }

        @Override
        public int getKind() {
            int kind = this.fDiffs.get(0).getKind();
            for (AttributeDiff attributeDiff : this.fDiffs) {
                if (attributeDiff.getKind() == kind && attributeDiff.getKind() != 3) continue;
                return 3;
            }
            return kind;
        }

        @Override
        public void merge() {
            if (this.isOutgoing()) {
                return;
            }
            EObject outgoing = (EObject)this.getReport().getOutgoing();
            EObject incoming = (EObject)this.getReport().getIncoming();
            for (SingleAttributeDiff diff : this.fDiffs) {
                EMFHelper.set(outgoing, diff.getFeature(), EMFHelper.copy(incoming.eGet(diff.getFeature())));
            }
        }

        @Override
        public boolean canMergeAutomatically() {
            return this.isOutgoing();
        }

        @Override
        public boolean mergePreservesOutgoing() {
            return !this.isConflicting();
        }

        @Override
        public boolean affects(EStructuralFeature feature) {
            for (AttributeDiff attributeDiff : this.fDiffs) {
                if (!attributeDiff.affects(feature)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommentsAttributeDiff
    extends SingleAttributeDiff {
        public CommentsAttributeDiff(ThreeWayDiffReport report, int kind) {
            super(report, kind, (EStructuralFeature)ModelPackage.eINSTANCE.getWorkItem_InternalComments());
        }

        @Override
        public void merge() {
            if (this.isOutgoing()) {
                return;
            }
            List merged = ((WorkItem)this.getReport().getOutgoing()).getInternalComments();
            List incoming = ((WorkItem)this.getReport().getIncoming()).getInternalComments();
            for (IComment comment : incoming) {
                if (this.contains(merged, comment)) continue;
                comment = (IComment)EcoreUtil.copy((EObject)((EObject)comment));
                UUID internalId = ((Helper)comment).getInternalId();
                boolean added = false;
                for (IComment current : merged) {
                    if (!this.newer(current, comment)) continue;
                    merged.add(merged.indexOf(current), comment);
                    added = true;
                    break;
                }
                if (!added) {
                    merged.add(comment);
                }
                ((Helper)comment).setInternalId(internalId);
            }
        }

        private boolean newer(IComment outgoing, IComment incoming) {
            return outgoing.getCreationDate() == null || incoming.getCreationDate() != null && outgoing.getCreationDate().compareTo(incoming.getCreationDate()) >= 0;
        }

        private boolean contains(List<IComment> comments, IComment comment) {
            for (IComment current : comments) {
                if (!ThreeWayDiffReport.equals((Helper)current, (Helper)comment)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canMergeAutomatically() {
            return true;
        }

        @Override
        public boolean mergePreservesOutgoing() {
            return true;
        }
    }

    private static class SingleAttributeDiff
    extends AttributeDiff {
        private static final Set<EStructuralFeature> MERGE_INCOMING = new HashSet<EStructuralFeature>((Collection)Arrays.asList(RepositoryPackage.eINSTANCE.getAuditable_WorkingCopyPredecessor(), RepositoryPackage.eINSTANCE.getAuditable_WorkingCopyMergePredecessor()));
        private int fKind;
        private EStructuralFeature fFeature;

        public SingleAttributeDiff(ThreeWayDiffReport report, int kind, EStructuralFeature feature) {
            super(report);
            this.fKind = kind;
            this.fFeature = feature;
        }

        public int getKind() {
            return this.fKind;
        }

        public EStructuralFeature getFeature() {
            return this.fFeature;
        }

        public void merge() {
            if (this.isIncoming() || this.isConflicting() || MERGE_INCOMING.contains(this.getFeature())) {
                EObject outgoing = (EObject)this.getReport().getOutgoing();
                EObject incoming = (EObject)this.getReport().getIncoming();
                EMFHelper.set(outgoing, this.fFeature, EMFHelper.copy(incoming.eGet(this.fFeature)));
            }
        }

        public boolean canMergeAutomatically() {
            return this.isOutgoing() || MERGE_INCOMING.contains(this.getFeature());
        }

        public boolean mergePreservesOutgoing() {
            return !this.isConflicting() || MERGE_INCOMING.contains(this.getFeature());
        }

        public boolean affects(EStructuralFeature feature) {
            return feature == this.fFeature;
        }
    }

    private static class SubscriptionsAttributeDiff
    extends SingleAttributeDiff {
        public SubscriptionsAttributeDiff(ThreeWayDiffReport report, int kind) {
            super(report, kind, (EStructuralFeature)ModelPackage.eINSTANCE.getWorkItem_InternalSubscriptions());
        }

        public void merge() {
            if (this.isOutgoing()) {
                return;
            }
            ItemHandleAwareHashSet base = new ItemHandleAwareHashSet(((WorkItem)this.getReport().getBase()).getInternalSubscriptions());
            ItemHandleAwareHashSet incoming = new ItemHandleAwareHashSet(((WorkItem)this.getReport().getIncoming()).getInternalSubscriptions());
            ItemHandleAwareHashSet added = new ItemHandleAwareHashSet(incoming);
            added.removeAll(base);
            ISubscriptions subscriptions = ((IWorkItem)this.getReport().getOutgoing()).getSubscriptions();
            for (IItemHandle handle : added) {
                subscriptions.add((IContributorHandle)handle);
            }
            ItemHandleAwareHashSet removed = new ItemHandleAwareHashSet(base);
            removed.removeAll(incoming);
            for (IItemHandle handle : removed) {
                subscriptions.remove((IContributorHandle)handle);
            }
        }

        public boolean canMergeAutomatically() {
            return true;
        }

        public boolean mergePreservesOutgoing() {
            return true;
        }
    }
}

