/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryableAttributePath {
    private static final String PATH_SEPARATOR = "/";

    public static List<IQueryableAttribute> getPath(IQueryableAttribute attribute) {
        LinkedList<IQueryableAttribute> path = new LinkedList<IQueryableAttribute>();
        IQueryableAttribute parent = attribute;
        while (parent != null) {
            path.addFirst(parent);
            parent = parent.getParent();
        }
        return path;
    }

    public static String createPathString(IQueryableAttribute attribute) {
        return QueryableAttributePath.createPathString(attribute, PATH_SEPARATOR);
    }

    private static String createPathString(IQueryableAttribute attribute, String separator) {
        List<IQueryableAttribute> path = QueryableAttributePath.getPath(attribute);
        StringBuffer buffer = new StringBuffer();
        Iterator<IQueryableAttribute> iterator = path.iterator();
        while (iterator.hasNext()) {
            IQueryableAttribute part = iterator.next();
            buffer.append(part.getIdentifier());
            if (!iterator.hasNext()) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static String createPathString(String ... identifiers) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < identifiers.length) {
            buffer.append(identifiers[i]);
            if (i < identifiers.length - 1) {
                buffer.append(PATH_SEPARATOR);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String[] createPath(String pathString) {
        return pathString.split(PATH_SEPARATOR);
    }

    public static IQueryableAttribute getAttribute(IQueryableAttribute attribute, String[] path) {
        IQueryableAttribute leaf = attribute;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String childIdentifier = stringArray[n2];
            List<IQueryableAttribute> children = leaf.getChildAttributes();
            for (IQueryableAttribute child : children) {
                if (!child.getIdentifier().equals(childIdentifier)) continue;
                leaf = child;
            }
            ++n2;
        }
        return leaf;
    }

    public static String createPathLabel(IQueryableAttribute attribute, String separator) {
        List<IQueryableAttribute> path = QueryableAttributePath.getPath(attribute);
        StringBuffer buffer = new StringBuffer();
        Iterator<IQueryableAttribute> iterator = path.iterator();
        while (iterator.hasNext()) {
            IQueryableAttribute part = iterator.next();
            buffer.append(part.getDisplayName());
            if (!iterator.hasNext()) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static String[] removeFirstSegment(String[] path) {
        Assert.isLegal((path.length > 0 ? 1 : 0) != 0);
        String[] shortened = new String[path.length - 1];
        System.arraycopy(path, 1, shortened, 0, shortened.length);
        return shortened;
    }

    public static IQueryableAttribute getRoot(IQueryableAttribute attribute) {
        IQueryableAttribute root = null;
        IQueryableAttribute parent = attribute;
        while (parent != null) {
            root = parent;
            parent = parent.getParent();
        }
        return root;
    }

    public static String getLeafIdentifier(String pathString) {
        String[] path = QueryableAttributePath.createPath(pathString);
        return path[path.length - 1];
    }
}

