/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationsHelper {
    public static final String ITERATION_NAME_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"name");
    public static final String ITERATION_START_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"startDate");
    public static final String ITERATION_END_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"endDate");

    public static IIterationHandle findCurrentMilestone(IAuditableCommon auditableCommon, IDevelopmentLineHandle developmentLine, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IIteration> currentIterations = auditableCommon.findCurrentIterations(developmentLine, monitor);
        return IterationsHelper.findCurrentMilestone(currentIterations);
    }

    private static IIterationHandle findCurrentMilestone(List<IIteration> currentIterations) {
        ListIterator<IIteration> iterator = currentIterations.listIterator(currentIterations.size());
        while (iterator.hasPrevious()) {
            IIteration iteration = iterator.previous();
            if (!iteration.hasDeliverable()) continue;
            return (IIterationHandle)iteration.getItemHandle();
        }
        return null;
    }

    public static List<IIteration> findIterations(IAuditableCommon auditableCommon, IProjectAreaHandle projectAreaHandle, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IIteration> iterations = new ArrayList<IIteration>();
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.createProfile(IProjectArea.ITEM_TYPE, ProcessCommon.getPropertyName(IProjectArea.class, (String)"developmentLines")), monitor);
        List<IDevelopmentLine> developmentLines = auditableCommon.resolveAuditables(Arrays.asList(projectArea.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        for (IDevelopmentLine line : developmentLines) {
            iterations.addAll(IterationsHelper.findIterations(auditableCommon, line.getIterations(), profile, includeArchived, monitor));
        }
        return iterations;
    }

    public static List<IIteration> findIterations(IAuditableCommon auditableCommon, IDevelopmentLineHandle developmentLine, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        IDevelopmentLine line = auditableCommon.resolveAuditable((IAuditableHandle)developmentLine, ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        return IterationsHelper.findIterations(auditableCommon, line.getIterations(), profile, includeArchived, monitor);
    }

    public static List<IIteration> findAllIterations(IAuditableCommon auditableCommon, IIterationHandle[] parents, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        return IterationsHelper.findIterations(auditableCommon, parents, profile, includeArchived, monitor);
    }

    private static List<IIteration> findIterations(IAuditableCommon auditableCommon, IIterationHandle[] parents, ItemProfile<IIteration> profile, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        String isArchivedProperty;
        String hasDeliverableProperty;
        String childrenProperty = ProcessCommon.getPropertyName(IIteration.class, (String)"children");
        if (!profile.contains(childrenProperty)) {
            profile = profile.createExtension((Collection<String>)Collections.singleton(childrenProperty));
        }
        if (!profile.contains(hasDeliverableProperty = ProcessCommon.getPropertyName(IIteration.class, (String)"hasDeliverable"))) {
            profile = profile.createExtension((Collection<String>)Collections.singleton(hasDeliverableProperty));
        }
        if (!profile.contains(isArchivedProperty = ProcessCommon.getPropertyName(IIteration.class, (String)"archived"))) {
            profile = profile.createExtension((Collection<String>)Collections.singleton(isArchivedProperty));
        }
        ArrayList<IIteration> all = new ArrayList<IIteration>();
        ArrayList found = new ArrayList(Arrays.asList(parents));
        while (!found.isEmpty()) {
            List<IIteration> list = auditableCommon.resolveAuditables(found, profile, monitor);
            all.addAll(list);
            found.clear();
            for (IIteration iteration : list) {
                found.addAll(Arrays.asList(iteration.getChildren()));
            }
        }
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            IIteration iteration;
            iteration = (IIteration)iter.next();
            if ((!iteration.isArchived() || includeArchived) && iteration.hasDeliverable()) continue;
            iter.remove();
        }
        return all;
    }

    @Deprecated
    public static void setDefaultTeamArea(IAuditableCommon auditableCommon, ITeamAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        workItemCommon.setDefaultTeamArea(handle, monitor);
    }
}

