/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.ibm.team.workitem.common.internal.util.Messages;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;

public class Daystamp {
    private static final int DAY = 86400000;
    private static final int HALF_DAY = 43200000;
    private Timestamp fTimestamp;
    private Timestamp fStoredTimestamp;
    private Calendar fCalendar;
    private String fNone;
    private DateFormat fDateFormat;

    public Daystamp(int dateStyle) {
        this(dateStyle, ULocale.getDefault(), TimeZone.getDefault());
    }

    public Daystamp(int dateStyle, ULocale locale, TimeZone timeZone) {
        this.fNone = Messages.getString("Daystamp.NONE", locale.toLocale());
        this.fDateFormat = DateFormat.getDateInstance((int)dateStyle, (ULocale)locale);
        this.fDateFormat.setTimeZone(timeZone);
        this.fCalendar = Calendar.getInstance((TimeZone)timeZone);
    }

    public void setStoredTimestamp(Timestamp timestamp) {
        this.fStoredTimestamp = timestamp;
        this.fTimestamp = timestamp;
    }

    public Timestamp getTimestamp() {
        return this.fTimestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        if (timestamp != null) {
            this.fCalendar.setTimeInMillis(timestamp.getTime());
            this.fCalendar.set(21, 43200000);
            timestamp = new Timestamp(this.fCalendar.getTimeInMillis());
        }
        if (timestamp != null && this.fStoredTimestamp != null && this.fDateFormat.format((Date)timestamp).equals(this.fDateFormat.format((Date)this.fStoredTimestamp))) {
            timestamp = this.fStoredTimestamp;
        }
        this.fTimestamp = timestamp;
    }

    public String getText() {
        if (this.fTimestamp == null) {
            return this.fNone;
        }
        return this.fDateFormat.format((Date)this.fTimestamp);
    }

    public ParseException setText(String text) {
        String trimmed;
        ParseException ex = null;
        Date date = null;
        if (text != null && (trimmed = text.trim()).length() > 0 && !this.fNone.equals(trimmed)) {
            try {
                date = this.fDateFormat.parse(trimmed);
            }
            catch (ParseException x) {
                ex = x;
            }
        }
        this.setTimestamp(date != null ? new Timestamp(date.getTime()) : null);
        return ex;
    }
}

