/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class CacheHelper {
    private IAuditableCommon fAuditableCommon;
    private Map<UUID, UUID> fLastSeenStates = Collections.synchronizedMap(new HashMap());
    private Object fUpdateLock = new Object();

    public CacheHelper(IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
    }

    private boolean hasChanged(IAuditable auditable) throws TeamRepositoryException {
        UUID lastSeen = this.fLastSeenStates.get(auditable.getItemId());
        return lastSeen == null || !lastSeen.equals((Object)auditable.getStateId());
    }

    public void checkCache(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (AuditablesHelper.ENFORCE_PROJECT_AREA_NOT_NULL) {
            Assert.isTrue((projectAreaHandle != null ? 1 : 0) != 0);
        }
        try {
            this.internalCheckCache(projectAreaHandle, monitor);
        }
        catch (TeamRepositoryException x) {
            if (this.fLastSeenStates.get(projectAreaHandle.getItemId()) == null) {
                throw x;
            }
            WorkItemCommonPlugin.log("Exception while updating cache", (Exception)((Object)x));
        }
    }

    public void invalidateCache(IProjectAreaHandle projectArea) {
        this.fLastSeenStates.remove(projectArea.getItemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache(IProjectAreaHandle projectArea) {
        Object object = this.fUpdateLock;
        synchronized (object) {
            this.invalidateCache(projectArea);
            this.doFlushCache(projectArea);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalCheckCache(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea projectArea = this.fAuditableCommon.resolveAuditable((IAuditableHandle)projectAreaHandle, ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        if (!this.hasChanged((IAuditable)projectArea)) {
            return;
        }
        Object object = this.fUpdateLock;
        synchronized (object) {
            if (!this.hasChanged((IAuditable)projectArea)) {
                return;
            }
            this.updateCache(projectAreaHandle, monitor);
            this.fLastSeenStates.put(projectArea.getItemId(), projectArea.getStateId());
        }
    }

    protected IAuditableCommon getAuditableCommon() {
        return this.fAuditableCommon;
    }

    protected abstract void updateCache(IProjectAreaHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected void doFlushCache(IProjectAreaHandle projectArea) {
    }
}

