/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.util;

import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.query.util.Messages;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessTemplateCheckVisitor
extends ProgressExpressionVisitor {
    private final ArrayList<TemplateViolation> fViolations = new ArrayList();
    private final IEvaluationContext fContext;

    public ProcessTemplateCheckVisitor(IEvaluationContext context) {
        this.fContext = context;
    }

    public List<TemplateViolation> getTemplateViolations() {
        return Collections.unmodifiableList(this.fViolations);
    }

    public IStatus getViolationStatus() {
        if (this.fViolations.isEmpty()) {
            return Status.OK_STATUS;
        }
        MultiStatus multi = new MultiStatus("com.ibm.team.workitem.common", 0, Messages.getString("ProcessTemplateCheckVisitor.QUERY_NOT_SUPPORTED_IN_PROCESS_TEMPLATE"), null);
        for (TemplateViolation violation : this.fViolations) {
            String message = NLS.bind((String)Messages.getString("ProcessTemplateCheckVisitor.WARNING_DETAIL_VALUE_REFERENCE"), (Object[])new Object[]{violation.getAttributePath()});
            Status status = new Status(2, "com.ibm.team.workitem.common", message);
            multi.add((IStatus)status);
        }
        return multi;
    }

    @Override
    public boolean visit(AttributeExpression expression, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkExpression(expression, monitor);
        return super.visit(expression, monitor);
    }

    private void checkExpression(AttributeExpression expression, IProgressMonitor monitor) throws TeamRepositoryException {
        Object value = expression.getValue();
        if (value instanceof IAuditableHandle) {
            if (this.fContext != null) {
                IQueryableAttribute attribute = expression.getAttribute(this.fContext, monitor);
                String attributePath = QueryableAttributePath.createPathLabel(attribute, Messages.getString("ProcessTemplateCheckVisitor.PATH_SEPARATOR"));
                this.fViolations.add(new TemplateViolation(attributePath));
            } else {
                this.fViolations.add(new TemplateViolation(expression.getAttributeIdentifier()));
            }
        }
    }

    public static class TemplateViolation {
        private String fAttributePath;

        private TemplateViolation(String attributePath) {
            this.fAttributePath = attributePath;
        }

        public String getAttributePath() {
            return this.fAttributePath;
        }
    }
}

