/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.util;

import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.VariableAttributeExpression;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExpressionResolver
extends ProgressExpressionVisitor {
    private final IEvaluationContext fContext;
    private final Map<String, IQueryableAttribute> fAttributeMap;

    public ExpressionResolver(IEvaluationContext context) {
        this.fContext = context;
        this.fAttributeMap = new HashMap<String, IQueryableAttribute>();
    }

    public IQueryableAttribute getAttribute(String attributeIdentifier) {
        return this.fAttributeMap.get(attributeIdentifier);
    }

    public boolean visit(AttributeExpression expression, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resolveAttributeExpression(expression, monitor);
        return super.visit(expression, monitor);
    }

    public boolean visit(VariableAttributeExpression expression, IProgressMonitor monitor) throws TeamRepositoryException {
        this.resolveAttributeExpression(expression, monitor);
        return super.visit(expression, monitor);
    }

    private void resolveAttributeExpression(AttributeExpression expression, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryableAttribute queryableAttribute = expression.getAttribute(this.fContext, monitor);
        this.fAttributeMap.put(expression.getAttributeIdentifier(), queryableAttribute);
        Object value = expression.getValue();
        if (value instanceof IAuditableHandle) {
            IAuditableHandle handle = (IAuditableHandle)value;
            this.fContext.getAuditableCommon().resolveAuditable(handle, ItemProfile.createFullProfile(handle.getItemType()), monitor);
        } else if (IWorkItem.PRIORITY_PROPERTY.equals(expression.getAttributeIdentifier())) {
            IAttribute attribute = this.getWorkItemCommon().findAttribute(this.fContext.getProjectArea(), IWorkItem.PRIORITY_PROPERTY, monitor);
            this.getWorkItemCommon().resolveEnumeration(attribute, monitor);
        } else if (IWorkItem.SEVERITY_PROPERTY.equals(expression.getAttributeIdentifier())) {
            IAttribute attribute = this.getWorkItemCommon().findAttribute(this.fContext.getProjectArea(), IWorkItem.SEVERITY_PROPERTY, monitor);
            this.getWorkItemCommon().resolveEnumeration(attribute, monitor);
        } else if (IWorkItem.TYPE_PROPERTY.equals(expression.getAttributeIdentifier())) {
            this.getWorkItemCommon().findWorkItemType(this.fContext.getProjectArea(), value.toString(), monitor);
        }
    }

    private IWorkItemCommon getWorkItemCommon() {
        return this.fContext.getAuditableCommon().getPeer(IWorkItemCommon.class);
    }
}

