/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.presentations;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.query.presentations.ControlPresentationDescriptor;
import com.ibm.team.workitem.common.internal.query.presentations.IControlPresentationDescriptor;
import com.ibm.team.workitem.common.internal.query.presentations.InternalControlPresentationDescriptor;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import com.ibm.team.workitem.common.query.IQueryType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEditorPresentation {
    private Map<String, InternalControlPresentationDescriptor> fAttributeDescriptorMap = new HashMap<String, InternalControlPresentationDescriptor>();
    private Map<String, InternalControlPresentationDescriptor> fTypeDescriptorMap = new HashMap<String, InternalControlPresentationDescriptor>();
    private final IQueryType fQueryType;

    public QueryEditorPresentation(IQueryType type, List<InternalControlPresentationDescriptor> controlPresentations) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull(controlPresentations);
        this.initializeMaps(controlPresentations);
        this.fQueryType = type;
    }

    public IControlPresentationDescriptor getControlPresentationDescriptor(IQueryableAttribute attribute) {
        String key = QueryableAttributePath.createPathString(attribute);
        InternalControlPresentationDescriptor descriptor = this.fAttributeDescriptorMap.get(key);
        if (descriptor != null) {
            return this.createControlDescriptor(attribute, descriptor);
        }
        descriptor = this.fTypeDescriptorMap.get(attribute.getAttributeType());
        if (descriptor != null) {
            return this.createControlDescriptor(attribute, descriptor);
        }
        return new ControlPresentationDescriptor(attribute);
    }

    public IQueryType getQueryType() {
        return this.fQueryType;
    }

    private IControlPresentationDescriptor createControlDescriptor(IQueryableAttribute attribute, InternalControlPresentationDescriptor descriptor) {
        return new ControlPresentationDescriptor(attribute, descriptor.getPresentationIdentifier(), descriptor.getProperties());
    }

    private void initializeMaps(List<InternalControlPresentationDescriptor> controlPresentations) {
        for (InternalControlPresentationDescriptor descriptor : controlPresentations) {
            if (descriptor.getAttributeIdentifier() != null) {
                this.fAttributeDescriptorMap.put(descriptor.getAttributeIdentifier(), descriptor);
            }
            if (descriptor.getTypeIdentifier() == null) continue;
            this.fTypeDescriptorMap.put(descriptor.getTypeIdentifier(), descriptor);
        }
    }
}

