/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.presentations;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.query.presentations.IControlPresentationDescriptor;
import com.ibm.team.workitem.common.internal.query.presentations.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlPresentationDescriptor
implements IControlPresentationDescriptor {
    private final IQueryableAttribute fAttribute;
    private final String fPresentationId;
    private final Map<String, String> fProperties;

    public ControlPresentationDescriptor(IQueryableAttribute attribute) {
        this(attribute, null, Collections.emptyMap());
    }

    public ControlPresentationDescriptor(IQueryableAttribute attribute, String presentationId, Map<String, String> properties) {
        this.fAttribute = attribute;
        this.fPresentationId = presentationId;
        this.fProperties = new HashMap<String, String>(properties);
    }

    @Override
    public IQueryableAttribute getAttribute() {
        return this.fAttribute;
    }

    @Override
    public Set<String> getConfigurationKeys() {
        return Collections.unmodifiableSet(this.fProperties.keySet());
    }

    @Override
    public boolean hasConfigurationValue(String key) {
        return this.fProperties.containsKey(key);
    }

    @Override
    public String getConfigurationValue(String key) {
        return this.fProperties.get(key);
    }

    @Override
    public boolean getBooleanConfigurationValue(String key) {
        String booleanString = this.getConfigurationValue(key);
        if (booleanString == null) {
            throw new IllegalArgumentException(Messages.getString("ControlPresentationDescriptor.UNKOWN_KEY"));
        }
        return Boolean.parseBoolean(booleanString);
    }

    @Override
    public int getNumericConfigurationValue(String key) {
        String numericString = this.getConfigurationValue(key);
        if (numericString == null) {
            throw new IllegalArgumentException(Messages.getString("ControlPresentationDescriptor.UNKOWN_KEY"));
        }
        return Integer.parseInt(numericString);
    }

    @Override
    public String getPresentationIdentifier() {
        return this.fPresentationId;
    }

    @Override
    public String setConfigurationValue(String key, String value) {
        return this.fProperties.put(key, value);
    }
}

