/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.presentations;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.presentations.Messages;
import com.ibm.team.workitem.common.model.AttributeTypes;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class AttributeTypePresentationIdBindingManager {
    private static final String BINDING_POINT = "com.ibm.team.workitem.common.attributeTypePresentationIdBinding";
    private static final String TYPE_BINDING = "attributeTypePresentationIdBinding";
    private static final String TYPE = "attributeType";
    private static final String PRESENTATION = "presentationId";
    private static final String ENUMERATION_ATTRIBUTE_TYPE = "enumeration";
    private static Map<String, String> fgTypeBindings;
    private static Object fgBindingLock;

    static {
        fgBindingLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAttributeTypePresentationId(String attributeType) {
        Object object = fgBindingLock;
        synchronized (object) {
            if (fgTypeBindings == null) {
                AttributeTypePresentationIdBindingManager.initializeBindings();
            }
        }
        if (fgTypeBindings.containsKey(attributeType)) {
            return fgTypeBindings.get(attributeType);
        }
        if (AttributeTypes.isEnumerationAttributeType(attributeType)) {
            return fgTypeBindings.get(ENUMERATION_ATTRIBUTE_TYPE);
        }
        return null;
    }

    private static void initializeBindings() {
        fgTypeBindings = new HashMap<String, String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(BINDING_POINT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (TYPE_BINDING.equals(element.getName())) {
                String type = element.getAttribute(TYPE);
                String presentation = element.getAttribute(PRESENTATION);
                if (fgTypeBindings.get(type) != null) {
                    String message = NLS.bind((String)Messages.getString("AttributeTypePresentationIdBindingManager.IGNORE_DUPLICATE_BINDING"), (Object[])new Object[]{type, fgTypeBindings.get(type), presentation});
                    WorkItemCommonPlugin.log(message, null);
                } else {
                    fgTypeBindings.put(type, presentation);
                }
            }
            ++i;
        }
    }
}

