/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.model;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import java.net.URL;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemType
extends ConfigurationItem
implements IWorkItemType {
    private String fCategory;
    private List<IAttributeHandle> fCustomAttributes;
    private URL fDimmedIconURL;
    private List<String> fAliases;

    public WorkItemType(IProjectAreaHandle projectArea, String identifier, String category, List<IAttributeHandle> customAttributes, String displayName, List<String> aliases, URL iconURL, URL dimmedIconURL) {
        super(projectArea, identifier, displayName, iconURL);
        this.fCategory = category;
        this.fCustomAttributes = customAttributes != null ? Collections.unmodifiableList(customAttributes) : Collections.emptyList();
        this.fAliases = aliases;
        this.fDimmedIconURL = dimmedIconURL;
    }

    @Override
    public Identifier<? extends ILiteral> getIdentifier2() {
        return Identifier.create(WorkItemType.class, this.getIdentifier());
    }

    @Override
    public String getCategory() {
        return this.fCategory;
    }

    @Override
    public List<IAttributeHandle> getCustomAttributes() {
        return this.fCustomAttributes;
    }

    @Override
    public URL getDimmedIconURL() {
        return this.fDimmedIconURL;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IWorkItemType)) {
            return false;
        }
        IWorkItemType other = (IWorkItemType)obj;
        return this.equals((IItemHandle)this.getProjectArea(), (IItemHandle)other.getProjectArea()) && this.getIdentifier().equals(other.getIdentifier());
    }

    private boolean equals(IItemHandle left, IItemHandle right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.sameItemId(right);
    }

    @Override
    public int hashCode() {
        return 13 * this.hashCode((IItemHandle)this.getProjectArea()) + this.getIdentifier().hashCode();
    }

    private int hashCode(IItemHandle handle) {
        return handle != null ? handle.getItemId().hashCode() : 0;
    }

    @Override
    public List<String> getAliases() {
        if (this.fAliases == null) {
            return Collections.emptyList();
        }
        return this.fAliases;
    }
}

