/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.linkdetection;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.TextLinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemURI;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WorkItemTextLinkDetector
extends TextLinkDetector
implements TextLinkDetectorManager.IServerSensitiveLinkDetector {
    private static final Object fgPatternLock = new Object();
    private static Pattern fgPattern;
    private static ILinkDetectorHelper fgClientHelper;
    private static ILinkDetectorHelper fgServerHelper;
    private IAuditableCommon fAuditableCommon;
    private boolean fIsServer;
    private static List<WorkItemTextLinkDetector> fgUninitializedDetectors;
    private static Object fgInitializerLock;

    static {
        fgUninitializedDetectors = new ArrayList<WorkItemTextLinkDetector>();
        fgInitializerLock = new Object();
    }

    public DetectedTextLink createDetectedLink(Matcher matcher) {
        int referenceLength;
        int referenceOffset;
        Integer workItemId;
        ILinkDetectorHelper helper = WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer);
        if (helper == null) {
            return null;
        }
        IProjectAreaHandle projectArea = helper.findLinkProjectArea(matcher, this);
        IAuditableCommon auditableCommon = null;
        if (projectArea == null) {
            auditableCommon = this.getAuditableCommon(helper);
            if (auditableCommon == null && helper.getAuditableCommons().size() == 1) {
                auditableCommon = helper.getAuditableCommons().get(0);
            }
        } else {
            auditableCommon = helper.getAuditableCommon(projectArea);
        }
        Integer commentId = null;
        try {
            workItemId = new Integer(matcher.group(9));
        }
        catch (NumberFormatException numberFormatException) {
            workItemId = null;
        }
        String workItemName = matcher.group(7);
        if (workItemName != null && helper.getAllTypeNames().contains(workItemName.toLowerCase()) && workItemId != null) {
            try {
                commentId = new Integer(matcher.group(12));
            }
            catch (NumberFormatException numberFormatException) {
                commentId = null;
            }
            if (commentId != null && commentId == 0) {
                commentId = null;
            }
            referenceOffset = projectArea != null ? matcher.start(1) : matcher.start(7);
            referenceLength = commentId != null ? matcher.end(1) - referenceOffset : matcher.end(9) - referenceOffset;
        } else {
            workItemId = null;
            try {
                commentId = new Integer(matcher.group(3));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (commentId != null && commentId == 0) {
                return null;
            }
            if (auditableCommon != null) {
                if (this.getBaseURI() == null) {
                    return null;
                }
                IItemHandle handle = ItemURI.resolveLocation(auditableCommon, this.getBaseURI());
                if (!(handle instanceof IWorkItemHandle)) {
                    return null;
                }
            }
            referenceOffset = matcher.start(1);
            referenceLength = matcher.end(1) - referenceOffset;
        }
        return new DetectedWorkItemTextLink(referenceOffset, referenceLength, auditableCommon, helper.getAuditableCommons(), this.getBaseURI(), workItemId, commentId);
    }

    protected Pattern getPattern() {
        return this.internalGetPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pattern internalGetPattern() {
        Object object = fgPatternLock;
        synchronized (object) {
            if (fgPattern == null) {
                ILinkDetectorHelper helper = WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer);
                if (helper == null || helper.getAllTypeNames().isEmpty() || helper.getComments().isEmpty() || helper.getProjectAreas().isEmpty()) {
                    return null;
                }
                String types = "";
                for (String typeName : helper.getAllTypeNames()) {
                    types = String.valueOf(types) + "|" + Pattern.quote(typeName);
                }
                if (types.length() > 0) {
                    types = types.substring(1);
                }
                String projectAreas = "";
                for (IProjectAreaHandle projectArea : helper.getProjectAreas()) {
                    String name = helper.getProjectAreaName(projectArea);
                    if (name == null) continue;
                    projectAreas = String.valueOf(projectAreas) + "|" + Pattern.quote(name);
                }
                if (projectAreas.length() > 0) {
                    projectAreas = projectAreas.substring(1);
                }
                String comments = "";
                for (String comment : helper.getComments()) {
                    comments = String.valueOf(comments) + "|" + Pattern.quote(comment);
                }
                if (comments.length() > 0) {
                    comments = comments.substring(1);
                }
                fgPattern = Pattern.compile("((" + comments + ")\\s?(\\d+)|(((" + projectAreas + "),?\\s?)?\\b(" + types + ")(\\s|\\s?#)(\\d+))(,?\\s?(" + comments + ")\\s?(\\d+))?)", 66);
            }
            return fgPattern;
        }
    }

    public static ILinkDetectorHelper getLinkDetectorHelper(boolean isServer) {
        if (isServer) {
            return fgServerHelper;
        }
        return fgClientHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClientHelper(ILinkDetectorHelper clientHelper) {
        if (fgClientHelper == null) {
            fgClientHelper = clientHelper;
            Object object = fgInitializerLock;
            synchronized (object) {
                if (!fgUninitializedDetectors.isEmpty()) {
                    Iterator<WorkItemTextLinkDetector> it = fgUninitializedDetectors.iterator();
                    while (it.hasNext()) {
                        WorkItemTextLinkDetector detector = it.next();
                        if (detector.fIsServer) continue;
                        detector.initialize();
                        it.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServerHelper(ILinkDetectorHelper serverHelper) {
        if (fgServerHelper == null) {
            fgServerHelper = serverHelper;
            Object object = fgInitializerLock;
            synchronized (object) {
                if (!fgUninitializedDetectors.isEmpty()) {
                    Iterator<WorkItemTextLinkDetector> it = fgUninitializedDetectors.iterator();
                    while (it.hasNext()) {
                        WorkItemTextLinkDetector detector = it.next();
                        if (!detector.fIsServer) continue;
                        detector.initialize();
                        it.remove();
                    }
                }
            }
        }
    }

    public void setIsServer(boolean isServer) {
        this.fIsServer = isServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer) != null) {
            WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer).cleanUp(this);
        } else {
            Object object = fgInitializerLock;
            synchronized (object) {
                fgUninitializedDetectors.remove((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer) != null) {
            WorkItemTextLinkDetector.getLinkDetectorHelper(this.fIsServer).initialize(this);
        } else {
            Object object = fgInitializerLock;
            synchronized (object) {
                fgUninitializedDetectors.add(this);
            }
        }
    }

    private IAuditableCommon getAuditableCommon(ILinkDetectorHelper helper) {
        if (this.fAuditableCommon == null && this.getBaseURI() != null) {
            for (IAuditableCommon aud : helper.getAuditableCommons()) {
                try {
                    if (aud.getRepositoryURI() == null) continue;
                    String auditableRepo = aud.getRepositoryURI();
                    if (auditableRepo.endsWith("/")) {
                        auditableRepo = auditableRepo.substring(0, auditableRepo.length() - 1);
                    }
                    if (!auditableRepo.equals(Location.location((URI)this.getBaseURI()).getRepoUri())) continue;
                    this.fAuditableCommon = aud;
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
        }
        return this.fAuditableCommon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidatePattern() {
        Object object = fgPatternLock;
        synchronized (object) {
            fgPattern = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DetectedWorkItemTextLink
    extends DetectedTextLink {
        private IAuditableCommon fAuditableCommon;
        private URI fBaseURI;
        private Integer fWorkItemId;
        private Integer fCommentId;
        private ArrayList<IAuditableCommon> fAllAuditableCommons;

        public DetectedWorkItemTextLink(int offset, int length, IAuditableCommon auditableCommon, List<IAuditableCommon> allAuditableCommons, URI baseUri, Integer workItemId, Integer commentId) {
            super(offset, length);
            this.fAuditableCommon = auditableCommon;
            this.fWorkItemId = workItemId;
            this.fCommentId = commentId;
            this.fBaseURI = baseUri;
            this.fAllAuditableCommons = allAuditableCommons == null ? new ArrayList() : new ArrayList<IAuditableCommon>(allAuditableCommons);
        }

        public List<URI> createURIs() {
            ArrayList<URI> uris = new ArrayList<URI>();
            if (this.fAuditableCommon == null) {
                for (IAuditableCommon aud : this.fAllAuditableCommons) {
                    URI uri = this.getURI(aud);
                    if (uri == null) continue;
                    uris.add(uri);
                }
            } else {
                URI uri = this.getURI(this.fAuditableCommon);
                if (uri != null) {
                    uris.add(uri);
                }
            }
            return uris;
        }

        private URI getURI(IAuditableCommon auditableCommon) {
            URI uri;
            if (this.fWorkItemId == null) {
                if (this.fBaseURI == null || this.fCommentId == null) {
                    return null;
                }
                IItemHandle handle = ItemURI.resolveLocation(auditableCommon, this.fBaseURI);
                uri = ItemURI.createWorkItemCommentURI(auditableCommon, (IWorkItemHandle)handle, this.fCommentId - 1);
            } else {
                uri = this.fCommentId != null ? ItemURI.createWorkItemCommentURI(auditableCommon, this.fWorkItemId, this.fCommentId - 1) : ItemURI.createWorkItemURI(auditableCommon, this.fWorkItemId);
            }
            return uri;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ILinkDetectorHelper {
        public static final int ALL_GROUP = 1;
        public static final int TEAM_SERVICE_GROUP = 6;
        public static final int WORK_ITEM_REFERENCE_GROUP = 7;
        public static final int WORK_ITEM_ID_GROUP = 9;
        public static final int COMMENT_ID_GROUP = 12;
        public static final int COMMENT_ID_GROUP_STA = 3;

        public List<IProjectAreaHandle> getProjectAreas();

        public String getProjectAreaName(IProjectAreaHandle var1);

        public Collection<String> getAllTypeNames();

        public Collection<String> getAttachmentNames();

        public Collection<String> getComments();

        public IAuditableCommon getAuditableCommon(IProjectAreaHandle var1);

        public List<IAuditableCommon> getAuditableCommons();

        public IProjectAreaHandle findLinkProjectArea(Matcher var1, TextLinkDetector var2);

        public void cleanUp(TextLinkDetector var1);

        public void initialize(TextLinkDetector var1);
    }
}

