/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.linkdetection;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.TextLinkDetector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MailLinkDetector
extends TextLinkDetector {
    private static final String start = "[\\w-/?#&+'`~!$%*|^{}=]";
    private static final String any = "[\\w-/?#&+'`~!$%*|^{}=\\.]";
    private static final String host = "[\\w-]";
    private static final Pattern PATTERN = Pattern.compile("((([\\w-/?#&+'`~!$%*|^{}=])([\\w-/?#&+'`~!$%*|^{}=\\.])*)(@((([\\w-])+)\\.)+(\\w+)))", 66);
    private static final int ALL_GROUP = 1;

    public DetectedTextLink createDetectedLink(Matcher matcher) {
        String mailAddress = matcher.group(1);
        if (mailAddress == null) {
            return null;
        }
        int referenceOffset = matcher.start(1);
        int referenceLength = matcher.end(1) - referenceOffset;
        return new DetectedMailLink(referenceOffset, referenceLength, mailAddress);
    }

    protected Pattern getPattern() {
        return PATTERN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DetectedMailLink
    extends DetectedTextLink {
        private String fMailAddress;

        DetectedMailLink(int offset, int length, String mailAddress) {
            super(offset, length);
            this.fMailAddress = mailAddress;
        }

        public List<URI> createURIs() {
            ArrayList<URI> uris = new ArrayList<URI>(1);
            try {
                String local = this.fMailAddress.substring(0, this.fMailAddress.indexOf(64));
                local = local.replaceAll("%", "%25");
                local = local.replaceAll("`", "%60");
                local = local.replaceAll("\\^", "%5E");
                local = local.replaceAll("\\{", "%7B");
                local = local.replaceAll("\\}", "%7D");
                local = local.replaceAll("\\|", "%7C");
                String host = this.fMailAddress.substring(this.fMailAddress.indexOf(64));
                String encoded = String.valueOf(local) + host;
                URI uri = new URI("mailto:" + encoded);
                uris.add(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
            return uris;
        }
    }
}

