/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.variables.IAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.StatusVariable;
import com.ibm.team.workitem.common.internal.expression.AbstractQueryableAttribute;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryableWorkItemAttribute
extends AbstractQueryableAttribute {
    private static List<StatusVariable> fgStatusVariables = Arrays.asList(new StatusVariable(5), new StatusVariable(2));
    private static List<String> fgNonNullValueAttributeTypes = Arrays.asList("boolean", "integer", "float", "long");
    private static List<String> fgNonNullValueAttributes = Arrays.asList(IWorkItem.TYPE_PROPERTY, IWorkItem.STATE_PROPERTY, IWorkItem.RESOLUTION_PROPERTY, IWorkItem.CREATION_DATE_PROPERTY, IWorkItem.CREATOR_PROPERTY, IWorkItem.MODIFIED_BY_PROPERTY, IWorkItem.MODIFIED_PROPERTY, IWorkItem.SUBSCRIPTIONS_PROPERTY, IWorkItem.COMMENTS_PROPERTY, IWorkItem.APPROVALS_PROPERTY);
    private static final List<String> fgPastDateAttributes = Arrays.asList(IWorkItem.CREATION_DATE_PROPERTY, IWorkItem.MODIFIED_PROPERTY, IWorkItem.RESOLUTION_DATE_PROPERTY);
    private static Map<String, List<AttributeOperation>> fgCustomOperators = new HashMap<String, List<AttributeOperation>>();
    private final IAttribute fAttribute;
    private Object fNullValue;

    static {
        List<AttributeOperation> statusResolutionOperators = Arrays.asList(AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS);
        fgCustomOperators.put(IWorkItem.STATE_PROPERTY, statusResolutionOperators);
        fgCustomOperators.put(IWorkItem.RESOLUTION_PROPERTY, statusResolutionOperators);
    }

    public static boolean isPastDateAttribute(IQueryableAttribute attribute) {
        return fgPastDateAttributes.contains(attribute.getIdentifier());
    }

    public QueryableWorkItemAttribute(IAttribute attribute) {
        this(null, attribute);
    }

    public QueryableWorkItemAttribute(IQueryableAttribute parent, IAttribute attribute) {
        super(parent);
        this.fAttribute = attribute;
    }

    @Override
    public String getDisplayName() {
        return this.fAttribute.getDisplayName();
    }

    @Override
    public String getAttributeType() {
        return this.fAttribute.getAttributeType();
    }

    @Override
    public String getIdentifier() {
        return this.fAttribute.getIdentifier();
    }

    @Override
    public boolean isStateExtension() {
        return !this.fAttribute.isBuiltIn();
    }

    @Override
    public List<AttributeOperation> getOperators() {
        List<AttributeOperation> custom = fgCustomOperators.get(this.getIdentifier());
        if (custom != null) {
            return custom;
        }
        if (this.fAttribute.isBuiltIn()) {
            return super.getOperators();
        }
        ArrayList<AttributeOperation> operators = new ArrayList<AttributeOperation>();
        operators.addAll(super.getOperators());
        operators.add(AttributeOperation.EXISTS);
        return operators;
    }

    @Override
    public List<? extends IAttributeVariable<?>> getVariables() {
        if (IWorkItem.STATE_PROPERTY.equals(this.getIdentifier())) {
            return Collections.unmodifiableList(fgStatusVariables);
        }
        return super.getVariables();
    }

    @Override
    public boolean hasNullValue() {
        if (fgNonNullValueAttributes.contains(this.getIdentifier())) {
            return false;
        }
        if (fgNonNullValueAttributeTypes.contains(this.getAttributeType())) {
            return false;
        }
        if (AttributeTypes.isEnumerationAttributeType(this.getAttributeType())) {
            return false;
        }
        return !this.unaryOnly();
    }

    @Override
    public Object getNullValue() {
        return this.fNullValue;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    public IAttribute getAttribute() {
        return this.fAttribute;
    }

    void setNullValue(Object nullValue) {
        this.fNullValue = nullValue;
    }

    private boolean unaryOnly() {
        boolean unaryOnly = true;
        List<AttributeOperation> operators = this.getOperators();
        for (AttributeOperation operator : operators) {
            if (operator.isUnary()) continue;
            unaryOnly = false;
        }
        return unaryOnly;
    }

    @Override
    public String getSortIdentifier() {
        if (IWorkItem.CATEGORY_PROPERTY.equals(this.getIdentifier())) {
            return ICategory.CATEGORY_ID;
        }
        if (IWorkItem.DESCRIPTION_PROPERTY.equals(this.getIdentifier()) || this.isStateExtension()) {
            return null;
        }
        if (IWorkItem.TARGET_PROPERTY.equals(this.getIdentifier())) {
            return ProcessCommon.getPropertyName(IIteration.class, (String)"id");
        }
        return super.getSortIdentifier();
    }

    @Override
    public Object getValue(Object element) {
        if (element instanceof IWorkItem) {
            IWorkItem workItem = (IWorkItem)element;
            return workItem.isAttributeSet(this.fAttribute) ? workItem.getValue(this.fAttribute) : null;
        }
        return super.getValue(element);
    }
}

