/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ExpressionChangeEvent;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import com.ibm.team.workitem.common.internal.expression.EditableTerm;

public abstract class EditableExpression {
    private EditableTerm fParent;
    private EditableStatement fStatement;
    private boolean fIsInternal = false;

    public abstract Expression createExpression();

    public EditableTerm getParent() {
        return this.fParent;
    }

    public EditableStatement getStatement() {
        return this.fStatement;
    }

    public boolean isInternal() {
        return this.fIsInternal;
    }

    public void setInternal(boolean isInternal) {
        this.fIsInternal = isInternal;
    }

    void addToTree(EditableTerm parent, EditableStatement statement) {
        this.fParent = parent;
        this.fStatement = statement;
    }

    void removeFromTree() {
        this.fParent = null;
        this.fStatement = null;
    }

    protected void notify(ExpressionChangeEvent.Type type) {
        this.notify(type, this);
    }

    protected void notify(ExpressionChangeEvent.Type type, EditableExpression expression) {
        if (this.getStatement() != null) {
            this.getStatement().notify(new ExpressionChangeEvent(type, this, expression));
        }
    }

    public void remove() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }
}

