/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.internal.expression.ElementWrapper;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.Messages;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DOMElementWrapper
extends ElementWrapper {
    Element fElement;

    public DOMElementWrapper(Element element) {
        this.fElement = element;
    }

    public String getName() {
        return this.fElement.getTagName();
    }

    public IPersistableElement createChild(String name) {
        Element child = this.fElement.getOwnerDocument().createElement(name);
        this.fElement.appendChild(child);
        return new DOMElementWrapper(child);
    }

    public boolean hasAttribute(String name) {
        return this.fElement.hasAttribute(name);
    }

    public String getAttribute(String name) throws SerializationException {
        if (this.hasAttribute(name)) {
            return this.fElement.getAttribute(name);
        }
        String error = NLS.bind((String)Messages.getString("DOMElementWrapper.UNKNOWN_XML_ATTRIBUTE"), (Object[])new Object[]{name, this.fElement.getTagName()});
        throw new SerializationException(error);
    }

    public void setAttribute(String name, String value) {
        this.fElement.setAttribute(name, value);
    }

    public IPersistableElement[] getChildren() {
        ArrayList<DOMElementWrapper> childElements = new ArrayList<DOMElementWrapper>();
        NodeList childNodes = this.fElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i) instanceof Element) {
                childElements.add(new DOMElementWrapper((Element)childNodes.item(i)));
            }
            ++i;
        }
        return childElements.toArray(new IPersistableElement[childElements.size()]);
    }
}

