/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.Deliverable;
import com.ibm.team.workitem.common.internal.util.EMFListener;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IDeliverable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliverableWorkingCopy {
    private ICommonServiceContext fServiceContext;
    private IProjectAreaHandle fProjectArea;
    private Set<IDeliverable> fDeliverables = new ItemHandleAwareHashSet<IDeliverable>();
    private InternalListener fListener = new InternalListener();
    private Set<IDeliverable> fDirty = new ItemHandleAwareHashSet<IDeliverable>();
    private Runnable fDirtyListener = null;

    public static DeliverableWorkingCopy resolveWorkingCopy(ICommonServiceContext serviceContext, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableCommon auditableCommon = serviceContext.getService(IAuditableCommon.class);
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        if (projectArea instanceof IProjectArea) {
            projectArea = (IProjectAreaHandle)((IProjectArea)projectArea).getItemHandle();
        }
        List<IDeliverable> deliverables = ((WorkItemCommon)workItemCommon).findDeliverablesByProjectArea(projectArea, true, IDeliverable.FULL_PROFILE, true, monitor);
        return new DeliverableWorkingCopy(serviceContext, projectArea, deliverables);
    }

    private DeliverableWorkingCopy(ICommonServiceContext serviceContext, IProjectAreaHandle projectArea, List<IDeliverable> deliverables) {
        this.fServiceContext = serviceContext;
        this.fProjectArea = projectArea;
        for (IDeliverable deliverable : deliverables) {
            this.addDeliverable(deliverable);
        }
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    public Set<IDeliverable> getDeliverables() {
        return new ItemHandleAwareHashSet<IDeliverable>(this.fDeliverables);
    }

    public IDeliverable createDeliverable(String name) {
        IAuditableCommon auditableCommon = this.fServiceContext.getService(IAuditableCommon.class);
        Deliverable deliverable = (Deliverable)auditableCommon.createAuditable(IDeliverable.ITEM_TYPE);
        deliverable.setProjectArea(this.fProjectArea);
        deliverable.setName(name);
        this.addDeliverable(deliverable);
        this.markDirty(deliverable);
        return deliverable;
    }

    public boolean isDirty() {
        return !this.fDirty.isEmpty();
    }

    public void setDirtyListener(Runnable listener) {
        this.fDirtyListener = listener;
    }

    public void save(IProgressMonitor monitor) throws TeamRepositoryException {
        for (IDeliverable deliverable : new ArrayList<IDeliverable>(this.fDirty)) {
            if (!deliverable.isNewItem() || !deliverable.isArchived()) continue;
            this.removeDeliverable(deliverable);
        }
        ArrayList<IDeliverable> deliverables = new ArrayList<IDeliverable>(this.fDeliverables);
        Collections.sort(deliverables, new Comparator<IDeliverable>(){

            @Override
            public int compare(IDeliverable o1, IDeliverable o2) {
                return -DeliverableWorkingCopy.compare(o1, o2);
            }
        });
        int i = 0;
        while (i < deliverables.size()) {
            Deliverable deliverable = (Deliverable)deliverables.get(i);
            if (deliverable.getSequenceValue() != i) {
                deliverable.setSequenceValue(i);
            }
            ++i;
        }
        IWorkItemCommon workItemCommon = this.fServiceContext.getService(IWorkItemCommon.class);
        ArrayList<IDeliverable> save = new ArrayList<IDeliverable>(this.fDirty);
        workItemCommon.saveDeliverables(save, monitor);
        this.markAllClean();
    }

    public void update(IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableCommon auditableCommon = this.fServiceContext.getService(IAuditableCommon.class);
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        List<IDeliverable> deliverables = ((WorkItemCommon)workItemCommon).findDeliverablesByProjectArea(this.fProjectArea, true, IDeliverable.FULL_PROFILE, true, monitor);
        for (IDeliverable deliverable : deliverables) {
            if (this.fDeliverables.contains(deliverable)) continue;
            this.addDeliverable(deliverable);
        }
    }

    private void addDeliverable(IDeliverable deliverable) {
        IDeliverable workingCopy = (IDeliverable)deliverable.getWorkingCopy();
        ((EObject)workingCopy).eAdapters().add((Object)this.fListener);
        this.fDeliverables.add(workingCopy);
    }

    private void removeDeliverable(IDeliverable deliverable) {
        ((EObject)deliverable).eAdapters().remove((Object)this.fListener);
        this.fDeliverables.remove(deliverable);
        this.markClean(deliverable);
    }

    public static int compare(IDeliverable o1, IDeliverable o2) {
        int seq2;
        int seq1 = ((Deliverable)o1).getSequenceValue();
        if (seq1 != (seq2 = ((Deliverable)o2).getSequenceValue())) {
            return seq2 - seq1;
        }
        Timestamp time1 = o1.getCreationDate();
        Timestamp time2 = o2.getCreationDate();
        if (time1 != null && time2 != null && !time1.equals(time2)) {
            return time2.compareTo(time1);
        }
        if (time1 == null && time2 != null) {
            return -1;
        }
        if (time2 == null && time1 != null) {
            return 1;
        }
        return Collator.getInstance().compare(o1.getName(), o2.getName());
    }

    private void markDirty(IDeliverable deliverable) {
        boolean notify = this.fDirtyListener != null && this.fDirty.isEmpty();
        this.fDirty.add(deliverable);
        if (notify) {
            this.fDirtyListener.run();
        }
    }

    private void markClean(IDeliverable deliverable) {
        boolean notify = this.fDirtyListener != null && !this.fDirty.isEmpty();
        this.fDirty.remove(deliverable);
        if (notify && this.fDirty.isEmpty()) {
            this.fDirtyListener.run();
        }
    }

    private void markAllClean() {
        boolean notify = this.fDirtyListener != null && !this.fDirty.isEmpty();
        this.fDirty.clear();
        if (notify) {
            this.fDirtyListener.run();
        }
    }

    private class InternalListener
    extends EMFListener {
        private InternalListener() {
        }

        protected void featureChanged(Object notifier, EStructuralFeature feature, Object oldValue, Object newValue, int position) {
            if (notifier instanceof IDeliverable) {
                DeliverableWorkingCopy.this.markDirty((IDeliverable)notifier);
            }
        }
    }
}

