/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ResourceLocation;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationItemManager<T extends ConfigurationItem> {
    private IAuditableCommon fAuditableCommon;
    private Map<UUID, Map<String, T>> fIdentifierCache = new HashMap<UUID, Map<String, T>>();
    private Map<UUID, List<T>> fListCache = new HashMap<UUID, List<T>>();
    private CacheManager fCacheManager;
    private Object fLock = new Object();

    public ConfigurationItemManager(IAuditableCommon auditableCommon) {
        this.fAuditableCommon = auditableCommon;
        this.fCacheManager = new CacheManager(auditableCommon);
    }

    public List<T> findConfigurationItems(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fCacheManager.checkCache(projectArea, monitor);
        List<T> cache = this.findCachedConfigurationItems(projectArea);
        return cache != null ? cache : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> findCachedConfigurationItems(IProjectAreaHandle projectArea) {
        if (AuditablesHelper.ENFORCE_PROJECT_AREA_NOT_NULL) {
            Assert.isTrue((projectArea != null ? 1 : 0) != 0);
        }
        if (projectArea == null) {
            return Collections.emptyList();
        }
        Object object = this.fLock;
        synchronized (object) {
            List<T> configurationItems;
            block6: {
                configurationItems = this.fListCache.get(projectArea.getItemId());
                if (configurationItems != null) break block6;
                return null;
            }
            return new ArrayList<T>(configurationItems);
        }
    }

    public T findConfigurationItem(IProjectAreaHandle projectArea, String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fCacheManager.checkCache(projectArea, monitor);
        return this.findCachedConfigurationItem(projectArea, identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T findCachedConfigurationItem(IProjectAreaHandle projectArea, String identifier) {
        if (AuditablesHelper.ENFORCE_PROJECT_AREA_NOT_NULL) {
            Assert.isTrue((projectArea != null ? 1 : 0) != 0);
        }
        if (projectArea == null) {
            return null;
        }
        Object object = this.fLock;
        synchronized (object) {
            Map<String, T> configurationItems;
            block6: {
                configurationItems = this.fIdentifierCache.get(projectArea.getItemId());
                if (configurationItems != null) break block6;
                return null;
            }
            return (T)((ConfigurationItem)configurationItems.get(identifier));
        }
    }

    public void invalidateCache(IProjectAreaHandle projectArea) {
        this.fCacheManager.invalidateCache(projectArea);
    }

    public void flushCache(IProjectAreaHandle projectArea) {
        this.fCacheManager.flushCache(projectArea);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFlushCache(IProjectAreaHandle projectArea) {
        Object object = this.fLock;
        synchronized (object) {
            this.fIdentifierCache.remove(projectArea.getItemId());
            this.fListCache.remove(projectArea.getItemId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readConfigurationItems(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, ConfigurationItem> configurationItemsMap = new HashMap<String, ConfigurationItem>();
        ArrayList<ConfigurationItem> configurationItemsList = new ArrayList<ConfigurationItem>();
        IProcessConfigurationData processConfiguration = this.resolveProcessConfiguration(projectArea, monitor);
        if (processConfiguration != null) {
            this.readConfigurationItems(configurationItemsMap, configurationItemsList, projectArea, processConfiguration, monitor);
        }
        for (ConfigurationItem configurationItem : this.readStaticConfigurationItems(projectArea, monitor)) {
            if (configurationItemsMap.containsKey(configurationItem.getIdentifier())) continue;
            configurationItemsMap.put(configurationItem.getIdentifier(), configurationItem);
            configurationItemsList.add(configurationItem);
        }
        Object object = this.fLock;
        synchronized (object) {
            this.fIdentifierCache.put(projectArea.getItemId(), configurationItemsMap);
            this.fListCache.put(projectArea.getItemId(), configurationItemsList);
        }
    }

    protected IProcessConfigurationData resolveProcessConfiguration(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableCommonProcess process = this.fAuditableCommon.getProcess((IProcessAreaHandle)projectArea, monitor);
        return process.findProcessConfiguration(this.getConfigurationDataPoint(), monitor);
    }

    private void readConfigurationItems(Map<String, T> configurationItemsMap, List<T> configurationItemsList, IProjectAreaHandle projectArea, IProcessConfigurationData processConfiguration, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessConfigurationElement[] iProcessConfigurationElementArray = processConfiguration.getElements();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement configurationElement = iProcessConfigurationElementArray[n2];
            if (this.getGroupElement().equals(configurationElement.getName())) {
                IProcessConfigurationElement[] iProcessConfigurationElementArray2 = configurationElement.getChildren();
                int n3 = iProcessConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcessConfigurationElement childElement = iProcessConfigurationElementArray2[n4];
                    if (this.getElement().equals(childElement.getName())) {
                        this.readConfigurationItem(configurationItemsMap, configurationItemsList, projectArea, childElement, monitor);
                    }
                    ++n4;
                }
            } else if (this.getElement().equals(configurationElement.getName())) {
                this.readConfigurationItem(configurationItemsMap, configurationItemsList, projectArea, configurationElement, monitor);
            }
            ++n2;
        }
    }

    private void readConfigurationItem(Map<String, T> configurationItemsMap, List<T> configurationItemsList, IProjectAreaHandle projectArea, IProcessConfigurationElement childElement, IProgressMonitor monitor) throws TeamRepositoryException {
        T configurationItem = this.readElement(projectArea, childElement, monitor);
        if (configurationItem != null) {
            configurationItemsMap.put(((ConfigurationItem)configurationItem).getIdentifier(), configurationItem);
            configurationItemsList.add(configurationItem);
        }
    }

    protected URL createResourceURL(IProcessContainerHandle container, String icon, IProgressMonitor monitor) {
        URL iconURL = null;
        URL resourceURL = null;
        try {
            if (icon != null && icon.length() > 0) {
                URI uri = new URI(icon = this.encodeAnyURI(icon));
                if (uri.getPath() == null) {
                    throw new MalformedURLException("Path must not be empty");
                }
                resourceURL = ResourceLocation.getResourceURL(container, uri, this.getAuditableCommon().getRepositoryURI());
                iconURL = this.resolveURL(resourceURL, monitor);
            }
        }
        catch (MalformedURLException x) {
            WorkItemCommonPlugin.log("Exception while creating URL", x);
        }
        catch (URISyntaxException x) {
            WorkItemCommonPlugin.log("Exception while creating URL", x);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            WorkItemCommonPlugin.log(NLS.bind((String)"URL not found: {0}", (Object[])new Object[]{icon}), null);
        }
        catch (TeamRepositoryException x) {
            WorkItemCommonPlugin.log("Exception while creating URL", (Exception)((Object)x));
        }
        return iconURL;
    }

    protected URL resolveURL(URL resourceURL, IProgressMonitor monitor) throws TeamRepositoryException {
        return ((WorkItemCommon)this.getAuditableCommon().getPeer(IWorkItemCommon.class)).resolveURL(resourceURL, monitor);
    }

    private String encodeAnyURI(String url) {
        return url.replace(" ", "%20");
    }

    protected IAuditableCommon getAuditableCommon() {
        return this.fAuditableCommon;
    }

    protected List<T> readStaticConfigurationItems(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return Collections.emptyList();
    }

    protected abstract String getConfigurationDataPoint();

    protected abstract String getGroupElement();

    protected abstract String getElement();

    protected abstract T readElement(IProjectAreaHandle var1, IProcessConfigurationElement var2, IProgressMonitor var3) throws TeamRepositoryException;

    private class CacheManager
    extends CacheHelper {
        public CacheManager(IAuditableCommon auditableCommon) {
            super(auditableCommon);
        }

        protected void updateCache(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
            ConfigurationItemManager.this.readConfigurationItems(projectAreaHandle, monitor);
        }

        protected void doFlushCache(IProjectAreaHandle projectArea) {
            ConfigurationItemManager.this.doFlushCache(projectArea);
        }
    }
}

