/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression.variables;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.sql.Timestamp;

public class TimeSpan {
    private final Timestamp fStart;
    private final Timestamp fEnd;
    private final Timestamp fReference;

    public static TimeSpan createTimeSpan(Timestamp timestamp, int calendarUnit, TimeZone timeZone) {
        Calendar reference = Calendar.getInstance((TimeZone)timeZone);
        reference.setTimeInMillis(timestamp.getTime());
        int year = reference.get(1);
        int month = reference.get(2);
        int date = reference.get(5);
        int hour = reference.get(11);
        int min = reference.get(12);
        Calendar start = Calendar.getInstance((TimeZone)timeZone);
        start.clear();
        switch (calendarUnit) {
            case 12: {
                start.set(year, month, date, hour, min, 0);
                break;
            }
            case 11: {
                start.set(year, month, date, hour, 0);
                break;
            }
            case 5: {
                start.set(year, month, date);
                break;
            }
            case 2: {
                start.set(year, month, 1);
                break;
            }
            case 1: {
                start.set(year, 0, 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        Calendar end = Calendar.getInstance((TimeZone)timeZone);
        end.setTimeInMillis(start.getTimeInMillis() - 1L);
        end.add(calendarUnit, 1);
        return new TimeSpan(new Timestamp(start.getTimeInMillis()), new Timestamp(end.getTimeInMillis()), timestamp);
    }

    public TimeSpan(Timestamp start, Timestamp end, Timestamp reference) {
        this.fStart = start;
        this.fEnd = end;
        this.fReference = reference;
    }

    public Timestamp getStart() {
        return this.fStart;
    }

    public Timestamp getEnd() {
        return this.fEnd;
    }

    public Timestamp getReference() {
        return this.fReference;
    }
}

